/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.AlConversation;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.listners.ConversationListHandler;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.task.AlAsyncTask;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ConversationListTask
extends AlAsyncTask<Void, List<AlConversation>> {
    private WeakReference<Context> context;
    private String searchString;
    private Contact contact;
    private Channel channel;
    private Long startTime;
    private Long endTime;
    private boolean isForMessageList;
    private ConversationListHandler handler;
    private ApplozicException exception;
    private AppContactService appContactService;
    private ChannelService channelService;
    private MessageDatabaseService messageDatabaseService;

    public ConversationListTask(Context context, String searchString, Contact contact, Channel channel, Long startTime, Long endTime, ConversationListHandler handler, boolean isForMessageList) {
        this.context = new WeakReference<Context>(context);
        this.searchString = searchString;
        this.contact = contact;
        this.channel = channel;
        this.startTime = startTime;
        this.endTime = endTime;
        this.handler = handler;
        this.isForMessageList = isForMessageList;
        this.channelService = ChannelService.getInstance((Context)this.context.get());
        this.appContactService = new AppContactService((Context)this.context.get());
        this.messageDatabaseService = new MessageDatabaseService((Context)this.context.get());
    }

    protected List<AlConversation> doInBackground() {
        List<Message> messageList = null;
        try {
            messageList = this.isForMessageList ? new MobiComConversationService((Context)this.context.get()).getLatestMessagesGroupByPeople(this.startTime, TextUtils.isEmpty((CharSequence)this.searchString) ? null : this.searchString) : new MobiComConversationService((Context)this.context.get()).getMessages(this.startTime, this.endTime, this.contact, this.channel, null);
            if (messageList == null && this.exception == null) {
                this.exception = new ApplozicException("Some internal error occurred");
            }
            ArrayList<String> recList = new ArrayList<String>();
            ArrayList<AlConversation> conversationList = new ArrayList<AlConversation>();
            if (this.isForMessageList && messageList != null) {
                for (Message message : messageList) {
                    AlConversation conversation = new AlConversation();
                    if (!(message.getGroupId() != null && message.getGroupId() != 0 || recList.contains(message.getContactIds()))) {
                        recList.add(message.getContactIds());
                        conversation.setMessage(message);
                        conversation.setContact(this.appContactService.getContactById(message.getContactIds()));
                        conversation.setChannel(null);
                        conversation.setUnreadCount(this.messageDatabaseService.getUnreadMessageCountForContact(message.getContactIds()));
                        conversationList.add(conversation);
                        continue;
                    }
                    if (message.getGroupId() == null || recList.contains("group" + message.getGroupId())) continue;
                    recList.add("group" + message.getGroupId());
                    conversation.setMessage(message);
                    conversation.setContact(null);
                    conversation.setChannel(this.channelService.getChannel(message.getGroupId()));
                    conversation.setUnreadCount(this.messageDatabaseService.getUnreadMessageCountForChannel(message.getGroupId()));
                    conversationList.add(conversation);
                }
                if (!messageList.isEmpty()) {
                    MobiComUserPreference.getInstance((Context)this.context.get()).setStartTimeForPagination(messageList.get(messageList.size() - 1).getCreatedAtTime());
                }
                return conversationList;
            }
        }
        catch (Exception e) {
            this.exception = new ApplozicException(e.getMessage());
        }
        return null;
    }

    protected void onPostExecute(List<AlConversation> conversationList) {
        super.onPostExecute(conversationList);
        this.handler.onResult((Context)this.context.get(), conversationList, this.exception);
    }
}

