/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.MultipleChannelFeedApiResponse;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.notification.MuteNotificationRequest;
import com.applozic.mobicomkit.api.people.ChannelInfo;
import com.applozic.mobicomkit.channel.service.ApplozicAddMemberOfGroupType;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeedListResponse;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelClientService
extends MobiComKitClientService {
    private static final String CHANNEL_INFO_URL = "/rest/ws/group/info";
    private static final String CHANNEL_SYNC_URL = "/rest/ws/group/v3/list";
    private static final String CREATE_CHANNEL_URL = "/rest/ws/group/create";
    private static final String CREATE_MULTIPLE_CHANNEL_URL = "/rest/ws/group/create/multiple";
    private static final String ADD_MEMBER_TO_CHANNEL_URL = "/rest/ws/group/add/member";
    private static final String REMOVE_MEMBER_FROM_CHANNEL_URL = "/rest/ws/group/remove/member";
    private static final String CHANNEL_UPDATE_URL = "/rest/ws/group/update";
    private static final String CHANNEL_LEFT_URL = "/rest/ws/group/left";
    private static final String ADD_MEMBER_TO_MULTIPLE_CHANNELS_URL = "/rest/ws/group/add/user";
    private static final String CHANNEL_DELETE_URL = "/rest/ws/group/delete";
    private static final String REMOVE_MEMBERS_FROM_MULTIPE_CHANNELS = "/rest/ws/group/remove/user";
    private static final String MUTE_CHANNEL_UPDATE = "/rest/ws/group/user/update";
    private static final String ADD_MEMBERS_TO_CONTACT_GROUP_URL = "/rest/ws/group/%s/add";
    private static final String GET_MEMBERS_FROM_CONTACT_GROUP_URL = "/rest/ws/group/%s/get";
    private static final String GET_GROUP_INFO_FROM_GROUP_IDS_URL = "/rest/ws/group/details";
    private static final String ADD_MEMBERS_TO_CONTACT_GROUP_OF_TYPE_URL = "/rest/ws/group/%s/add/members";
    private static final String GET_MEMBERS_TO_CONTACT_GROUP_OF_TYPE_URL = "/rest/ws/group/%s/get";
    private static final String GET_MEMBERS_FROM_CONTACT_GROUP_LIST_URL = "/rest/ws/group/favourite/list/get";
    private static final String CREATE_CONVERSATION_URL = "/conversations";
    private static final String UPDATED_AT = "updatedAt";
    private static final String USER_ID = "userId";
    private static final String GROUP_ID = "groupId";
    private static final String UPDATE_CLIENT_GROUP_ID = "updateClientGroupId";
    private static final String RESET_UNREAD_COUNT = "resetCount";
    private static final String CLIENT_GROUPID = "clientGroupId";
    private static final String GROUPIDS = "groupIds";
    private static final String GROUP_NAME = "groupName";
    private static final String CLIENT_GROUPIDs = "clientGroupIds";
    private static final String GROUPTYPE = "groupType";
    private static final String TAG = "ChannelClientService";
    private static ChannelClientService channelClientService;
    private static final String REMOVE_MEMBERS_FROM_CONTACT_GROUP_OF_TYPE_URL = "/rest/ws/group/%s/remove";
    private HttpRequestUtils httpRequestUtils;

    private ChannelClientService(Context context) {
        super(context);
        this.context = ApplozicService.getContext((Context)context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public static ChannelClientService getInstance(Context context) {
        if (channelClientService == null) {
            channelClientService = new ChannelClientService(ApplozicService.getContext((Context)context));
        }
        return channelClientService;
    }

    public String getChannelInfoUrl() {
        return this.getBaseUrl() + CHANNEL_INFO_URL;
    }

    public String getChannelSyncUrl() {
        return this.getBaseUrl() + CHANNEL_SYNC_URL;
    }

    public String getCreateChannelUrl() {
        return this.getBaseUrl() + CREATE_CHANNEL_URL;
    }

    public String getMuteChannelUrl() {
        return this.getBaseUrl() + MUTE_CHANNEL_UPDATE;
    }

    public String getCreateMultipleChannelUrl() {
        return this.getBaseUrl() + CREATE_MULTIPLE_CHANNEL_URL;
    }

    public String getAddMemberToGroup() {
        return this.getBaseUrl() + ADD_MEMBER_TO_CHANNEL_URL;
    }

    public String getRemoveMemberUrl() {
        return this.getBaseUrl() + REMOVE_MEMBER_FROM_CHANNEL_URL;
    }

    public String getChannelUpdateUrl() {
        return this.getBaseUrl() + CHANNEL_UPDATE_URL;
    }

    public String getChannelLeftUrl() {
        return this.getBaseUrl() + CHANNEL_LEFT_URL;
    }

    public String getChannelDeleteUrl() {
        return this.getBaseUrl() + CHANNEL_DELETE_URL;
    }

    public String getAddMemberToMultipleChannelsUrl() {
        return this.getBaseUrl() + ADD_MEMBER_TO_MULTIPLE_CHANNELS_URL;
    }

    public String getRemoveMembersFromMultipChannels() {
        return this.getBaseUrl() + REMOVE_MEMBERS_FROM_MULTIPE_CHANNELS;
    }

    public String addMembersToContactGroupUrl() {
        return this.getBaseUrl() + ADD_MEMBERS_TO_CONTACT_GROUP_URL;
    }

    public String addMembersToContactGroupOfTypeUrl() {
        return this.getBaseUrl() + ADD_MEMBERS_TO_CONTACT_GROUP_OF_TYPE_URL;
    }

    public String getMembersFromContactGroupUrl() {
        return this.getBaseUrl() + "/rest/ws/group/%s/get";
    }

    public String getMembersFromContactGroupOfTypeUrl() {
        return this.getBaseUrl() + "/rest/ws/group/%s/get";
    }

    private String getMembersFromContactGroupListUrl() {
        return this.getBaseUrl() + GET_MEMBERS_FROM_CONTACT_GROUP_LIST_URL;
    }

    public String getGroupInfoFromGroupIdsUrl() {
        return this.getBaseUrl() + GET_GROUP_INFO_FROM_GROUP_IDS_URL;
    }

    public String getRemoveMemberFromGroupTypeUrl() {
        return this.getBaseUrl() + REMOVE_MEMBERS_FROM_CONTACT_GROUP_OF_TYPE_URL;
    }

    private String getCreateConversationUrl() {
        return this.getKmBaseUrl() + CREATE_CONVERSATION_URL;
    }

    public ChannelFeed getChannelInfoByParameters(String parameters) {
        String response = "";
        try {
            response = this.httpRequestUtils.getResponse(this.getChannelInfoUrl() + "?" + parameters, "application/json", "application/json");
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ChannelFeedApiResponse.class));
            Utils.printLog((Context)this.context, (String)TAG, (String)("Channel info response  is :" + response));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
                return channelFeed;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ChannelFeed getChannelInfo(String clientGroupId) {
        return this.getChannelInfoByParameters("clientGroupId=" + clientGroupId);
    }

    public ChannelFeed getChannelInfo(Integer channelKey) {
        return this.getChannelInfoByParameters("groupId=" + channelKey);
    }

    public ApiResponse muteNotification(MuteNotificationRequest muteNotificationRequest) {
        ApiResponse apiResponse = null;
        try {
            if (muteNotificationRequest.isRequestValid()) {
                String requestJson = GsonUtils.getJsonFromObject((Object)((Object)muteNotificationRequest), MuteNotificationRequest.class);
                String response = this.httpRequestUtils.postData(this.getMuteChannelUrl(), "application/json", "application/json", requestJson);
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Mute notification response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public SyncChannelFeed getChannelFeed(String lastChannelSyncTime) {
        String url = this.getChannelSyncUrl() + "?" + UPDATED_AT + "=" + lastChannelSyncTime;
        try {
            String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Channel sync call response: " + response));
            return (SyncChannelFeed)((Object)GsonUtils.getObjectFromJson((String)response, SyncChannelFeed.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public ChannelFeed createChannel(ChannelInfo channelInfo) {
        ChannelFeed channelFeed = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)channelInfo), ((Object)((Object)channelInfo)).getClass());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCreateChannelUrl(), "application/json", "application/json", jsonFromObject);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Create channel Response :" + createChannelResponse));
            ChannelFeedApiResponse channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                channelFeed = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return channelFeed;
    }

    public ChannelFeedApiResponse createChannelWithReponse(ChannelInfo channelInfo) throws Exception {
        String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)channelInfo), ((Object)((Object)channelInfo)).getClass());
        String createChannelResponse = this.httpRequestUtils.postData(this.getCreateChannelUrl(), "application/json", "application/json", jsonFromObject);
        Utils.printLog((Context)this.context, (String)TAG, (String)("Create channel Response :" + createChannelResponse));
        return (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class));
    }

    public List<ChannelFeed> createMultipleChannels(List<ChannelInfo> channels) {
        List<ChannelFeed> channelFeeds = null;
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject(channels, (Type)new TypeToken<List<ChannelInfo>>(){}.getType());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCreateMultipleChannelUrl(), "application/json", "application/json", jsonFromObject);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Create Multiple channel Response :" + createChannelResponse));
            MultipleChannelFeedApiResponse channelFeedApiResponse = (MultipleChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)createChannelResponse, MultipleChannelFeedApiResponse.class));
            if (channelFeedApiResponse != null && channelFeedApiResponse.isSuccess()) {
                channelFeeds = channelFeedApiResponse.getResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return channelFeeds;
    }

    public ApiResponse removeMembersFromMultipleChannelsByChannelKeys(Set<Integer> channelKeys, Set<String> userIds) {
        return this.removeMembersFromMultipleChannels(null, channelKeys, userIds);
    }

    public ApiResponse removeMembersFromMultipleChannelsByClientGroupIds(Set<String> clientGroupIds, Set<String> userIds) {
        return this.removeMembersFromMultipleChannels(clientGroupIds, null, userIds);
    }

    private ApiResponse removeMembersFromMultipleChannels(Set<String> clientGroupIds, Set<Integer> channelKeys, Set<String> userIds) {
        ApiResponse apiResponse;
        block9: {
            apiResponse = null;
            try {
                if (userIds == null || userIds.size() <= 0) break block9;
                String parameters = "";
                if (clientGroupIds != null && clientGroupIds.size() > 0) {
                    for (String clientGroupId : clientGroupIds) {
                        parameters = parameters + "clientGroupIds=" + URLEncoder.encode(clientGroupId, "UTF-8") + "&";
                    }
                } else if (channelKeys != null && channelKeys.size() > 0) {
                    for (Integer channelKey : channelKeys) {
                        parameters = parameters + "groupIds=" + channelKey + "&";
                    }
                }
                for (String userId : userIds) {
                    parameters = parameters + "userId=" + URLEncoder.encode(userId, "UTF-8") + "&";
                }
                String url = this.getRemoveMembersFromMultipChannels() + "?" + parameters;
                String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Channel remove members from channels response: " + apiResponse.getStatus()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return apiResponse;
    }

    public synchronized ApiResponse addMemberToMultipleChannels(Set<String> clientGroupIds, Set<Integer> channelKeys, String userId) {
        ApiResponse apiResponse;
        block7: {
            apiResponse = null;
            try {
                String url;
                String response;
                if (TextUtils.isEmpty((CharSequence)userId)) break block7;
                String parameters = "";
                if (clientGroupIds != null && clientGroupIds.size() > 0) {
                    for (String clientGroupId : clientGroupIds) {
                        parameters = parameters + "clientGroupIds=" + URLEncoder.encode(clientGroupId, "UTF-8") + "&";
                    }
                } else {
                    for (Integer channelKey : channelKeys) {
                        parameters = parameters + "groupIds=" + channelKey + "&";
                    }
                }
                if ((apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = this.getAddMemberToMultipleChannelsUrl() + "?" + parameters + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8"), "application/json", "application/json")), ApiResponse.class))) != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Channel add member call response: " + apiResponse.getStatus()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return apiResponse;
    }

    public ApiResponse addMemberToMultipleChannelsByChannelKey(Set<Integer> channelKeys, String userId) {
        return this.addMemberToMultipleChannels(null, channelKeys, userId);
    }

    public ApiResponse addMemberToMultipleChannelsByClientGroupIds(Set<String> clientGroupIds, String userId) {
        return this.addMemberToMultipleChannels(clientGroupIds, null, userId);
    }

    public synchronized ApiResponse addMemberToChannel(String clientGroupId, Integer channelKey, String userId) {
        try {
            String parameters = "";
            parameters = !TextUtils.isEmpty((CharSequence)clientGroupId) ? "clientGroupId=" + URLEncoder.encode(clientGroupId, "UTF-8") : "groupId=" + channelKey;
            if (!TextUtils.isEmpty((CharSequence)parameters) && !TextUtils.isEmpty((CharSequence)userId)) {
                String url = this.getAddMemberToGroup() + "?" + parameters + "&" + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8");
                String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
                ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Channel add member call response: " + apiResponse.getStatus()));
                }
                return apiResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized ApiResponse addMemberToChannel(Integer channelKey, String userId) {
        return this.addMemberToChannel(null, channelKey, userId);
    }

    public synchronized ApiResponse addMemberToChannel(String clientGroupId, String userId) {
        return this.addMemberToChannel(clientGroupId, null, userId);
    }

    public synchronized ApiResponse removeMemberFromChannel(String clientGroupId, Integer channelKey, String userId) {
        ApiResponse apiResponse = null;
        try {
            String url;
            String response;
            String parameters = "";
            parameters = !TextUtils.isEmpty((CharSequence)clientGroupId) ? "clientGroupId=" + URLEncoder.encode(clientGroupId, "UTF-8") : "groupId=" + channelKey;
            if (!TextUtils.isEmpty((CharSequence)parameters) && !TextUtils.isEmpty((CharSequence)userId) && (apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = this.getRemoveMemberUrl() + "?" + parameters + "&" + USER_ID + "=" + URLEncoder.encode(userId, "UTF-8"), "application/json", "application/json")), ApiResponse.class))) != null) {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Channel remove member response: " + apiResponse.getStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse removeMemberFromChannel(Integer channelKey, String userId) {
        return this.removeMemberFromChannel(null, channelKey, userId);
    }

    public synchronized ApiResponse removeMemberFromChannel(String clientGroupId, String userId) {
        return this.removeMemberFromChannel(clientGroupId, null, userId);
    }

    public synchronized ApiResponse updateChannel(GroupInfoUpdate groupInfoUpdate) {
        ApiResponse apiResponse = null;
        try {
            if (groupInfoUpdate != null) {
                String channelNameUpdateJson = GsonUtils.getJsonFromObject((Object)((Object)groupInfoUpdate), GroupInfoUpdate.class);
                String response = this.httpRequestUtils.postData(this.getChannelUpdateUrl(), "application/json", "application/json", channelNameUpdateJson);
                apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Update Channel response: " + apiResponse.getStatus()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public ApiResponse leaveMemberFromChannel(Integer channelKey) {
        return this.leaveMemberFromChannel(null, channelKey);
    }

    public ApiResponse leaveMemberFromChannel(String clientGroupId) {
        return this.leaveMemberFromChannel(clientGroupId, null);
    }

    public synchronized ApiResponse leaveMemberFromChannel(String clientGroupId, Integer channelKey) {
        ApiResponse apiResponse = null;
        try {
            String url;
            String response;
            String parameters = "";
            parameters = !TextUtils.isEmpty((CharSequence)clientGroupId) ? "clientGroupId=" + URLEncoder.encode(clientGroupId, "UTF-8") : "groupId=" + channelKey;
            if ((!TextUtils.isEmpty((CharSequence)clientGroupId) || channelKey != null && channelKey != 0) && (apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = this.getChannelLeftUrl() + "?" + parameters, "application/json", "application/json")), ApiResponse.class))) != null) {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Channel leave member call response: " + apiResponse.getStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return apiResponse;
    }

    public synchronized ApiResponse deleteChannel(Integer channelKey) {
        return this.deleteChannel(channelKey, false, false);
    }

    public synchronized ApiResponse deleteChannel(Integer channelKey, boolean updateClientGroupId, boolean resetCount) {
        try {
            if (channelKey != null) {
                String response;
                ApiResponse apiResponse;
                StringBuilder urlBuilder = new StringBuilder(this.getChannelDeleteUrl());
                urlBuilder.append("?").append(GROUP_ID).append("=").append(URLEncoder.encode(String.valueOf(channelKey), "UTF-8"));
                if (updateClientGroupId) {
                    urlBuilder.append("&").append(UPDATE_CLIENT_GROUP_ID).append("=").append("true");
                }
                if (resetCount) {
                    urlBuilder.append("&").append(RESET_UNREAD_COUNT).append("=").append("true");
                }
                if ((apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(urlBuilder.toString(), "application/json", "application/json")), ApiResponse.class))) != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Channel delete call response: " + apiResponse.getStatus()));
                }
                return apiResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ChannelFeedApiResponse createChannelWithResponse(ChannelInfo channelInfo) {
        try {
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)((Object)channelInfo), ((Object)((Object)channelInfo)).getClass());
            String createChannelResponse = this.httpRequestUtils.postData(this.getCreateChannelUrl(), "application/json", "application/json", jsonFromObject);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Create channel Response :" + createChannelResponse));
            if (TextUtils.isEmpty((CharSequence)createChannelResponse)) {
                return null;
            }
            return (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)createChannelResponse, ChannelFeedApiResponse.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiResponse addMemberToContactGroup(String contactGroupId, List<String> contactGroupMemberList) {
        if (!TextUtils.isEmpty((CharSequence)contactGroupId) && contactGroupMemberList != null) {
            String url = String.format(this.addMembersToContactGroupUrl(), contactGroupId);
            Utils.printLog((Context)this.context, (String)TAG, (String)url);
            String jsonFromObject = GsonUtils.getJsonFromObject(contactGroupMemberList, List.class);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Sending json:" + jsonFromObject));
            try {
                String response = this.httpRequestUtils.postData(url, "application/json", "application/json", jsonFromObject);
                ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Add Member To Contact Group Response: " + apiResponse.getStatus()));
                    return apiResponse;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ApiResponse addMemberToContactGroupOfType(String contactGroupId, String groupType, List<String> contactGroupMemberList) {
        if (!TextUtils.isEmpty((CharSequence)contactGroupId) && !TextUtils.isEmpty((CharSequence)groupType) && contactGroupMemberList != null) {
            String url = String.format(this.addMembersToContactGroupOfTypeUrl(), contactGroupId);
            ApplozicAddMemberOfGroupType applozicAddMemberOfGroupType = new ApplozicAddMemberOfGroupType();
            applozicAddMemberOfGroupType.setGroupMemberList(contactGroupMemberList);
            applozicAddMemberOfGroupType.setType(groupType);
            String jsonFromObject = GsonUtils.getJsonFromObject((Object)applozicAddMemberOfGroupType, ApplozicAddMemberOfGroupType.class);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Sending json:" + jsonFromObject));
            try {
                String response = this.httpRequestUtils.postData(url, "application/json", "application/json", jsonFromObject);
                ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Add Member To Contact Group Response: " + apiResponse.getStatus()));
                    return apiResponse;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ChannelFeed getMembersFromContactGroup(String contactGroupId) {
        String url;
        String response;
        ChannelFeedApiResponse channelFeedApiResponse;
        if (!TextUtils.isEmpty((CharSequence)contactGroupId) && (channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = String.format(this.getMembersFromContactGroupUrl(), contactGroupId), "application/json", "application/json")), ChannelFeedApiResponse.class))) != null && channelFeedApiResponse.isSuccess()) {
            ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
            return channelFeed;
        }
        return null;
    }

    public ChannelFeed getMembersFromContactGroupOfType(String contactGroupId, String groupType) {
        String url;
        String response;
        ChannelFeedApiResponse channelFeedApiResponse;
        if (!TextUtils.isEmpty((CharSequence)contactGroupId) && !TextUtils.isEmpty((CharSequence)groupType) && (channelFeedApiResponse = (ChannelFeedApiResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = String.format(this.getMembersFromContactGroupOfTypeUrl() + "?" + GROUPTYPE + "=" + groupType, contactGroupId), "application/json", "application/json")), ChannelFeedApiResponse.class))) != null && channelFeedApiResponse.isSuccess()) {
            ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
            return channelFeed;
        }
        return null;
    }

    public ChannelFeedListResponse getGroupInfoFromGroupIds(List<String> groupIds, List<String> clientGroupIds) {
        ChannelFeedListResponse apiResponse = null;
        try {
            String url;
            String response;
            StringBuilder parameters = new StringBuilder("?");
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    if (TextUtils.isEmpty((CharSequence)groupId)) continue;
                    parameters.append("groupIds=" + groupId + "&");
                }
            }
            if (clientGroupIds != null) {
                for (String clientGroupId : clientGroupIds) {
                    if (TextUtils.isEmpty((CharSequence)clientGroupId) || groupIds != null && groupIds.contains(clientGroupId)) continue;
                    parameters.append("clientGroupIds=" + clientGroupId + "&");
                }
            }
            if ((apiResponse = (ChannelFeedListResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = this.getGroupInfoFromGroupIdsUrl() + parameters, "application/json", "application/json")), ChannelFeedListResponse.class))) != null) {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Group Info from groupIds/clientGroupIds response : " + apiResponse.getStatus()));
            }
        }
        catch (Exception e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)e.getMessage());
        }
        return apiResponse;
    }

    public ChannelFeedListResponse getMemebersFromContactGroupIds(List<String> groupIds, List<String> groupNames, String groupType) {
        ChannelFeedListResponse channelFeedListResponse = null;
        try {
            String url;
            String response;
            StringBuilder parameters = new StringBuilder("?");
            if (!TextUtils.isEmpty((CharSequence)groupType)) {
                parameters.append("groupType=" + groupType + "&");
            }
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    if (TextUtils.isEmpty((CharSequence)groupId)) continue;
                    parameters.append("groupId=" + groupId + "&");
                }
            }
            if (groupNames != null) {
                for (String groupName : groupNames) {
                    if (TextUtils.isEmpty((CharSequence)groupName)) continue;
                    parameters.append("groupName=" + groupName + "&");
                }
            }
            if ((channelFeedListResponse = (ChannelFeedListResponse)((Object)GsonUtils.getObjectFromJson((String)(response = this.httpRequestUtils.getResponse(url = this.getMembersFromContactGroupListUrl() + parameters, "application/json", "application/json")), ChannelFeedListResponse.class))) != null) {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Get Memebers from Contact Group List of Type Response : " + channelFeedListResponse.getStatus()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return channelFeedListResponse;
    }

    public String createConversation(Integer groupId, String userId, String agentId, String applicationId) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(GROUP_ID, (Object)groupId);
            jsonObject.put("participentUserId", (Object)userId);
            jsonObject.put("createdBy", (Object)userId);
            jsonObject.put("defaultAgentId", (Object)agentId);
            jsonObject.put("applicationId", (Object)applicationId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        try {
            String response = this.httpRequestUtils.postData(this.getCreateConversationUrl(), "application/json", "application/json", jsonObject.toString());
            Utils.printLog((Context)this.context, (String)TAG, (String)("Response : " + response));
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiResponse removeMemberFromContactGroupOfType(String groupName, String groupType, String userId) {
        if (!TextUtils.isEmpty((CharSequence)groupName) && !TextUtils.isEmpty((CharSequence)userId)) {
            String parameters = !TextUtils.isEmpty((CharSequence)groupType) ? "?userId=" + userId + "&" + GROUPTYPE + "=" + groupType : "?userId=" + userId;
            String url = String.format(this.getRemoveMemberFromGroupTypeUrl() + parameters, groupName);
            try {
                String response = this.httpRequestUtils.getResponse(url, "application/json", "application/json");
                ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
                if (apiResponse != null) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Remove memeber from Group of Type Response: " + apiResponse.getStatus()));
                    return apiResponse;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

