/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.task.AlAsyncTask;
import java.lang.ref.WeakReference;

public class AlTotalUnreadCountTask
extends AlAsyncTask<Void, Integer> {
    private static final String TAG = "AlTotalUnreadCountTask";
    private TaskListener callback;
    private WeakReference<Context> weakReferenceContext;
    MessageDatabaseService messageDatabaseService;

    public AlTotalUnreadCountTask(Context context, TaskListener callback) {
        this.callback = callback;
        this.weakReferenceContext = new WeakReference<Context>(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
    }

    protected Integer doInBackground() {
        try {
            if (!ApplozicClient.getInstance(ApplozicService.getContextFromWeak(this.weakReferenceContext)).wasServerCallDoneBefore(null, null, null)) {
                if (!Utils.isInternetAvailable((Context)ApplozicService.getContextFromWeak(this.weakReferenceContext))) {
                    return null;
                }
                SyncCallService.getInstance(ApplozicService.getContextFromWeak(this.weakReferenceContext)).getLatestMessagesGroupByPeople(null, MobiComUserPreference.getInstance(ApplozicService.getContextFromWeak(this.weakReferenceContext)).getParentGroupKey());
            }
            return this.messageDatabaseService.getTotalUnreadCount();
        }
        catch (Exception e) {
            Utils.printLog((Context)ApplozicService.getContextFromWeak(this.weakReferenceContext), (String)TAG, (String)e.getMessage());
            return null;
        }
    }

    protected void onPostExecute(Integer unreadCount) {
        super.onPostExecute((Object)unreadCount);
        if (this.callback != null) {
            if (unreadCount != null) {
                this.callback.onSuccess(unreadCount);
            } else {
                this.callback.onFailure("Failed to fetch the unread count");
            }
        }
    }

    public static interface TaskListener {
        public void onSuccess(Integer var1);

        public void onFailure(String var1);
    }
}

