/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.data.AlPrefSettings;
import java.io.File;
import java.util.Set;

public class MobiComUserPreference {
    private static final String USER_ID = "userId";
    public static final String AL_USER_PREF_KEY = "al_user_pref_key";
    public static MobiComUserPreference userpref;
    private static String device_registration_id;
    private static String device_key_string;
    private static String last_outbox_sync_time;
    private static String delivery_report_pref_key;
    private static String last_inbox_sync_time;
    private static String last_message_stat_sync_time;
    private static String sent_sms_sync_pref_key;
    private static String email;
    private static String email_verified;
    private static String user_key_string;
    private static String stop_service;
    private static String patch_available;
    private static String webhook_enable_key;
    private static String group_sms_freq_key;
    private static String update_push_registration;
    private static String verify_contact_number;
    private static String received_sms_sync_pref_key;
    private static String phone_number_key;
    private static String call_history_display_within_messages_pref_key;
    private static String mobitexter_contact_sync_key;
    private static String last_sms_sync_time;
    private static String new_message_flag;
    private static String base_url;
    private static String display_name;
    private static String logged_in;
    private static String lastSeenAtSyncTime;
    private static String channelSyncTime;
    private static String device_time_offset_from_UTC;
    private static String image_compression_enabled;
    private static String userBlockSyncTime;
    private static String max_compressed_image_size;
    private static String image_link;
    private static String registered_users_last_fetch_time;
    private static String password;
    private static String authenticationType;
    private static String mqtt_broker_url;
    private static String contact_list_server_call;
    private static String pricing_package;
    private static String delete_channel;
    private static String encryption_Key;
    private static String enable_encryption;
    private static String enable_auto_download_on_wifi;
    private static String enable_auto_download_on_cellular;
    private static String video_call_token;
    private static String user_type_id;
    private static String application_info_call_done;
    private static String CONTACTS_GROUP_ID;
    private static String CONTACT_GROUP_ID_LISTS;
    private static String IS_CONTACT_GROUP_NAME_LIST;
    private static String last_sync_time_for_metadata_update;
    private static String START_TIME_FOR_MESSAGE_LIST_SCROLL;
    private static String USER_ROLE_TYPE;
    private static String sync_contacts;
    private static String contact_sync_time;
    private static String device_contact_sync_time;
    private static String PARENT_GROUP_KEY;
    private static String user_encryption_Key;
    private static String CATEGORY_NAME_KEY;
    private static String USER_AUTH_TOKEN;
    private static String AUTH_TOKEN_VALID_UPTO_MINS;
    private static String AUTH_TOKEN_CREATED_AT_TIME;
    private static String USER_DEACTIVATED;
    private static String CHANNEL_LIST_LAST_GENERATED_TIME;
    private static String CHANNEL_LIST_LAST_GENERATED_DEFAULT_VALUE;
    private static String ENCRYPTION_IV;
    private SharedPreferences sharedPreferences;
    private Context context;
    private String countryCode;

    private MobiComUserPreference(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        ApplozicService.initWithContext((Context)context);
        MobiComUserPreference.renameSharedPrefFile(this.context);
        this.sharedPreferences = this.context.getSharedPreferences(AL_USER_PREF_KEY, 0);
        this.moveKeysToSecured();
    }

    public static MobiComUserPreference getInstance(Context context) {
        if (userpref == null) {
            userpref = new MobiComUserPreference(ApplozicService.getContext((Context)context));
        }
        return userpref;
    }

    public static synchronized void renameSharedPrefFile(Context context) {
        File oldFile = new File("/data/data/" + Utils.getPackageName((Context)context) + "/shared_prefs/" + MobiComKitClientService.getApplicationKey(context) + ".xml");
        if (oldFile.exists()) {
            oldFile.renameTo(new File("/data/data/" + Utils.getPackageName((Context)context) + "/shared_prefs/" + AL_USER_PREF_KEY + ".xml"));
        }
    }

    public synchronized void moveKeysToSecured() {
        if (this.sharedPreferences != null) {
            if (this.sharedPreferences.contains(password)) {
                this.setPassword(this.sharedPreferences.getString(password, null));
                this.sharedPreferences.edit().remove(password).commit();
            }
            if (this.sharedPreferences.contains(user_encryption_Key)) {
                this.setUserEncryptionKey(this.sharedPreferences.getString(user_encryption_Key, null));
                this.sharedPreferences.edit().remove(user_encryption_Key).commit();
            }
            if (this.sharedPreferences.contains(encryption_Key)) {
                this.setEncryptionKey(encryption_Key);
                this.sharedPreferences.edit().remove(encryption_Key).commit();
            }
        }
    }

    public boolean isRegistered() {
        return !TextUtils.isEmpty((CharSequence)this.getDeviceKeyString());
    }

    public String getDeviceRegistrationId() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(device_registration_id, null);
        }
        return null;
    }

    public void setDeviceRegistrationId(String deviceRegistrationId) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(device_registration_id, deviceRegistrationId).commit();
        }
    }

    public String getDeviceKeyString() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(device_key_string, null);
        }
        return null;
    }

    public void setDeviceKeyString(String deviceKeyString) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(device_key_string, deviceKeyString).commit();
        }
    }

    public long getLastOutboxSyncTime() {
        return this.sharedPreferences.getLong(last_outbox_sync_time, 0L);
    }

    public void setLastOutboxSyncTime(long lastOutboxSyncTime) {
        this.sharedPreferences.edit().putLong(last_outbox_sync_time, lastOutboxSyncTime).commit();
    }

    public boolean isReportEnable() {
        return this.sharedPreferences.getBoolean(delivery_report_pref_key, false);
    }

    public void setReportEnable(boolean reportEnable) {
        this.sharedPreferences.edit().putBoolean(delivery_report_pref_key, reportEnable).commit();
    }

    public String getLastSyncTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(last_sms_sync_time, "0");
        }
        return null;
    }

    public void setLastSyncTime(String lastSyncTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(last_sms_sync_time, lastSyncTime).commit();
        }
    }

    public long getLastInboxSyncTime() {
        return this.sharedPreferences.getLong(last_inbox_sync_time, 0L);
    }

    public void setLastInboxSyncTime(long lastInboxSyncTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putLong(last_inbox_sync_time, lastInboxSyncTime).commit();
        }
    }

    public Long getLastMessageStatSyncTime() {
        return this.sharedPreferences.getLong(last_message_stat_sync_time, 0L);
    }

    public void setLastMessageStatSyncTime(long lastMessageStatSyncTime) {
        this.sharedPreferences.edit().putLong(last_message_stat_sync_time, lastMessageStatSyncTime).commit();
    }

    public boolean isSentSmsSyncFlag() {
        return this.sharedPreferences.getBoolean(sent_sms_sync_pref_key, true);
    }

    public void setSentSmsSyncFlag(boolean sentSmsSyncFlag) {
        this.sharedPreferences.edit().putBoolean(sent_sms_sync_pref_key, sentSmsSyncFlag).commit();
    }

    public String getEmailIdValue() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(email, null);
        }
        return null;
    }

    public void setEmailIdValue(String emailIdValue) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(email, emailIdValue).commit();
        }
    }

    public String getUserId() {
        if (this.sharedPreferences != null) {
            String userId = this.sharedPreferences.getString(USER_ID, null);
            if (TextUtils.isEmpty((CharSequence)userId)) {
                return this.getEmailIdValue();
            }
            return userId;
        }
        return null;
    }

    public void setUserId(String userId) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(USER_ID, userId).commit();
        }
    }

    public boolean isEmailVerified() {
        return this.sharedPreferences.getBoolean(email_verified, true);
    }

    public void setEmailVerified(boolean emailVerified) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(email_verified, emailVerified).commit();
        }
    }

    public String getSuUserKeyString() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(user_key_string, null);
        }
        return null;
    }

    public void setSuUserKeyString(String suUserKeyString) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(user_key_string, suUserKeyString).commit();
        }
    }

    public boolean isStopServiceFlag() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(stop_service, false);
        }
        return false;
    }

    public void setStopServiceFlag(Boolean stopServiceFlag) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(stop_service, stopServiceFlag.booleanValue()).commit();
        }
    }

    public boolean isPatchAvailable() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(patch_available, false);
        }
        return false;
    }

    public void setPatchAvailable(Boolean patchAvailable) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(patch_available, patchAvailable.booleanValue()).commit();
        }
    }

    public boolean isWebHookEnable() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(webhook_enable_key, false);
        }
        return false;
    }

    public void setWebHookEnable(boolean enable) {
        this.sharedPreferences.edit().putBoolean(webhook_enable_key, enable).commit();
    }

    public int getGroupSmsDelayInSec() {
        return this.sharedPreferences.getInt(group_sms_freq_key, 0);
    }

    public void setDelayGroupSmsDelayTime(int delay) {
        this.sharedPreferences.edit().putInt(group_sms_freq_key, delay).commit();
    }

    public boolean isUpdateRegFlag() {
        return this.sharedPreferences.getBoolean(update_push_registration, false);
    }

    public void setUpdateRegFlag(boolean updateRegFlag) {
        this.sharedPreferences.edit().putBoolean(update_push_registration, updateRegFlag).commit();
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean isVerifyContactNumber() {
        return this.sharedPreferences.getBoolean(verify_contact_number, false);
    }

    public void setVerifyContactNumber(boolean verifyContactNumber) {
        this.sharedPreferences.edit().putBoolean(verify_contact_number, verifyContactNumber).commit();
    }

    public boolean getReceivedSmsSyncFlag() {
        return this.sharedPreferences.getBoolean(received_sms_sync_pref_key, true);
    }

    public void setReceivedSmsSyncFlag(boolean receivedSmsSyncFlag) {
        this.sharedPreferences.edit().putBoolean(received_sms_sync_pref_key, receivedSmsSyncFlag).commit();
    }

    public String getContactNumber() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(phone_number_key, null);
        }
        return null;
    }

    public void setContactNumber(String contactNumber) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(phone_number_key, contactNumber).commit();
        }
    }

    public boolean isDisplayCallRecordEnable() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(call_history_display_within_messages_pref_key, false);
        }
        return false;
    }

    public void setDisplayCallRecordEnable(boolean enable) {
        this.sharedPreferences.edit().putBoolean(call_history_display_within_messages_pref_key, enable).commit();
    }

    public boolean getNewMessageFlag() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(new_message_flag, false);
        }
        return false;
    }

    public void setNewMessageFlag(boolean enable) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(new_message_flag, enable).commit();
        }
    }

    public long getDeviceTimeOffset() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getLong(device_time_offset_from_UTC, 0L);
        }
        return 0L;
    }

    public boolean setDeviceTimeOffset(long diiference) {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.edit().putLong(device_time_offset_from_UTC, diiference).commit();
        }
        return false;
    }

    public boolean isMobiTexterContactSyncCompleted() {
        return this.sharedPreferences.getBoolean(mobitexter_contact_sync_key, false);
    }

    public void setMobiTexterContactSyncCompleted(boolean status) {
        this.sharedPreferences.edit().putBoolean(mobitexter_contact_sync_key, status).commit();
    }

    public String getUrl() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(base_url, null);
        }
        return null;
    }

    public void setUrl(String url) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(base_url, url).commit();
        }
    }

    public String getMqttBrokerUrl() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(mqtt_broker_url, null);
        }
        return null;
    }

    public void setMqttBrokerUrl(String url) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(mqtt_broker_url, url).commit();
        }
    }

    public int getPricingPackage() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getInt(pricing_package, (int)RegistrationResponse.PricingType.STARTER.getValue().shortValue());
        }
        return 0;
    }

    public void setPricingPackage(int pricingPackage) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putInt(pricing_package, pricingPackage).commit();
        }
    }

    public String getDisplayName() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(display_name, null);
        }
        return null;
    }

    public void setDisplayName(String displayName) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(display_name, displayName).commit();
        }
    }

    public boolean isLoggedIn() {
        if (this.sharedPreferences != null) {
            return !TextUtils.isEmpty((CharSequence)this.getUserId());
        }
        return false;
    }

    public String getLastSeenAtSyncTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(lastSeenAtSyncTime, "0");
        }
        return null;
    }

    public void setLastSeenAtSyncTime(String lastSeenAtTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(lastSeenAtSyncTime, lastSeenAtTime).commit();
        }
    }

    public String getChannelSyncTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(channelSyncTime, "0");
        }
        return null;
    }

    public void setChannelSyncTime(String syncChannelTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(channelSyncTime, syncChannelTime).commit();
        }
    }

    public int getCompressedImageSizeInMB() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getInt(max_compressed_image_size, 10);
        }
        return 0;
    }

    public void setCompressedImageSizeInMB(int maxSize) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putInt(max_compressed_image_size, maxSize).commit();
        }
    }

    public void setLastSyncTimeForMetadataUpdate(String lastSyncTime) {
        this.sharedPreferences.edit().putString(last_sync_time_for_metadata_update, lastSyncTime).commit();
    }

    public String getLastSyncTimeForMetadataUpdate() {
        return this.sharedPreferences.getString(last_sync_time_for_metadata_update, null);
    }

    public String getUserBlockSyncTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(userBlockSyncTime, "0");
        }
        return null;
    }

    public void setUserBlockSyncTime(String lastUserBlockSyncTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(userBlockSyncTime, lastUserBlockSyncTime).commit();
        }
    }

    public long getRegisteredUsersLastFetchTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getLong(registered_users_last_fetch_time, 0L);
        }
        return 0L;
    }

    public void setRegisteredUsersLastFetchTime(long lastFetchTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putLong(registered_users_last_fetch_time, lastFetchTime).commit();
        }
    }

    public String getImageLink() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(image_link, null);
        }
        return null;
    }

    public void setImageLink(String imageUrl) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(image_link, imageUrl).commit();
        }
    }

    public String getPassword() {
        if (this.sharedPreferences != null) {
            String decryptedPassword = AlPrefSettings.getInstance((Context)this.context).getPassword();
            if (!TextUtils.isEmpty((CharSequence)decryptedPassword)) {
                return decryptedPassword;
            }
            String savedPassword = this.sharedPreferences.getString(password, null);
            if (!TextUtils.isEmpty((CharSequence)savedPassword)) {
                this.setPassword(savedPassword);
                this.sharedPreferences.edit().remove(password).commit();
            }
            return savedPassword;
        }
        return null;
    }

    public void setPassword(String val) {
        AlPrefSettings.getInstance((Context)this.context).setPassword(val);
    }

    public String getAuthenticationType() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(authenticationType, "0");
        }
        return null;
    }

    public void setAuthenticationType(String val) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(authenticationType, val).commit();
        }
    }

    public void setDeleteChannel(boolean channelDelete) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(delete_channel, channelDelete).commit();
        }
    }

    public boolean isChannelDeleted() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(delete_channel, false);
        }
        return false;
    }

    public MobiComUserPreference setUserAuthToken(String authToken) {
        AlPrefSettings.getInstance((Context)this.context).setUserAuthToken(authToken);
        return this;
    }

    public String getUserAuthToken() {
        String decodedUserAuthToken = AlPrefSettings.getInstance((Context)this.context).getUserAuthToken();
        if (!TextUtils.isEmpty((CharSequence)decodedUserAuthToken)) {
            return decodedUserAuthToken;
        }
        if (this.sharedPreferences != null) {
            String savedUserAuthToken = this.sharedPreferences.getString(USER_AUTH_TOKEN, null);
            if (!TextUtils.isEmpty((CharSequence)savedUserAuthToken)) {
                this.setUserAuthToken(savedUserAuthToken);
                this.sharedPreferences.edit().remove(USER_AUTH_TOKEN).commit();
            }
            return savedUserAuthToken;
        }
        return null;
    }

    public String toString() {
        return "MobiComUserPreference{context=" + this.context + ", countryCode='" + this.getCountryCode() + '\'' + ", deviceKeyString=" + this.getDeviceKeyString() + ", contactNumber=" + this.getContactNumber() + '}';
    }

    public boolean clearAll() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.edit().clear().commit();
        }
        return false;
    }

    public boolean isImageCompressionEnabled() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(image_compression_enabled, true);
        }
        return false;
    }

    public void setImageCompressionEnabled(boolean imageCompressionEnabled) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(image_compression_enabled, imageCompressionEnabled).commit();
        }
    }

    public boolean getWasContactListServerCallAlreadyDone() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(contact_list_server_call, false);
        }
        return false;
    }

    public void setWasContactListServerCallAlreadyDone(Boolean serverCallAlreadyDone) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(contact_list_server_call, serverCallAlreadyDone.booleanValue()).commit();
        }
    }

    public String getEncryptionKey() {
        String decodedEncryptionKey = AlPrefSettings.getInstance((Context)this.context).getEncryptionKey();
        if (!TextUtils.isEmpty((CharSequence)decodedEncryptionKey)) {
            return decodedEncryptionKey;
        }
        if (this.sharedPreferences != null) {
            String savedEncryptionKey = this.sharedPreferences.getString(encryption_Key, null);
            if (!TextUtils.isEmpty((CharSequence)savedEncryptionKey)) {
                this.setEncryptionKey(savedEncryptionKey);
                this.sharedPreferences.edit().remove(encryption_Key).commit();
            }
            return savedEncryptionKey;
        }
        return null;
    }

    public void setEncryptionKey(String encryptionKey) {
        AlPrefSettings.getInstance((Context)this.context).setEncryptionKey(encryptionKey);
    }

    public boolean isEncryptionEnabled() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(enable_encryption, false);
        }
        return false;
    }

    public void enableEncryption(boolean enableEncryption) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(enable_encryption, enableEncryption).commit();
        }
    }

    public boolean getAutoDownloadOnWifi() {
        return this.sharedPreferences.getBoolean(enable_auto_download_on_wifi, false);
    }

    public void setAutoDownloadOnWifi(boolean enable) {
        this.sharedPreferences.edit().putBoolean(enable_auto_download_on_wifi, enable).commit();
    }

    public boolean getAutoDownloadOnCellular() {
        return this.sharedPreferences.getBoolean(enable_auto_download_on_cellular, false);
    }

    public void setAutoDownloadOnCellular(boolean enable) {
        this.sharedPreferences.edit().putBoolean(enable_auto_download_on_cellular, enable).commit();
    }

    public String getVideoCallToken() {
        return this.sharedPreferences.getString(video_call_token, null);
    }

    public void setVideoCallToken(String token) {
        this.sharedPreferences.edit().putString(video_call_token, token).commit();
    }

    public String getUserTypeId() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(user_type_id, null);
        }
        return null;
    }

    public void setUserTypeId(String userTypeId) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(user_type_id, userTypeId).commit();
        }
    }

    public boolean getApplicationInfoCall() {
        return this.sharedPreferences.getBoolean(application_info_call_done, false);
    }

    public void setApplicationInfoCallDone(boolean customerResponse) {
        this.sharedPreferences.edit().putBoolean(application_info_call_done, customerResponse).commit();
    }

    public String getContactsGroupId() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(CONTACTS_GROUP_ID, null);
        }
        return null;
    }

    public void setContactsGroupId(String contactsGroupId) {
        this.sharedPreferences.edit().putString(CONTACTS_GROUP_ID, contactsGroupId).commit();
    }

    public void setContactGroupIdList(Set<String> contactGroupList) {
        this.sharedPreferences.edit().putStringSet(CONTACT_GROUP_ID_LISTS, contactGroupList).commit();
    }

    public Set<String> getContactGroupIdList() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getStringSet(CONTACT_GROUP_ID_LISTS, null);
        }
        return null;
    }

    public boolean isContactGroupNameList() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(IS_CONTACT_GROUP_NAME_LIST, false);
        }
        return false;
    }

    public void setIsContactGroupNameList(boolean isContactGroupNameList) {
        this.sharedPreferences.edit().putBoolean(IS_CONTACT_GROUP_NAME_LIST, isContactGroupNameList).commit();
    }

    public void setStartTimeForPagination(Long startTime) {
        this.sharedPreferences.edit().putLong(START_TIME_FOR_MESSAGE_LIST_SCROLL, startTime.longValue()).commit();
    }

    public Long getStartTimeForPagination() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getLong(START_TIME_FOR_MESSAGE_LIST_SCROLL, 0L);
        }
        return null;
    }

    public void setUserRoleType(Short roleType) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putInt(USER_ROLE_TYPE, (int)roleType.shortValue()).commit();
        }
    }

    public Short getUserRoleType() {
        if (this.sharedPreferences != null) {
            return (short)this.sharedPreferences.getInt(USER_ROLE_TYPE, 0);
        }
        return (short)0;
    }

    public boolean isSyncRequired() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(sync_contacts, false);
        }
        return false;
    }

    public void setSyncContacts(boolean syncConatcts) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(sync_contacts, syncConatcts).commit();
        }
    }

    public long getDeviceContactSyncTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getLong(device_contact_sync_time, 0L);
        }
        return 0L;
    }

    public void setDeviceContactSyncTime(long contactSyncTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putLong(device_contact_sync_time, contactSyncTime).commit();
        }
    }

    public long getContactSyncTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getLong(contact_sync_time, 0L);
        }
        return 0L;
    }

    public void setContactSyncTime(long contactSyncTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putLong(contact_sync_time, contactSyncTime).commit();
        }
    }

    public Integer getParentGroupKey() {
        return this.sharedPreferences.getInt(PARENT_GROUP_KEY, 0);
    }

    public void setParentGroupKey(Integer parentGroupKey) {
        this.sharedPreferences.edit().putInt(PARENT_GROUP_KEY, parentGroupKey.intValue()).commit();
    }

    public String getUserEncryptionKey() {
        String decodedUserEncryptionKey = AlPrefSettings.getInstance((Context)this.context).getUserEncryptionKey();
        if (!TextUtils.isEmpty((CharSequence)decodedUserEncryptionKey)) {
            return decodedUserEncryptionKey;
        }
        if (this.sharedPreferences != null) {
            String savedUserEncryptionKey = this.sharedPreferences.getString(user_encryption_Key, null);
            if (!TextUtils.isEmpty((CharSequence)savedUserEncryptionKey)) {
                this.setUserEncryptionKey(savedUserEncryptionKey);
                this.sharedPreferences.edit().remove(user_encryption_Key).commit();
            }
            return savedUserEncryptionKey;
        }
        return null;
    }

    public void setUserEncryptionKey(String userEncryptionKey) {
        AlPrefSettings.getInstance((Context)this.context).setUserEncryptionKey(userEncryptionKey);
    }

    public String getCategoryName() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(CATEGORY_NAME_KEY, null);
        }
        return null;
    }

    public void setCategoryName(String category) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(CATEGORY_NAME_KEY, category).commit();
        }
    }

    public long getTokenCreatedAtTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getLong(AUTH_TOKEN_CREATED_AT_TIME, 0L);
        }
        return 0L;
    }

    public MobiComUserPreference setTokenCreatedAtTime(Long authTokenCreatedAtTime) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putLong(AUTH_TOKEN_CREATED_AT_TIME, authTokenCreatedAtTime.longValue()).commit();
        }
        return this;
    }

    public int getTokenValidUptoMins() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getInt(AUTH_TOKEN_VALID_UPTO_MINS, 0);
        }
        return 0;
    }

    public MobiComUserPreference setTokenValidUptoMins(Integer validUptoMins) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putInt(AUTH_TOKEN_VALID_UPTO_MINS, validUptoMins.intValue()).commit();
        }
        return this;
    }

    public void setUserDeactivated(boolean isDeactivated) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putBoolean(USER_DEACTIVATED, isDeactivated).commit();
        }
    }

    public boolean isUserDeactivated() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getBoolean(USER_DEACTIVATED, false);
        }
        return false;
    }

    public void setChannelListLastGeneratedAtTime(String generatedAt) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(CHANNEL_LIST_LAST_GENERATED_TIME, generatedAt).commit();
        }
    }

    public String getChannelListLastGeneratedAtTime() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(CHANNEL_LIST_LAST_GENERATED_TIME, CHANNEL_LIST_LAST_GENERATED_DEFAULT_VALUE);
        }
        return CHANNEL_LIST_LAST_GENERATED_DEFAULT_VALUE;
    }

    public String getEncryptionIVString() {
        String defaultValue = new String(new byte[16]);
        try {
            if (this.sharedPreferences.contains(ENCRYPTION_IV)) {
                return this.sharedPreferences.getString(ENCRYPTION_IV, defaultValue);
            }
            this.sharedPreferences.edit().putString(ENCRYPTION_IV, new String(new byte[16])).commit();
            return this.sharedPreferences.getString(ENCRYPTION_IV, defaultValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    static {
        device_registration_id = "device_registration_id";
        device_key_string = "device_key_string";
        last_outbox_sync_time = "last_outbox_sync_time";
        delivery_report_pref_key = "delivery_report_pref_key";
        last_inbox_sync_time = "last_inbox_sync_time";
        last_message_stat_sync_time = "last_message_stat_sync_time";
        sent_sms_sync_pref_key = "sent_sms_sync_pref_key";
        email = "email";
        email_verified = "email_verified";
        user_key_string = "user_key_string";
        stop_service = "stop_service";
        patch_available = "patch_available";
        webhook_enable_key = "webhook_enable_key";
        group_sms_freq_key = "group_sms_freq_key";
        update_push_registration = "update_push_registration";
        verify_contact_number = "verify_contact_number";
        received_sms_sync_pref_key = "received_sms_sync_pref_key";
        phone_number_key = "phone_number_key";
        call_history_display_within_messages_pref_key = "call_history_display_within_messages_pref_key";
        mobitexter_contact_sync_key = "mobitexter_contact_sync_key";
        last_sms_sync_time = "last_sms_sync_time";
        new_message_flag = "new_message_flag";
        base_url = "base_url";
        display_name = "display_name";
        logged_in = "logged_in";
        lastSeenAtSyncTime = "lastSeenAtSyncTime";
        channelSyncTime = "channelSyncTime";
        device_time_offset_from_UTC = "device_time_offset_from_UTC";
        image_compression_enabled = "image_compression_enabled";
        userBlockSyncTime = "user_block_Sync_Time";
        max_compressed_image_size = "max_compressed_image_size";
        image_link = "image_link";
        registered_users_last_fetch_time = "registered_users_last_fetch_time";
        password = "password";
        authenticationType = "authenticationType";
        mqtt_broker_url = "mqtt_broker_url";
        contact_list_server_call = "contact_list_server_call";
        pricing_package = "pricing_package";
        delete_channel = "delete_channel";
        encryption_Key = "encryption_Key";
        enable_encryption = "enable_encryption";
        enable_auto_download_on_wifi = "enable_auto_download_on_wifi";
        enable_auto_download_on_cellular = "enable_auto_download_on_cellular";
        video_call_token = "video_call_token";
        user_type_id = "user_type_id";
        application_info_call_done = "application_info_call_done";
        CONTACTS_GROUP_ID = "CONTACTS_GROUP_ID";
        CONTACT_GROUP_ID_LISTS = "contactGroupIdLists";
        IS_CONTACT_GROUP_NAME_LIST = "isContactGroupNameList";
        last_sync_time_for_metadata_update = "lastSyncTimeForMetadataUpdate";
        START_TIME_FOR_MESSAGE_LIST_SCROLL = "startTimeForMessageListScroll";
        USER_ROLE_TYPE = "userRoleType";
        sync_contacts = "sync_contacts";
        contact_sync_time = "contact_sync_time";
        device_contact_sync_time = "device_contact_sync_time";
        PARENT_GROUP_KEY = "PARENT_GROUP_KEY";
        user_encryption_Key = "user_encryption_Key";
        CATEGORY_NAME_KEY = "CATEGORY_KEY";
        USER_AUTH_TOKEN = "USER_AUTH_TOKEN";
        AUTH_TOKEN_VALID_UPTO_MINS = "AUTH_TOKEN_VALID_UPTO_MINS";
        AUTH_TOKEN_CREATED_AT_TIME = "AUTH_TOKEN_CREATED_AT_TIME";
        USER_DEACTIVATED = "USER_DEACTIVATED";
        CHANNEL_LIST_LAST_GENERATED_TIME = "channelListLastGeneratedAtTime";
        CHANNEL_LIST_LAST_GENERATED_DEFAULT_VALUE = "10000";
        ENCRYPTION_IV = "ENCRYPTION_IV";
    }
}

