/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.content.Context;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ErrorResponseFeed;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.task.AlAsyncTask;
import java.lang.ref.WeakReference;

public class MuteUserNotificationAsync
extends AlAsyncTask<Void, ApiResponse> {
    TaskListener listener;
    Long notificationAfterTime;
    WeakReference<Context> context;
    String userId;
    ApiResponse response;

    public MuteUserNotificationAsync(TaskListener listener, Long notificationAfterTime, String userId, Context context) {
        this.listener = listener;
        this.notificationAfterTime = notificationAfterTime;
        this.userId = userId;
        this.context = new WeakReference<Context>(context);
    }

    protected ApiResponse doInBackground() {
        return UserService.getInstance((Context)this.context.get()).muteUserNotifications(this.userId, this.notificationAfterTime);
    }

    protected void onPostExecute(ApiResponse apiResponse) {
        super.onPostExecute((Object)apiResponse);
        if (apiResponse == null) {
            this.listener.onFailure("Some error occurred", (Context)this.context.get());
        } else if ("success".equals(apiResponse.getStatus())) {
            this.listener.onSuccess("Successfully muted/unmuted user", (Context)this.context.get());
        } else if (apiResponse.getErrorResponse() != null) {
            this.listener.onFailure(GsonUtils.getJsonFromObject((Object)apiResponse.getErrorResponse().toArray(new ErrorResponseFeed[apiResponse.getErrorResponse().size()]), ErrorResponseFeed[].class), (Context)this.context.get());
        } else {
            this.listener.onFailure("Some unknown error occurred", (Context)this.context.get());
        }
    }

    public static interface TaskListener {
        public void onSuccess(String var1, Context var2);

        public void onFailure(String var1, Context var2);
    }
}

