/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class NotificationChannels {
    public static int NOTIFICATION_CHANNEL_VERSION = 1;
    private Context context;
    private NotificationManager mNotificationManager;
    private String soundFilePath;
    private String TAG = this.getClass().getSimpleName();

    public NotificationChannels(Context context, String soundFilePath) {
        this.context = context;
        this.soundFilePath = soundFilePath;
        this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
    }

    @RequiresApi(api=26)
    public void prepareNotificationChannels() {
        if (Applozic.getInstance(this.context).getNotificationChannelVersion() < NOTIFICATION_CHANNEL_VERSION) {
            if (this.isNotificationChannelCreated()) {
                this.deleteNotificationChannel();
            }
            if (this.isSilentChannelCreated()) {
                this.deleteSilentNotificationChannel();
            }
            if (this.isAppChannelCreated()) {
                Applozic.getInstance(this.context).setCustomNotificationSound(null);
                this.soundFilePath = null;
                this.deleteAppNotificationChannel();
            }
            if (TextUtils.isEmpty((CharSequence)this.soundFilePath)) {
                this.createNotificationChannel();
            } else {
                try {
                    this.createAppNotificationChannel();
                }
                catch (ApplozicException e) {
                    e.printStackTrace();
                }
            }
            this.createSilentNotificationChannel();
            Applozic.getInstance(this.context).setNotificationChannelVersion(NOTIFICATION_CHANNEL_VERSION);
        }
    }

    @RequiresApi(api=26)
    public void deleteAllChannels() {
        if (this.isSilentChannelCreated()) {
            this.deleteSilentNotificationChannel();
        }
        if (this.isNotificationChannelCreated()) {
            this.deleteNotificationChannel();
        }
        if (this.isAppChannelCreated()) {
            this.deleteAppNotificationChannel();
        }
    }

    public String getDefaultChannelId(boolean mute) {
        if (mute) {
            return "AL_SILENT_NOTIFICATION";
        }
        if (TextUtils.isEmpty((CharSequence)this.soundFilePath)) {
            return "AL_PUSH_NOTIFICATION";
        }
        return "AL_APP_NOTIFICATION";
    }

    @RequiresApi(api=26)
    private synchronized void createNotificationChannel() {
        String name = "Push Notification";
        int importance = 4;
        if (this.mNotificationManager != null && this.mNotificationManager.getNotificationChannel("AL_PUSH_NOTIFICATION") == null) {
            NotificationChannel mChannel = new NotificationChannel("AL_PUSH_NOTIFICATION", (CharSequence)name, importance);
            mChannel.enableLights(true);
            mChannel.setLightColor(-16711936);
            mChannel.setShowBadge(ApplozicClient.getInstance(this.context).isUnreadCountBadgeEnabled());
            if (ApplozicClient.getInstance(this.context).getVibrationOnNotification()) {
                mChannel.enableVibration(true);
                mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            }
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
            mChannel.setSound(TextUtils.isEmpty((CharSequence)this.soundFilePath) ? RingtoneManager.getDefaultUri((int)2) : Uri.parse((String)this.soundFilePath), audioAttributes);
            this.mNotificationManager.createNotificationChannel(mChannel);
            Utils.printLog((Context)this.context, (String)this.TAG, (String)"Created notification channel");
        }
    }

    @RequiresApi(api=26)
    private synchronized void createAppNotificationChannel() throws ApplozicException {
        String name = "App Notification";
        int importance = 4;
        if (this.mNotificationManager != null && this.mNotificationManager.getNotificationChannel("AL_APP_NOTIFICATION") == null) {
            NotificationChannel mChannel = new NotificationChannel("AL_APP_NOTIFICATION", (CharSequence)name, importance);
            mChannel.enableLights(true);
            mChannel.setLightColor(-16711936);
            mChannel.setShowBadge(ApplozicClient.getInstance(this.context).isUnreadCountBadgeEnabled());
            if (ApplozicClient.getInstance(this.context).getVibrationOnNotification()) {
                mChannel.enableVibration(true);
                mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            }
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
            if (TextUtils.isEmpty((CharSequence)this.soundFilePath)) {
                throw new ApplozicException("Custom sound path is required to create App notification channel. Please set a sound path using Applozic.getInstance(context).setCustomNotificationSound(your-sound-file-path)");
            }
            mChannel.setSound(Uri.parse((String)this.soundFilePath), audioAttributes);
            this.mNotificationManager.createNotificationChannel(mChannel);
            Utils.printLog((Context)this.context, (String)this.TAG, (String)"Created app notification channel");
        }
    }

    @RequiresApi(api=26)
    private synchronized void createSilentNotificationChannel() {
        String name = "Silent Notification";
        int importance = 2;
        if (this.mNotificationManager != null && this.mNotificationManager.getNotificationChannel("AL_SILENT_NOTIFICATION") == null) {
            NotificationChannel mChannel = new NotificationChannel("AL_SILENT_NOTIFICATION", (CharSequence)name, importance);
            mChannel.enableLights(true);
            mChannel.setLightColor(-16711936);
            if (ApplozicClient.getInstance(this.context).isUnreadCountBadgeEnabled()) {
                mChannel.setShowBadge(true);
            } else {
                mChannel.setShowBadge(false);
            }
            this.mNotificationManager.createNotificationChannel(mChannel);
            Utils.printLog((Context)this.context, (String)this.TAG, (String)"Created silent notification channel");
        }
    }

    @RequiresApi(api=26)
    private synchronized void deleteNotificationChannel() {
        if (this.mNotificationManager != null) {
            this.mNotificationManager.deleteNotificationChannel("AL_PUSH_NOTIFICATION");
            Utils.printLog((Context)this.context, (String)this.TAG, (String)"Deleted notification channel");
        }
    }

    @RequiresApi(api=26)
    private synchronized void deleteSilentNotificationChannel() {
        if (this.mNotificationManager != null) {
            this.mNotificationManager.deleteNotificationChannel("AL_SILENT_NOTIFICATION");
            Utils.printLog((Context)this.context, (String)this.TAG, (String)"Deleted silent notification channel");
        }
    }

    @RequiresApi(api=26)
    private synchronized void deleteAppNotificationChannel() {
        if (this.mNotificationManager != null) {
            this.mNotificationManager.deleteNotificationChannel("AL_APP_NOTIFICATION");
            Utils.printLog((Context)this.context, (String)this.TAG, (String)"Deleted app notification channel");
        }
    }

    @RequiresApi(api=26)
    private boolean isNotificationChannelCreated() {
        return this.mNotificationManager != null && this.mNotificationManager.getNotificationChannel("AL_PUSH_NOTIFICATION") != null;
    }

    @RequiresApi(api=26)
    private boolean isAppChannelCreated() {
        return this.mNotificationManager != null && this.mNotificationManager.getNotificationChannel("AL_APP_NOTIFICATION") != null;
    }

    @RequiresApi(api=26)
    private boolean isSilentChannelCreated() {
        return this.mNotificationManager != null && this.mNotificationManager.getNotificationChannel("AL_SILENT_NOTIFICATION") != null;
    }
}

