/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.core.app.AlJobIntentService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.List;

public class ConversationIntentService
extends AlJobIntentService {
    public static final String SYNC = "AL_SYNC";
    public static final String AL_MESSAGE = "AL_MESSAGE";
    private static final String TAG = "ConversationIntent";
    public static final String MESSAGE_METADATA_UPDATE = "MessageMetadataUpdate";
    public static final String MUTED_USER_LIST_SYNC = "MutedUserListSync";
    private static final int PRE_FETCH_MESSAGES_FOR = 6;
    private MobiComMessageService mobiComMessageService;
    static final int JOB_ID = 1000;

    public static void enqueueWork(Context context, Intent work) {
        ConversationIntentService.enqueueWork((Context)ApplozicService.getContext((Context)context), ConversationIntentService.class, (int)1000, (Intent)work);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.mobiComMessageService = new MobiComMessageService((Context)this, MessageIntentService.class);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        if (intent == null) {
            return;
        }
        boolean sync = intent.getBooleanExtra(SYNC, false);
        Utils.printLog((Context)this, (String)TAG, (String)("Syncing messages service started: " + sync));
        boolean metadataSync = intent.getBooleanExtra(MESSAGE_METADATA_UPDATE, false);
        boolean mutedUserListSync = intent.getBooleanExtra(MUTED_USER_LIST_SYNC, false);
        if (mutedUserListSync) {
            Utils.printLog((Context)this, (String)TAG, (String)"Muted user list sync started..");
            try {
                Thread thread = new Thread(new MutedUserListSync());
                thread.setPriority(10);
                thread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (metadataSync) {
            Utils.printLog((Context)this, (String)TAG, (String)"Syncing messages service started for metadata update");
            this.mobiComMessageService.syncMessageForMetadataUpdate();
            return;
        }
        Message message = (Message)((Object)intent.getSerializableExtra(AL_MESSAGE));
        if (message != null) {
            this.mobiComMessageService.processInstantMessage(message);
        } else if (sync) {
            this.mobiComMessageService.syncMessages();
        } else {
            Thread thread = new Thread(new ConversationSync());
            thread.setPriority(10);
            thread.start();
        }
    }

    private class MutedUserListSync
    implements Runnable {
        private MutedUserListSync() {
        }

        @Override
        public void run() {
            try {
                UserService.getInstance((Context)ConversationIntentService.this).getMutedUserList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ConversationSync
    implements Runnable {
        @Override
        public void run() {
            try {
                MobiComConversationService mobiComConversationService = new MobiComConversationService((Context)ConversationIntentService.this);
                List<Message> messages = mobiComConversationService.getLatestMessagesGroupByPeople();
                UserService.getInstance((Context)ConversationIntentService.this).processSyncUserBlock();
                for (Message message : messages.subList(0, Math.min(6, messages.size()))) {
                    Contact contact = null;
                    Channel channel = null;
                    if (message.getGroupId() != null) {
                        channel = new Channel(message.getGroupId());
                    } else {
                        contact = new Contact(message.getContactIds());
                    }
                    mobiComConversationService.getMessages(1L, null, contact, channel, null, true, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

