/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.ApplozicIntentService;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class TimeChangeBroadcastReceiver
extends BroadcastReceiver {
    public void onReceive(final Context context, Intent intent) {
        if (Utils.isDeviceInIdleState((Context)context)) {
            Thread timeChangeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Utils.printLog((Context)context, (String)"TimeChange", (String)"This thread has been called on date change");
                    long diff = DateUtils.getTimeDiffFromUtc();
                    MobiComUserPreference.getInstance(context).setDeviceTimeOffset(diff);
                }
            });
            timeChangeThread.setPriority(10);
            timeChangeThread.start();
        } else {
            Intent applozicIntent = new Intent(context, ApplozicIntentService.class);
            applozicIntent.putExtra("AL_TIME_CHANGE_RECEIVER", true);
            ApplozicIntentService.enqueueWork(context, applozicIntent);
        }
    }
}

