/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicommons.ALSpecificSettings;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.DBUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class MobiComDatabaseHelper
extends SQLiteOpenHelper {
    public static final int DB_VERSION = 35;
    public static final String _ID = "_id";
    public static final String DB_NAME = "APPLOZIC_LOCAL_DATABASE";
    public static final String SMS_KEY_STRING = "smsKeyString";
    public static final String STORE_ON_DEVICE_COLUMN = "storeOnDevice";
    public static final String TO_FIELD = "toField";
    public static final String SMS = "sms";
    public static final String TIMESTAMP = "timeStamp";
    public static final String SMS_TYPE = "SMSType";
    public static final String TIME_TO_LIVE = "timeToLive";
    public static final String CONTACTID = "contactId";
    public static final String SCHEDULE_SMS_TABLE_NAME = "ScheduleSMS";
    public static final String SMS_TABLE_NAME = "sms";
    public static final String CONTACT_TABLE_NAME = "contact";
    public static final String FULL_NAME = "fullName";
    public static final String CONTACT_NO = "contactNO";
    public static final String DISPLAY_NAME = "displayName";
    public static final String CONTACT_IMAGE_LOCAL_URI = "contactImageLocalURI";
    public static final String CONTACT_IMAGE_URL = "contactImageURL";
    public static final String CHANNEL_IMAGE_URL = "channelImageURL";
    public static final String CHANNEL_IMAGE_LOCAL_URI = "channelImageLocalURI";
    public static final String USERID = "userId";
    public static final String EMAIL = "email";
    public static final String APPLICATION_ID = "applicationId";
    public static final String CONNECTED = "connected";
    public static final String LAST_SEEN_AT_TIME = "lastSeenAt";
    public static final String MESSAGE_CONTENT_TYPE = "messageContentType";
    public static final String MESSAGE_METADATA = "metadata";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String TOPIC_ID = "topicId";
    public static final String CHANNEL_DISPLAY_NAME = "channelName";
    public static final String TYPE = "type";
    public static final String CHANNEL_KEY = "channelKey";
    public static final String CLIENT_GROUP_ID = "clientGroupId";
    public static final String USER_COUNT = "userCount";
    public static final String STATUS = "status";
    public static final String ADMIN_ID = "adminId";
    public static final String BLOCKED = "blocked";
    public static final String BLOCKED_BY = "blockedBy";
    public static final String UNREAD_COUNT = "unreadCount";
    public static final String TOPIC_DETAIL = "topicDetail";
    public static final String TOPIC_LOCAL_IMAGE_URL = "topicLocalImageUrl";
    public static final String CREATED = "created";
    public static final String SENDER_USER_NAME = "senderUserName";
    public static final String CHANNEL = "channel";
    public static final String CHANNEL_USER_X = "channel_User_X";
    public static final String KEY = "key";
    public static final String CONVERSATION = "conversation";
    public static final String CONTACT_TYPE = "contactType";
    public static final String USER_TYPE_ID = "userTypeId";
    public static final String NOTIFICATION_AFTER_TIME = "notificationAfterTime";
    public static final String DELETED_AT = "deletedAtTime";
    public static final String CHANNEL_META_DATA = "channelMetadata";
    public static final String HIDDEN = "hidden";
    public static final String REPLY_MESSAGE = "replyMessage";
    public static final String USER_METADATA = "userMetadata";
    public static final String USER_ROLE_TYPE = "userRoleType";
    public static final String LAST_MESSAGED_AT = "lastMessagedAt";
    public static final String URL = "url";
    public static final String ROLE = "role";
    public static final String APPLOZIC_TYPE = "applozicType";
    public static final String PHONE_CONTACT_DISPLAY_NAME = "phoneContactDisplayName";
    public static final String DEVICE_CONTACT_TYPE = "deviceContactType";
    public static final String PARENT_GROUP_KEY = "parentGroupKey";
    public static final String PARENT_CLIENT_GROUP_ID = "parentClientGroupId";
    public static final String THUMBNAIL_BLOB_KEY = "thumbnailBlobKey";
    public static final String AL_CATEGORY = "AL_CATEGORY";
    public static final String KM_STATUS = "kmStatus";
    public static final String CREATE_SCHEDULE_SMS_TABLE = "create table ScheduleSMS( _id integer primary key autoincrement  ,sms text not null, timeStamp INTEGER ,toField varchar(20) not null, SMSType varchar(20) not null ,contactId varchar(20) , smsKeyString varChar(50), storeOnDevice INTEGER DEFAULT 1, source INTEGER, timeToLive integer) ;";
    public static final String CREATE_SMS_TABLE = "create table sms ( id integer primary key autoincrement, keyString var(100), toNumbers varchar(1000), contactNumbers varchar(2000), message text not null, type integer, read integer default 0, delivered integer default 0, storeOnDevice integer default 1, sentToServer integer default 1, createdAt integer, scheduledAt integer, source integer, timeToLive integer, fileMetaKeyStrings varchar(2000), filePaths varchar(2000), metadata varchar(2000), thumbnailUrl varchar(2000), size integer, name varchar(2000), contentType varchar(200), metaFileKeyString varchar(2000), blobKeyString varchar(2000), thumbnailBlobKey varchar(2000), canceled integer default 0, deleted integer default 0,applicationId varchar(2000) null,messageContentType integer default 0,conversationId integer default 0,topicId varchar(300) null,channelKey integer default 0,status varchar(200) default 0,clientGroupId varchar(1000) default null,hidden integer default 0,replyMessage INTEGER default 0,url varchar(2000),UNIQUE (keyString,contactNumbers,channelKey))";
    private static final String SMS_BACKUP = "sms_backup";
    public static final String INSERT_INTO_SMS_FROM_SMS_BACKUP_QUERY = "INSERT INTO sms (id,keyString,toNumbers,contactNumbers,message,type,read,delivered,storeOnDevice,sentToServer,createdAt,scheduledAt,source,timeToLive,fileMetaKeyStrings,filePaths,metadata,thumbnailUrl,size,name,contentType,metaFileKeyString,blobKeyString,canceled,deleted,applicationId,messageContentType,conversationId,topicId,channelKey,status,hidden,replyMessage,url) SELECT id,keyString,toNumbers,contactNumbers,message,type,read,delivered,storeOnDevice,sentToServer,createdAt,scheduledAt,source,timeToLive,fileMetaKeyStrings,filePaths,metadata,thumbnailUrl,size,name,contentType,metaFileKeyString,blobKeyString,canceled,deleted,applicationId,messageContentType,conversationId,topicId,channelKey,status,hidden,replyMessage,url FROM sms_backup";
    private static final String DROP_SMS_BACKUP = "DROP TABLE sms_backup";
    private static final String ALTER_SMS_TABLE_FOR_DELETE_COLUMN = "ALTER TABLE sms ADD COLUMN deleted integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_APPLICATION_ID_COLUMN = "ALTER TABLE contact ADD COLUMN applicationId varchar(2000) null";
    private static final String ALTER_SMS_TABLE_FOR__APPLICATION_ID_COLUMN = "ALTER TABLE sms ADD COLUMN applicationId varchar(2000) null";
    private static final String ALTER_SMS_TABLE_FOR_CONTENT_TYPE_COLUMN = "ALTER TABLE sms ADD COLUMN messageContentType integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_STATUS = "ALTER TABLE contact ADD COLUMN status varchar(2500) null";
    private static final String ALTER_SMS_TABLE_FOR_METADATA_TYPE_COLUMN = "ALTER TABLE sms ADD COLUMN metadata varchar(2000) null";
    private static final String ALTER_CONTACT_TABLE_FOR_CONNECTED_COLUMN = "ALTER TABLE contact ADD COLUMN connected integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_LAST_SEEN_AT_COLUMN = "ALTER TABLE contact ADD COLUMN lastSeenAt integer default 0";
    private static final String ALTER_MESSAGE_TABLE_FOR_CONVERSATION_ID_COLUMN = "ALTER TABLE sms ADD COLUMN conversationId integer default 0";
    private static final String ALTER_MESSAGE_TABLE_FOR_TOPIC_ID_COLUMN = "ALTER TABLE sms ADD COLUMN topicId varchar(300) null";
    private static final String ALTER_CONTACT_TABLE_UNREAD_COUNT_COLUMN = "ALTER TABLE contact ADD COLUMN unreadCount integer default 0";
    private static final String ALTER_CHANNEL_TABLE_UNREAD_COUNT_COLUMN = "ALTER TABLE channel ADD COLUMN unreadCount integer default 0";
    private static final String ALTER_CONTACT_TABLE_BLOCKED_COLUMN = "ALTER TABLE contact ADD COLUMN blocked integer default 0";
    private static final String ALTER_CONTACT_TABLE_BLOCKED_BY_COLUMN = "ALTER TABLE contact ADD COLUMN blockedBy integer default 0";
    private static final String ALTER_CHANNEL_TABLE_FOR_IMAGE_URL_COLUMN = "ALTER TABLE channel ADD COLUMN channelImageURL varchar(300) null";
    private static final String ALTER_CHANNEL_TABLE_FOR_IMAGE_LOCAL_URI_COLUMN = "ALTER TABLE channel ADD COLUMN channelImageLocalURI varchar(300) null";
    private static final String ALTER_CHANNEL_TABLE_FOR_CLIENT_GROUP_ID = "ALTER TABLE channel ADD COLUMN clientGroupId varchar(200) null";
    private static final String ALTER_SMS_TABLE = "ALTER TABLE sms RENAME TO sms_backup";
    private static final String ALTER_CONVERSATION_TABLE_FOR_TOPIC_LOCAL_IMAGE_URL = "ALTER TABLE conversation ADD COLUMN topicLocalImageUrl varchar(500) null";
    private static final String ALTER_CONTACT_TABLE_FOR_CONTENT_TYPE_COLUMN = "ALTER TABLE contact ADD COLUMN contactType integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_USER_TYPE_ID_COLUMN = "ALTER TABLE contact ADD COLUMN userTypeId integer default 0";
    private static final String ALTER_CHANNEL_TABLE_FOR_NOTIFICATION_AFTER_TIME_COLUMN = "ALTER TABLE channel ADD COLUMN notificationAfterTime integer default 0";
    private static final String ALTER_CHANNEL_TABLE_FOR_DELETED_AT_COLUMN = "ALTER TABLE channel ADD COLUMN deletedAtTime integer";
    private static final String ALTER_CHANNEL_TABLE_FOR_CHANNEL_META_DATA = "ALTER TABLE channel ADD COLUMN channelMetadata VARCHAR(2000)";
    private static final String ALTER_SMS_TABLE_FOR_HIDDEN = "ALTER TABLE sms ADD COLUMN hidden integer default 0";
    private static final String ALTER_SMS_TABLE_FOR_REPLY_MESSAGE_COLUMN = "ALTER TABLE sms ADD COLUMN replyMessage INTEGER default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_DELETED_AT = "ALTER TABLE contact ADD COLUMN deletedAtTime integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_NOTIFICATION_AFTER_TIME = "ALTER TABLE contact ADD COLUMN notificationAfterTime integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_METADATA = "ALTER TABLE contact ADD COLUMN userMetadata varchar(2000) null";
    private static final String ALTER_CONTACT_TABLE_FOR_ROLE_TYPE = "ALTER TABLE contact ADD COLUMN userRoleType integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_LAST_MESSAGED_AT = "ALTER TABLE contact ADD COLUMN lastMessagedAt integer default 0";
    private static final String ALTER_SMS_TABLE_FOR_FILE_URL = "ALTER TABLE sms ADD COLUMN url varchar(2000)";
    private static final String ALTER_CHANNEL_USER_MAPPER_TABLE_FOR_ROLE = "ALTER TABLE channel_User_X ADD COLUMN role integer default 0";
    private static final String ALTER_CONTACT_TABLE_FOR_PHONE_CONTACT_DISPLAY_NAME = "ALTER TABLE contact ADD COLUMN phoneContactDisplayName varchar(100) ";
    private static final String ALTER_CONTACT_TABLE_FOR_APPLOZIC_TYPE = "ALTER TABLE contact ADD COLUMN applozicType integer default 1";
    private static final String ALTER_CONTACT_TABLE_FOR_DEVICE_CONTACT_TYPE = "ALTER TABLE contact ADD COLUMN deviceContactType integer default 1";
    private static final String ALTER_CHANNEL_TABLE_FOR_PARENT_GROUP_KEY_COLUMN = "ALTER TABLE channel ADD COLUMN parentGroupKey integer default 0";
    private static final String ALTER_CHANNEL_USER_MAPPER_TABLE_FOR_PARENT_GROUP_KEY_COLUMN = "ALTER TABLE channel_User_X ADD COLUMN parentGroupKey integer default 0";
    private static final String ALTER_CHANNEL_TABLE_FOR_PARENT_CLIENT_GROUP_ID_COLUMN = "ALTER TABLE channel ADD COLUMN parentClientGroupId varchar(1000) null";
    private static final String ALTER_CREATE_SMS_TABLE_FOR_THUMBNAIL_BLOB_KEY = "ALTER TABLE sms ADD COLUMN thumbnailBlobKey varchar(2000)";
    private static final String ALTER_CHANNEL_TABLE_FOR_AL_CATEGORY_COLUMN = "ALTER TABLE channel ADD COLUMN AL_CATEGORY VARCHAR(2000)";
    private static final String ALTER_CHANNEL_TABLE_FOR_KM_STATUS_COLUMN = "ALTER TABLE channel ADD COLUMN kmStatus integer default 0";
    private static final String CREATE_CONTACT_TABLE = " CREATE TABLE contact ( userId VARCHAR(50) primary key, fullName VARCHAR(200), contactNO VARCHAR(15), displayName VARCHAR(25), contactImageURL VARCHAR(200), contactImageLocalURI VARCHAR(200), email VARCHAR(100), applicationId VARCHAR(2000) null, connected integer default 0,lastSeenAt integer, unreadCount integer default 0,blocked integer default 0, blockedBy integer default 0, status varchar(2500) null, phoneContactDisplayName varchar(100),contactType integer default 0,applozicType integer default 0, userTypeId integer default 0,deletedAtTime INTEGER default 0, notificationAfterTime integer default 0, userRoleType integer default 0, lastMessagedAt integer, userMetadata varchar(2000) null, deviceContactType integer default 0 ) ";
    private static final String CREATE_CHANNEL_TABLE = " CREATE TABLE channel ( _id integer primary key autoincrement, channelKey integer , clientGroupId varchar(200), channelName varchar(200), adminId varchar(100), type integer default 0, unreadCount integer default 0, userCountinteger, channelImageURL VARCHAR(300), channelImageLocalURI VARCHAR(300), notificationAfterTime integer default 0, deletedAtTime integer,parentGroupKey integer default 0 ,parentClientGroupId varchar(1000) default null,channelMetadata VARCHAR(2000) ,AL_CATEGORY  VARCHAR(2000) ,kmStatus integer default 0)";
    private static final String CREATE_CHANNEL_USER_X_TABLE = " CREATE TABLE channel_User_X ( _id integer primary key autoincrement, channelKey integer , userId varchar(100), unreadCount integer, status integer, role integer default 0,parentGroupKey integer default 0,UNIQUE (channelKey, userId))";
    private static final String CREATE_CONVERSATION_TABLE = " CREATE TABLE conversation ( _id integer primary key autoincrement, key integer , topicId varchar(100) , userId varchar(100) ,channelKey integer ,topicDetail varchar(2500),topicLocalImageUrl varchar(500))";
    private static final String CREATE_INDEX_SMS_TYPE = "CREATE INDEX IF NOT EXISTS INDEX_SMS_TYPE ON sms (type)";
    private static final String CREATE_INDEX_ON_CREATED_AT = "CREATE INDEX IF NOT EXISTS message_createdAt ON sms (createdAt)";
    private static final String TAG = "MobiComDatabaseHelper";
    private static MobiComDatabaseHelper sInstance;
    private Context context;

    private MobiComDatabaseHelper(Context context) {
        this(context, !TextUtils.isEmpty((CharSequence)ALSpecificSettings.getInstance((Context)ApplozicService.getContext((Context)context)).getDatabaseName()) ? ALSpecificSettings.getInstance((Context)ApplozicService.getContext((Context)context)).getDatabaseName() : "MCK_" + MobiComKitClientService.getApplicationKey(ApplozicService.getContext((Context)context)), null, 35);
        this.context = ApplozicService.getContext((Context)context);
    }

    public MobiComDatabaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public static MobiComDatabaseHelper getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new MobiComDatabaseHelper(ApplozicService.getContext((Context)context));
        }
        return sInstance;
    }

    public SQLiteDatabase getReadableDatabase() {
        SQLiteDatabase database = super.getReadableDatabase();
        database.enableWriteAheadLogging();
        return database;
    }

    public SQLiteDatabase getWritableDatabase() {
        SQLiteDatabase database = super.getWritableDatabase();
        database.enableWriteAheadLogging();
        return database;
    }

    public void onCreate(SQLiteDatabase database) {
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)"sms")) {
            database.execSQL(CREATE_SMS_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)SCHEDULE_SMS_TABLE_NAME)) {
            database.execSQL(CREATE_SCHEDULE_SMS_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME)) {
            database.execSQL(CREATE_CONTACT_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL)) {
            database.execSQL(CREATE_CHANNEL_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONVERSATION)) {
            database.execSQL(CREATE_CONVERSATION_TABLE);
        }
        if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL_USER_X)) {
            database.execSQL(CREATE_CHANNEL_USER_X_TABLE);
        }
        database.execSQL(CREATE_INDEX_ON_CREATED_AT);
        database.execSQL(CREATE_INDEX_SMS_TYPE);
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        if (newVersion > oldVersion) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data"));
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)"sms")) {
                database.execSQL(CREATE_SMS_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)SCHEDULE_SMS_TABLE_NAME)) {
                database.execSQL(CREATE_SCHEDULE_SMS_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL)) {
                database.execSQL(CREATE_CHANNEL_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CHANNEL_USER_X)) {
                database.execSQL(CREATE_CHANNEL_USER_X_TABLE);
            }
            if (!DBUtils.isTableExists((SQLiteDatabase)database, (String)CONVERSATION)) {
                database.execSQL(CREATE_CONVERSATION_TABLE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)"deleted")) {
                database.execSQL(ALTER_SMS_TABLE_FOR_DELETE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)APPLICATION_ID)) {
                database.execSQL(ALTER_SMS_TABLE_FOR__APPLICATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)APPLICATION_ID)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_APPLICATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)UNREAD_COUNT)) {
                database.execSQL(ALTER_CONTACT_TABLE_UNREAD_COUNT_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)CONNECTED)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_CONNECTED_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)LAST_SEEN_AT_TIME)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_LAST_SEEN_AT_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)BLOCKED)) {
                database.execSQL(ALTER_CONTACT_TABLE_BLOCKED_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)BLOCKED_BY)) {
                database.execSQL(ALTER_CONTACT_TABLE_BLOCKED_BY_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)MESSAGE_CONTENT_TYPE)) {
                database.execSQL(ALTER_SMS_TABLE_FOR_CONTENT_TYPE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)MESSAGE_METADATA)) {
                database.execSQL(ALTER_SMS_TABLE_FOR_METADATA_TYPE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)CONVERSATION_ID)) {
                database.execSQL(ALTER_MESSAGE_TABLE_FOR_CONVERSATION_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)TOPIC_ID)) {
                database.execSQL(ALTER_MESSAGE_TABLE_FOR_TOPIC_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)CHANNEL_IMAGE_URL)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_IMAGE_URL_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)CHANNEL_IMAGE_LOCAL_URI)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_IMAGE_LOCAL_URI_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)CLIENT_GROUP_ID)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_CLIENT_GROUP_ID);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)UNREAD_COUNT)) {
                database.execSQL(ALTER_CHANNEL_TABLE_UNREAD_COUNT_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)STATUS)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_STATUS);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)CONTACT_TYPE)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_CONTENT_TYPE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONVERSATION, (String)TOPIC_LOCAL_IMAGE_URL)) {
                database.execSQL(ALTER_CONVERSATION_TABLE_FOR_TOPIC_LOCAL_IMAGE_URL);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)USER_TYPE_ID)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_USER_TYPE_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)NOTIFICATION_AFTER_TIME)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_NOTIFICATION_AFTER_TIME_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)DELETED_AT)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_DELETED_AT_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)DELETED_AT)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_DELETED_AT);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)CHANNEL_META_DATA)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_CHANNEL_META_DATA);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)HIDDEN)) {
                database.execSQL(ALTER_SMS_TABLE_FOR_HIDDEN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)REPLY_MESSAGE)) {
                database.execSQL(ALTER_SMS_TABLE_FOR_REPLY_MESSAGE_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)NOTIFICATION_AFTER_TIME)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_NOTIFICATION_AFTER_TIME);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)USER_METADATA)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_METADATA);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)USER_ROLE_TYPE)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_ROLE_TYPE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)LAST_MESSAGED_AT)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_LAST_MESSAGED_AT);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)URL)) {
                database.execSQL(ALTER_SMS_TABLE_FOR_FILE_URL);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"CHANNEL_USER_X", (String)ROLE)) {
                database.execSQL(ALTER_CHANNEL_USER_MAPPER_TABLE_FOR_ROLE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)APPLOZIC_TYPE)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_APPLOZIC_TYPE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)PHONE_CONTACT_DISPLAY_NAME)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_PHONE_CONTACT_DISPLAY_NAME);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CONTACT_TABLE_NAME, (String)DEVICE_CONTACT_TYPE)) {
                database.execSQL(ALTER_CONTACT_TABLE_FOR_DEVICE_CONTACT_TYPE);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)PARENT_GROUP_KEY)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_PARENT_GROUP_KEY_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL_USER_X, (String)PARENT_GROUP_KEY)) {
                database.execSQL(ALTER_CHANNEL_USER_MAPPER_TABLE_FOR_PARENT_GROUP_KEY_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)PARENT_CLIENT_GROUP_ID)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_PARENT_CLIENT_GROUP_ID_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)"sms", (String)THUMBNAIL_BLOB_KEY)) {
                database.execSQL(ALTER_CREATE_SMS_TABLE_FOR_THUMBNAIL_BLOB_KEY);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)AL_CATEGORY)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_AL_CATEGORY_COLUMN);
            }
            if (!DBUtils.existsColumnInTable((SQLiteDatabase)database, (String)CHANNEL, (String)KM_STATUS)) {
                database.execSQL(ALTER_CHANNEL_TABLE_FOR_KM_STATUS_COLUMN);
            }
            database.execSQL(CREATE_INDEX_ON_CREATED_AT);
            database.execSQL(CREATE_INDEX_SMS_TYPE);
            database.execSQL(ALTER_SMS_TABLE);
            database.execSQL(CREATE_SMS_TABLE);
            database.execSQL(INSERT_INTO_SMS_FROM_SMS_BACKUP_QUERY);
            database.execSQL(DROP_SMS_BACKUP);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        new UserClientService(MobiComDatabaseHelper.this.context).updateCodeVersion(MobiComUserPreference.getInstance(MobiComDatabaseHelper.this.context).getDeviceKeyString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        } else {
            this.onCreate(database);
        }
    }

    public synchronized void close() {
    }

    public int delDatabase() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("delete from ScheduleSMS");
        db.execSQL("delete from sms");
        db.execSQL("delete from contact");
        db.execSQL("delete from channel");
        db.execSQL("delete from channel_User_X");
        db.execSQL("delete from conversation");
        return 0;
    }
}

