/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.app.AlJobIntentService;
import com.applozic.mobicomkit.api.ApplozicMqttService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class ApplozicMqttIntentService
extends AlJobIntentService {
    public static final String TAG = "ApplozicMqttIntentService";
    public static final String SUBSCRIBE = "subscribe";
    public static final String SUBSCRIBE_TO_TYPING = "subscribeToTyping";
    public static final String UN_SUBSCRIBE_TO_TYPING = "unSubscribeToTyping";
    public static final String DEVICE_KEY_STRING = "deviceKeyString";
    public static final String USER_KEY_STRING = "userKeyString";
    public static final String CONNECTED_PUBLISH = "connectedPublish";
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String TYPING = "typing";
    public static final String STOP_TYPING = "STOP_TYPING";
    public static final String CONNECT_TO_SUPPORT_GROUP_TOPIC = "connectToSupportGroupTopic";
    public static final String DISCONNECT_FROM_SUPPORT_GROUP_TOPIC = "disconnectFromSupportGroupTopic";
    public static final String USE_ENCRYPTED_TOPIC = "useEncryptedTopic";
    static final int JOB_ID = 1110;

    public static void enqueueWork(Context context, Intent work) {
        ApplozicMqttIntentService.enqueueWork((Context)ApplozicService.getContext((Context)context), ApplozicMqttIntentService.class, (int)1110, (Intent)work);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        boolean stop;
        boolean connectedStatus;
        if (intent == null) {
            return;
        }
        boolean useEncryptedTopic = intent.getBooleanExtra(USE_ENCRYPTED_TOPIC, false);
        boolean subscribe = intent.getBooleanExtra(SUBSCRIBE, false);
        if (subscribe) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).subscribe(useEncryptedTopic);
        }
        Contact contact = (Contact)intent.getSerializableExtra(CONTACT);
        Channel channel = (Channel)intent.getSerializableExtra(CHANNEL);
        boolean subscribeToTyping = intent.getBooleanExtra(SUBSCRIBE_TO_TYPING, false);
        if (subscribeToTyping) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).subscribeToTypingTopic(channel);
            if (channel != null && Channel.GroupType.OPEN.getValue().equals(channel.getType())) {
                ApplozicMqttService.getInstance(this.getApplicationContext()).subscribeToOpenGroupTopic(channel);
            }
            return;
        }
        boolean unSubscribeToTyping = intent.getBooleanExtra(UN_SUBSCRIBE_TO_TYPING, false);
        if (unSubscribeToTyping) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).unSubscribeToTypingTopic(channel);
            if (channel != null && Channel.GroupType.OPEN.getValue().equals(channel.getType())) {
                ApplozicMqttService.getInstance(this.getApplicationContext()).unSubscribeToOpenGroupTopic(channel);
            }
            return;
        }
        boolean subscribeToSupportGroupTopic = intent.getBooleanExtra(CONNECT_TO_SUPPORT_GROUP_TOPIC, false);
        if (subscribeToSupportGroupTopic) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).subscribeToSupportGroup(useEncryptedTopic);
            return;
        }
        boolean unSubscribeToSupportGroupTopic = intent.getBooleanExtra(DISCONNECT_FROM_SUPPORT_GROUP_TOPIC, false);
        if (unSubscribeToSupportGroupTopic) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).unSubscribeToSupportGroup(useEncryptedTopic);
            return;
        }
        String userKeyString = intent.getStringExtra(USER_KEY_STRING);
        String deviceKeyString = intent.getStringExtra(DEVICE_KEY_STRING);
        if (!TextUtils.isEmpty((CharSequence)userKeyString) && !TextUtils.isEmpty((CharSequence)deviceKeyString)) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).disconnectPublish(userKeyString, deviceKeyString, "0", useEncryptedTopic);
        }
        if (connectedStatus = intent.getBooleanExtra(CONNECTED_PUBLISH, false)) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).connectPublish(MobiComUserPreference.getInstance(this.getApplicationContext()).getSuUserKeyString(), MobiComUserPreference.getInstance(this.getApplicationContext()).getDeviceKeyString(), "1");
        }
        if (contact != null && (stop = intent.getBooleanExtra(STOP_TYPING, false))) {
            ApplozicMqttService.getInstance(this.getApplicationContext()).typingStopped(contact, null);
        }
        if (contact != null && (contact.isBlocked() || contact.isBlockedBy())) {
            return;
        }
        if (contact != null || channel != null) {
            boolean typing = intent.getBooleanExtra(TYPING, false);
            if (typing) {
                ApplozicMqttService.getInstance(this.getApplicationContext()).typingStarted(contact, channel);
            } else {
                ApplozicMqttService.getInstance(this.getApplicationContext()).typingStopped(contact, channel);
            }
        }
    }
}

