/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;

public class RegisteredUsersAsyncTask
extends AsyncTask<Void, Void, Boolean> {
    private final TaskListener taskListener;
    Context context;
    int numberOfUsersToFetch;
    UserService userService;
    long lastTimeFetched;
    String[] userIdArray;
    RegisteredUsersApiResponse registeredUsersApiResponse;
    boolean callForRegistered;
    private Exception mException;
    private Message message;
    private String messageContent;

    public RegisteredUsersAsyncTask(Context context, TaskListener listener, int numberOfUsersToFetch, Message message, String messageContent) {
        this.message = message;
        this.context = context;
        this.taskListener = listener;
        this.messageContent = messageContent;
        this.numberOfUsersToFetch = numberOfUsersToFetch;
        this.userService = UserService.getInstance(context);
    }

    public RegisteredUsersAsyncTask(Context context, TaskListener listener, int numberOfUsersToFetch, long lastTimeFetched, Message message, String messageContent, boolean callForRegistered) {
        this.callForRegistered = callForRegistered;
        this.message = message;
        this.taskListener = listener;
        this.context = context;
        this.messageContent = messageContent;
        this.numberOfUsersToFetch = numberOfUsersToFetch;
        this.lastTimeFetched = lastTimeFetched;
        this.userService = UserService.getInstance(context);
    }

    protected Boolean doInBackground(Void ... params) {
        try {
            if (this.callForRegistered) {
                this.registeredUsersApiResponse = this.userService.getRegisteredUsersList(this.lastTimeFetched, this.numberOfUsersToFetch);
            } else {
                this.userIdArray = this.userService.getOnlineUsers(this.numberOfUsersToFetch);
            }
            return this.registeredUsersApiResponse != null || this.userIdArray != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mException = e;
            return false;
        }
    }

    protected void onPostExecute(Boolean result) {
        if (result.booleanValue() && this.taskListener != null) {
            this.taskListener.onSuccess(this.registeredUsersApiResponse, this.userIdArray);
        } else if (!result.booleanValue() && this.taskListener != null) {
            this.taskListener.onFailure(this.registeredUsersApiResponse, this.userIdArray, this.mException);
        }
        this.taskListener.onCompletion();
    }

    public static interface TaskListener {
        public void onSuccess(RegisteredUsersApiResponse var1, String[] var2);

        public void onFailure(RegisteredUsersApiResponse var1, String[] var2, Exception var3);

        public void onCompletion();
    }
}

