/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.PushNotificationTask;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserLoginTask;
import com.applozic.mobicomkit.api.account.user.UserLogoutTask;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.broadcast.ApplozicBroadcastReceiver;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.listners.AlLoginHandler;
import com.applozic.mobicomkit.listners.AlLogoutHandler;
import com.applozic.mobicomkit.listners.AlPushNotificationHandler;
import com.applozic.mobicomkit.listners.ApplozicUIListener;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.Serializable;

public class Applozic {
    private static final String APPLICATION_KEY = "APPLICATION_KEY";
    private static final String DEVICE_REGISTRATION_ID = "DEVICE_REGISTRATION_ID";
    private static final String MY_PREFERENCE = "applozic_preference_key";
    public static Applozic applozic;
    public SharedPreferences sharedPreferences;
    private Context context;
    private ApplozicBroadcastReceiver applozicBroadcastReceiver;

    private Applozic(Context context) {
        this.context = context;
        this.sharedPreferences = context.getSharedPreferences(MY_PREFERENCE, 0);
    }

    public static Applozic init(Context context, String applicationKey) {
        applozic = Applozic.getInstance(context);
        applozic.setApplicationKey(applicationKey);
        return applozic;
    }

    public static Applozic getInstance(Context context) {
        if (applozic == null) {
            applozic = new Applozic(context.getApplicationContext());
        }
        return applozic;
    }

    public String getApplicationKey() {
        return this.sharedPreferences.getString(APPLICATION_KEY, null);
    }

    public Applozic setApplicationKey(String applicationKey) {
        this.sharedPreferences.edit().putString(APPLICATION_KEY, applicationKey).commit();
        return this;
    }

    public String getDeviceRegistrationId() {
        return this.sharedPreferences.getString(DEVICE_REGISTRATION_ID, null);
    }

    public Applozic setDeviceRegistrationId(String registrationId) {
        this.sharedPreferences.edit().putString(DEVICE_REGISTRATION_ID, registrationId).commit();
        return this;
    }

    public static void disconnectPublish(Context context, String deviceKeyString, String userKeyString) {
        if (!TextUtils.isEmpty((CharSequence)userKeyString) && !TextUtils.isEmpty((CharSequence)deviceKeyString)) {
            Intent intent = new Intent(context, ApplozicMqttIntentService.class);
            intent.putExtra("userKeyString", userKeyString);
            intent.putExtra("deviceKeyString", deviceKeyString);
            ApplozicMqttIntentService.enqueueWork(context, intent);
        }
    }

    public static void disconnectPublish(Context context) {
        String deviceKeyString = MobiComUserPreference.getInstance(context).getDeviceKeyString();
        String userKeyString = MobiComUserPreference.getInstance(context).getSuUserKeyString();
        Applozic.disconnectPublish(context, deviceKeyString, userKeyString);
    }

    public static void connectPublish(Context context) {
        Intent subscribeIntent = new Intent(context, ApplozicMqttIntentService.class);
        subscribeIntent.putExtra("subscribe", true);
        ApplozicMqttIntentService.enqueueWork(context, subscribeIntent);
    }

    public static void subscribeToTyping(Context context, Channel channel, Contact contact) {
        Intent intent = new Intent(context, ApplozicMqttIntentService.class);
        if (channel != null) {
            intent.putExtra("channel", (Serializable)channel);
        } else if (contact != null) {
            // empty if block
        }
        intent.putExtra("subscribeToTyping", true);
        ApplozicMqttIntentService.enqueueWork(context, intent);
    }

    public static void unSubscribeToTyping(Context context, Channel channel, Contact contact) {
        Intent intent = new Intent(context, ApplozicMqttIntentService.class);
        if (channel != null) {
            intent.putExtra("channel", (Serializable)channel);
        } else if (contact != null) {
            // empty if block
        }
        intent.putExtra("unSubscribeToTyping", true);
        ApplozicMqttIntentService.enqueueWork(context, intent);
    }

    public static void publishTypingStatus(Context context, Channel channel, Contact contact, boolean typingStarted) {
        Intent intent = new Intent(context, ApplozicMqttIntentService.class);
        if (channel != null) {
            intent.putExtra("channel", (Serializable)channel);
        } else if (contact != null) {
            intent.putExtra("contact", (Serializable)contact);
        }
        intent.putExtra("typing", typingStarted);
        ApplozicMqttIntentService.enqueueWork(context, intent);
    }

    public static void loginUser(Context context, User user, AlLoginHandler loginHandler) {
        if (MobiComUserPreference.getInstance(context).isLoggedIn()) {
            RegistrationResponse registrationResponse = new RegistrationResponse();
            registrationResponse.setMessage("User already Logged in");
            loginHandler.onSuccess(registrationResponse, context);
        } else {
            new UserLoginTask(user, loginHandler, context).execute(new Void[0]);
        }
    }

    public static void logoutUser(Context context, AlLogoutHandler logoutHandler) {
        new UserLogoutTask(logoutHandler, context).execute(new Void[0]);
    }

    public static void registerForPushNotification(Context context, String pushToken, AlPushNotificationHandler handler) {
        new PushNotificationTask(context, pushToken, handler).execute(new Void[0]);
    }

    public static void registerForPushNotification(Context context, AlPushNotificationHandler handler) {
        Applozic.registerForPushNotification(context, Applozic.getInstance(context).getDeviceRegistrationId(), handler);
    }

    public void registerUIListener(ApplozicUIListener applozicUIListener) {
        this.applozicBroadcastReceiver = new ApplozicBroadcastReceiver(this.context, applozicUIListener);
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver((BroadcastReceiver)this.applozicBroadcastReceiver, BroadcastService.getIntentFilter());
    }

    public void unregisterUIListener() {
        if (this.applozicBroadcastReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this.context).unregisterReceiver((BroadcastReceiver)this.applozicBroadcastReceiver);
            this.applozicBroadcastReceiver = null;
        }
    }
}

