/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Process;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.attachment.urlservice.URLServiceProvider;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.listners.MediaDownloadProgressHandler;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;

class AttachmentDownloader
extends MobiComKitClientService
implements Runnable {
    static final int HTTP_STATE_FAILED = -1;
    static final int HTTP_STATE_STARTED = 0;
    static final int HTTP_STATE_COMPLETED = 1;
    private static final String TAG = "AttachmentDownloader";
    private static final int READ_SIZE = 1024;
    private static final String LOG_TAG = "PhotoDownloadRunnable";
    final TaskRunnableDownloadMethods mPhotoTask;

    AttachmentDownloader(TaskRunnableDownloadMethods photoTask) {
        this.mPhotoTask = photoTask;
    }

    @Override
    public void run() {
        this.mPhotoTask.setDownloadThread(Thread.currentThread());
        Process.setThreadPriority((int)10);
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.mPhotoTask.getMessage() != null && !this.mPhotoTask.getMessage().isAttachmentDownloaded()) {
                this.mPhotoTask.handleDownloadState(0);
                this.loadAttachmentImage(this.mPhotoTask.getMessage(), this.mPhotoTask.getContext());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.mPhotoTask.getMessage() != null && !this.mPhotoTask.getMessage().isAttachmentDownloaded() && this.mPhotoTask.getMessage().isSentToServer()) {
                this.mPhotoTask.handleDownloadState(-1);
            } else {
                this.mPhotoTask.handleDownloadState(1);
            }
            this.mPhotoTask.setDownloadThread(null);
            Thread.interrupted();
        }
    }

    public void loadAttachmentImage(Message message, Context context) {
        File file = null;
        try {
            InputStream inputStream = null;
            FileMeta fileMeta = message.getFileMetas();
            String contentType = fileMeta.getContentType();
            HttpURLConnection connection = null;
            String fileName = null;
            fileName = message.getContentType() == Message.ContentType.AUDIO_MSG.getValue().shortValue() ? fileMeta.getName() : FileUtils.getName((String)fileMeta.getName()) + message.getCreatedAtTime() + "." + FileUtils.getFileFormat((String)fileMeta.getName());
            file = FileClientService.getFilePath(fileName, context.getApplicationContext(), contentType);
            if (!file.exists()) {
                connection = new URLServiceProvider(context).getDownloadConnection(message);
                if (connection.getResponseCode() != 200) {
                    Utils.printLog((Context)context, (String)TAG, (String)("Got Error response while uploading file : " + connection.getResponseCode()));
                    return;
                }
                inputStream = connection.getInputStream();
                FileOutputStream output = new FileOutputStream(file);
                byte[] data = new byte[1024];
                long totalSize = fileMeta.getSize();
                long progressCount = 0L;
                int count = 0;
                int prevPrecentage = 0;
                while ((count = inputStream.read(data)) != -1) {
                    ((OutputStream)output).write(data, 0, count);
                    long percentage = (progressCount += (long)count) * 100L / totalSize;
                    android.os.Message msg = new android.os.Message();
                    if (percentage + 1L != (long)prevPrecentage) {
                        this.mPhotoTask.handleDownloadState(5);
                        this.mPhotoTask.downloadProgress((int)percentage + 1);
                        msg.what = 5;
                        msg.arg1 = (int)percentage + 1;
                        msg.obj = this;
                        prevPrecentage = (int)percentage + 1;
                    }
                    if (percentage % 10L == 0L) {
                        msg.what = 1;
                        msg.obj = this;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                output.flush();
                ((OutputStream)output).close();
                inputStream.close();
            }
            new MessageDatabaseService(context).updateInternalFilePath(message.getKeyString(), file.getAbsolutePath());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            message.setFilePaths(arrayList);
            MediaScannerConnection.scanFile((Context)this.mPhotoTask.getContext(), (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                public void onScanCompleted(String path, Uri uri) {
                    Log.i((String)"ExternalStorage", (String)("Scanned " + path + ":"));
                    Log.i((String)"ExternalStorage", (String)("-> uri=" + uri));
                }
            });
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Utils.printLog((Context)context, (String)TAG, (String)"File not found on server");
        }
        catch (Exception ex) {
            if (file != null && file.exists()) {
                Utils.printLog((Context)context, (String)TAG, (String)(" Exception occured while downloading :" + file.getAbsolutePath()));
                file.delete();
            }
            ex.printStackTrace();
            Utils.printLog((Context)context, (String)TAG, (String)"Exception fetching file from server");
        }
    }

    static interface TaskRunnableDownloadMethods {
        public void setDownloadThread(Thread var1);

        public void handleDownloadState(int var1);

        public String getImageURL();

        public Message getMessage();

        public Context getContext();

        public MediaDownloadProgressHandler getDownloadHandler();

        public void downloadProgress(int var1);

        public String getContentType();
    }
}

