/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.AlUserUpdateTask;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.api.notification.MuteUserResponse;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.feed.SyncBlockUserApiResponse;
import com.applozic.mobicomkit.listners.AlCallback;
import com.applozic.mobicomkit.sync.SyncUserBlockFeed;
import com.applozic.mobicomkit.sync.SyncUserBlockListFeed;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserService {
    private static final String TAG = "UserService";
    private static UserService userService;
    Context context;
    UserClientService userClientService;
    BaseContactService baseContactService;
    private MobiComUserPreference userPreference;

    private UserService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.userClientService = new UserClientService(context);
        this.userPreference = MobiComUserPreference.getInstance(context);
        this.baseContactService = new AppContactService(context);
    }

    public static UserService getInstance(Context context) {
        if (userService == null) {
            userService = new UserService(ApplozicService.getContext((Context)context));
        }
        return userService;
    }

    public synchronized void processSyncUserBlock() {
        try {
            SyncBlockUserApiResponse apiResponse = this.userClientService.getSyncUserBlockList(this.userPreference.getUserBlockSyncTime());
            if (apiResponse != null && "success".equals(apiResponse.getStatus())) {
                SyncUserBlockListFeed syncUserBlockListFeed = apiResponse.getResponse();
                if (syncUserBlockListFeed != null) {
                    Contact contact;
                    List<SyncUserBlockFeed> blockedToUserList = syncUserBlockListFeed.getBlockedToUserList();
                    List<SyncUserBlockFeed> blockedByUserList = syncUserBlockListFeed.getBlockedByUserList();
                    if (blockedToUserList != null && blockedToUserList.size() > 0) {
                        for (SyncUserBlockFeed syncUserBlockedFeed : blockedToUserList) {
                            contact = new Contact();
                            if (syncUserBlockedFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockedFeed.getBlockedTo())) continue;
                            if (this.baseContactService.isContactExists(syncUserBlockedFeed.getBlockedTo())) {
                                this.baseContactService.updateUserBlocked(syncUserBlockedFeed.getBlockedTo(), syncUserBlockedFeed.getUserBlocked());
                                continue;
                            }
                            contact.setBlocked(syncUserBlockedFeed.getUserBlocked().booleanValue());
                            contact.setUserId(syncUserBlockedFeed.getBlockedTo());
                            this.baseContactService.upsert(contact);
                            this.baseContactService.updateUserBlocked(syncUserBlockedFeed.getBlockedTo(), syncUserBlockedFeed.getUserBlocked());
                        }
                    }
                    if (blockedByUserList != null && blockedByUserList.size() > 0) {
                        for (SyncUserBlockFeed syncUserBlockByFeed : blockedByUserList) {
                            contact = new Contact();
                            if (syncUserBlockByFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockByFeed.getBlockedBy())) continue;
                            if (this.baseContactService.isContactExists(syncUserBlockByFeed.getBlockedBy())) {
                                this.baseContactService.updateUserBlockedBy(syncUserBlockByFeed.getBlockedBy(), syncUserBlockByFeed.getUserBlocked());
                                continue;
                            }
                            contact.setBlockedBy(syncUserBlockByFeed.getUserBlocked().booleanValue());
                            contact.setUserId(syncUserBlockByFeed.getBlockedBy());
                            this.baseContactService.upsert(contact);
                            this.baseContactService.updateUserBlockedBy(syncUserBlockByFeed.getBlockedBy(), syncUserBlockByFeed.getUserBlocked());
                        }
                    }
                }
                this.userPreference.setUserBlockSyncTime(apiResponse.getGeneratedAt());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApiResponse processUserBlock(String userId, boolean block) {
        ApiResponse apiResponse = this.userClientService.userBlock(userId, block);
        if (apiResponse != null && apiResponse.isSuccess()) {
            this.baseContactService.updateUserBlocked(userId, block);
            return apiResponse;
        }
        return null;
    }

    public synchronized void processUserDetail(Set<UserDetail> userDetails) {
        if (userDetails != null && userDetails.size() > 0) {
            for (UserDetail userDetail : userDetails) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUserDetails(String userId) {
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.processUserDetails(userIds);
    }

    public synchronized void processUserDetails(Set<String> userIds) {
        String response = this.userClientService.getUserDetails(userIds);
        if (!TextUtils.isEmpty((CharSequence)response)) {
            UserDetail[] userDetails;
            for (UserDetail userDetail : userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)response, UserDetail[].class)) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUser(UserDetail userDetail) {
        this.processUser(userDetail, Contact.ContactType.APPLOZIC);
    }

    public synchronized Contact getContactFromUserDetail(UserDetail userDetail) {
        return this.getContactFromUserDetail(userDetail, Contact.ContactType.APPLOZIC);
    }

    public synchronized Contact getContactFromUserDetail(UserDetail userDetail, Contact.ContactType contactType) {
        Contact contact = new Contact();
        contact.setUserId(userDetail.getUserId());
        contact.setContactNumber(userDetail.getPhoneNumber());
        contact.setConnected(userDetail.isConnected());
        contact.setStatus(userDetail.getStatusMessage());
        if (!TextUtils.isEmpty((CharSequence)userDetail.getDisplayName())) {
            contact.setFullName(userDetail.getDisplayName());
        }
        contact.setLastSeenAt(userDetail.getLastSeenAtTime());
        contact.setUserTypeId(userDetail.getUserTypeId());
        contact.setUnreadCount(Integer.valueOf(0));
        contact.setLastMessageAtTime(userDetail.getLastMessageAtTime());
        contact.setMetadata(userDetail.getMetadata());
        contact.setRoleType(userDetail.getRoleType());
        contact.setDeletedAtTime(userDetail.getDeletedAtTime());
        contact.setEmailId(userDetail.getEmailId());
        if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
            contact.setImageURL(userDetail.getImageLink());
        }
        contact.setContactType(contactType.getValue().shortValue());
        this.baseContactService.upsert(contact);
        return contact;
    }

    public synchronized void processUser(UserDetail userDetail, Contact.ContactType contactType) {
        Contact contact = new Contact();
        contact.setUserId(userDetail.getUserId());
        contact.setContactNumber(userDetail.getPhoneNumber());
        contact.setConnected(userDetail.isConnected());
        contact.setStatus(userDetail.getStatusMessage());
        if (!TextUtils.isEmpty((CharSequence)userDetail.getDisplayName())) {
            contact.setFullName(userDetail.getDisplayName());
        }
        contact.setLastSeenAt(userDetail.getLastSeenAtTime());
        contact.setUserTypeId(userDetail.getUserTypeId());
        contact.setUnreadCount(Integer.valueOf(0));
        contact.setLastMessageAtTime(userDetail.getLastMessageAtTime());
        contact.setMetadata(userDetail.getMetadata());
        contact.setRoleType(userDetail.getRoleType());
        contact.setDeletedAtTime(userDetail.getDeletedAtTime());
        contact.setEmailId(userDetail.getEmailId());
        if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
            contact.setImageURL(userDetail.getImageLink());
        }
        contact.setContactType(contactType.getValue().shortValue());
        this.baseContactService.upsert(contact);
    }

    public synchronized void processMuteUserResponse(MuteUserResponse response) {
        Contact contact = new Contact();
        contact.setUserId(response.getUserId());
        BroadcastService.sendMuteUserBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MUTE_USER_CHAT.toString(), true, response.getUserId());
        if (!TextUtils.isEmpty((CharSequence)response.getImageLink())) {
            contact.setImageURL(response.getImageLink());
        }
        contact.setUnreadCount(Integer.valueOf(response.getUnreadCount()));
        if (response.getNotificationAfterTime() != null && response.getNotificationAfterTime() != 0L) {
            contact.setNotificationAfterTime(response.getNotificationAfterTime());
        }
        contact.setConnected(response.isConnected());
        this.baseContactService.upsert(contact);
    }

    public synchronized String[] getOnlineUsers(int numberOfUser) {
        try {
            Map<String, String> userMapList = this.userClientService.getOnlineUserList(numberOfUser);
            if (userMapList != null && userMapList.size() > 0) {
                String[] userIdArray = new String[userMapList.size()];
                HashSet<String> userIds = new HashSet<String>();
                int i = 0;
                for (Map.Entry<String, String> keyValue : userMapList.entrySet()) {
                    Contact contact = new Contact();
                    contact.setUserId(keyValue.getKey());
                    contact.setConnected(keyValue.getValue().contains("true"));
                    userIdArray[i] = keyValue.getKey();
                    userIds.add(keyValue.getKey());
                    this.baseContactService.upsert(contact);
                    ++i;
                }
                this.processUserDetails(userIds);
                return userIdArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized RegisteredUsersApiResponse getRegisteredUsersList(Long startTime, int pageSize) {
        String response = this.userClientService.getRegisteredUsers(startTime, pageSize);
        RegisteredUsersApiResponse apiResponse = null;
        if (!TextUtils.isEmpty((CharSequence)response) && !"error".equals(response)) {
            apiResponse = (RegisteredUsersApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, RegisteredUsersApiResponse.class));
            if (apiResponse != null) {
                this.processUserDetail(apiResponse.getUsers());
                this.userPreference.setRegisteredUsersLastFetchTime(apiResponse.getLastFetchTime());
            }
            return apiResponse;
        }
        return null;
    }

    public ApiResponse muteUserNotifications(String userId, Long notificationAfterTime) {
        ApiResponse response = this.userClientService.muteUserNotifications(userId, notificationAfterTime);
        if (response == null) {
            return null;
        }
        if (response.isSuccess()) {
            new ContactDatabase(this.context).updateNotificationAfterTime(userId, notificationAfterTime);
        }
        return response;
    }

    public List<MuteUserResponse> getMutedUserList() {
        MuteUserResponse[] mutedUserList = this.userClientService.getMutedUserList();
        if (mutedUserList == null) {
            return null;
        }
        for (MuteUserResponse muteUserResponse : mutedUserList) {
            this.processMuteUserResponse(muteUserResponse);
        }
        return Arrays.asList(mutedUserList);
    }

    public String updateDisplayNameORImageLink(String displayName, String profileImageLink, String localURL, String status) {
        return this.updateDisplayNameORImageLink(displayName, profileImageLink, localURL, status, null, null, null, null);
    }

    public String updateDisplayNameORImageLink(String displayName, String profileImageLink, String localURL, String status, String contactNumber, Map<String, String> metadata) {
        return this.updateDisplayNameORImageLink(displayName, profileImageLink, localURL, status, null, null, null, null);
    }

    public String updateDisplayNameORImageLink(String displayName, String profileImageLink, String localURL, String status, String contactNumber, String emailId, Map<String, String> metadata, String userId) {
        ApiResponse response = this.userClientService.updateDisplayNameORImageLink(displayName, profileImageLink, status, contactNumber, emailId, metadata, userId);
        if (response == null) {
            return null;
        }
        if (response.isSuccess()) {
            Contact contact = this.baseContactService.getContactById(!TextUtils.isEmpty((CharSequence)userId) ? userId : MobiComUserPreference.getInstance(this.context).getUserId());
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                contact.setFullName(displayName);
            }
            if (!TextUtils.isEmpty((CharSequence)profileImageLink)) {
                contact.setImageURL(profileImageLink);
            }
            contact.setLocalImageUrl(localURL);
            if (!TextUtils.isEmpty((CharSequence)status)) {
                contact.setStatus(status);
            }
            if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
                contact.setContactNumber(contactNumber);
            }
            if (!TextUtils.isEmpty((CharSequence)emailId)) {
                contact.setEmailId(emailId);
            }
            if (metadata != null && !metadata.isEmpty()) {
                HashMap<String, String> existingMetadata = contact.getMetadata();
                if (existingMetadata == null) {
                    existingMetadata = new HashMap<String, String>();
                }
                existingMetadata.putAll(metadata);
                contact.setMetadata(existingMetadata);
            }
            this.baseContactService.upsert(contact);
            Contact contact1 = this.baseContactService.getContactById(!TextUtils.isEmpty((CharSequence)userId) ? userId : MobiComUserPreference.getInstance(this.context).getUserId());
            Utils.printLog((Context)this.context, (String)TAG, (String)(contact1.getImageURL() + ", " + contact1.getDisplayName() + "," + contact1.getStatus() + "," + contact1.getStatus() + "," + contact1.getMetadata() + "," + contact1.getEmailId() + "," + contact1.getContactNumber()));
        }
        return response.getStatus();
    }

    public ApiResponse updateUserWithResponse(String displayName, String profileImageLink, String localURL, String status, String contactNumber, String emailId, Map<String, String> metadata, String userId) {
        ApiResponse response = this.userClientService.updateDisplayNameORImageLink(displayName, profileImageLink, status, contactNumber, emailId, metadata, userId);
        if (response == null) {
            return null;
        }
        if (response.isSuccess()) {
            Contact contact = this.baseContactService.getContactById(!TextUtils.isEmpty((CharSequence)userId) ? userId : MobiComUserPreference.getInstance(this.context).getUserId());
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                contact.setFullName(displayName);
            }
            if (!TextUtils.isEmpty((CharSequence)profileImageLink)) {
                contact.setImageURL(profileImageLink);
            }
            contact.setLocalImageUrl(localURL);
            if (!TextUtils.isEmpty((CharSequence)status)) {
                contact.setStatus(status);
            }
            if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
                contact.setContactNumber(contactNumber);
            }
            if (!TextUtils.isEmpty((CharSequence)emailId)) {
                contact.setEmailId(emailId);
            }
            if (metadata != null && !metadata.isEmpty()) {
                HashMap<String, String> existingMetadata = contact.getMetadata();
                if (existingMetadata == null) {
                    existingMetadata = new HashMap<String, String>();
                }
                existingMetadata.putAll(metadata);
                contact.setMetadata(existingMetadata);
            }
            this.baseContactService.upsert(contact);
        }
        return response;
    }

    public ApiResponse updateUserWithResponse(User user) {
        return this.updateUserWithResponse(user.getDisplayName(), user.getImageLink(), user.getLocalImageUri(), user.getStatus(), user.getContactNumber(), user.getEmail(), user.getMetadata(), user.getUserId());
    }

    public String updateLoggedInUser(User user) {
        return this.updateDisplayNameORImageLink(user.getDisplayName(), user.getImageLink(), user.getLocalImageUri(), user.getStatus(), user.getContactNumber(), user.getMetadata());
    }

    public String updateUser(User user) {
        return this.updateDisplayNameORImageLink(user.getDisplayName(), user.getImageLink(), user.getLocalImageUri(), user.getStatus(), user.getContactNumber(), user.getEmail(), user.getMetadata(), user.getUserId());
    }

    public void processUserDetailsResponse(String response) {
        if (!TextUtils.isEmpty((CharSequence)response)) {
            List userDetails = (List)GsonUtils.getObjectFromJson((String)response, (Type)new TypeToken<List<UserDetail>>(){}.getType());
            for (UserDetail userDetail : userDetails) {
                this.processUser(userDetail);
            }
        }
    }

    public void processUserDetailsByUserIds(Set<String> userIds) {
        this.userClientService.postUserDetailsByUserIds(userIds);
    }

    public ApiResponse processUserReadConversation() {
        return this.userClientService.getUserReadServerCall();
    }

    public String processUpdateUserPassword(String oldPassword, String newPassword) {
        String response = this.userClientService.updateUserPassword(oldPassword, newPassword);
        if (!TextUtils.isEmpty((CharSequence)response) && "success".equals(response)) {
            this.userPreference.setPassword(newPassword);
        }
        return response;
    }

    public List<Contact> getUserListBySearch(String searchString) throws ApplozicException {
        try {
            ApiResponse response = this.userClientService.getUsersBySearchString(searchString);
            if (response == null) {
                return null;
            }
            if (response.isSuccess()) {
                UserDetail[] userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)GsonUtils.getJsonFromObject(response.getResponse(), List.class), UserDetail[].class);
                ArrayList<Contact> contactList = new ArrayList<Contact>();
                for (UserDetail userDetail : userDetails) {
                    contactList.add(this.getContactFromUserDetail(userDetail));
                }
                return contactList;
            }
            if (response.getErrorResponse() != null && !response.getErrorResponse().isEmpty()) {
                throw new ApplozicException(GsonUtils.getJsonFromObject(response.getErrorResponse(), List.class));
            }
        }
        catch (Exception e) {
            throw new ApplozicException(e.getMessage());
        }
        return null;
    }

    public void updateUser(User user, AlCallback callback) {
        new AlUserUpdateTask(this.context, user, callback).execute(new Void[0]);
    }

    public ApiResponse updateUserDisplayName(String userId, String userDisplayName) {
        ApiResponse response = this.userClientService.updateUserDisplayName(userId, userDisplayName);
        if (response != null && response.isSuccess()) {
            this.baseContactService.updateMetadataKeyValueForUserId(userId, "AL_DISPLAY_NAME_UPDATED", "true");
            Utils.printLog((Context)this.context, (String)TAG, (String)(" Update display name Response :" + response.getStatus()));
        }
        return response;
    }
}

