/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.HashMap;
import java.util.Map;

public class VideoCallNotificationHelper {
    public static final String CALL_STARTED = "CALL_STARTED";
    public static final String CALL_END = "CALL_END";
    public static final String MSG_TYPE = "MSG_TYPE";
    public static final String CALL_ID = "CALL_ID";
    public static final String CALL_DIALED = "CALL_DIALED";
    public static final String CALL_REJECTED = "CALL_REJECTED";
    public static final String CALL_ANSWERED = "CALL_ANSWERED";
    public static final String CALL_MISSED = "CALL_MISSED";
    public static final String CALL_CANCELED = "CALL_CANCELED";
    public static final String CALL_AUDIO_ONLY = "CALL_AUDIO_ONLY";
    public static final int MAX_NOTIFICATION_RING_DURATION = 60000;
    public static final String NOTIFICATION_ACTIVITY_NAME = "com.applozic.audiovideo.activity.CallActivity";
    public static final String CALL_DURATION = "CALL_DURATION";
    private static final String TAG = "CallNotiHandler";
    String videoCallId;
    Context context;
    boolean isAudioOnly;
    private MobiComConversationService conversationService;
    private AppContactService baseContactService;

    public VideoCallNotificationHelper(Context context) {
        this.context = context;
        this.isAudioOnly = false;
        this.init();
    }

    public VideoCallNotificationHelper(Context context, boolean isAudioOnly) {
        this.context = context;
        this.isAudioOnly = isAudioOnly;
        this.init();
    }

    public static String getStatus(Map<String, String> metaDataMap) {
        String audioORVideoCallPrefix;
        String type = metaDataMap.get(MSG_TYPE);
        String string = audioORVideoCallPrefix = Boolean.valueOf(metaDataMap.get(CALL_AUDIO_ONLY)) != false ? "Audio call" : "Video call";
        if (type.equals(CALL_STARTED)) {
            return audioORVideoCallPrefix + " started";
        }
        if (type.equals(CALL_END)) {
            return audioORVideoCallPrefix;
        }
        if (type.equals(CALL_REJECTED)) {
            return "Call busy";
        }
        return "Missed " + audioORVideoCallPrefix;
    }

    public static boolean isMissedCall(Message message) {
        String msgType = message.getMetaDataValueForKey(MSG_TYPE);
        return CALL_MISSED.equals(msgType) || CALL_REJECTED.equals(msgType) || CALL_CANCELED.equals(msgType);
    }

    public static boolean isAudioCall(Message message) {
        return Boolean.parseBoolean(message.getMetaDataValueForKey(CALL_AUDIO_ONLY));
    }

    public static void buildVideoCallNotification(Context context, Message message, int index) {
        String audioORVideoCallPrefix;
        Map<String, String> metaDataMap = message.getMetadata();
        Contact contact = new AppContactService(context).getContactById(message.getContactIds());
        String string = audioORVideoCallPrefix = Boolean.valueOf(metaDataMap.get(CALL_AUDIO_ONLY)) != false ? "audio call " : "video call ";
        if (metaDataMap.get(MSG_TYPE).equals(CALL_MISSED)) {
            Message message1 = new Message(message);
            message1.setMessage("You missed " + audioORVideoCallPrefix + " from " + contact.getDisplayName());
            BroadcastService.sendNotificationBroadcast(context, message1, index);
        }
    }

    public void init() {
        this.conversationService = new MobiComConversationService(this.context);
        this.baseContactService = new AppContactService(this.context);
    }

    public Map<String, String> getDialCallMetaData() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(MSG_TYPE, CALL_DIALED);
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public Map<String, String> getAnswerCallMetaData() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(MSG_TYPE, CALL_ANSWERED);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public Map<String, String> getVideoCallStartedMap() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(MSG_TYPE, CALL_STARTED);
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public Map<String, String> getVideoCallEndMap(String callDuration) {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(MSG_TYPE, CALL_END);
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(CALL_DURATION, callDuration);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public Map<String, String> getVideoCanceledMap() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(MSG_TYPE, CALL_CANCELED);
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public Map<String, String> getRejectedCallMap() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(MSG_TYPE, CALL_REJECTED);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public Map<String, String> getMissedCallMap() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(CALL_ID, this.videoCallId);
        metaData.put(MSG_TYPE, CALL_MISSED);
        metaData.put(CALL_AUDIO_ONLY, Boolean.toString(this.isAudioOnly));
        return metaData;
    }

    public String sendVideoCallRequest(Contact contact, boolean audioOnly) {
        Message notificationMessage = this.getNotificationMessage(contact);
        this.videoCallId = MobiComUserPreference.getInstance(this.context).getDeviceKeyString() + ":" + notificationMessage.getCreatedAtTime();
        notificationMessage.setMessage(this.videoCallId);
        notificationMessage.setMetadata(this.getDialCallMetaData());
        if (audioOnly) {
            notificationMessage.getMetadata().put(CALL_AUDIO_ONLY, "true");
        }
        this.conversationService.sendMessage(notificationMessage, MessageIntentService.class);
        return this.videoCallId;
    }

    public String sendVideoCallRequest(Contact contact) {
        return this.sendVideoCallRequest(contact, false);
    }

    public String sendAudioCallRequest(Contact contact) {
        return this.sendVideoCallRequest(contact, true);
    }

    public void sendVideoCallAnswer(Contact contact, String videoCallId) {
        Log.i((String)TAG, (String)"sendVideoCallAnswer()");
        this.videoCallId = videoCallId;
        Message notificationMessage = this.getNotificationMessage(contact);
        notificationMessage.setMessage(videoCallId);
        notificationMessage.setMetadata(this.getAnswerCallMetaData());
        this.conversationService.sendMessage(notificationMessage, MessageIntentService.class);
        Log.i((String)TAG, (String)"sendVideoCallAnswer()  END");
    }

    public void sendVideoCallReject(Contact contact, String videoCallId) {
        this.videoCallId = videoCallId;
        Message notificationMessage = this.getNotificationMessage(contact);
        notificationMessage.setMetadata(this.getRejectedCallMap());
        notificationMessage.setMessage(videoCallId);
        this.conversationService.sendMessage(notificationMessage, MessageIntentService.class);
    }

    public void sendCallMissed(Contact contact, String videoCallId) {
        this.videoCallId = videoCallId;
        Message notificationMessage = this.getNotificationMessage(contact);
        notificationMessage.setMetadata(this.getMissedCallMap());
        notificationMessage.setMessage(videoCallId);
        this.conversationService.sendMessage(notificationMessage, MessageIntentService.class);
    }

    public void sendVideoCallStarted(Contact contact, String videoCallId) {
        Message statusMessage = this.getVideoCallStatusMessage(contact);
        statusMessage.setMetadata(this.getVideoCallStartedMap());
        statusMessage.setMessage(videoCallId);
        this.conversationService.sendMessage(statusMessage, MessageIntentService.class);
    }

    public void sendVideoCallEnd(Contact contact, String videoCallId, String duration) {
        Message statusMessage = this.getVideoCallStatusMessage(contact);
        statusMessage.setMetadata(this.getVideoCallEndMap(duration));
        statusMessage.setMessage("Call End");
        this.conversationService.sendMessage(statusMessage, MessageIntentService.class);
    }

    @NonNull
    private Message getNotificationMessage(Contact contact) {
        Message notificationMessage = new Message();
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        notificationMessage.setContactIds(contact.getContactIds());
        notificationMessage.setTo(contact.getContactIds());
        notificationMessage.setCreatedAtTime(System.currentTimeMillis());
        notificationMessage.setStoreOnDevice(Boolean.TRUE);
        notificationMessage.setSendToDevice(Boolean.TRUE);
        notificationMessage.setContentType(Message.ContentType.VIDEO_CALL_NOTIFICATION_MSG.getValue());
        notificationMessage.setDeviceKeyString(userPreferences.getDeviceKeyString());
        notificationMessage.setMessage(this.videoCallId);
        return notificationMessage;
    }

    @NonNull
    private Message getVideoCallStatusMessage(Contact contact) {
        Message notificationMessage = new Message();
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        notificationMessage.setContactIds(contact.getContactIds());
        notificationMessage.setTo(contact.getContactIds());
        notificationMessage.setCreatedAtTime(System.currentTimeMillis());
        notificationMessage.setStoreOnDevice(Boolean.TRUE);
        notificationMessage.setSendToDevice(Boolean.TRUE);
        notificationMessage.setContentType(Message.ContentType.VIDEO_CALL_STATUS_MSG.getValue());
        notificationMessage.setDeviceKeyString(userPreferences.getDeviceKeyString());
        return notificationMessage;
    }

    public void handleVideoCallNotificationMessages(Message message) {
        Map<String, String> valueMap = message.getMetadata();
        String type = valueMap.get(MSG_TYPE);
        this.videoCallId = valueMap.get(CALL_ID);
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        if (type.equals(CALL_DIALED)) {
            this.handleIncomingVideoNotification(message);
        } else if (type.equals(CALL_ANSWERED)) {
            Intent intent = new Intent("applozic.video.call.answer");
            intent.putExtra(CALL_ID, this.videoCallId);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        } else if (type.equals(CALL_REJECTED)) {
            Intent intent = new Intent("applozic.video.call.rejected");
            intent.putExtra(CALL_ID, this.videoCallId);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
            if (!message.isTypeOutbox() && BroadcastService.videoCallAcitivityOpend) {
                Contact contact = this.baseContactService.getContactById(message.getContactIds());
                Message statusMessage = this.getVideoCallStatusMessage(contact);
                statusMessage.setMessage("Call Busy");
                statusMessage.setMetadata(this.getRejectedCallMap());
                this.conversationService.sendMessage(statusMessage, MessageIntentService.class);
            }
        } else if (type.equals(CALL_MISSED)) {
            Intent intent = new Intent(CALL_MISSED);
            intent.putExtra(CALL_ID, this.videoCallId);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        } else if (type.equals(CALL_CANCELED)) {
            Intent intent = new Intent(CALL_CANCELED);
            intent.putExtra(CALL_ID, this.videoCallId);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        } else if (type.equals(CALL_END)) {
            Intent intent = new Intent(CALL_END);
            intent.putExtra(CALL_ID, this.videoCallId);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        }
    }

    private void handleIncomingVideoNotification(Message msg) {
        boolean staleNotification;
        String isAudioCallOnly = msg.getMetadata().get(CALL_AUDIO_ONLY);
        boolean bl = staleNotification = System.currentTimeMillis() - msg.getCreatedAtTime() > 60000L;
        if (staleNotification || msg.isTypeOutbox()) {
            Log.i((String)TAG, (String)"notification not valid ignoring..");
            return;
        }
        if (BroadcastService.callRinging) {
            Contact contactDetail = this.baseContactService.getContactById(msg.getTo());
            VideoCallNotificationHelper helper = new VideoCallNotificationHelper(this.context, this.isAudioOnly);
            helper.sendVideoCallReject(contactDetail, this.videoCallId);
            return;
        }
        if (BroadcastService.videoCallAcitivityOpend) {
            Intent intent = new Intent("applozic.video.call.dialed");
            intent.putExtra("CONTACT_ID", msg.getTo());
            intent.putExtra(CALL_ID, this.videoCallId);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
            return;
        }
        Class<?> activityToOpen = null;
        try {
            activityToOpen = Class.forName(NOTIFICATION_ACTIVITY_NAME);
        }
        catch (Exception helper) {
            // empty catch block
        }
        Intent intent1 = new Intent(this.context, activityToOpen);
        intent1.setFlags(0x10000000);
        intent1.putExtra("CONTACT_ID", msg.getTo());
        intent1.putExtra(CALL_ID, this.videoCallId);
        if (!TextUtils.isEmpty((CharSequence)isAudioCallOnly) && "true".equals(isAudioCallOnly)) {
            intent1.putExtra(CALL_AUDIO_ONLY, true);
        }
        this.context.startActivity(intent1);
    }

    public void sendVideoCallMissedMessage(Contact contactToCall, String callId) {
        Message notificationMessage = this.getVideoCallStatusMessage(contactToCall);
        notificationMessage.setMetadata(this.getMissedCallMap());
        notificationMessage.setMessage("Call Missed");
        this.conversationService.sendMessage(notificationMessage, MessageIntentService.class);
    }
}

