/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class ApplozicMultipartUtility {
    private static final String LINE_FEED = "\r\n";
    final String TAG = "AlMultipartUtility";
    private final String boundary = "--" + System.currentTimeMillis() + "--";
    private HttpURLConnection httpConn;
    private OutputStream outputStream;
    private PrintWriter writer;

    public ApplozicMultipartUtility(String requestURL, String charset, Context context) throws IOException {
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        HttpRequestUtils httpRequestUtils = new HttpRequestUtils(context);
        httpRequestUtils.addGlobalHeaders(this.httpConn, null);
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFilePart(String fieldName, File uploadFile, Handler handler, String oldMessageKey) throws IOException, InterruptedException {
        String fileName = uploadFile.getName();
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        long bytesRead = -1L;
        long totalRead = 0L;
        long previousPercent = 0L;
        long totalSize = uploadFile.length();
        if (handler != null) {
            Message msg = handler.obtainMessage();
            msg.what = 1;
            msg.getData().putString("oldMessageKey", oldMessageKey);
            msg.getData().putString("error", null);
            msg.sendToTarget();
        }
        while ((bytesRead = (long)inputStream.read(buffer)) != -1L) {
            Message msg;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.outputStream.write(buffer, 0, (int)bytesRead);
                int percentage = (int)((float)(totalRead += bytesRead) / (float)totalSize * 100.0f);
                if ((long)percentage == previousPercent) continue;
                if (handler != null) {
                    msg = handler.obtainMessage();
                    msg.what = 2;
                    msg.getData().putString("oldMessageKey", oldMessageKey);
                    msg.arg1 = percentage;
                    msg.sendToTarget();
                }
                previousPercent = percentage;
            }
            catch (Exception e) {
                if (handler == null) continue;
                msg = handler.obtainMessage();
                msg.what = 4;
                msg.getData().putString("oldMessageKey", oldMessageKey);
                msg.getData().putString("error", e.getMessage());
                msg.sendToTarget();
            }
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse() throws IOException {
        StringBuilder sb;
        block8: {
            sb = new StringBuilder();
            this.writer.append(LINE_FEED).flush();
            this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
            this.writer.close();
            BufferedReader reader = null;
            int status = this.httpConn.getResponseCode();
            try {
                if (status == 200) {
                    reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    break block8;
                }
                throw new IOException("Server exception with status code: " + status);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    reader.close();
                    this.httpConn.disconnect();
                }
            }
        }
        return sb.toString();
    }
}

