/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MessageInfoResponse;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.selfdestruct.DisappearingMessageTask;
import com.applozic.mobicomkit.api.notification.VideoCallNotificationHelper;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.sync.SyncMessageFeed;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Support;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.personalization.PersonalizedMessage;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class MobiComMessageService {
    public static final long DELAY = 60000L;
    private static final String TAG = "MobiComMessageService";
    public static Map<String, Uri> map = new HashMap<String, Uri>();
    public static Map<String, Message> mtMessages = new LinkedHashMap<String, Message>();
    protected Context context;
    protected MobiComConversationService conversationService;
    protected MessageDatabaseService messageDatabaseService;
    protected MessageClientService messageClientService;
    protected Class messageIntentServiceClass;
    protected BaseContactService baseContactService;
    protected UserService userService;
    protected FileClientService fileClientService;
    private boolean isHideActionMessage;

    public MobiComMessageService(Context context, Class messageIntentServiceClass) {
        this.context = ApplozicService.getContext((Context)context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.messageClientService = new MessageClientService(context);
        this.conversationService = new MobiComConversationService(context);
        this.messageIntentServiceClass = messageIntentServiceClass;
        this.baseContactService = new AppContactService(context);
        this.fileClientService = new FileClientService(context);
        this.userService = UserService.getInstance(context);
        this.isHideActionMessage = ApplozicClient.getInstance(context).isActionMessagesHidden();
    }

    public Message processMessage(Message messageToProcess, String tofield, int index) {
        Channel channel;
        try {
            if (!TextUtils.isEmpty((CharSequence)ApplozicClient.getInstance(this.context).getMessageMetaDataServiceName())) {
                Class<?> serviceName = Class.forName(ApplozicClient.getInstance(this.context).getMessageMetaDataServiceName());
                Intent intentService = new Intent(this.context, serviceName);
                if (Message.MetaDataType.HIDDEN.getValue().equals(messageToProcess.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) {
                    intentService.putExtra("MESSAGE", (Serializable)((Object)messageToProcess));
                    intentService.putExtra("HIDDEN", true);
                    MessageIntentService.enqueueWork(this.context, intentService, null);
                    return null;
                }
                if (Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(messageToProcess.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) {
                    BroadcastService.sendNotificationBroadcast(this.context, messageToProcess, index);
                    intentService.putExtra("MESSAGE", (Serializable)((Object)messageToProcess));
                    intentService.putExtra("PUSH_NOTIFICATION", true);
                    MessageIntentService.enqueueWork(this.context, intentService, null);
                    return null;
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Message message = this.prepareMessage(messageToProcess, tofield);
        if (message.getGroupId() != null && (channel = ChannelService.getInstance(this.context).getChannelInfo(message.getGroupId())) == null) {
            return null;
        }
        if (message.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
            this.fileClientService.loadContactsvCard(message);
        }
        try {
            Message replyMessage;
            Message[] replyMessageList;
            ArrayList<String> messageKeys = new ArrayList<String>();
            if (message.getMetadata() != null && message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()) != null && !this.messageDatabaseService.isMessagePresent(message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()))) {
                messageKeys.add(message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()));
            }
            if (messageKeys != null && messageKeys.size() > 0 && (replyMessageList = this.conversationService.getMessageListByKeyList(messageKeys)) != null && (replyMessage = replyMessageList[0]) != null) {
                if (replyMessage.hasAttachment() && replyMessage.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    this.conversationService.setFilePathifExist(replyMessage);
                }
                if (replyMessage.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                    this.fileClientService.loadContactsvCard(replyMessage);
                }
                replyMessage.setReplyMessage(Message.ReplyMessage.HIDE_MESSAGE.getValue());
                this.messageDatabaseService.createMessage(replyMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (message.getType().equals(Message.MessageType.MT_INBOX.getValue())) {
            this.addMTMessage(message, index);
        } else if (message.getType().equals(Message.MessageType.MT_OUTBOX.getValue())) {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
            this.messageDatabaseService.createMessage(message);
            if (!message.getCurrentId().equals(BroadcastService.currentUserId)) {
                MobiComUserPreference.getInstance(this.context).setNewMessageFlag(true);
            }
            if (message.isVideoNotificationMessage()) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Got notifications for Video call...");
                VideoCallNotificationHelper helper = new VideoCallNotificationHelper(this.context);
                helper.handleVideoCallNotificationMessages(message);
            }
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("processing message: " + (Object)((Object)message)));
        return message;
    }

    public Message prepareMessage(Message messageToProcess, String tofield) {
        Message message = new Message(messageToProcess);
        message.setMessageId(messageToProcess.getMessageId());
        message.setKeyString(messageToProcess.getKeyString());
        message.setPairedMessageKeyString(messageToProcess.getPairedMessageKeyString());
        if (message.getMessage() != null && PersonalizedMessage.isPersonalized((String)message.getMessage())) {
            Contact contact = null;
            if (message.getGroupId() == null) {
                contact = this.baseContactService.getContactById(tofield);
            }
            if (contact != null) {
                message.setMessage(PersonalizedMessage.prepareMessageFromTemplate((String)message.getMessage(), (Contact)contact));
            }
        }
        return message;
    }

    public Contact addMTMessage(Message message, int index) {
        boolean isContainerOpened;
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        Contact receiverContact = null;
        message.processContactIds(this.context);
        String currentId = message.getCurrentId();
        if (message.getGroupId() == null) {
            receiverContact = this.baseContactService.getContactById(message.getContactIds());
        }
        if (message.getMessage() != null && PersonalizedMessage.isPersonalized((String)message.getMessage()) && receiverContact != null) {
            message.setMessage(PersonalizedMessage.prepareMessageFromTemplate((String)message.getMessage(), (Contact)receiverContact));
        }
        if (this.isHideActionMessage && message.isActionMessage()) {
            message.setHidden(true);
        }
        this.messageDatabaseService.createMessage(message);
        if (message.getConversationId() != null && BroadcastService.isContextBasedChatEnabled()) {
            if (BroadcastService.currentConversationId == null) {
                BroadcastService.currentConversationId = message.getConversationId();
            }
            isContainerOpened = currentId.equals(BroadcastService.currentUserId) && message.getConversationId().equals(BroadcastService.currentConversationId);
        } else {
            isContainerOpened = currentId.equals(BroadcastService.currentUserId);
        }
        if (message.isVideoNotificationMessage()) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Got notifications for Video call...");
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
            VideoCallNotificationHelper helper = new VideoCallNotificationHelper(this.context);
            helper.handleVideoCallNotificationMessages(message);
        } else if (message.isVideoCallMessage()) {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
            VideoCallNotificationHelper.buildVideoCallNotification(this.context, message, index);
        } else if (!isContainerOpened) {
            if (message.isConsideredForCount() && !message.isHidden()) {
                if (!(message.getTo() == null || message.getGroupId() != null || this.isHideActionMessage && message.isActionMessage())) {
                    this.messageDatabaseService.updateContactUnreadCount(message.getTo());
                    BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
                    Contact contact = new ContactDatabase(this.context).getContactById(message.getTo());
                    if (contact != null && !contact.isNotificationMuted()) {
                        this.sendNotification(message, index);
                    }
                }
                if (message.getGroupId() != null && !Message.GroupMessageMetaData.FALSE.getValue().equals(message.getMetaDataValueForKey(Message.GroupMessageMetaData.KEY.getValue()))) {
                    if (!(Message.ContentType.CHANNEL_CUSTOM_MESSAGE.getValue().equals(message.getContentType()) || this.isHideActionMessage && message.isActionMessage())) {
                        this.messageDatabaseService.updateChannelUnreadCount(message.getGroupId());
                    }
                    BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
                    Channel currentChannel = ChannelService.getInstance(this.context).getChannelInfo(message.getGroupId());
                    if (currentChannel != null && (!Channel.GroupType.SUPPORT_GROUP.getValue().equals(currentChannel.getType()) && !currentChannel.isNotificationMuted() || Channel.GroupType.SUPPORT_GROUP.getValue().equals(currentChannel.getType()) && currentChannel.getKmStatus() == 1)) {
                        this.sendNotification(message, index);
                    }
                }
                MobiComUserPreference.getInstance(this.context).setNewMessageFlag(true);
            } else {
                BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
            }
        } else {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("Updating delivery status: " + message.getPairedMessageKeyString() + ", " + userPreferences.getUserId() + ", " + userPreferences.getContactNumber()));
        this.messageClientService.updateDeliveryStatus(message.getPairedMessageKeyString(), userPreferences.getUserId(), userPreferences.getContactNumber());
        return receiverContact;
    }

    public void sendNotification(Message message, int index) {
        if (this.isHideActionMessage && message.isActionMessage()) {
            return;
        }
        BroadcastService.sendNotificationBroadcast(this.context, message, index);
        Intent intent = new Intent("APPLOZIC_UNREAD_COUNT");
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    public void processOpenGroupAttachmentMessage(Message message) {
        this.processMessage(message, message.getTo(), 0);
    }

    public synchronized void syncMessages() {
        MobiComUserPreference userpref = MobiComUserPreference.getInstance(this.context);
        boolean syncChannel = false;
        boolean syncChannelForMetadata = false;
        Utils.printLog((Context)this.context, (String)TAG, (String)("Starting syncMessages for lastSyncTime: " + userpref.getLastSyncTime()));
        SyncMessageFeed syncMessageFeed = this.messageClientService.getMessageFeed(userpref.getLastSyncTime(), false);
        if (syncMessageFeed == null) {
            return;
        }
        if (syncMessageFeed != null && syncMessageFeed.getMessages() != null) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Got sync response " + syncMessageFeed.getMessages().size() + " messages."));
            this.processUserDetailFromMessages(syncMessageFeed.getMessages());
        }
        if (syncMessageFeed != null && syncMessageFeed.isRegIdInvalid() && Utils.hasFroyo()) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Going to call GCM device registration");
        }
        if (syncMessageFeed != null && syncMessageFeed.getMessages() != null) {
            List<Message> messageList = syncMessageFeed.getMessages();
            for (int i = messageList.size() - 1; i >= 0; --i) {
                if (Message.ContentType.CHANNEL_CUSTOM_MESSAGE.getValue().equals(messageList.get(i).getContentType())) {
                    if (messageList.get(i).isGroupMetaDataUpdated()) {
                        syncChannelForMetadata = true;
                    } else {
                        syncChannel = true;
                    }
                    ChannelService.isUpdateTitle = true;
                }
                this.processMessage(messageList.get(i), messageList.get(i).getTo(), messageList.size() - 1 - i);
                MobiComUserPreference.getInstance(this.context).setLastInboxSyncTime(messageList.get(i).getCreatedAtTime());
            }
            if (syncChannel) {
                ChannelService.getInstance(this.context).syncChannels(false);
            }
            if (syncChannelForMetadata) {
                ChannelService.getInstance(this.context).syncChannels(true);
            }
            this.updateDeliveredStatus(syncMessageFeed.getDeliveredMessageKeys());
            userpref.setLastSyncTime(String.valueOf(syncMessageFeed.getLastSyncTime()));
        }
    }

    public synchronized void syncMessageForMetadataUpdate() {
        MobiComUserPreference userpref = MobiComUserPreference.getInstance(this.context);
        SyncMessageFeed syncMessageFeed = this.messageClientService.getMessageFeed(userpref.getLastSyncTimeForMetadataUpdate(), true);
        Utils.printLog((Context)this.context, (String)TAG, (String)("\nStarting syncMessages for metadata update for lastSyncTime: " + userpref.getLastSyncTimeForMetadataUpdate()));
        if (syncMessageFeed != null && syncMessageFeed.getMessages() != null) {
            userpref.setLastSyncTimeForMetadataUpdate(String.valueOf(syncMessageFeed.getLastSyncTime()));
            List<Message> messageList = syncMessageFeed.getMessages();
            for (Message message : messageList) {
                if (message == null) continue;
                new MessageDatabaseService(this.context).updateMessageMetadata(message.getKeyString(), message.getMetadata());
                BroadcastService.updateMessageMetadata(this.context, message.getKeyString(), BroadcastService.INTENT_ACTIONS.MESSAGE_METADATA_UPDATE.toString());
            }
        }
    }

    public MessageInfoResponse getMessageInfoResponse(String messageKey) {
        MessageInfoResponse messageInfoResponse = this.messageClientService.getMessageInfoList(messageKey);
        return messageInfoResponse;
    }

    private void updateDeliveredStatus(List<String> deliveredMessageKeys) {
        if (deliveredMessageKeys == null) {
            return;
        }
        for (String messageKey : deliveredMessageKeys) {
            this.messageDatabaseService.updateMessageDeliveryReportForContact(messageKey, false);
            Message message = this.messageDatabaseService.getMessage(messageKey);
            if (message == null) continue;
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MESSAGE_DELIVERY.toString(), message);
        }
    }

    public boolean isMessagePresent(String key) {
        return this.messageDatabaseService.isMessagePresent(key);
    }

    public synchronized void syncMessagesWithServer(String syncMessage) {
        Toast.makeText((Context)this.context, (CharSequence)syncMessage, (int)1).show();
        new Thread(new Runnable(){

            @Override
            public void run() {
                MobiComMessageService.this.syncMessages();
            }
        }).start();
    }

    public void processContactFromMessages(List<Message> messages) {
        try {
            if (!ApplozicClient.getInstance(this.context).isHandleDisplayName()) {
                return;
            }
            HashSet<String> userIds = new HashSet<String>();
            for (Message msg : messages) {
                if (this.baseContactService.isContactExists(msg.getContactIds())) continue;
                userIds.add(msg.getContactIds());
            }
            if (userIds.isEmpty()) {
                return;
            }
            try {
                Map<String, String> userIdsHashMap = new UserClientService(this.context).getUserInfo(userIds);
                for (Map.Entry<String, String> keyValue : userIdsHashMap.entrySet()) {
                    Contact contact = new Contact();
                    contact.setUserId(keyValue.getKey());
                    contact.setFullName(keyValue.getValue());
                    contact.setUnreadCount(Integer.valueOf(0));
                    this.baseContactService.upsert(contact);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processUserDetailFromMessages(List<Message> messages) {
        try {
            if (!ApplozicClient.getInstance(this.context).isHandleDisplayName()) {
                return;
            }
            HashSet<String> userIds = new HashSet<String>();
            for (Message msg : messages) {
                if (this.baseContactService.isContactPresent(msg.getContactIds())) continue;
                userIds.add(msg.getContactIds());
            }
            if (userIds.isEmpty()) {
                return;
            }
            this.userService.processUserDetails(userIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void putMtextToDatabase(String payloadForMtextReceived) {
        JSONObject json = null;
        try {
            json = new JSONObject(payloadForMtextReceived);
            String smsKeyString = json.getString("keyString");
            String receiverNumber = json.getString("contactNumber");
            String body = json.getString("message");
            Integer timeToLive = json.isNull("timeToLive") ? null : Integer.valueOf(Integer.parseInt(json.getString("timeToLive")));
            Message mTextMessageReceived = new Message();
            mTextMessageReceived.setTo(json.getString("senderContactNumber"));
            mTextMessageReceived.setCreatedAtTime(System.currentTimeMillis());
            mTextMessageReceived.setMessage(body);
            mTextMessageReceived.setSendToDevice(Boolean.FALSE);
            mTextMessageReceived.setSent(Boolean.TRUE);
            mTextMessageReceived.setDeviceKeyString(MobiComUserPreference.getInstance(this.context).getDeviceKeyString());
            mTextMessageReceived.setType(Message.MessageType.MT_INBOX.getValue());
            mTextMessageReceived.setSource(Message.Source.MT_MOBILE_APP.getValue());
            mTextMessageReceived.setTimeToLive(timeToLive);
            mTextMessageReceived.processContactIds(this.context);
            mTextMessageReceived.setTo(mTextMessageReceived.getTo());
            Contact receiverContact = this.baseContactService.getContactById(receiverNumber);
            if (mTextMessageReceived.getMessage() != null && PersonalizedMessage.isPersonalized((String)mTextMessageReceived.getMessage())) {
                mTextMessageReceived.setMessage(PersonalizedMessage.prepareMessageFromTemplate((String)mTextMessageReceived.getMessage(), (Contact)receiverContact));
            }
            try {
                this.messageClientService.sendMessageToServer(mTextMessageReceived, null);
            }
            catch (Exception ex) {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Received message error " + ex.getMessage()));
            }
            this.messageClientService.updateDeliveryStatus(smsKeyString, null, receiverNumber);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return;
        }
    }

    public void addWelcomeMessage(String content) {
        Message message = new Message();
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        message.setContactIds(new Support(this.context).getSupportNumber());
        message.setTo(new Support(this.context).getSupportNumber());
        message.setMessage(content);
        message.setStoreOnDevice(Boolean.TRUE);
        message.setSendToDevice(Boolean.FALSE);
        message.setType(Message.MessageType.MT_INBOX.getValue());
        message.setDeviceKeyString(userPreferences.getDeviceKeyString());
        message.setSource(Message.Source.MT_MOBILE_APP.getValue());
        this.conversationService.sendMessage(message, this.messageIntentServiceClass);
    }

    public void sendCustomMessage(Message message) {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        message.setStoreOnDevice(Boolean.TRUE);
        message.setSendToDevice(Boolean.FALSE);
        message.setType(Message.MessageType.MT_OUTBOX.getValue());
        message.setContentType(Message.ContentType.CUSTOM.getValue());
        message.setDeviceKeyString(userPreferences.getDeviceKeyString());
        message.setSource(Message.Source.MT_MOBILE_APP.getValue());
        this.conversationService.sendMessage(message, this.messageIntentServiceClass);
    }

    public synchronized void updateDeliveryStatusForContact(String contactId, boolean markRead) {
        int rows = this.messageDatabaseService.updateMessageDeliveryReportForContact(contactId, markRead);
        Utils.printLog((Context)this.context, (String)TAG, (String)("Updated delivery report of " + rows + " messages for contactId: " + contactId));
        if (rows > 0) {
            String action = markRead ? BroadcastService.INTENT_ACTIONS.MESSAGE_READ_AND_DELIVERED_FOR_CONTECT.toString() : BroadcastService.INTENT_ACTIONS.MESSAGE_DELIVERY_FOR_CONTACT.toString();
            BroadcastService.sendDeliveryReportForContactBroadcast(this.context, action, contactId);
        }
    }

    public synchronized void updateDeliveryStatus(String key, boolean markRead) {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Got the delivery report for key: " + key));
        String[] keyParts = key.split(",");
        Message message = this.messageDatabaseService.getMessage(keyParts[0]);
        if (message != null && message.getStatus() != Message.Status.DELIVERED_AND_READ.getValue().shortValue()) {
            message.setDelivered(Boolean.TRUE);
            if (markRead) {
                message.setStatus(Message.Status.DELIVERED_AND_READ.getValue());
            } else {
                message.setStatus(Message.Status.DELIVERED.getValue());
            }
            this.messageDatabaseService.updateMessageDeliveryReportForContact(keyParts[0], null, markRead);
            String action = markRead ? BroadcastService.INTENT_ACTIONS.MESSAGE_READ_AND_DELIVERED.toString() : BroadcastService.INTENT_ACTIONS.MESSAGE_DELIVERY.toString();
            BroadcastService.sendMessageUpdateBroadcast(this.context, action, message);
            if (message.getTimeToLive() != null && message.getTimeToLive() != 0) {
                Timer timer = new Timer();
                timer.schedule((TimerTask)new DisappearingMessageTask(this.context, new MobiComConversationService(this.context), message), message.getTimeToLive() * 60 * 1000);
            }
        } else if (message == null) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Message is not present in table, keyString: " + keyParts[0]));
        }
        map.remove(key);
        mtMessages.remove(key);
    }

    public void createEmptyMessages(List<Contact> contactList) {
        for (Contact contact : contactList) {
            this.createEmptyMessage(contact);
        }
        BroadcastService.sendLoadMoreBroadcast(this.context, true);
    }

    public ApiResponse getUpdateMessageMetadata(String key, Map<String, String> metadata) {
        return this.messageClientService.updateMessageMetadata(key, metadata);
    }

    public void createEmptyMessage(Contact contact) {
        Message sms = new Message();
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        sms.setContactIds(contact.getFormattedContactNumber());
        sms.setTo(contact.getContactNumber());
        sms.setCreatedAtTime(0L);
        sms.setStoreOnDevice(Boolean.TRUE);
        sms.setSendToDevice(Boolean.FALSE);
        sms.setType(Message.MessageType.MT_OUTBOX.getValue());
        sms.setDeviceKeyString(userPreferences.getDeviceKeyString());
        sms.setSource(Message.Source.MT_MOBILE_APP.getValue());
        this.messageDatabaseService.createMessage(sms);
    }

    public synchronized void processInstantMessage(Message message) {
        Channel channel;
        if (!this.baseContactService.isContactPresent(message.getContactIds())) {
            this.userService.processUserDetails(message.getContactIds());
        }
        if ((channel = ChannelService.getInstance(this.context).getChannelInfo(message.getGroupId())) == null) {
            return;
        }
        if (message.hasAttachment()) {
            this.processOpenGroupAttachmentMessage(message);
        } else {
            BroadcastService.sendMessageUpdateBroadcast(this.context, BroadcastService.INTENT_ACTIONS.SYNC_MESSAGE.toString(), message);
        }
    }
}

