/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.KmConversationResponse;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.api.people.UserIntentService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.cache.MessageSearchCache;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.listners.MediaUploadProgressHandler;
import com.applozic.mobicomkit.sync.SyncUserDetailsResponse;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.AnnotationExclusionStrategy;
import com.applozic.mobicommons.json.ArrayAdapterFactory;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MobiComConversationService {
    public static final String SERVER_SYNC = "SERVER_SYNC_[CONVERSATION]_[CONTACT]_[CHANNEL]";
    private static final String TAG = "Conversation";
    protected Context context = null;
    protected MessageClientService messageClientService;
    protected MessageDatabaseService messageDatabaseService;
    private SharedPreferences sharedPreferences;
    private BaseContactService baseContactService;
    private ConversationService conversationService;
    private ChannelService channelService;
    public static final int UPLOAD_STARTED = 1;
    public static final int UPLOAD_PROGRESS = 2;
    public static final int UPLOAD_CANCELLED = 3;
    public static final int UPLOAD_COMPLETED = 4;
    public static final int MESSAGE_SENT = 5;
    private boolean isHideActionMessage = false;

    public MobiComConversationService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.messageClientService = new MessageClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.baseContactService = new AppContactService(context);
        this.conversationService = ConversationService.getInstance(context);
        this.channelService = ChannelService.getInstance(context);
        this.isHideActionMessage = ApplozicClient.getInstance(context).isActionMessagesHidden();
        this.sharedPreferences = ApplozicService.getContext((Context)context).getSharedPreferences(MobiComKitClientService.getApplicationKey(context), 0);
    }

    @VisibleForTesting
    public void setMessageClientService(MessageClientService messageClientService) {
        this.messageClientService = messageClientService;
    }

    @VisibleForTesting
    public void setMessageDatabaseService(MessageDatabaseService messageDatabaseService) {
        this.messageDatabaseService = messageDatabaseService;
    }

    @VisibleForTesting
    public void setConversationService(ConversationService conversationService) {
        this.conversationService = conversationService;
    }

    @VisibleForTesting
    public void setContactService(AppContactService appContactService) {
        this.baseContactService = appContactService;
    }

    public void sendMessage(Message message) {
        this.sendMessage(message, null, MessageIntentService.class);
    }

    public void sendMessage(Message message, final MediaUploadProgressHandler progressHandler, Class messageIntentClass) {
        Intent intent = new Intent(this.context, messageIntentClass);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        Handler handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(android.os.Message message) {
                MobiComConversationService.this.handleState(message, progressHandler);
                return true;
            }
        });
        MessageIntentService.enqueueWork(this.context, intent, handler);
    }

    public void sendMessage(Message message, Class messageIntentClass) {
        Intent intent = new Intent(this.context, messageIntentClass);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)message), Message.class));
        MessageIntentService.enqueueWork(this.context, intent, null);
    }

    public void sendMessage(Message message, MediaUploadProgressHandler handler) {
        if (message == null) {
            return;
        }
        ApplozicException e = null;
        if (!message.hasAttachment()) {
            e = new ApplozicException("Message does not have any attachment");
            if (handler != null) {
                handler.onUploadStarted(e, null);
                handler.onProgressUpdate(0, e, null);
                handler.onCancelled(e, null);
            }
        }
        this.sendMessage(message, handler, MessageIntentService.class);
    }

    public List<Message> getLatestMessagesGroupByPeople() {
        return this.getLatestMessagesGroupByPeople(null, null);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt, String searchString, Integer parentGroupKey) {
        boolean emptyTable = this.messageDatabaseService.isMessageTableEmpty();
        if (emptyTable || createdAt != null && createdAt != 0L) {
            this.getMessages(null, createdAt, null, null, null, false, false);
        }
        return this.messageDatabaseService.getMessages(createdAt, searchString, parentGroupKey);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt, String searchString) {
        return this.getLatestMessagesGroupByPeople(createdAt, searchString, null);
    }

    public List<Message> getMessages(String userId, Long startTime, Long endTime) {
        return this.getMessages(startTime, endTime, new Contact(userId), null, null, false, false);
    }

    public synchronized List<Message> getMessages(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId) {
        return this.getMessages(startTime, endTime, contact, channel, conversationId, false, false);
    }

    public synchronized List<Message> getMessagesForParticularThread(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId, boolean isSkipRead) {
        String data = null;
        try {
            data = this.messageClientService.getMessages(contact, channel, startTime, endTime, conversationId, isSkipRead);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Received response from server for Messages: " + data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (data == null || TextUtils.isEmpty(data) || data.equals("UnAuthorized Access") || !data.contains("{")) {
            return null;
        }
        KmConversationResponse kmConversationResponse = null;
        try {
            kmConversationResponse = (KmConversationResponse)((Object)GsonUtils.getObjectFromJson((String)this.messageClientService.getMessages(contact, channel, startTime, endTime, conversationId, isSkipRead), KmConversationResponse.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (kmConversationResponse == null) {
            return null;
        }
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            if (kmConversationResponse.getUserDetails() != null) {
                MessageSearchCache.processUserDetails(kmConversationResponse.getUserDetails());
            }
            if (kmConversationResponse.getGroupFeeds() != null) {
                MessageSearchCache.processChannelFeeds(kmConversationResponse.getGroupFeeds());
            }
            ArrayList<String> messageKeys = new ArrayList<String>();
            for (Message message : kmConversationResponse.getMessage()) {
                if (message.getTo() == null) continue;
                if (message.hasAttachment() && message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    this.setFilePathifExist(message);
                }
                if (message.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                    FileClientService fileClientService = new FileClientService(this.context);
                    fileClientService.loadContactsvCard(message);
                }
                if (Message.MetaDataType.HIDDEN.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || message.getMetadata() != null && Message.GroupMessageMetaData.TRUE.getValue().equals(message.getMetadata().get(Message.GroupMessageMetaData.HIDE_KEY.getValue()))) continue;
                if (this.isHideActionMessage && message.isActionMessage()) {
                    message.setHidden(true);
                }
                messageList.add(message);
                if (message.getMetadata() == null || message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()) == null) continue;
                messageKeys.add(message.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()));
            }
            if (kmConversationResponse.getMessage() != null) {
                Collections.reverse(messageList);
                MessageSearchCache.setMessageList(messageList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public synchronized List<Message> getMessages(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId, boolean isSkipRead, boolean isForSearch) {
        Message[] replyMessageList;
        String data;
        if (isForSearch) {
            return this.getMessagesForParticularThread(startTime, endTime, contact, channel, conversationId, isSkipRead);
        }
        ArrayList<Message> messageList = new ArrayList<Message>();
        List<Message> cachedMessageList = this.messageDatabaseService.getMessages(startTime, endTime, contact, channel, conversationId);
        boolean isServerCallNotRequired = false;
        if (channel != null) {
            Channel newChannel = ChannelService.getInstance(this.context).getChannelByChannelKey(channel.getKey());
            isServerCallNotRequired = newChannel != null && !Channel.GroupType.OPEN.getValue().equals(newChannel.getType());
        } else if (contact != null) {
            isServerCallNotRequired = true;
        }
        if (isServerCallNotRequired && (!cachedMessageList.isEmpty() && this.wasServerCallDoneBefore(contact, channel, conversationId) || contact == null && channel == null && cachedMessageList.isEmpty() && this.wasServerCallDoneBefore(contact, channel, conversationId))) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("cachedMessageList size is : " + cachedMessageList.size()));
            return cachedMessageList;
        }
        try {
            data = this.messageClientService.getMessages(contact, channel, startTime, endTime, conversationId, isSkipRead);
            Utils.printLog((Context)this.context, (String)TAG, (String)("Received response from server for Messages: " + data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return cachedMessageList;
        }
        if (data == null || TextUtils.isEmpty((CharSequence)data) || data.equals("UnAuthorized Access") || !data.contains("{")) {
            if (channel != null && channel.getKey() != null) {
                return cachedMessageList;
            }
            return cachedMessageList;
        }
        this.updateServerCallDoneStatus(contact, channel, conversationId);
        try {
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ArrayAdapterFactory()).setExclusionStrategies(new ExclusionStrategy[]{new AnnotationExclusionStrategy()}).create();
            JsonParser parser = new JsonParser();
            JSONObject jsonObject = new JSONObject(data);
            String channelFeedResponse = "";
            String conversationPxyResponse = "";
            String element = parser.parse(data).getAsJsonObject().get("message").toString();
            String userDetailsElement = parser.parse(data).getAsJsonObject().get("userDetails").toString();
            if (!TextUtils.isEmpty((CharSequence)userDetailsElement)) {
                UserDetail[] userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)userDetailsElement, UserDetail[].class);
                this.processUserDetails(userDetails);
            }
            if (jsonObject.has("groupFeeds")) {
                channelFeedResponse = parser.parse(data).getAsJsonObject().get("groupFeeds").toString();
                ChannelFeed[] channelFeeds = (ChannelFeed[])GsonUtils.getObjectFromJson((String)channelFeedResponse, ChannelFeed[].class);
                ChannelService.getInstance(this.context).processChannelFeedList(channelFeeds, false);
                if (channel != null && !isServerCallNotRequired) {
                    BroadcastService.sendUpdate(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_TITLE_SUBTITLE.toString());
                }
            }
            if (jsonObject.has("conversationPxys")) {
                conversationPxyResponse = parser.parse(data).getAsJsonObject().get("conversationPxys").toString();
                Conversation[] conversationPxy = (Conversation[])GsonUtils.getObjectFromJson((String)conversationPxyResponse, Conversation[].class);
                ConversationService.getInstance(this.context).processConversationArray(conversationPxy, channel, contact);
            }
            Message[] messages = (Message[])gson.fromJson(element, Message[].class);
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            if (messages != null && messages.length > 0 && cachedMessageList.size() > 0 && cachedMessageList.get(0).isLocalMessage() && cachedMessageList.get(0).equals((Object)messages[0])) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Both messages are same.");
                this.deleteMessage(cachedMessageList.get(0));
            }
            for (Message message : messages) {
                if (!message.isCall() || userPreferences.isDisplayCallRecordEnable()) {
                    if (message.getTo() == null) continue;
                    if (message.hasAttachment() && message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                        this.setFilePathifExist(message);
                    }
                    if (message.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                        FileClientService fileClientService = new FileClientService(this.context);
                        fileClientService.loadContactsvCard(message);
                    }
                    if (Message.MetaDataType.HIDDEN.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) continue;
                    if (this.isHideActionMessage && message.isActionMessage()) {
                        message.setHidden(true);
                    }
                    if (this.messageDatabaseService.isMessagePresent(message.getKeyString(), Message.ReplyMessage.HIDE_MESSAGE.getValue())) {
                        this.messageDatabaseService.updateMessageReplyType(message.getKeyString(), Message.ReplyMessage.NON_HIDDEN.getValue());
                    } else if (isServerCallNotRequired || contact == null && channel == null) {
                        this.messageDatabaseService.createMessage(message);
                    }
                    if (contact == null && channel == null && message.isHidden()) {
                        if (message.getGroupId() != null) {
                            Channel newChannel = ChannelService.getInstance(this.context).getChannelByChannelKey(message.getGroupId());
                            if (newChannel != null) {
                                this.getMessages(null, null, null, newChannel, null, true, isForSearch);
                            }
                        } else {
                            this.getMessages(null, null, new Contact(message.getContactIds()), null, null, true, isForSearch);
                        }
                    }
                }
                if (isServerCallNotRequired) continue;
                messageList.add(message);
            }
            if (contact == null && channel == null) {
                Intent intent = new Intent("APPLOZIC_UNREAD_COUNT");
                LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Message> finalMessageList = this.messageDatabaseService.getMessages(startTime, endTime, contact, channel, conversationId);
        ArrayList<String> messageKeys = new ArrayList<String>();
        for (Message msg : finalMessageList) {
            if (msg.getTo() == null || Message.MetaDataType.HIDDEN.getValue().equals(msg.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(msg.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || msg.getMetadata() == null || msg.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()) == null || this.messageDatabaseService.isMessagePresent(msg.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()))) continue;
            messageKeys.add(msg.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()));
        }
        if (messageKeys != null && messageKeys.size() > 0 && (replyMessageList = this.getMessageListByKeyList(messageKeys)) != null) {
            for (Message replyMessage : replyMessageList) {
                if (replyMessage.getTo() == null || Message.MetaDataType.HIDDEN.getValue().equals(replyMessage.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(replyMessage.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) continue;
                if (replyMessage.hasAttachment() && replyMessage.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    this.setFilePathifExist(replyMessage);
                }
                if (replyMessage.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                    FileClientService fileClientService = new FileClientService(this.context);
                    fileClientService.loadContactsvCard(replyMessage);
                }
                replyMessage.setReplyMessage(Message.ReplyMessage.HIDE_MESSAGE.getValue());
                if (!isServerCallNotRequired && (contact != null || channel != null)) continue;
                this.messageDatabaseService.createMessage(replyMessage);
            }
        }
        if (messageList != null && !messageList.isEmpty()) {
            Collections.sort(messageList, new Comparator<Message>(){

                @Override
                public int compare(Message lhs, Message rhs) {
                    return lhs.getCreatedAtTime().compareTo(rhs.getCreatedAtTime());
                }
            });
        }
        return channel != null && Channel.GroupType.OPEN.getValue().equals(channel.getType()) ? messageList : finalMessageList;
    }

    public List<Message> getConversationSearchList(String searchString) throws Exception {
        String response = this.messageClientService.getMessageSearchResult(searchString);
        try {
            ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, (Type)new TypeToken<ApiResponse<KmConversationResponse>>(){}.getType()));
            if (apiResponse != null) {
                if (apiResponse.isSuccess()) {
                    this.processMessageSearchResult((KmConversationResponse)((Object)apiResponse.getResponse()));
                    return Arrays.asList(((KmConversationResponse)((Object)apiResponse.getResponse())).getMessage());
                }
                if (apiResponse.getErrorResponse() != null) {
                    throw new ApplozicException(GsonUtils.getJsonFromObject(apiResponse.getErrorResponse(), List.class));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return null;
    }

    private void processMessageSearchResult(KmConversationResponse kmConversationResponse) {
        if (kmConversationResponse != null) {
            MessageSearchCache.processChannelFeeds(kmConversationResponse.getGroupFeeds());
            MessageSearchCache.processUserDetails(kmConversationResponse.getUserDetails());
            MessageSearchCache.setMessageList(Arrays.asList(kmConversationResponse.getMessage()));
        }
    }

    public synchronized List<Message> getKmConversationList(int status, int pageSize, Long lastFetchTime, boolean makeServerCall) {
        Message[] replyMessageList;
        ArrayList<Message> conversationList = new ArrayList<Message>();
        List<Message> cachedConversationList = this.messageDatabaseService.getKmConversationList(status, lastFetchTime);
        if (!makeServerCall && !cachedConversationList.isEmpty()) {
            return cachedConversationList;
        }
        KmConversationResponse kmConversationResponse = null;
        try {
            ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)this.messageClientService.getKmConversationList(status, pageSize, lastFetchTime), (Type)new TypeToken<ApiResponse<KmConversationResponse>>(){}.getType()));
            if (apiResponse != null) {
                kmConversationResponse = (KmConversationResponse)((Object)apiResponse.getResponse());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return cachedConversationList;
        }
        if (kmConversationResponse == null) {
            return null;
        }
        try {
            if (kmConversationResponse.getUserDetails() != null) {
                this.processUserDetails(kmConversationResponse.getUserDetails());
            }
            if (kmConversationResponse.getGroupFeeds() != null) {
                ChannelService.getInstance(this.context).processChannelFeedList(kmConversationResponse.getGroupFeeds(), false);
            }
            Message[] messages = kmConversationResponse.getMessage();
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            if (messages != null && messages.length > 0 && cachedConversationList.size() > 0 && cachedConversationList.get(0).isLocalMessage() && cachedConversationList.get(0).equals((Object)messages[0])) {
                Utils.printLog((Context)this.context, (String)TAG, (String)"Both messages are same.");
                this.deleteMessage(cachedConversationList.get(0));
            }
            for (Message message : messages) {
                if (!message.isCall() || userPreferences.isDisplayCallRecordEnable()) {
                    if (message.getTo() == null) continue;
                    if (message.hasAttachment() && message.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                        this.setFilePathifExist(message);
                    }
                    if (message.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                        FileClientService fileClientService = new FileClientService(this.context);
                        fileClientService.loadContactsvCard(message);
                    }
                    if (Message.MetaDataType.HIDDEN.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) continue;
                    if (this.isHideActionMessage && message.isActionMessage()) {
                        message.setHidden(true);
                    }
                    if (this.messageDatabaseService.isMessagePresent(message.getKeyString(), Message.ReplyMessage.HIDE_MESSAGE.getValue())) {
                        this.messageDatabaseService.updateMessageReplyType(message.getKeyString(), Message.ReplyMessage.NON_HIDDEN.getValue());
                    } else {
                        this.messageDatabaseService.createMessage(message);
                    }
                    if (message.isHidden()) {
                        if (message.getGroupId() != null) {
                            Channel newChannel = ChannelService.getInstance(this.context).getChannelByChannelKey(message.getGroupId());
                            if (newChannel != null) {
                                this.getMessages(null, null, null, newChannel, null, true, false);
                            }
                        } else {
                            this.getMessages(null, null, new Contact(message.getContactIds()), null, null, true, false);
                        }
                    }
                }
                conversationList.add(message);
            }
            Intent intent = new Intent("APPLOZIC_UNREAD_COUNT");
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Message> finalMessageList = this.messageDatabaseService.getKmConversationList(status, lastFetchTime);
        ArrayList<String> messageKeys = new ArrayList<String>();
        for (Message msg : finalMessageList) {
            if (msg.getTo() == null || Message.MetaDataType.HIDDEN.getValue().equals(msg.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(msg.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || msg.getMetadata() == null || msg.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()) == null || this.messageDatabaseService.isMessagePresent(msg.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()))) continue;
            messageKeys.add(msg.getMetaDataValueForKey(Message.MetaDataType.AL_REPLY.getValue()));
        }
        if (messageKeys != null && messageKeys.size() > 0 && (replyMessageList = this.getMessageListByKeyList(messageKeys)) != null) {
            for (Message replyMessage : replyMessageList) {
                if (replyMessage.getTo() == null || Message.MetaDataType.HIDDEN.getValue().equals(replyMessage.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) || Message.MetaDataType.PUSHNOTIFICATION.getValue().equals(replyMessage.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) continue;
                if (replyMessage.hasAttachment() && replyMessage.getContentType() != Message.ContentType.TEXT_URL.getValue().shortValue()) {
                    this.setFilePathifExist(replyMessage);
                }
                if (replyMessage.getContentType() == Message.ContentType.CONTACT_MSG.getValue().shortValue()) {
                    FileClientService fileClientService = new FileClientService(this.context);
                    fileClientService.loadContactsvCard(replyMessage);
                }
                replyMessage.setReplyMessage(Message.ReplyMessage.HIDE_MESSAGE.getValue());
                this.messageDatabaseService.createMessage(replyMessage);
            }
        }
        if (!conversationList.isEmpty()) {
            Collections.sort(conversationList, new Comparator<Message>(){

                @Override
                public int compare(Message lhs, Message rhs) {
                    return lhs.getCreatedAtTime().compareTo(rhs.getCreatedAtTime());
                }
            });
        }
        return finalMessageList;
    }

    private void processUserDetails(SyncUserDetailsResponse userDetailsResponse) {
        for (UserDetail userDetail : userDetailsResponse.getResponse()) {
            Contact newContact = this.baseContactService.getContactById(userDetail.getUserId());
            Contact contact = new Contact();
            contact.setUserId(userDetail.getUserId());
            contact.setContactNumber(userDetail.getPhoneNumber());
            contact.setStatus(userDetail.getStatusMessage());
            contact.setConnected(userDetail.isConnected());
            if (!TextUtils.isEmpty((CharSequence)userDetail.getDisplayName())) {
                contact.setFullName(userDetail.getDisplayName());
            }
            contact.setLastSeenAt(userDetail.getLastSeenAtTime());
            if (userDetail.getUnreadCount() != null) {
                contact.setUnreadCount(userDetail.getUnreadCount());
            }
            if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
                contact.setImageURL(userDetail.getImageLink());
            }
            contact.setUserTypeId(userDetail.getUserTypeId());
            contact.setDeletedAtTime(userDetail.getDeletedAtTime());
            contact.setRoleType(userDetail.getRoleType());
            contact.setMetadata(userDetail.getMetadata());
            contact.setLastMessageAtTime(userDetail.getLastMessageAtTime());
            if (newContact != null && newContact.isConnected() != contact.isConnected()) {
                BroadcastService.sendUpdateLastSeenAtTimeBroadcast(this.context, BroadcastService.INTENT_ACTIONS.UPDATE_LAST_SEEN_AT_TIME.toString(), contact.getContactIds());
            }
            this.baseContactService.upsert(contact);
        }
        MobiComUserPreference.getInstance(this.context).setLastSeenAtSyncTime(userDetailsResponse.getGeneratedAt());
    }

    public Message[] getMessageListByKeyList(List<String> messageKeyList) {
        String response = this.messageClientService.getMessageByMessageKeys(messageKeyList);
        if (!TextUtils.isEmpty((CharSequence)response)) {
            JsonParser parser = new JsonParser();
            try {
                String responseString;
                String messageResponse;
                JSONObject jsonObject = new JSONObject(response);
                String status = null;
                if (jsonObject.has("status")) {
                    status = jsonObject.getString("status");
                }
                if (!TextUtils.isEmpty(status) && "success".equals(status) && !TextUtils.isEmpty((CharSequence)(messageResponse = parser.parse(responseString = jsonObject.getString("response")).getAsJsonObject().get("message").toString()))) {
                    return (Message[])GsonUtils.getObjectFromJson((String)messageResponse, Message[].class);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean wasServerCallDoneBefore(Contact contact, Channel channel, Integer conversationId) {
        if (contact == null && channel == null) {
            return false;
        }
        return this.sharedPreferences.getBoolean(this.getServerSyncCallKey(contact, channel, conversationId), false);
    }

    private void updateServerCallDoneStatus(Contact contact, Channel channel, Integer conversationId) {
        if (contact == null && channel == null) {
            return;
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)"updating server call to true");
        this.sharedPreferences.edit().putBoolean(this.getServerSyncCallKey(contact, channel, conversationId), true).commit();
    }

    public String getServerSyncCallKey(Contact contact, Channel channel, Integer conversationId) {
        return SERVER_SYNC.replace("[CONVERSATION]", conversationId != null && conversationId != 0 ? String.valueOf(conversationId) : "").replace("[CONTACT]", contact != null ? contact.getContactIds() : "").replace("[CHANNEL]", channel != null ? String.valueOf(channel.getKey()) : "");
    }

    public void setFilePathifExist(Message message) {
        FileMeta fileMeta = message.getFileMetas();
        File file = FileClientService.getFilePath(FileUtils.getName((String)fileMeta.getName()) + message.getCreatedAtTime() + "." + FileUtils.getFileFormat((String)fileMeta.getName()), this.context.getApplicationContext(), fileMeta.getContentType());
        if (file.exists()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            message.setFilePaths(arrayList);
        }
    }

    public boolean deleteMessage(Message message, Contact contact) {
        if (!message.isSentToServer()) {
            this.deleteMessageFromDevice(message, contact != null ? contact.getContactIds() : null);
            return true;
        }
        String response = this.messageClientService.deleteMessage(message, contact);
        if ("success".equals(response)) {
            this.deleteMessageFromDevice(message, contact != null ? contact.getContactIds() : null);
        } else {
            this.messageDatabaseService.updateDeleteSyncStatus(message, "1");
        }
        return true;
    }

    public boolean deleteMessage(Message message) {
        return this.deleteMessage(message, null);
    }

    public String deleteMessageFromDevice(Message message, String contactNumber) {
        if (message == null) {
            return null;
        }
        return this.messageDatabaseService.deleteMessage(message, contactNumber);
    }

    public void deleteConversationFromDevice(String contactNumber) {
        this.messageDatabaseService.deleteConversation(contactNumber);
    }

    public void deleteChannelConversationFromDevice(Integer channelKey) {
        this.messageDatabaseService.deleteChannelConversation(channelKey);
    }

    public void deleteAndBroadCast(final Contact contact, boolean deleteFromServer) {
        this.deleteConversationFromDevice(contact.getContactIds());
        if (deleteFromServer) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MobiComConversationService.this.messageClientService.deleteConversationThreadFromServer(contact);
                }
            });
            thread.setPriority(10);
            thread.start();
        }
        BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), contact.getContactIds(), 0, "success");
    }

    public String deleteSync(Contact contact, Channel channel, Integer conversationId) {
        String response = "";
        if (contact != null || channel != null) {
            response = this.messageClientService.syncDeleteConversationThreadFromServer(contact, channel);
        }
        if (!TextUtils.isEmpty((CharSequence)response) && "success".equals(response)) {
            if (contact != null) {
                this.messageDatabaseService.deleteConversation(contact.getContactIds());
                if (conversationId != null && conversationId != 0) {
                    this.conversationService.deleteConversation(contact.getContactIds());
                }
            } else {
                this.messageDatabaseService.deleteChannelConversation(channel.getKey());
            }
        }
        BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), contact != null ? contact.getContactIds() : null, channel != null ? channel.getKey() : null, response);
        return response;
    }

    public String deleteMessageFromDevice(String keyString, String contactNumber) {
        return this.deleteMessageFromDevice(this.messageDatabaseService.getMessage(keyString), contactNumber);
    }

    public synchronized void processLastSeenAtStatus() {
        try {
            SyncUserDetailsResponse userDetailsResponse = this.messageClientService.getUserDetailsList(MobiComUserPreference.getInstance(this.context).getLastSeenAtSyncTime());
            if (userDetailsResponse != null && userDetailsResponse.getResponse() != null && "success".equals(userDetailsResponse.getStatus())) {
                this.processUserDetails(userDetailsResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processUserDetails(UserDetail[] userDetails) {
        if (userDetails != null && userDetails.length > 0) {
            for (UserDetail userDetail : userDetails) {
                Contact contact = new Contact();
                contact.setUserId(userDetail.getUserId());
                contact.setContactNumber(userDetail.getPhoneNumber());
                contact.setConnected(userDetail.isConnected());
                if (!TextUtils.isEmpty((CharSequence)userDetail.getDisplayName())) {
                    contact.setFullName(userDetail.getDisplayName());
                }
                contact.setLastSeenAt(userDetail.getLastSeenAtTime());
                contact.setStatus(userDetail.getStatusMessage());
                contact.setUnreadCount(userDetail.getUnreadCount());
                contact.setUserTypeId(userDetail.getUserTypeId());
                contact.setImageURL(userDetail.getImageLink());
                contact.setDeletedAtTime(userDetail.getDeletedAtTime());
                contact.setLastMessageAtTime(userDetail.getLastMessageAtTime());
                contact.setMetadata(userDetail.getMetadata());
                contact.setRoleType(userDetail.getRoleType());
                this.baseContactService.upsert(contact);
            }
        }
    }

    public String getConversationIdString(Integer conversationId) {
        return BroadcastService.isContextBasedChatEnabled() && conversationId != null && conversationId != 0 ? "_" + conversationId : "";
    }

    public String reportMessage(String messageKey) {
        return this.messageClientService.reportMessage(messageKey);
    }

    public void read(Contact contact, Channel channel) {
        try {
            int unreadCount = 0;
            if (contact != null) {
                unreadCount = contact.getUnreadCount();
            } else if (channel != null) {
                unreadCount = channel.getUnreadCount();
            }
            Intent intent = new Intent(this.context, UserIntentService.class);
            intent.putExtra("contact", (Serializable)contact);
            intent.putExtra("channel", (Serializable)channel);
            intent.putExtra("UNREAD_COUNT", unreadCount);
            UserIntentService.enqueueWork(this.context, intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleState(android.os.Message message, MediaUploadProgressHandler progressHandler) {
        if (message != null) {
            Bundle bundle = message.getData();
            String e = null;
            String oldMessageKey = null;
            if (bundle != null) {
                e = bundle.getString("error");
                oldMessageKey = bundle.getString("oldMessageKey");
            }
            switch (message.what) {
                case 1: {
                    if (progressHandler == null) break;
                    progressHandler.onUploadStarted(e != null ? new ApplozicException(e) : null, oldMessageKey);
                    break;
                }
                case 2: {
                    if (progressHandler == null) break;
                    progressHandler.onProgressUpdate(message.arg1, e != null ? new ApplozicException(e) : null, oldMessageKey);
                    break;
                }
                case 4: {
                    if (progressHandler == null) break;
                    progressHandler.onCompleted(e != null ? new ApplozicException(e) : null, oldMessageKey);
                    break;
                }
                case 3: {
                    if (progressHandler == null) break;
                    progressHandler.onCancelled(e != null ? new ApplozicException(e) : null, oldMessageKey);
                    break;
                }
                case 5: {
                    if (bundle == null || progressHandler == null) break;
                    Message messageObject = this.messageDatabaseService.getMessage(bundle.getString("message"));
                    String messageJson = bundle.getString("messageJson");
                    if (messageObject == null) {
                        messageObject = (Message)((Object)GsonUtils.getObjectFromJson((String)messageJson, Message.class));
                    }
                    progressHandler.onSent(messageObject, oldMessageKey);
                }
            }
        }
    }
}

