/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.feed.GcmMessageResponse;
import com.applozic.mobicomkit.feed.InstantMessageResponse;
import com.applozic.mobicomkit.feed.MqttMessageResponse;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.json.JsonMarker;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class MobiComPushReceiver {
    public static final String MTCOM_PREFIX = "APPLOZIC_";
    public static final List<String> notificationKeyList = new ArrayList<String>();
    public static final String BLOCKED_TO = "BLOCKED_TO";
    public static final String UNBLOCKED_TO = "UNBLOCKED_TO";
    private static final String TAG = "MobiComPushReceiver";
    private static Queue<String> notificationIdList = new LinkedList<String>();

    public static boolean isMobiComPushNotification(Intent intent) {
        Log.d((String)TAG, (String)"checking for Applozic notification.");
        if (intent == null) {
            return false;
        }
        return MobiComPushReceiver.isMobiComPushNotification(intent.getExtras());
    }

    public static boolean isMobiComPushNotification(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        String payLoad = bundle.getString("collapse_key");
        Log.d((String)TAG, (String)"Received notification");
        if (payLoad != null && payLoad.contains(MTCOM_PREFIX) || notificationKeyList.contains(payLoad)) {
            return true;
        }
        for (String key : notificationKeyList) {
            payLoad = bundle.getString(key);
            if (payLoad == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isMobiComPushNotification(Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return false;
        }
        String payLoad = data.toString();
        Log.d((String)TAG, (String)"Received notification");
        if (payLoad != null && payLoad.contains(MTCOM_PREFIX) || notificationKeyList.contains(payLoad)) {
            return true;
        }
        for (String key : notificationKeyList) {
            if (!data.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean processPushNotificationId(String id) {
        if (id != null && notificationIdList != null && notificationIdList.contains(id)) {
            if (notificationIdList.size() > 0) {
                notificationIdList.remove(id);
            }
            return true;
        }
        return false;
    }

    public static synchronized void addPushNotificationId(String notificationId) {
        try {
            if (notificationIdList != null && notificationIdList.size() < 20) {
                notificationIdList.add(notificationId);
            }
            if (notificationIdList != null && notificationIdList.size() == 20) {
                for (int i = 1; i <= 14; ++i) {
                    if (notificationIdList.size() <= 0) continue;
                    notificationIdList.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processMessage(Context context, Bundle bundle, Map<String, String> data) {
        block60: {
            try {
                JsonMarker response;
                String userId;
                String keyString;
                String[] splitKeyString;
                String payloadForDelivered = null;
                String userConnected = null;
                String userDisconnected = null;
                String payloadDeliveredAndRead = null;
                String messageKey = null;
                String messageSent = null;
                String deleteConversationForContact = null;
                String deleteConversationForChannel = null;
                String deleteMessage = null;
                String conversationReadResponse = null;
                String userBlockedResponse = null;
                String userUnBlockedResponse = null;
                String conversationReadForContact = null;
                String conversationReadForChannel = null;
                Object conversationReadForSingleMessage = null;
                String userDetailChanged = null;
                String userDeleteNotification = null;
                String messageMetadataUpdate = null;
                String mutedUserListResponse = null;
                String contactSync = null;
                SyncCallService syncCallService = SyncCallService.getInstance(context);
                if (bundle != null) {
                    deleteConversationForContact = bundle.getString(notificationKeyList.get(5));
                    deleteMessage = bundle.getString(notificationKeyList.get(4));
                    payloadForDelivered = bundle.getString(notificationKeyList.get(3));
                    userConnected = bundle.getString(notificationKeyList.get(10));
                    userDisconnected = bundle.getString(notificationKeyList.get(11));
                    payloadDeliveredAndRead = bundle.getString(notificationKeyList.get(7));
                    messageSent = bundle.getString(notificationKeyList.get(1));
                    messageKey = bundle.getString(notificationKeyList.get(0));
                    conversationReadResponse = bundle.getString(notificationKeyList.get(9));
                    userBlockedResponse = bundle.getString(notificationKeyList.get(15));
                    userUnBlockedResponse = bundle.getString(notificationKeyList.get(16));
                    conversationReadForContact = bundle.getString(notificationKeyList.get(8));
                    conversationReadForChannel = bundle.getString(notificationKeyList.get(20));
                    deleteConversationForChannel = bundle.getString(notificationKeyList.get(22));
                    userDetailChanged = bundle.getString(notificationKeyList.get(29));
                    userDeleteNotification = bundle.getString(notificationKeyList.get(31));
                    messageMetadataUpdate = bundle.getString(notificationKeyList.get(30));
                    mutedUserListResponse = bundle.getString(notificationKeyList.get(32));
                    contactSync = bundle.getString(notificationKeyList.get(25));
                } else if (data != null) {
                    deleteConversationForContact = data.get(notificationKeyList.get(5));
                    deleteMessage = data.get(notificationKeyList.get(4));
                    payloadForDelivered = data.get(notificationKeyList.get(3));
                    userConnected = data.get(notificationKeyList.get(10));
                    userDisconnected = data.get(notificationKeyList.get(11));
                    payloadDeliveredAndRead = data.get(notificationKeyList.get(7));
                    messageSent = data.get(notificationKeyList.get(1));
                    messageKey = data.get(notificationKeyList.get(0));
                    conversationReadResponse = data.get(notificationKeyList.get(9));
                    userBlockedResponse = data.get(notificationKeyList.get(15));
                    userUnBlockedResponse = data.get(notificationKeyList.get(16));
                    conversationReadForContact = data.get(notificationKeyList.get(8));
                    conversationReadForChannel = data.get(notificationKeyList.get(20));
                    deleteConversationForChannel = data.get(notificationKeyList.get(22));
                    userDetailChanged = data.get(notificationKeyList.get(29));
                    userDeleteNotification = data.get(notificationKeyList.get(31));
                    messageMetadataUpdate = data.get(notificationKeyList.get(30));
                    mutedUserListResponse = data.get(notificationKeyList.get(32));
                    contactSync = data.get(notificationKeyList.get(25));
                }
                if (!TextUtils.isEmpty(payloadForDelivered)) {
                    MqttMessageResponse messageResponseForDelivered = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(payloadForDelivered, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(messageResponseForDelivered.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(messageResponseForDelivered.getId());
                    splitKeyString = messageResponseForDelivered.getMessage().toString().split(",");
                    keyString = splitKeyString[0];
                    syncCallService.updateDeliveryStatus(keyString);
                }
                if (!TextUtils.isEmpty(payloadDeliveredAndRead)) {
                    MqttMessageResponse messageResponseForDeliveredAndRead = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(payloadDeliveredAndRead, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(messageResponseForDeliveredAndRead.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(messageResponseForDeliveredAndRead.getId());
                    splitKeyString = messageResponseForDeliveredAndRead.getMessage().toString().split(",");
                    keyString = splitKeyString[0];
                    syncCallService.updateReadStatus(keyString);
                }
                if (!TextUtils.isEmpty((CharSequence)deleteConversationForContact)) {
                    MqttMessageResponse deleteConversationResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson((String)deleteConversationForContact, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(deleteConversationResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(deleteConversationResponse.getId());
                    MobiComConversationService conversationService = new MobiComConversationService(context);
                    conversationService.deleteConversationFromDevice(deleteConversationResponse.getMessage().toString());
                    BroadcastService.sendConversationDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), deleteConversationResponse.getMessage().toString(), 0, "success");
                }
                if (!TextUtils.isEmpty(deleteConversationForChannel)) {
                    InstantMessageResponse instantMessageResponse = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson(deleteConversationForChannel, InstantMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(instantMessageResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(instantMessageResponse.getId());
                    syncCallService.deleteChannelConversationThread(instantMessageResponse.getMessage());
                    BroadcastService.sendConversationDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), null, Integer.valueOf(instantMessageResponse.getMessage()), "success");
                }
                if (!TextUtils.isEmpty(userConnected)) {
                    MqttMessageResponse userConnectedResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(userConnected, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(userConnectedResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(userConnectedResponse.getId());
                    syncCallService.updateConnectedStatus(userConnectedResponse.getMessage().toString(), new Date(), true);
                }
                if (!TextUtils.isEmpty(userDisconnected)) {
                    MqttMessageResponse userDisconnectedResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(userDisconnected, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(userDisconnectedResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(userDisconnectedResponse.getId());
                    String[] parts = userDisconnectedResponse.getMessage().toString().split(",");
                    userId = parts[0];
                    Date lastSeenAt = new Date();
                    if (parts.length >= 2 && !parts[1].equals("null")) {
                        lastSeenAt = new Date(Long.valueOf(parts[1]));
                    }
                    syncCallService.updateConnectedStatus(userId, lastSeenAt, false);
                }
                if (!TextUtils.isEmpty((CharSequence)deleteMessage)) {
                    MqttMessageResponse deleteSingleMessageResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson((String)deleteMessage, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(deleteSingleMessageResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(deleteSingleMessageResponse.getId());
                    String deleteMessageKeyAndUserId = deleteSingleMessageResponse.getMessage().toString();
                    syncCallService.deleteMessage(deleteMessageKeyAndUserId.split(",")[0]);
                }
                if (!TextUtils.isEmpty(messageSent)) {
                    GcmMessageResponse syncSentMessageResponse = (GcmMessageResponse)((Object)GsonUtils.getObjectFromJson(messageSent, GcmMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(syncSentMessageResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(syncSentMessageResponse.getId());
                    syncCallService.syncMessages(null);
                }
                GcmMessageResponse syncMessageResponse = null;
                if (!TextUtils.isEmpty(messageKey)) {
                    syncMessageResponse = (GcmMessageResponse)((Object)GsonUtils.getObjectFromJson(messageKey, GcmMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(syncMessageResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(syncMessageResponse.getId());
                    Message messageObj = syncMessageResponse.getMessage();
                    if (!TextUtils.isEmpty((CharSequence)messageObj.getKeyString())) {
                        syncCallService.syncMessages(messageObj.getKeyString());
                        if (messageObj.getGroupId() != null && messageObj.isGroupDeleteAction()) {
                            syncCallService.deleteChannelConversationThread(messageObj.getGroupId());
                            BroadcastService.sendConversationDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), null, messageObj.getGroupId(), "success");
                        }
                    } else {
                        syncCallService.syncMessages(null);
                    }
                }
                if (!TextUtils.isEmpty(conversationReadResponse)) {
                    MqttMessageResponse updateDeliveryStatusForContactResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(conversationReadResponse, MqttMessageResponse.class));
                    if (notificationKeyList.get(9).equals(updateDeliveryStatusForContactResponse.getType())) {
                        if (MobiComPushReceiver.processPushNotificationId(updateDeliveryStatusForContactResponse.getId())) {
                            return;
                        }
                        MobiComPushReceiver.addPushNotificationId(updateDeliveryStatusForContactResponse.getId());
                        syncCallService.updateDeliveryStatusForContact(updateDeliveryStatusForContactResponse.getMessage().toString(), true);
                    }
                }
                if (!TextUtils.isEmpty(userBlockedResponse)) {
                    MqttMessageResponse syncUserBlock = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(userBlockedResponse, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(syncUserBlock.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(syncUserBlock.getId());
                    SyncCallService.getInstance(context).syncBlockUsers();
                }
                if (!TextUtils.isEmpty(userUnBlockedResponse)) {
                    MqttMessageResponse syncUserUnBlock = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(userUnBlockedResponse, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(syncUserUnBlock.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(syncUserUnBlock.getId());
                    SyncCallService.getInstance(context).syncBlockUsers();
                }
                if (!TextUtils.isEmpty(conversationReadForContact)) {
                    MqttMessageResponse conversationReadForContactResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(conversationReadForContact, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(conversationReadForContactResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(conversationReadForContactResponse.getId());
                    syncCallService.updateConversationReadStatus(conversationReadForContactResponse.getMessage().toString(), false);
                }
                if (!TextUtils.isEmpty(conversationReadForChannel)) {
                    InstantMessageResponse conversationReadForChannelResponse = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson(conversationReadForChannel, InstantMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(conversationReadForChannelResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(conversationReadForChannelResponse.getId());
                    syncCallService.updateConversationReadStatus(conversationReadForChannelResponse.getMessage(), true);
                }
                if (!TextUtils.isEmpty(userDetailChanged) || !TextUtils.isEmpty(userDeleteNotification)) {
                    response = null;
                    if (!TextUtils.isEmpty(userDetailChanged)) {
                        response = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(userDetailChanged, MqttMessageResponse.class));
                    } else if (!TextUtils.isEmpty(userDeleteNotification)) {
                        response = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(userDeleteNotification, MqttMessageResponse.class));
                    }
                    if (MobiComPushReceiver.processPushNotificationId(response.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(response.getId());
                    userId = response.getMessage().toString();
                    syncCallService.syncUserDetail(userId);
                }
                if (!TextUtils.isEmpty(messageMetadataUpdate)) {
                    String keyString2 = null;
                    String id = null;
                    String deviceKey = null;
                    try {
                        GcmMessageResponse messageResponse = (GcmMessageResponse)((Object)GsonUtils.getObjectFromJson(messageMetadataUpdate, GcmMessageResponse.class));
                        keyString2 = messageResponse.getMessage().getKeyString();
                        id = messageResponse.getId();
                        deviceKey = messageResponse.getMessage().getDeviceKeyString();
                    }
                    catch (Exception e) {
                        try {
                            InstantMessageResponse response2 = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson(messageMetadataUpdate, InstantMessageResponse.class));
                            keyString2 = response2.getMessage();
                            id = response2.getId();
                            Message message = new MessageDatabaseService(context).getMessage(keyString2);
                            if (message != null) {
                                deviceKey = message.getDeviceKeyString();
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (MobiComPushReceiver.processPushNotificationId(id)) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(id);
                    if (deviceKey != null && deviceKey.equals(MobiComUserPreference.getInstance(context).getDeviceKeyString())) {
                        return;
                    }
                    syncCallService.syncMessageMetadataUpdate(keyString2, true);
                }
                if (Applozic.getInstance(context).isDeviceContactSync() && !TextUtils.isEmpty(contactSync)) {
                    MqttMessageResponse mqttMessageResponse = (MqttMessageResponse)((Object)GsonUtils.getObjectFromJson(contactSync, MqttMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(mqttMessageResponse.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(mqttMessageResponse.getId());
                    syncCallService.processContactSync(mqttMessageResponse.getMessage().toString());
                }
                if (TextUtils.isEmpty(mutedUserListResponse)) break block60;
                try {
                    response = (InstantMessageResponse)((Object)GsonUtils.getObjectFromJson(mutedUserListResponse, InstantMessageResponse.class));
                    if (MobiComPushReceiver.processPushNotificationId(response.getId())) {
                        return;
                    }
                    MobiComPushReceiver.addPushNotificationId(response.getId());
                    if (response.getMessage() != null) {
                        String muteFlag = String.valueOf(response.getMessage().charAt(response.getMessage().length() - 1));
                        if ("1".equals(muteFlag)) {
                            syncCallService.syncMutedUserList(true, null);
                        } else if ("0".equals(muteFlag)) {
                            String userId2 = response.getMessage().substring(0, response.getMessage().length() - 2);
                            syncCallService.syncMutedUserList(true, userId2);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void processMessageAsync(final Context context, final Bundle bundle) {
        try {
            if (MobiComUserPreference.getInstance(context).isLoggedIn()) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MobiComPushReceiver.processMessage(context, bundle);
                    }
                });
                t.setPriority(10);
                t.start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void processMessageAsync(Context context, Intent intent) {
        MobiComPushReceiver.processMessageAsync(context, intent.getExtras());
    }

    public static void processMessageAsync(final Context context, final Map<String, String> data) {
        try {
            if (MobiComUserPreference.getInstance(context).isLoggedIn()) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MobiComPushReceiver.processMessage(context, data);
                    }
                });
                t.setPriority(10);
                t.start();
            }
        }
        catch (Throwable w) {
            w.printStackTrace();
        }
    }

    public static void processMessage(Context context, Map<String, String> data) {
        MobiComPushReceiver.processMessage(context, null, data);
    }

    public static void processMessage(Context context, Bundle bundle) {
        MobiComPushReceiver.processMessage(context, bundle, null);
    }

    static {
        notificationKeyList.add("APPLOZIC_01");
        notificationKeyList.add("APPLOZIC_02");
        notificationKeyList.add("APPLOZIC_03");
        notificationKeyList.add("APPLOZIC_04");
        notificationKeyList.add("APPLOZIC_05");
        notificationKeyList.add("APPLOZIC_06");
        notificationKeyList.add("APPLOZIC_07");
        notificationKeyList.add("APPLOZIC_08");
        notificationKeyList.add("APPLOZIC_09");
        notificationKeyList.add("APPLOZIC_10");
        notificationKeyList.add("APPLOZIC_11");
        notificationKeyList.add("APPLOZIC_12");
        notificationKeyList.add("APPLOZIC_13");
        notificationKeyList.add("APPLOZIC_14");
        notificationKeyList.add("APPLOZIC_15");
        notificationKeyList.add("APPLOZIC_16");
        notificationKeyList.add("APPLOZIC_17");
        notificationKeyList.add("APPLOZIC_18");
        notificationKeyList.add("APPLOZIC_19");
        notificationKeyList.add("APPLOZIC_20");
        notificationKeyList.add("APPLOZIC_21");
        notificationKeyList.add("APPLOZIC_22");
        notificationKeyList.add("APPLOZIC_23");
        notificationKeyList.add("APPLOZIC_24");
        notificationKeyList.add("APPLOZIC_25");
        notificationKeyList.add("APPLOZIC_26");
        notificationKeyList.add("APPLOZIC_27");
        notificationKeyList.add("APPLOZIC_28");
        notificationKeyList.add("APPLOZIC_29");
        notificationKeyList.add("APPLOZIC_30");
        notificationKeyList.add("APPLOZIC_33");
        notificationKeyList.add("APPLOZIC_34");
        notificationKeyList.add("APPLOZIC_37");
    }
}

