/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.people;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;

public class UserIntentService
extends JobIntentService {
    private static final String TAG = "UserIntentService";
    public static final String USER_ID = "userId";
    public static final String USER_LAST_SEEN_AT_STATUS = "USER_LAST_SEEN_AT_STATUS";
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String UNREAD_COUNT = "UNREAD_COUNT";
    public static final String SINGLE_MESSAGE_READ = "SINGLE_MESSAGE_READ";
    MessageClientService messageClientService;
    MobiComConversationService mobiComConversationService;
    static final int JOB_ID = 1100;

    public static void enqueueWork(Context context, Intent work) {
        UserIntentService.enqueueWork((Context)context, UserIntentService.class, (int)1100, (Intent)work);
    }

    public void onCreate() {
        super.onCreate();
        this.messageClientService = new MessageClientService(this.getApplicationContext());
        this.mobiComConversationService = new MobiComConversationService(this.getApplicationContext());
    }

    protected void onHandleWork(@NonNull Intent intent) {
        Integer unreadCount = intent.getIntExtra(UNREAD_COUNT, 0);
        boolean singleMessageRead = intent.getBooleanExtra(SINGLE_MESSAGE_READ, false);
        Contact contact = (Contact)intent.getSerializableExtra(CONTACT);
        Channel channel = (Channel)intent.getSerializableExtra(CHANNEL);
        if (unreadCount != 0 || singleMessageRead) {
            this.messageClientService.updateReadStatus(contact, channel);
        } else {
            String userId = intent.getStringExtra(USER_ID);
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                SyncCallService.getInstance((Context)this).processUserStatus(userId);
            } else if (intent.getBooleanExtra(USER_LAST_SEEN_AT_STATUS, false)) {
                this.mobiComConversationService.processLastSeenAtStatus();
            }
        }
    }
}

