/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.List;

public class ConversationIntentService
extends JobIntentService {
    public static final String SYNC = "AL_SYNC";
    private static final String TAG = "ConversationIntent";
    public static final String MESSAGE_METADATA_UPDATE = "MessageMetadataUpdate";
    public static final String MUTED_USER_LIST_SYNC = "MutedUserListSync";
    private static final int PRE_FETCH_MESSAGES_FOR = 6;
    private MobiComMessageService mobiComMessageService;
    static final int JOB_ID = 1000;

    public static void enqueueWork(Context context, Intent work) {
        ConversationIntentService.enqueueWork((Context)context, ConversationIntentService.class, (int)1000, (Intent)work);
    }

    public void onCreate() {
        super.onCreate();
        this.mobiComMessageService = new MobiComMessageService((Context)this, MessageIntentService.class);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        if (intent == null) {
            return;
        }
        boolean sync = intent.getBooleanExtra(SYNC, false);
        boolean metadataSync = intent.getBooleanExtra(MESSAGE_METADATA_UPDATE, false);
        boolean mutedUserListSync = intent.getBooleanExtra(MUTED_USER_LIST_SYNC, false);
        if (mutedUserListSync) {
            Utils.printLog((Context)this, (String)TAG, (String)"Muted user list sync started..");
            new Thread(new MutedUserListSync()).start();
            return;
        }
        if (metadataSync) {
            Utils.printLog((Context)this, (String)TAG, (String)"Syncing messages service started for metadata update");
            this.mobiComMessageService.syncMessageForMetadataUpdate();
            return;
        }
        Utils.printLog((Context)this, (String)TAG, (String)("Syncing messages service started: " + sync));
        if (sync) {
            this.mobiComMessageService.syncMessages();
        } else {
            Thread thread = new Thread(new ConversationSync());
            thread.start();
        }
    }

    private class MutedUserListSync
    implements Runnable {
        private MutedUserListSync() {
        }

        @Override
        public void run() {
            try {
                UserService.getInstance((Context)ConversationIntentService.this).getMutedUserList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ConversationSync
    implements Runnable {
        @Override
        public void run() {
            try {
                MobiComConversationService mobiComConversationService = new MobiComConversationService((Context)ConversationIntentService.this);
                List<Message> messages = mobiComConversationService.getLatestMessagesGroupByPeople();
                UserService.getInstance((Context)ConversationIntentService.this).processSyncUserBlock();
                for (Message message : messages.subList(0, Math.min(6, messages.size()))) {
                    Contact contact = null;
                    Channel channel = null;
                    if (message.getGroupId() != null) {
                        channel = new Channel(message.getGroupId());
                    } else {
                        contact = new Contact(message.getContactIds());
                    }
                    mobiComConversationService.getMessages(1L, null, contact, channel, null, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

