/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.provider.ContactsContract;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.ALContactProcessor;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.contact.ContactUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class DeviceContactService
implements BaseContactService {
    private Context context;

    public DeviceContactService(Context context) {
        this.context = context;
    }

    @Override
    public void add(Contact contact) {
    }

    @Override
    public void addAll(List<Contact> contactList) {
    }

    @Override
    public void deleteContact(Contact contact) {
    }

    @Override
    public void deleteContactById(String contactId) {
    }

    @Override
    public List<Contact> getAll() {
        return null;
    }

    @Override
    public Contact getContactById(String contactId) {
        Contact contact = ContactUtils.getContact((Context)this.context, (String)contactId);
        if (contact != null) {
            contact.processContactNumbers(this.context);
        }
        return contact;
    }

    @Override
    public void updateContact(Contact contact) {
    }

    @Override
    public void upsert(Contact contact) {
    }

    @Override
    public List<Contact> getAllContactListExcludingLoggedInUser() {
        return null;
    }

    @Override
    public Bitmap downloadContactImage(Context context, Contact contact) {
        return null;
    }

    @Override
    public Bitmap downloadGroupImage(Context context, Channel channel) {
        return null;
    }

    @Override
    public Contact getContactReceiver(List<String> items, List<String> userIds) {
        if (items != null && !items.isEmpty()) {
            return ContactUtils.getContact((Context)this.context, (String)items.get(0));
        }
        return null;
    }

    @Override
    public boolean isContactExists(String contactId) {
        return false;
    }

    @Override
    public void updateConnectedStatus(String contactId, Date date, boolean connected) {
    }

    @Override
    public void updateUserBlocked(String userId, boolean userBlocked) {
    }

    @Override
    public void updateUserBlockedBy(String userId, boolean userBlockedBy) {
    }

    @Override
    public boolean isContactPresent(String userId) {
        return false;
    }

    @Override
    public int getChatConversationCount() {
        return 0;
    }

    @Override
    public int getGroupConversationCount() {
        return 0;
    }

    @Override
    public void updateLocalImageUri(Contact contact) {
    }

    @Override
    public List<Contact> getContacts(Contact.ContactType contactType) {
        return null;
    }

    public Contact getContactFromContactCursor(Cursor people) {
        String contactNO = people.getString(people.getColumnIndex("data1"));
        String displayName = people.getString(people.getColumnIndex("display_name"));
        String lookupKey = "lkupkey-" + people.getString(people.getColumnIndex("lookup"));
        if (TextUtils.isEmpty((CharSequence)contactNO) || contactNO.trim().length() <= 8) {
            return null;
        }
        contactNO = contactNO.trim().replace(" ", "").replace("-", "");
        contactNO = contactNO.replaceFirst("^0+(?!$)", "");
        String formattedPhoneNumber = contactNO;
        TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
        String countryCode = telephonyManager.getSimCountryIso().toUpperCase();
        try {
            if (this.context.getApplicationContext() instanceof ALContactProcessor) {
                formattedPhoneNumber = ((ALContactProcessor)this.context.getApplicationContext()).processContact(contactNO, countryCode);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        ContactDatabase contactDatabase = new ContactDatabase(this.context);
        Contact contact = contactDatabase.getContactByPhoneNo(formattedPhoneNumber);
        Contact contactByLookupKey = contactDatabase.getContactById(lookupKey);
        if (contactDatabase.isContactPresent(formattedPhoneNumber, Contact.ContactType.DEVICE_AND_APPLOZIC)) {
            if (!displayName.equals(contact.getPhoneDisplayName())) {
                contactDatabase.updatePhoneContactDisplayName(formattedPhoneNumber, displayName, Contact.ContactType.DEVICE_AND_APPLOZIC.getValue().shortValue());
            }
            return null;
        }
        if (contact != null) {
            lookupKey = contact.getUserId();
        } else if (contactByLookupKey != null) {
            lookupKey = lookupKey + "-" + formattedPhoneNumber;
        }
        Contact newContact = new Contact();
        newContact.setContactNumber(formattedPhoneNumber);
        newContact.setUserId(lookupKey);
        newContact.setDeviceContactType(Contact.ContactType.DEVICE.getValue());
        newContact.setFullName(displayName);
        newContact.setPhoneDisplayName(displayName);
        newContact.processContactNumbers(this.context);
        return newContact;
    }

    public List<String> getModifiedContacts() {
        ArrayList<String> contactIdList = new ArrayList<String>();
        Cursor cursor = this.context.getContentResolver().query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"contact_id"}, "dirty=1", null, null);
        if (cursor != null && cursor.getCount() > 0) {
            while (cursor.moveToNext()) {
                if (TextUtils.isEmpty((CharSequence)cursor.getString(0))) continue;
                contactIdList.add(cursor.getString(0));
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        Utils.printLog((Context)this.context, (String)"DeviceContactService", (String)("Total modified contacts to sync : " + contactIdList.size()));
        return contactIdList;
    }

    public void processModifiedContacts() {
        try {
            HashSet<String> contactNumberList = new HashSet<String>();
            AppContactService appContactService = new AppContactService(this.context);
            for (String contactId : this.getModifiedContacts()) {
                Cursor cursorPhone = this.context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, new String[]{"data1", "display_name", "lookup"}, "contact_id = ? AND data2 = 2", new String[]{contactId}, null);
                if (cursorPhone != null && cursorPhone.getCount() > 0) {
                    while (cursorPhone.moveToNext()) {
                        Contact contact = this.getContactFromContactCursor(cursorPhone);
                        if (contact == null) continue;
                        appContactService.upsert(contact);
                        contactNumberList.add(contact.getFormattedContactNumber());
                    }
                }
                if (cursorPhone == null) continue;
                cursorPhone.close();
            }
            if (contactNumberList != null && contactNumberList.size() > 0) {
                UserService.getInstance(this.context).processUserDetailsByContactNos(contactNumberList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

