/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChannelDatabaseService {
    private static final String TAG = "ChannelDatabaseService";
    private static final String CHANNEL = "channel";
    private static final String CHANNEL_USER_X = "channel_User_X";
    private static ChannelDatabaseService channelDatabaseService;
    private Context context;
    private MobiComUserPreference mobiComUserPreference;
    private MobiComDatabaseHelper dbHelper;

    private ChannelDatabaseService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.mobiComUserPreference = MobiComUserPreference.getInstance(ApplozicService.getContext((Context)context));
        this.dbHelper = MobiComDatabaseHelper.getInstance(ApplozicService.getContext((Context)context));
    }

    public static synchronized ChannelDatabaseService getInstance(Context context) {
        if (channelDatabaseService == null) {
            channelDatabaseService = new ChannelDatabaseService(ApplozicService.getContext((Context)context));
        }
        return channelDatabaseService;
    }

    public static ChannelUserMapper getChannelUser(Cursor cursor) {
        ChannelUserMapper channelUserMapper = new ChannelUserMapper();
        channelUserMapper.setUserKey(cursor.getString(cursor.getColumnIndex("userId")));
        channelUserMapper.setKey(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("channelKey"))));
        channelUserMapper.setUnreadCount((int)cursor.getShort(cursor.getColumnIndex("unreadCount")));
        channelUserMapper.setRole(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("role"))));
        channelUserMapper.setParentKey(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("parentGroupKey"))));
        return channelUserMapper;
    }

    public static List<ChannelUserMapper> getListOfUsers(Cursor cursor) {
        ArrayList<ChannelUserMapper> channelUserMapper = new ArrayList<ChannelUserMapper>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    channelUserMapper.add(ChannelDatabaseService.getChannelUser(cursor));
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return channelUserMapper;
    }

    public void addChannel(Channel channel) {
        try {
            ContentValues contentValues = this.prepareChannelValues(channel);
            this.dbHelper.getWritableDatabase().insertWithOnConflict(CHANNEL, null, contentValues, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public ContentValues prepareChannelValues(Channel channel) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("channelName", channel.getName());
        contentValues.put("channelKey", channel.getKey());
        contentValues.put("clientGroupId", channel.getClientGroupId());
        contentValues.put("type", channel.getType());
        contentValues.put("notificationAfterTime", channel.getNotificationAfterTime());
        contentValues.put("deletedAtTime", channel.getDeletedAtTime());
        contentValues.put("adminId", channel.getAdminKey());
        Channel oldChannel = null;
        if (!TextUtils.isEmpty((CharSequence)channel.getImageUrl())) {
            contentValues.put("channelImageURL", channel.getImageUrl());
            oldChannel = ChannelDatabaseService.getInstance(this.context).getChannelByChannelKey(channel.getKey());
        }
        if (channel.getKmStatus() != 0) {
            contentValues.put("kmStatus", Integer.valueOf(channel.getKmStatus()));
        }
        if (!(oldChannel == null || TextUtils.isEmpty((CharSequence)channel.getImageUrl()) || TextUtils.isEmpty((CharSequence)oldChannel.getImageUrl()) || channel.getImageUrl().equals(oldChannel.getImageUrl()))) {
            this.updateChannelLocalImageURI(channel.getKey(), null);
        }
        if (!TextUtils.isEmpty((CharSequence)channel.getLocalImageUri())) {
            contentValues.put("channelImageLocalURI", channel.getLocalImageUri());
        }
        if (channel.getUserCount() != 0) {
            contentValues.put("userCount", Integer.valueOf(channel.getUserCount()));
        }
        if (channel.getUnreadCount() != 0) {
            contentValues.put("unreadCount", Integer.valueOf(channel.getUnreadCount()));
        }
        if (channel.getMetadata() != null) {
            contentValues.put("channelMetadata", GsonUtils.getJsonFromObject((Object)channel.getMetadata(), Map.class));
            if (channel.getMetadata().containsKey("AL_CATEGORY")) {
                contentValues.put("AL_CATEGORY", (String)channel.getMetadata().get("AL_CATEGORY"));
            }
        }
        contentValues.put("parentGroupKey", channel.getParentKey());
        contentValues.put("parentClientGroupId", channel.getParentClientGroupId());
        return contentValues;
    }

    public void addChannelUserMapper(ChannelUserMapper channelUserMapper) {
        try {
            ContentValues contentValues = this.prepareChannelUserMapperValues(channelUserMapper);
            this.dbHelper.getWritableDatabase().insertWithOnConflict(CHANNEL_USER_X, null, contentValues, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public ContentValues prepareChannelUserMapperValues(ChannelUserMapper channelUserMapper) {
        ContentValues contentValues = new ContentValues();
        if (channelUserMapper != null) {
            if (channelUserMapper.getKey() != null) {
                contentValues.put("channelKey", channelUserMapper.getKey());
            }
            if (channelUserMapper.getUserKey() != null) {
                contentValues.put("userId", channelUserMapper.getUserKey());
            }
            if (channelUserMapper.getUserKey() != null) {
                contentValues.put("unreadCount", Integer.valueOf(channelUserMapper.getUnreadCount()));
            }
            if (channelUserMapper.getStatus() != 0) {
                contentValues.put("status", Short.valueOf(channelUserMapper.getStatus()));
            }
            contentValues.put("role", channelUserMapper.getRole());
            if (channelUserMapper.getParentKey() != null) {
                contentValues.put("parentGroupKey", channelUserMapper.getParentKey());
            }
        }
        return contentValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannelByClientGroupId(String clientGroupId) {
        Channel channel = null;
        try {
            String structuredNameWhere = "clientGroupId =?";
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = db.query(CHANNEL, null, structuredNameWhere, new String[]{String.valueOf(clientGroupId)}, null, null, null);
            try {
                if (cursor != null && cursor.getCount() > 0) {
                    cursor.moveToFirst();
                    channel = this.getChannel(cursor);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                this.dbHelper.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannelByChannelKey(Integer channelKey) {
        Channel channel = null;
        try {
            String structuredNameWhere = "channelKey =?";
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = db.query(CHANNEL, null, structuredNameWhere, new String[]{String.valueOf(channelKey)}, null, null, null);
            try {
                if (cursor != null && cursor.getCount() > 0) {
                    cursor.moveToFirst();
                    channel = this.getChannel(cursor);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                this.dbHelper.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelUserMapper> getChannelUserList(Integer channelKey) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String structuredNameWhere = "";
            structuredNameWhere = structuredNameWhere + "channelKey = ?";
            cursor = db.query(CHANNEL_USER_X, null, structuredNameWhere, new String[]{String.valueOf(channelKey)}, null, null, null);
            List<ChannelUserMapper> list = ChannelDatabaseService.getListOfUsers(cursor);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return null;
    }

    public Channel getChannel(Cursor cursor) {
        Channel channel = new Channel();
        channel.setKey(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("channelKey"))));
        channel.setParentClientGroupId(cursor.getString(cursor.getColumnIndex("parentClientGroupId")));
        channel.setClientGroupId(cursor.getString(cursor.getColumnIndex("clientGroupId")));
        channel.setName(cursor.getString(cursor.getColumnIndex("channelName")));
        channel.setAdminKey(cursor.getString(cursor.getColumnIndex("adminId")));
        channel.setType(Short.valueOf(cursor.getShort(cursor.getColumnIndex("type"))));
        channel.setImageUrl(cursor.getString(cursor.getColumnIndex("channelImageURL")));
        channel.setLocalImageUri(cursor.getString(cursor.getColumnIndex("channelImageLocalURI")));
        int count = cursor.getInt(cursor.getColumnIndex("unreadCount"));
        channel.setNotificationAfterTime(Long.valueOf(cursor.getLong(cursor.getColumnIndex("notificationAfterTime"))));
        channel.setDeletedAtTime(Long.valueOf(cursor.getLong(cursor.getColumnIndex("deletedAtTime"))));
        channel.setParentKey(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("parentGroupKey"))));
        channel.setKmStatus(cursor.getInt(cursor.getColumnIndex("kmStatus")));
        String metadata = cursor.getString(cursor.getColumnIndex("channelMetadata"));
        channel.setMetadata((Map)GsonUtils.getObjectFromJson((String)metadata, Map.class));
        if (count > 0) {
            channel.setUnreadCount(count);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Channel> getAllChannels() {
        List<Channel> contactList = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            cursor = db.query(CHANNEL, null, null, null, null, null, "channelName asc");
            contactList = this.getChannelList(cursor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return contactList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Channel> getChannelList(Cursor cursor) {
        try {
            ArrayList<Channel> channelList = new ArrayList<Channel>();
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    channelList.add(this.getChannel(cursor));
                } while (cursor.moveToNext());
            }
            ArrayList<Channel> arrayList = channelList;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void updateChannel(Channel channel) {
        ContentValues contentValues = this.prepareChannelValues(channel);
        this.dbHelper.getWritableDatabase().update(CHANNEL, contentValues, "channelKey=?", new String[]{String.valueOf(channel.getKey())});
        this.dbHelper.close();
    }

    public void updateNotificationAfterTime(Integer id, Long notificationAfterTime) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("notificationAfterTime", notificationAfterTime);
        this.dbHelper.getWritableDatabase().update(CHANNEL, contentValues, "channelKey=?", new String[]{String.valueOf(id)});
    }

    public void updateChannelUserMapper(ChannelUserMapper channelUserMapper) {
        ContentValues contentValues = this.prepareChannelUserMapperValues(channelUserMapper);
        this.dbHelper.getWritableDatabase().update(CHANNEL_USER_X, contentValues, "channelKey=?  and userId=?", new String[]{String.valueOf(channelUserMapper.getKey()), String.valueOf(channelUserMapper.getUserKey())});
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChannelPresent(Integer channelKey) {
        Cursor cursor = null;
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.rawQuery("SELECT COUNT(*) FROM channel WHERE channelKey=?", new String[]{String.valueOf(channelKey)});
            cursor.moveToFirst();
            boolean bl = cursor.getInt(0) > 0;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    public void updateChannelLocalImageURI(Integer channelKey, String channelLocalURI) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("channelImageLocalURI", channelLocalURI);
        this.dbHelper.getWritableDatabase().update(CHANNEL, contentValues, "channelKey=?", new String[]{String.valueOf(channelKey)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChannelUserPresent(Integer channelKey, String userId) {
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        Cursor cursor = null;
        boolean present = false;
        try {
            cursor = database.rawQuery("SELECT COUNT(*) FROM channel_User_X WHERE channelKey=? and userId=?", new String[]{String.valueOf(channelKey), String.valueOf(userId)});
            cursor.moveToFirst();
            present = cursor.getInt(0) > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return present;
    }

    public int removeMemberFromChannel(String clientGroupId, String userId) {
        Channel channel = this.getChannelByClientGroupId(clientGroupId);
        return this.removeMemberFromChannel(channel.getKey(), userId);
    }

    public int removeMemberFromChannel(Integer channelKey, String userId) {
        int deleteUser = 0;
        try {
            deleteUser = this.dbHelper.getWritableDatabase().delete(CHANNEL_USER_X, "channelKey=? AND userId= ?", new String[]{String.valueOf(channelKey), userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deleteUser;
    }

    public int leaveMemberFromChannel(String clientGroupId, String userId) {
        Channel channel = this.getChannelByClientGroupId(clientGroupId);
        return this.leaveMemberFromChannel(channel.getKey(), userId);
    }

    public int leaveMemberFromChannel(Integer channelKey, String userId) {
        int deletedRows = 0;
        try {
            deletedRows = this.dbHelper.getWritableDatabase().delete(CHANNEL_USER_X, "channelKey=? AND userId= ?", new String[]{String.valueOf(channelKey), userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletedRows;
    }

    public int updateChannel(GroupInfoUpdate groupInfoUpdate) {
        if (groupInfoUpdate.getImageUrl() == null && groupInfoUpdate.getNewName() == null) {
            return 0;
        }
        int rowUpdated = 0;
        try {
            ContentValues values = new ContentValues();
            if (groupInfoUpdate != null) {
                if (!TextUtils.isEmpty((CharSequence)groupInfoUpdate.getClientGroupId())) {
                    Channel channel = this.getChannelByClientGroupId(groupInfoUpdate.getClientGroupId());
                    groupInfoUpdate.setGroupId(channel.getKey());
                }
                if (groupInfoUpdate.getNewName() != null) {
                    values.put("channelName", groupInfoUpdate.getNewName());
                }
                if (groupInfoUpdate.getImageUrl() != null) {
                    values.put("channelImageURL", groupInfoUpdate.getImageUrl());
                    values.putNull("channelImageLocalURI");
                }
            }
            rowUpdated = this.dbHelper.getWritableDatabase().update(CHANNEL, values, "channelKey=" + groupInfoUpdate.getGroupId(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowUpdated;
    }

    public int deleteChannel(Integer channelKey) {
        int deletedRows = 0;
        try {
            deletedRows = this.dbHelper.getWritableDatabase().delete(CHANNEL, "channelKey=?", new String[]{String.valueOf(channelKey)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletedRows;
    }

    public int deleteChannelUserMappers(Integer channelKey) {
        int deletedRows = 0;
        try {
            deletedRows = this.dbHelper.getWritableDatabase().delete(CHANNEL_USER_X, "channelKey=?", new String[]{String.valueOf(channelKey)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deletedRows;
    }

    public Loader<Cursor> getSearchCursorForGroupsLoader(final String searchString) {
        return new CursorLoader(this.context, null, null, null, null, "channelName asc"){

            public Cursor loadInBackground() {
                SQLiteDatabase db = ChannelDatabaseService.this.dbHelper.getReadableDatabase();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ").append(" * ").append(" FROM ").append(ChannelDatabaseService.CHANNEL).append(" where ").append("type").append(" NOT IN ('").append(Channel.GroupType.CONTACT_GROUP.getValue()).append("')");
                if (!TextUtils.isEmpty((CharSequence)searchString)) {
                    stringBuffer.append(" AND channelName like '%" + searchString.replaceAll("'", "''") + "%'");
                }
                stringBuffer.append(" order by channelName COLLATE NOCASE asc ");
                Cursor cursor = db.rawQuery(stringBuffer.toString(), null);
                return cursor;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupOfTwoReceiverId(Integer channelKey) {
        Cursor cursor = null;
        try {
            ChannelUserMapper channelUserMapper;
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String structuredNameWhere = "";
            structuredNameWhere = structuredNameWhere + "channelKey = ? AND userId NOT IN ('" + MobiComUserPreference.getInstance(this.context).getUserId().replaceAll("'", "''") + "')";
            cursor = db.query(CHANNEL_USER_X, null, structuredNameWhere, new String[]{String.valueOf(channelKey)}, null, null, null);
            List<ChannelUserMapper> channelUserMappers = ChannelDatabaseService.getListOfUsers(cursor);
            if (channelUserMappers != null && channelUserMappers.size() > 0 && (channelUserMapper = channelUserMappers.get(0)) != null) {
                String string = channelUserMapper.getUserKey();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getChannelMemberByName(String name, String type) {
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        ArrayList<String> userIds = new ArrayList<String>();
        Cursor cursor = database.rawQuery("Select cu.userId from channel c JOIN channel_User_X cu on c.channelKey = cu.channelKey where c.channelName ='" + name + "' AND c.type ='" + type + "'", null);
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    userIds.add(cursor.getString(cursor.getColumnIndex("userId")));
                } while (cursor.moveToNext());
            }
            if (userIds.contains(MobiComUserPreference.getInstance(this.context).getUserId())) {
                userIds.remove(MobiComUserPreference.getInstance(this.context).getUserId());
            }
            if (userIds != null && userIds.size() > 0) {
                String[] stringArray = userIds.toArray(new String[userIds.size()]);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    public void updateRoleInChannelUserMapper(Integer channelKey, String userId, Integer role) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("role", role);
        this.dbHelper.getWritableDatabase().update(CHANNEL_USER_X, contentValues, "channelKey=? AND userId=?", new String[]{String.valueOf(channelKey), userId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelUserMapper getChannelUserByChannelKey(Integer channelKey) {
        ChannelUserMapper channelUserMapper = null;
        Cursor cursor = null;
        try {
            String structuredNameWhere = "channelKey =? AND userId=" + MobiComUserPreference.getInstance(this.context).getUserId();
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(CHANNEL_USER_X, null, structuredNameWhere, new String[]{String.valueOf(channelKey)}, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                channelUserMapper = ChannelDatabaseService.getChannelUser(cursor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return channelUserMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelUserMapper getChannelUserByChannelKeyAndUserId(Integer channelKey, String userId) {
        ChannelUserMapper channelUserMapper = null;
        Cursor cursor = null;
        try {
            String structuredNameWhere = "channelKey =? AND userId =?";
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(CHANNEL_USER_X, null, structuredNameWhere, new String[]{String.valueOf(channelKey), userId}, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                channelUserMapper = ChannelDatabaseService.getChannelUser(cursor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return channelUserMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildGroupIds(Integer parentGroupKey) {
        if (parentGroupKey == null || parentGroupKey == 0) {
            return new ArrayList<String>();
        }
        Cursor cursor = null;
        try {
            ArrayList<String> childGroupIds = new ArrayList<String>();
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String structuredNameWhere = "";
            structuredNameWhere = structuredNameWhere + "parentGroupKey = ?";
            cursor = db.query(CHANNEL, null, structuredNameWhere, new String[]{String.valueOf(parentGroupKey)}, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    childGroupIds.add(String.valueOf(cursor.getInt(cursor.getColumnIndex("channelKey"))));
                } while (cursor.moveToNext());
            }
            ArrayList<String> arrayList = childGroupIds;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return null;
    }

    public void updateParentGroupKeyInUserMapper(Integer channelKey, Integer parentGroupKey) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("parentGroupKey", parentGroupKey);
        this.dbHelper.getWritableDatabase().update(CHANNEL_USER_X, contentValues, "channelKey=?", new String[]{String.valueOf(channelKey)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getParentGroupKey(String parentClientGroupId) {
        if (TextUtils.isEmpty((CharSequence)parentClientGroupId)) {
            return null;
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String structuredNameWhere = "";
            structuredNameWhere = structuredNameWhere + "parentClientGroupId = ?";
            cursor = db.query(CHANNEL, null, structuredNameWhere, new String[]{String.valueOf(parentClientGroupId)}, null, null, null);
            if (cursor.moveToFirst()) {
                Integer n = cursor.getInt(cursor.getColumnIndex("parentGroupKey"));
                return n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return null;
    }
}

