/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.contact.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ContactDatabase {
    public static final String CONTACT = "contact";
    private static final String TAG = "ContactDatabaseService";
    private Context context = null;
    private MobiComUserPreference userPreferences;
    private MobiComDatabaseHelper dbHelper;

    public ContactDatabase(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.userPreferences = MobiComUserPreference.getInstance(ApplozicService.getContext((Context)context));
        this.dbHelper = MobiComDatabaseHelper.getInstance(ApplozicService.getContext((Context)context));
    }

    public Contact getContact(Cursor cursor) {
        return this.getContact(cursor, null);
    }

    public Contact getContact(Cursor cursor, String primaryKeyAliash) {
        Contact contact = new Contact();
        try {
            contact.setFullName(cursor.getString(cursor.getColumnIndex("fullName")));
            contact.setUserId(cursor.getString(cursor.getColumnIndex(primaryKeyAliash == null ? "userId" : primaryKeyAliash)));
            contact.setLocalImageUrl(cursor.getString(cursor.getColumnIndex("contactImageLocalURI")));
            contact.setImageURL(cursor.getString(cursor.getColumnIndex("contactImageURL")));
            contact.setContactNumber(cursor.getString(cursor.getColumnIndex("contactNO")));
            contact.setApplicationId(cursor.getString(cursor.getColumnIndex("applicationId")));
            Long connected = cursor.getLong(cursor.getColumnIndex("connected"));
            contact.setContactType(cursor.getShort(cursor.getColumnIndex("contactType")));
            contact.setConnected(connected != 0L && connected.intValue() == 1);
            contact.setLastSeenAt(Long.valueOf(cursor.getLong(cursor.getColumnIndex("lastSeenAt"))));
            contact.setUnreadCount(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("unreadCount"))));
            Boolean userBlocked = cursor.getInt(cursor.getColumnIndex("blocked")) == 1;
            contact.setBlocked(userBlocked.booleanValue());
            Boolean userBlockedBy = cursor.getInt(cursor.getColumnIndex("blockedBy")) == 1;
            contact.setBlockedBy(userBlockedBy.booleanValue());
            contact.setEmailId(cursor.getString(cursor.getColumnIndex("email")));
            contact.setStatus(cursor.getString(cursor.getColumnIndex("status")));
            contact.setUserTypeId(Short.valueOf(cursor.getShort(cursor.getColumnIndex("userTypeId"))));
            contact.setDeletedAtTime(Long.valueOf(cursor.getLong(cursor.getColumnIndex("deletedAtTime"))));
            contact.setNotificationAfterTime(Long.valueOf(cursor.getLong(cursor.getColumnIndex("notificationAfterTime"))));
            contact.setRoleType(Short.valueOf(cursor.getShort(cursor.getColumnIndex("userRoleType"))));
            contact.setLastMessageAtTime(Long.valueOf(cursor.getLong(cursor.getColumnIndex("lastMessagedAt"))));
            String metadata = cursor.getString(cursor.getColumnIndex("userMetadata"));
            if (!TextUtils.isEmpty((CharSequence)metadata)) {
                contact.setMetadata((Map)GsonUtils.getObjectFromJson((String)metadata, Map.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contact;
    }

    public List<Contact> getContactList(Cursor cursor) {
        ArrayList<Contact> smsList = new ArrayList<Contact>();
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            do {
                smsList.add(this.getContact(cursor));
            } while (cursor.moveToNext());
        }
        return smsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Contact> getAllContactListExcludingLoggedInUser() {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        if (TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(this.context).getUserId())) {
            return new ArrayList<Contact>();
        }
        String structuredNameWhere = "userId != ?";
        Cursor cursor = null;
        try {
            cursor = db.query(CONTACT, null, structuredNameWhere, new String[]{MobiComUserPreference.getInstance(this.context).getUserId()}, null, null, "fullName asc");
            List<Contact> list = this.getContactList(cursor);
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Contact> getAllContact() {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(CONTACT, null, null, null, null, null, "fullName asc");
            List<Contact> list = this.getContactList(cursor);
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getContactById(String id) {
        Cursor cursor = null;
        try {
            if (TextUtils.isEmpty((CharSequence)id)) {
                Contact contact = null;
                return contact;
            }
            String structuredNameWhere = "userId =?";
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.query(CONTACT, null, structuredNameWhere, new String[]{id}, null, null, null);
            Contact contact = null;
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                contact = this.getContact(cursor);
            }
            Contact contact2 = contact;
            return contact2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return null;
    }

    public void updateContact(Contact contact) {
        ContentValues contentValues = this.prepareContactValues(contact, true);
        this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{contact.getUserId()});
        this.dbHelper.close();
    }

    public void updateLocalImageUri(Contact contact) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("contactImageLocalURI", contact.getLocalImageUrl());
        this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{contact.getUserId()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectedOrDisconnectedStatus(String userId, Date date, boolean connected) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("connected", Integer.valueOf(connected ? 1 : 0));
        contentValues.put("lastSeenAt", Long.valueOf(date.getTime()));
        try {
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastSeenTimeAt(String userId, long lastSeenTime) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("lastSeenAt", Long.valueOf(lastSeenTime));
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserBlockStatus(String userId, boolean userBlocked) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("blocked", Integer.valueOf(userBlocked ? 1 : 0));
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserBlockByStatus(String userId, boolean userBlockedBy) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("blockedBy", Integer.valueOf(userBlockedBy ? 1 : 0));
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public void addContact(Contact contact) {
        try {
            ContentValues contentValues = this.prepareContactValues(contact, false);
            this.dbHelper.getWritableDatabase().insert(CONTACT, null, contentValues);
        }
        catch (Exception e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Ignoring duplicate entry for contact");
        }
        finally {
            this.dbHelper.close();
        }
    }

    public ContentValues prepareContactValues(Contact contact, boolean isContactUpdated) {
        Map<String, String> metadata;
        ContentValues contentValues = new ContentValues();
        Contact contactImage = null;
        contentValues.put("fullName", this.getFullNameForUpdate(contact));
        if (!TextUtils.isEmpty((CharSequence)contact.getContactNumber())) {
            contentValues.put("contactNO", contact.getContactNumber());
        }
        if (!TextUtils.isEmpty((CharSequence)contact.getImageURL())) {
            contentValues.put("contactImageURL", contact.getImageURL());
            contactImage = this.getContactById(contact.getUserId());
        }
        if (!(contactImage == null || TextUtils.isEmpty((CharSequence)contactImage.getImageURL()) || TextUtils.isEmpty((CharSequence)contact.getImageURL()) || contact.getImageURL().equals(contactImage.getImageURL()))) {
            this.updateContactLocalImageURIToNull(contact.getUserId());
        }
        if (!TextUtils.isEmpty((CharSequence)contact.getLocalImageUrl())) {
            contentValues.put("contactImageLocalURI", contact.getLocalImageUrl());
        }
        contentValues.put("userId", contact.getUserId());
        if (!TextUtils.isEmpty((CharSequence)contact.getEmailId())) {
            contentValues.put("email", contact.getEmailId());
        }
        if (!TextUtils.isEmpty((CharSequence)contact.getApplicationId())) {
            contentValues.put("applicationId", contact.getApplicationId());
        }
        contentValues.put("connected", Integer.valueOf(contact.isConnected() ? 1 : 0));
        if (contact.getLastSeenAt() != 0L) {
            contentValues.put("lastSeenAt", Long.valueOf(contact.getLastSeenAt()));
        }
        if (contact.getUnreadCount() != null && contact.getUnreadCount() != 0) {
            contentValues.put("unreadCount", contact.getUnreadCount());
        }
        contentValues.put("status", contact.getStatus());
        if (contact.isBlocked()) {
            contentValues.put("blocked", Boolean.valueOf(contact.isBlocked()));
        }
        if (contact.isBlockedBy()) {
            contentValues.put("blockedBy", Boolean.valueOf(contact.isBlockedBy()));
        }
        if (contact.getContactType() != 0) {
            contentValues.put("contactType", Short.valueOf(contact.getContactType()));
        }
        if (contact.getNotificationAfterTime() != null && contact.getNotificationAfterTime() != 0L) {
            contentValues.put("notificationAfterTime", contact.getNotificationAfterTime());
        }
        if ((metadata = this.getUpdatedMetadata(contact, isContactUpdated)) != null && !metadata.isEmpty()) {
            contentValues.put("userMetadata", GsonUtils.getJsonFromObject(metadata, Map.class));
        }
        contentValues.put("userRoleType", contact.getRoleType());
        contentValues.put("lastMessagedAt", contact.getLastMessageAtTime());
        contentValues.put("userTypeId", contact.getUserTypeId());
        if (contact.getDeletedAtTime() != null && contact.getDeletedAtTime() != 0L) {
            contentValues.put("deletedAtTime", contact.getDeletedAtTime());
        }
        return contentValues;
    }

    private Map<String, String> getUpdatedMetadata(Contact contact, boolean isContactUpdate) {
        Map metadata = contact.getMetadata();
        if (isContactUpdate) {
            String flag;
            if (metadata != null && !metadata.isEmpty() && metadata.containsKey("AL_DISPLAY_NAME_UPDATED")) {
                return metadata;
            }
            Contact existingContact = this.getContactById(contact.getUserId());
            Map existingMetadata = existingContact.getMetadata();
            if (metadata != null && existingMetadata != null && !existingMetadata.isEmpty() && existingMetadata.containsKey("AL_DISPLAY_NAME_UPDATED") && !TextUtils.isEmpty((CharSequence)(flag = (String)existingMetadata.get("AL_DISPLAY_NAME_UPDATED")))) {
                metadata.put("AL_DISPLAY_NAME_UPDATED", flag);
            }
        }
        return metadata;
    }

    private String getFullNameForUpdate(Contact contact) {
        Contact contactFromDB;
        String fullName = contact.getDisplayName();
        if (TextUtils.isEmpty((CharSequence)contact.getFullName()) && (contactFromDB = this.getContactById(contact.getUserId())) != null) {
            fullName = contactFromDB.getFullName();
        }
        return fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContactPresent(String userId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.rawQuery("SELECT COUNT(*) FROM contact WHERE userId = ?", new String[]{userId});
            cursor.moveToFirst();
            boolean bl = cursor.getInt(0) > 0;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    public void addAllContact(List<Contact> contactList) {
        for (Contact contact : contactList) {
            this.addContact(contact);
        }
    }

    public void deleteContact(Contact contact) {
        this.deleteContactById(contact.getUserId());
    }

    public void deleteContactById(String id) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete(CONTACT, "userId=?", new String[]{id});
        this.dbHelper.close();
    }

    public void deleteAllContact(List<Contact> contacts) {
        for (Contact contact : contacts) {
            this.deleteContact(contact);
        }
    }

    public void updateNotificationAfterTime(String userId, Long notificationAfterTime) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("notificationAfterTime", notificationAfterTime);
        this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChatUnreadCount() {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT COUNT(DISTINCT (userId)) FROM contact WHERE unreadCount > 0 ", null);
            cursor.moveToFirst();
            int chatCount = 0;
            if (cursor.getCount() > 0) {
                chatCount = cursor.getInt(0);
            }
            int n = chatCount;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupUnreadCount() {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT COUNT(DISTINCT (channelKey)) FROM channel WHERE unreadCount > 0 ", null);
            cursor.moveToFirst();
            int groupCount = 0;
            if (cursor.getCount() > 0) {
                groupCount = cursor.getInt(0);
            }
            int n = groupCount;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return 0;
    }

    public Loader<Cursor> getSearchCursorLoader(String searchString, String[] userIdArray) {
        return this.getSearchCursorLoader(searchString, userIdArray, null);
    }

    public Loader<Cursor> getSearchCursorLoader(final String searchString, final String[] userIdArray, final Integer parentGroupKey) {
        return new CursorLoader(this.context, null, null, null, null, "displayName asc"){

            public Cursor loadInBackground() {
                Cursor cursor;
                if (TextUtils.isEmpty((CharSequence)ContactDatabase.this.userPreferences.getUserId())) {
                    return null;
                }
                SQLiteDatabase db = ContactDatabase.this.dbHelper.getReadableDatabase();
                String query = null;
                if (parentGroupKey != null && parentGroupKey != 0) {
                    query = "Select DISTINCT(c.userId) as _id,c.fullName,c.contactNO,c.displayName,c.contactImageURL,c.contactImageLocalURI,c.email,c.applicationId,c.connected,c.lastSeenAt,c.unreadCount,c.blocked,c.blockedBy,c.status,c.contactType,c.userTypeId,c.deletedAtTime,c.notificationAfterTime,c.userRoleType,c.lastMessagedAt,c.userMetadata from contact c join channel_User_X cux on cux.userId = c.userId where ( cux.channelKey = '" + parentGroupKey + "' OR cux.parentGroupKey = '" + parentGroupKey + "' ) AND c.userId NOT IN ('" + ContactDatabase.this.userPreferences.getUserId().replaceAll("'", "''") + "')";
                    if (!TextUtils.isEmpty((CharSequence)searchString)) {
                        query = query + " AND c.fullName like '%" + searchString.replaceAll("'", "''") + "%'";
                    }
                    query = query + " order by c.fullName,c.userId asc ";
                    cursor = db.rawQuery(query, null);
                } else {
                    query = "select userId as _id, fullName, contactNO, displayName,contactImageURL,contactImageLocalURI,email,applicationId,connected,lastSeenAt,unreadCount,blocked,blockedBy,status,contactType,userTypeId,deletedAtTime,notificationAfterTime,userRoleType,userMetadata,lastMessagedAt from contact where deletedAtTime=0 ";
                    if (userIdArray != null && userIdArray.length > 0) {
                        String placeHolderString = Utils.makePlaceHolders((int)userIdArray.length);
                        query = !TextUtils.isEmpty((CharSequence)searchString) ? query + " and fullName like '%" + searchString.replaceAll("'", "''") + "%' and  userId  IN (" + placeHolderString + ")" : query + " and userId IN (" + placeHolderString + ")";
                        query = query + " order by connected desc,lastSeenAt desc ";
                        cursor = db.rawQuery(query, userIdArray);
                    } else {
                        query = ApplozicClient.getInstance(ContactDatabase.this.context).isShowMyContacts() ? (!TextUtils.isEmpty((CharSequence)searchString) ? query + " and fullName like '%" + searchString.replaceAll("'", "''") + "%' AND contactType != 0 AND userId NOT IN ('" + ContactDatabase.this.userPreferences.getUserId().replaceAll("'", "''") + "')" : query + " and contactType != 0 AND userId != '" + ContactDatabase.this.userPreferences.getUserId() + "'") : (!TextUtils.isEmpty((CharSequence)searchString) ? query + " and fullName like '%" + searchString.replaceAll("'", "''") + "%' AND userId NOT IN ('" + ContactDatabase.this.userPreferences.getUserId().replaceAll("'", "''") + "')" : query + " and userId != '" + ContactDatabase.this.userPreferences.getUserId() + "'");
                        query = query + " order by fullName COLLATE NOCASE,userId COLLATE NOCASE asc ";
                        cursor = db.rawQuery(query, null);
                    }
                }
                return cursor;
            }
        };
    }

    public void updateContactLocalImageURIToNull(String userId) {
        ContentValues contentValues = new ContentValues();
        contentValues.putNull("contactImageLocalURI");
        this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{userId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Contact> getContacts(Contact.ContactType contactType) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String structuredNameWhere = "contactType = ?";
            cursor = db.query(CONTACT, null, structuredNameWhere, new String[]{String.valueOf(contactType.getValue())}, null, null, "fullName asc");
            List<Contact> list = this.getContactList(cursor);
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    public void saveOrUpdate(Contact contact) {
        Contact existingContact = this.getContactById(contact.getUserId());
        if (existingContact == null) {
            this.addContact(contact);
        } else {
            this.updateContact(contact);
        }
    }

    public void updateMetadataKeyValueForUserId(String userId, String key, String value) {
        Map metadata;
        Contact contact = this.getContactById(userId);
        if (contact != null && (metadata = contact.getMetadata()) != null && !metadata.isEmpty()) {
            metadata.put(key, value);
            ContentValues contentValues = new ContentValues();
            contentValues.put("userMetadata", GsonUtils.getJsonFromObject((Object)metadata, Map.class));
            this.dbHelper.getWritableDatabase().update(CONTACT, contentValues, "userId=?", new String[]{contact.getUserId()});
        }
    }
}

