/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.AlJobIntentService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class ApplozicIntentService
extends AlJobIntentService {
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    private static final String TAG = "ApplozicIntentService";
    private MessageClientService messageClientService;
    public static final String AL_SYNC_ON_CONNECTIVITY = "AL_SYNC_ON_CONNECTIVITY";
    public static final String AL_TIME_CHANGE_RECEIVER = "AL_TIME_CHANGE_RECEIVER";
    MobiComConversationService conversationService;
    static final int JOB_ID = 1010;

    public static void enqueueWork(Context context, Intent work) {
        ApplozicIntentService.enqueueWork((Context)ApplozicService.getContext((Context)context), ApplozicIntentService.class, (int)1010, (Intent)work);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.messageClientService = new MessageClientService((Context)this);
        this.conversationService = new MobiComConversationService((Context)this);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        boolean connectivityChange = intent.getBooleanExtra(AL_SYNC_ON_CONNECTIVITY, false);
        boolean timeChangeReceiver = intent.getBooleanExtra(AL_TIME_CHANGE_RECEIVER, false);
        if (connectivityChange) {
            SyncCallService.getInstance((Context)this).syncMessages(null);
            this.messageClientService.syncPendingMessages(true);
            this.messageClientService.syncDeleteMessages(true);
            this.conversationService.processLastSeenAtStatus();
            UserService.getInstance((Context)this).processSyncUserBlock();
        }
        if (timeChangeReceiver) {
            Utils.printLog((Context)this, (String)"TimeChange", (String)"This service has been called on date change");
            long diff = DateUtils.getTimeDiffFromUtc();
            MobiComUserPreference.getInstance((Context)this).setDeviceTimeOffset(diff);
        }
    }
}

