/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit;

import android.content.Context;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.List;

public class ConversationRunnables {
    Context context;
    private static final int PRE_FETCH_MESSAGES_FOR = 6;
    private boolean isMutedList;
    private boolean isSync;
    private boolean isMessageMetadataSync;
    private static String TAG = "ConversationSyncThread";
    private MobiComMessageService mobiComMessageService;
    private Message message;

    public ConversationRunnables(Context context, Message message, boolean isMutedList, boolean isSync, boolean isMessageMetadataSync) {
        this.context = context;
        this.isSync = isSync;
        this.isMutedList = isMutedList;
        this.isMessageMetadataSync = isMessageMetadataSync;
        this.message = message;
        this.mobiComMessageService = new MobiComMessageService(context, MessageIntentService.class);
        this.startSync();
    }

    public void startSync() {
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (ConversationRunnables.this.isMutedList) {
                    Utils.printLog((Context)ConversationRunnables.this.context, (String)TAG, (String)"Muted user list sync started from thread..");
                    try {
                        UserService.getInstance(ConversationRunnables.this.context).getMutedUserList();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (ConversationRunnables.this.isMessageMetadataSync) {
                    Utils.printLog((Context)ConversationRunnables.this.context, (String)TAG, (String)"Syncing messages service started for metadata update from thread");
                    ConversationRunnables.this.mobiComMessageService.syncMessageForMetadataUpdate();
                    return;
                }
                Utils.printLog((Context)ConversationRunnables.this.context, (String)TAG, (String)("Syncing messages service started from thread: " + ConversationRunnables.this.isSync));
                if (ConversationRunnables.this.message != null) {
                    ConversationRunnables.this.mobiComMessageService.processInstantMessage(ConversationRunnables.this.message);
                } else if (ConversationRunnables.this.isSync) {
                    ConversationRunnables.this.mobiComMessageService.syncMessages();
                } else {
                    ConversationRunnables.this.syncConversation();
                }
            }
        });
        syncThread.setPriority(10);
        syncThread.start();
    }

    private void syncConversation() {
        try {
            MobiComConversationService mobiComConversationService = new MobiComConversationService(this.context);
            List<Message> messages = mobiComConversationService.getLatestMessagesGroupByPeople();
            UserService.getInstance(this.context).processSyncUserBlock();
            for (Message message : messages.subList(0, Math.min(6, messages.size()))) {
                Contact contact = null;
                Channel channel = null;
                if (message.getGroupId() != null) {
                    channel = new Channel(message.getGroupId());
                } else {
                    contact = new Contact(message.getContactIds());
                }
                mobiComConversationService.getMessages(1L, null, contact, channel, null, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

