/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.register;

import android.text.TextUtils;
import com.applozic.mobicommons.json.JsonMarker;

public class RegistrationResponse
extends JsonMarker {
    private String message;
    private String deviceKey;
    private String userKey;
    private String userId;
    private String contactNumber;
    private Long lastSyncTime;
    private Long currentTimeStamp;
    private String displayName;
    private String notificationResponse;
    private String brokerUrl;
    private String imageLink;
    private String statusMessage;
    private String encryptionKey;
    private String userEncryptionKey;
    private boolean enableEncryption;
    private Short roleType;
    private Short pricingPackage = PricingType.STARTER.getValue();

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDeviceKey() {
        return this.deviceKey;
    }

    public void setDeviceKey(String deviceKeyString) {
        this.deviceKey = deviceKeyString;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String suUserKeyString) {
        this.userKey = suUserKeyString;
    }

    public String getContactNumber() {
        return this.contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public Long getLastSyncTime() {
        return this.lastSyncTime == null ? 0L : this.lastSyncTime;
    }

    public void setLastSyncTime(Long lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public Long getCurrentTimeStamp() {
        return this.currentTimeStamp == null ? 0L : this.currentTimeStamp;
    }

    public void setCurrentTimeStamp(Long currentTimeStamp) {
        this.currentTimeStamp = currentTimeStamp;
    }

    public String getNotificationResponse() {
        return this.notificationResponse;
    }

    public void setNotificationResponse(String notificationResponse) {
        this.notificationResponse = notificationResponse;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public boolean isPasswordInvalid() {
        return !TextUtils.isEmpty((CharSequence)this.message) && ("PASSWORD_INVALID".equals(this.message) || "PASSWORD_REQUIRED".equals(this.message));
    }

    public Short getPricingPackage() {
        return this.pricingPackage;
    }

    public void setPricingPackage(Short pricingPackage) {
        this.pricingPackage = pricingPackage;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getImageLink() {
        return this.imageLink;
    }

    public void setImageLink(String imageLink) {
        this.imageLink = imageLink;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public boolean isEnableEncryption() {
        return this.enableEncryption;
    }

    public void setEnableEncryption(boolean enableEncryption) {
        this.enableEncryption = enableEncryption;
    }

    public Short getRoleType() {
        return this.roleType;
    }

    public void setRoleType(Short roleType) {
        this.roleType = roleType;
    }

    public String getUserEncryptionKey() {
        return this.userEncryptionKey;
    }

    public void setUserEncryptionKey(String userEncryptionKey) {
        this.userEncryptionKey = userEncryptionKey;
    }

    public boolean isRegistrationSuccess() {
        return !TextUtils.isEmpty((CharSequence)this.message) && (SuccessResponse.UPDATED.getValue().equals(this.message) || SuccessResponse.REGISTERED.getValue().equals(this.message) || SuccessResponse.REGISTERED_WITHOUTREGISTRATIONID.getValue().equals(this.message));
    }

    public String toString() {
        return "RegistrationResponse{message='" + this.message + '\'' + ", deviceKey='" + this.deviceKey + '\'' + ", userKey='" + this.userKey + '\'' + ", userId='" + this.userId + '\'' + ", contactNumber='" + this.contactNumber + '\'' + ", lastSyncTime=" + this.lastSyncTime + ", currentTimeStamp=" + this.currentTimeStamp + ", displayName='" + this.displayName + '\'' + ", notificationResponse='" + this.notificationResponse + '\'' + ", brokerUrl='" + this.brokerUrl + '\'' + ", imageLink='" + this.imageLink + '\'' + ", statusMessage='" + this.statusMessage + '\'' + ", encryptionKey='" + this.encryptionKey + '\'' + ", userEncryptionKey='" + this.userEncryptionKey + '\'' + ", enableEncryption=" + this.enableEncryption + ", roleType=" + this.roleType + ", pricingPackage=" + this.pricingPackage + '}';
    }

    public static enum SuccessResponse {
        UPDATED("UPDATED"),
        REGISTERED("REGISTERED"),
        REGISTERED_WITHOUTREGISTRATIONID("REGISTERED.WITHOUTREGISTRATIONID");

        private final String value;

        private SuccessResponse(String c) {
            this.value = c;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PricingType {
        CLOSED(Short.valueOf("-1")),
        BETA(Short.valueOf("0")),
        STARTER(Short.valueOf("1")),
        LAUNCH(Short.valueOf("2")),
        GROWTH(Short.valueOf("3")),
        ENTERPRISE(Short.valueOf("4")),
        UNSUBSCRIBED(Short.valueOf("6"));

        private final Short value;

        private PricingType(Short c) {
            this.value = c;
        }

        public Short getValue() {
            return this.value;
        }
    }
}

