/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation.schedule;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;

public class ScheduledMessageUtil {
    Context context = null;
    private Class intentClass;

    public ScheduledMessageUtil(Context ctxt, Class intentClass) {
        this.context = ctxt;
        this.intentClass = intentClass;
    }

    public void createScheduleMessage(Message message, Context ctx) {
        MobiComDatabaseHelper dbHelper = MobiComDatabaseHelper.getInstance(ctx);
        SQLiteDatabase database = dbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("toField", message.getTo());
        values.put("sms", message.getMessage());
        values.put("timeStamp", message.getScheduledAt());
        values.put("SMSType", message.getType());
        values.put("contactId", message.getContactIds());
        values.put("smsKeyString", message.getKeyString());
        values.put("timeToLive", message.getTimeToLive());
        database.insert("ScheduleSMS", null, values);
        Intent otherIntent = new Intent();
        otherIntent.setClass(ctx, this.intentClass);
        AlarmManager alarm = (AlarmManager)ctx.getSystemService("alarm");
        PendingIntent intent = PendingIntent.getService((Context)ctx, (int)((int)System.currentTimeMillis()), (Intent)otherIntent, (int)0x8000000);
        alarm.set(0, message.getScheduledAt().longValue(), intent);
        dbHelper.close();
    }
}

