/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.applozic.mobicomkit.ConversationRunnables;
import com.applozic.mobicomkit.api.account.register.RegisterUserClientService;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.ConversationIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class SyncCallService {
    private static final String TAG = "SyncCall";
    public static boolean refreshView = false;
    private static SyncCallService syncCallService;
    private Context context;
    private MobiComMessageService mobiComMessageService;
    private MobiComConversationService mobiComConversationService;
    private BaseContactService contactService;
    private ChannelService channelService;
    private MessageClientService messageClientService;
    private MessageDatabaseService messageDatabaseService;

    private SyncCallService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.mobiComMessageService = new MobiComMessageService(context, MessageIntentService.class);
        this.mobiComConversationService = new MobiComConversationService(context);
        this.contactService = new AppContactService(context);
        this.channelService = ChannelService.getInstance(context);
        this.messageClientService = new MessageClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
    }

    public static SyncCallService getInstance(Context context) {
        if (syncCallService == null) {
            syncCallService = new SyncCallService(context);
        }
        return syncCallService;
    }

    public synchronized void updateDeliveryStatus(String key) {
        this.mobiComMessageService.updateDeliveryStatus(key, false);
        refreshView = true;
    }

    public synchronized void updateReadStatus(String key) {
        this.mobiComMessageService.updateDeliveryStatus(key, true);
        refreshView = true;
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(String searchString) {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(null, searchString);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople() {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(null, null);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt, String searchString) {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(createdAt, searchString);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(String searchString, Integer parentGroupKey) {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(null, searchString, parentGroupKey);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt, String searchString, Integer parentGroupKey) {
        return this.mobiComConversationService.getLatestMessagesGroupByPeople(createdAt, searchString, parentGroupKey);
    }

    public synchronized void syncMessages(String key) {
        this.syncMessages(key, null);
    }

    public synchronized void syncMessages(String key, Message message) {
        if (!TextUtils.isEmpty((CharSequence)key) && this.mobiComMessageService.isMessagePresent(key)) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Message is already present, MQTT reached before GCM.");
        } else if (Utils.isDeviceInIdleState((Context)this.context)) {
            new ConversationRunnables(this.context, message, false, true, false);
        } else {
            Intent intent = new Intent(this.context, ConversationIntentService.class);
            intent.putExtra("AL_SYNC", true);
            if (message != null) {
                intent.putExtra("AL_MESSAGE", (Serializable)((Object)message));
            }
            ConversationIntentService.enqueueWork(this.context, intent);
        }
    }

    public synchronized void syncMessageMetadataUpdate(String key, boolean isFromFcm) {
        if (!TextUtils.isEmpty((CharSequence)key) && this.mobiComMessageService.isMessagePresent(key)) {
            if (Utils.isDeviceInIdleState((Context)this.context)) {
                new ConversationRunnables(this.context, null, false, false, true);
            } else {
                Utils.printLog((Context)this.context, (String)TAG, (String)("Syncing updated message metadata from " + (isFromFcm ? "FCM" : "MQTT") + " for message key : " + key));
                Intent intent = new Intent(this.context, ConversationIntentService.class);
                intent.putExtra("MessageMetadataUpdate", true);
                ConversationIntentService.enqueueWork(this.context, intent);
            }
        }
    }

    public synchronized void syncMutedUserList(boolean isFromFcm, String userId) {
        if (userId == null) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Syncing muted user list from " + (isFromFcm ? "FCM" : "MQTT")));
            Intent intent = new Intent(this.context, ConversationIntentService.class);
            intent.putExtra("MutedUserListSync", true);
            ConversationIntentService.enqueueWork(this.context, intent);
        } else {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Unmuting userId : " + userId + " from " + (isFromFcm ? "FCM" : "MQTT")));
            new ContactDatabase(this.context).updateNotificationAfterTime(userId, Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime().getTime());
            BroadcastService.sendMuteUserBroadcast(this.context, BroadcastService.INTENT_ACTIONS.MUTE_USER_CHAT.toString(), false, userId);
        }
    }

    public synchronized void updateDeliveryStatusForContact(String contactId, boolean markRead) {
        this.mobiComMessageService.updateDeliveryStatusForContact(contactId, markRead);
    }

    public synchronized void updateConversationReadStatus(String currentId, boolean isGroup) {
        if (TextUtils.isEmpty((CharSequence)currentId)) {
            return;
        }
        if (isGroup) {
            this.messageDatabaseService.updateChannelUnreadCountToZero(Integer.valueOf(currentId));
        } else {
            this.messageDatabaseService.updateContactUnreadCountToZero(currentId);
        }
        BroadcastService.sendConversationReadBroadcast(this.context, BroadcastService.INTENT_ACTIONS.CONVERSATION_READ.toString(), currentId, isGroup);
    }

    public synchronized void updateConnectedStatus(String contactId, Date date, boolean connected) {
        this.contactService.updateConnectedStatus(contactId, date, connected);
    }

    public synchronized void deleteConversationThread(String userId) {
        this.mobiComConversationService.deleteConversationFromDevice(userId);
        refreshView = true;
    }

    public synchronized void deleteChannelConversationThread(String channelKey) {
        this.mobiComConversationService.deleteChannelConversationFromDevice(Integer.valueOf(channelKey));
        refreshView = true;
    }

    public synchronized void deleteChannelConversationThread(Integer channelKey) {
        this.mobiComConversationService.deleteChannelConversationFromDevice(channelKey);
        refreshView = true;
    }

    public synchronized void deleteMessage(String messageKey) {
        this.mobiComConversationService.deleteMessageFromDevice(messageKey, null);
        refreshView = true;
    }

    public synchronized void updateUserBlocked(String userId, boolean userBlocked) {
        this.contactService.updateUserBlocked(userId, userBlocked);
    }

    public synchronized void updateUserBlockedBy(String userId, boolean userBlockedBy) {
        this.contactService.updateUserBlockedBy(userId, userBlockedBy);
    }

    public void syncBlockUsers() {
        UserService.getInstance(this.context).processSyncUserBlock();
    }

    public void checkAccountStatus() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                new RegisterUserClientService(SyncCallService.this.context).syncAccountStatus();
            }
        }).start();
    }

    public void processUserStatus(String userId) {
        this.messageClientService.processUserStatus(userId);
    }

    public void syncUserDetail(String userId) {
        this.messageClientService.processUserStatus(userId, true);
    }

    public void processContactSync(String userId) {
        Contact contact;
        Utils.printLog((Context)this.context, (String)TAG, (String)("process contact sync for userId: " + userId));
        if (!TextUtils.isEmpty((CharSequence)userId) && this.contactService.isContactPresent(userId) && (contact = this.contactService.getContactById(userId)).isApplozicType()) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Contact is already present, MQTT reached before GCM.");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                UserService.getInstance(SyncCallService.this.context).processContactSync();
            }
        }).start();
    }
}

