/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.exception.ApplozicException;
import com.applozic.mobicomkit.listners.MessageListHandler;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class MessageListTask
extends AsyncTask<Void, Void, List<Message>> {
    private WeakReference<Context> context;
    private Contact contact;
    private Channel channel;
    private Long startTime;
    private Long endTime;
    private MessageListHandler handler;
    private boolean isForMessageList;
    private ApplozicException exception;

    public MessageListTask(Context context, Contact contact, Channel channel, Long startTime, Long endTime, MessageListHandler handler, boolean isForMessageList) {
        this.context = new WeakReference<Context>(context);
        this.contact = contact;
        this.channel = channel;
        this.startTime = startTime;
        this.endTime = endTime;
        this.handler = handler;
        this.isForMessageList = isForMessageList;
    }

    protected List<Message> doInBackground(Void ... voids) {
        List<Message> messageList = null;
        try {
            messageList = this.isForMessageList ? new MobiComConversationService((Context)this.context.get()).getLatestMessagesGroupByPeople(this.startTime, null) : new MobiComConversationService((Context)this.context.get()).getMessages(this.startTime, this.endTime, this.contact, this.channel, null);
        }
        catch (Exception e) {
            this.exception = new ApplozicException(e.getMessage());
        }
        return messageList;
    }

    protected void onPostExecute(List<Message> messageList) {
        super.onPostExecute(messageList);
        if (messageList == null && this.exception == null) {
            this.exception = new ApplozicException("Some internal error occurred");
        }
        ArrayList<String> recList = new ArrayList<String>();
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.isForMessageList && messageList != null && !messageList.isEmpty()) {
            for (Message message : messageList) {
                if (!(message.getGroupId() != null && message.getGroupId() != 0 || recList.contains(message.getContactIds()))) {
                    recList.add(message.getContactIds());
                    messages.add(message);
                    continue;
                }
                if (message.getGroupId() == null || recList.contains("group" + message.getGroupId())) continue;
                recList.add("group" + message.getGroupId());
                messages.add(message);
            }
            MobiComUserPreference.getInstance((Context)this.context.get()).setStartTimeForPagination(messageList.get(messageList.size() - 1).getCreatedAtTime());
        }
        if (this.handler != null) {
            if (this.isForMessageList && !messages.isEmpty()) {
                this.handler.onResult(messages, this.exception);
            } else if (messageList != null && !messageList.isEmpty()) {
                this.handler.onResult(messageList, this.exception);
            }
        }
    }
}

