/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.DBUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MessageDatabaseService {
    private static final String TAG = "MessageDatabaseService";
    private static final String MIN_CREATED_AT_KEY = "mck.sms.createdAt.min";
    private static final String MAX_CREATED_AT_KEY = "mck.sms.createdAt.max";
    public static List<Message> recentlyAddedMessage = new ArrayList<Message>();
    private Context context = null;
    private MobiComDatabaseHelper dbHelper;
    private boolean hideActionMessages = false;
    private boolean skipDeletedGroups;

    public MessageDatabaseService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.dbHelper = MobiComDatabaseHelper.getInstance(context);
        this.hideActionMessages = ApplozicClient.getInstance(context).isActionMessagesHidden();
        this.skipDeletedGroups = ApplozicClient.getInstance(context).isSkipDeletedGroups();
    }

    public static Message getMessage(Cursor cursor) {
        String filePaths;
        Message message = new Message();
        message.setMessageId(cursor.getLong(cursor.getColumnIndex("id")));
        message.setKeyString(cursor.getString(cursor.getColumnIndex("keyString")));
        message.setType(cursor.getShort(cursor.getColumnIndex("type")));
        message.setSource(cursor.getShort(cursor.getColumnIndex("source")));
        Long storeOnDevice = cursor.getLong(cursor.getColumnIndex("storeOnDevice"));
        message.setStoreOnDevice(storeOnDevice != null && storeOnDevice.intValue() == 1);
        String contactNumbers = cursor.getString(cursor.getColumnIndex("contactNumbers"));
        message.setContactIds(contactNumbers);
        message.setCreatedAtTime(cursor.getLong(cursor.getColumnIndex("createdAt")));
        Long delivered = cursor.getLong(cursor.getColumnIndex("delivered"));
        message.setDelivered(delivered != null && delivered.intValue() == 1);
        Long canceled = cursor.getLong(cursor.getColumnIndex("canceled"));
        message.setCanceled(canceled != null && canceled.intValue() == 1);
        Long read = cursor.getLong(cursor.getColumnIndex("read"));
        message.setRead(read != null && read.intValue() == 1);
        message.setStatus(cursor.getShort(cursor.getColumnIndex("status")));
        message.setClientGroupId(cursor.getString(cursor.getColumnIndex("clientGroupId")));
        Long scheduledAt = cursor.getLong(cursor.getColumnIndex("scheduledAt"));
        message.setScheduledAt(scheduledAt == null || scheduledAt.intValue() == 0 ? null : scheduledAt);
        message.setMessage(cursor.getString(cursor.getColumnIndex("message")));
        Long sentToServer = cursor.getLong(cursor.getColumnIndex("sentToServer"));
        message.setSentToServer(sentToServer != null && sentToServer.intValue() == 1);
        message.setTo(cursor.getString(cursor.getColumnIndex("toNumbers")));
        int timeToLive = cursor.getInt(cursor.getColumnIndex("timeToLive"));
        message.setReplyMessage(cursor.getInt(cursor.getColumnIndex("replyMessage")));
        message.setTimeToLive(timeToLive != 0 ? Integer.valueOf(timeToLive) : null);
        String fileMetaKeyStrings = cursor.getString(cursor.getColumnIndex("fileMetaKeyStrings"));
        if (!TextUtils.isEmpty((CharSequence)fileMetaKeyStrings)) {
            message.setFileMetaKeyStrings(fileMetaKeyStrings);
        }
        if (!TextUtils.isEmpty((CharSequence)(filePaths = cursor.getString(cursor.getColumnIndex("filePaths"))))) {
            message.setFilePaths(Arrays.asList(filePaths.split(",")));
        }
        message.setHidden(cursor.getInt(cursor.getColumnIndex("hidden")) == 1);
        String metadata = cursor.getString(cursor.getColumnIndex("metadata"));
        if (!TextUtils.isEmpty((CharSequence)metadata)) {
            message.setMetadata((Map)GsonUtils.getObjectFromJson((String)metadata, Map.class));
        }
        message.setApplicationId(cursor.getString(cursor.getColumnIndex("applicationId")));
        message.setContentType(cursor.getShort(cursor.getColumnIndex("messageContentType")));
        int conversationId = cursor.getInt(cursor.getColumnIndex("conversationId"));
        if (conversationId == 0) {
            message.setConversationId(null);
        } else {
            message.setConversationId(conversationId);
        }
        message.setTopicId(cursor.getString(cursor.getColumnIndex("topicId")));
        int channelKey = cursor.getInt(cursor.getColumnIndex("channelKey"));
        if (channelKey == 0) {
            message.setGroupId(null);
        } else {
            message.setGroupId(channelKey);
        }
        if (cursor.getString(cursor.getColumnIndex("blobKeyString")) != null) {
            FileMeta fileMeta = new FileMeta();
            fileMeta.setKeyString(cursor.getString(cursor.getColumnIndex("metaFileKeyString")));
            fileMeta.setBlobKeyString(cursor.getString(cursor.getColumnIndex("blobKeyString")));
            fileMeta.setThumbnailBlobKey(cursor.getString(cursor.getColumnIndex("thumbnailBlobKey")));
            fileMeta.setThumbnailUrl(cursor.getString(cursor.getColumnIndex("thumbnailUrl")));
            fileMeta.setSize(cursor.getInt(cursor.getColumnIndex("size")));
            fileMeta.setName(cursor.getString(cursor.getColumnIndex("name")));
            fileMeta.setContentType(cursor.getString(cursor.getColumnIndex("contentType")));
            fileMeta.setUrl(cursor.getString(cursor.getColumnIndex("url")));
            message.setFileMetas(fileMeta);
        }
        return message;
    }

    public static List<Message> getMessageList(Cursor cursor) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    Message message = MessageDatabaseService.getMessage(cursor);
                    if (Message.ContentType.CHANNEL_CUSTOM_MESSAGE.getValue().equals(message.getContentType())) {
                        if (Message.GroupMessageMetaData.TRUE.getValue().equals(message.getMetaDataValueForKey(Message.GroupMessageMetaData.HIDE_KEY.getValue()))) continue;
                        messageList.add(message);
                        continue;
                    }
                    messageList.add(message);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> getLatestMessageList(Cursor cursor, boolean isActionMessageHidden) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    Message message;
                    if ((message = MessageDatabaseService.getMessage(cursor)) == null || Message.MetaDataType.ARCHIVE.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue())) && isActionMessageHidden && message.isActionMessage()) continue;
                    messageList.add(message);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return messageList;
    }

    public static List<Message> getLatestMessageListForNotification(Cursor cursor) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    Message message;
                    if ((message = MessageDatabaseService.getMessage(cursor)) == null || Message.GroupMessageMetaData.FALSE.getValue().equals(message.getMetaDataValueForKey(Message.GroupMessageMetaData.KEY.getValue()))) continue;
                    messageList.add(message);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId) {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        if (channel != null && channel.getKey() != null) {
            structuredNameWhere = structuredNameWhere + "channelKey = ? AND ";
            structuredNameParamsList.add(String.valueOf(channel.getKey()));
        } else {
            structuredNameWhere = structuredNameWhere + "channelKey = ? AND ";
            structuredNameParamsList.add("0");
        }
        if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            structuredNameWhere = structuredNameWhere + "contactNumbers = ? AND ";
            structuredNameParamsList.add(contact.getContactIds());
        }
        if (startTime != null) {
            structuredNameWhere = structuredNameWhere + "createdAt >= ? AND ";
            structuredNameParamsList.add(String.valueOf(startTime));
        }
        if (endTime != null) {
            structuredNameWhere = structuredNameWhere + "createdAt < ? AND ";
            structuredNameParamsList.add(String.valueOf(endTime));
        }
        if (BroadcastService.isContextBasedChatEnabled() && conversationId != null && conversationId != 0) {
            structuredNameWhere = structuredNameWhere + "conversationId = ? AND ";
            structuredNameParamsList.add(String.valueOf(conversationId));
        }
        structuredNameWhere = structuredNameWhere + "messageContentType not in ( ?,? ) AND ";
        structuredNameParamsList.add(String.valueOf(Message.ContentType.HIDDEN.getValue()));
        structuredNameParamsList.add(String.valueOf(Message.ContentType.VIDEO_CALL_NOTIFICATION_MSG.getValue()));
        structuredNameWhere = structuredNameWhere + "deleted = ? AND ";
        structuredNameParamsList.add("0");
        structuredNameWhere = structuredNameWhere + "hidden = ? AND ";
        structuredNameParamsList.add("0");
        structuredNameWhere = structuredNameWhere + "replyMessage != ? AND ";
        structuredNameParamsList.add(String.valueOf(Message.ReplyMessage.HIDE_MESSAGE.getValue()));
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isDisplayCallRecordEnable()) {
            structuredNameWhere = structuredNameWhere + "type != ? AND type != ? AND ";
            structuredNameParamsList.add(String.valueOf(Message.MessageType.CALL_INCOMING.getValue()));
            structuredNameParamsList.add(String.valueOf(Message.MessageType.CALL_OUTGOING.getValue()));
        }
        if (!TextUtils.isEmpty((CharSequence)structuredNameWhere)) {
            structuredNameWhere = structuredNameWhere.substring(0, structuredNameWhere.length() - 5);
        }
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        try {
            Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt asc");
            List<Message> list = MessageDatabaseService.getMessageList(cursor);
            return list;
        }
        finally {
            this.dbHelper.close();
        }
    }

    public List<Message> getUnreadMessages() {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "messageContentType not in (11) AND ";
        structuredNameWhere = structuredNameWhere + "status in (0,3) AND ";
        structuredNameWhere = structuredNameWhere + "type = ? ";
        structuredNameParamsList.add(String.valueOf(Message.MessageType.MT_INBOX.getValue()));
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt desc limit 10");
        return MessageDatabaseService.getLatestMessageListForNotification(cursor);
    }

    public List<Message> getPendingMessages() {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "sentToServer = ? and canceled = ? and deleted = ?";
        structuredNameParamsList.add("0");
        structuredNameParamsList.add("0");
        structuredNameParamsList.add("0");
        Cursor cursor = this.dbHelper.getReadableDatabase().query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt asc");
        List<Message> messageList = MessageDatabaseService.getMessageList(cursor);
        this.dbHelper.close();
        return messageList;
    }

    public List<Message> getPendingDeleteMessages() {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "sentToServer = ? and deleted = ?";
        structuredNameParamsList.add("1");
        structuredNameParamsList.add("1");
        Cursor cursor = this.dbHelper.getReadableDatabase().query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt asc");
        List<Message> messageList = MessageDatabaseService.getMessageList(cursor);
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinCreatedAtFromMessageTable() {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("select min(createdAt) as createdAt from sms", null);
        try {
            long createdAt = 0L;
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                createdAt = cursor.getLong(0);
            }
            long l = createdAt;
            return l;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(String contactNumber, String message) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "contactNumbers = ? AND message = ?";
        structuredNameParamsList.add(contactNumber);
        structuredNameParamsList.add(message);
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, null);
        try {
            Message message1 = null;
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                message1 = MessageDatabaseService.getMessage(cursor);
            }
            Message message2 = message1;
            return message2;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessagePresent(String key) {
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        Cursor cursor = database.rawQuery("SELECT COUNT(*) FROM sms WHERE keyString = ?", new String[]{key});
        try {
            cursor.moveToFirst();
            boolean bl = cursor.getInt(0) > 0;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
                this.dbHelper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(String keyString) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return null;
        }
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "keyString = ?";
        structuredNameParamsList.add(keyString);
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, null);
        try {
            Message message = null;
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                message = MessageDatabaseService.getMessage(cursor);
            }
            Message message2 = message;
            return message2;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getScheduledMessages(Long time) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        if (!DBUtils.isTableExists((SQLiteDatabase)db, (String)"ScheduleSMS")) {
            this.dbHelper.close();
            return new ArrayList<Message>();
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        Cursor cursor = null;
        try {
            cursor = time != null ? db.query("ScheduleSMS", null, "timeStamp <= ?", new String[]{time + ""}, null, null, null) : db.query("ScheduleSMS", null, null, null, null, null, null);
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    String createdTime = cursor.getString(cursor.getColumnIndex("timeStamp"));
                    Message message = new Message();
                    message.setCreatedAtTime(Long.valueOf(createdTime));
                    message.setScheduledAt(cursor.getLong(cursor.getColumnIndex("timeStamp")));
                    message.setMessage(cursor.getString(cursor.getColumnIndex("sms")));
                    message.setType(cursor.getShort(cursor.getColumnIndex("SMSType")));
                    message.setSource(cursor.getShort(cursor.getColumnIndex("source")));
                    message.setContactIds(cursor.getString(cursor.getColumnIndex("contactId")));
                    message.setTo(cursor.getString(cursor.getColumnIndex("toField")));
                    message.setKeyString(cursor.getString(cursor.getColumnIndex("smsKeyString")));
                    message.setStoreOnDevice("1".equals(cursor.getString(cursor.getColumnIndex("storeOnDevice"))));
                    if (cursor.getColumnIndex("timeToLive") != -1) {
                        int timeToLive = cursor.getInt(cursor.getColumnIndex("timeToLive"));
                        message.setTimeToLive(timeToLive == 0 ? null : Integer.valueOf(timeToLive));
                    }
                    messages.add(message);
                } while (cursor.moveToNext());
            }
            ArrayList<Message> arrayList = messages;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    public void deleteScheduledMessages(long time) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete("ScheduleSMS", "timeStamp <= ? ", new String[]{time + ""});
        this.dbHelper.close();
    }

    public boolean deleteScheduledMessage(String messageKeyString) {
        SQLiteDatabase db = MobiComDatabaseHelper.getInstance(this.context).getWritableDatabase();
        boolean deleted = db.delete("ScheduleSMS", "smsKeyString='" + messageKeyString + "'", null) > 0;
        this.dbHelper.close();
        return deleted;
    }

    public boolean isMessageTableEmpty() {
        this.dbHelper = MobiComDatabaseHelper.getInstance(this.context);
        boolean empty = DBUtils.isTableEmpty((SQLiteDatabase)this.dbHelper.getReadableDatabase(), (String)"sms");
        this.dbHelper.close();
        return empty;
    }

    public synchronized void updateMessageFileMetas(long messageId, Message message) {
        FileMeta fileMeta;
        ContentValues values = new ContentValues();
        values.put("keyString", message.getKeyString());
        if (message.getFileMetaKeyStrings() != null) {
            values.put("fileMetaKeyStrings", message.getFileMetaKeyStrings());
        }
        if (message.getFileMetas() != null && (fileMeta = message.getFileMetas()) != null) {
            values.put("thumbnailUrl", fileMeta.getThumbnailUrl());
            values.put("size", Integer.valueOf(fileMeta.getSize()));
            values.put("name", fileMeta.getName());
            values.put("contentType", fileMeta.getContentType());
            values.put("metaFileKeyString", fileMeta.getKeyString());
            values.put("blobKeyString", fileMeta.getBlobKeyString());
            values.put("thumbnailBlobKey", fileMeta.getThumbnailBlobKey());
            values.put("url", fileMeta.getUrl());
        }
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + messageId, null);
        this.dbHelper.close();
    }

    public synchronized long createMessage(Message message) {
        long id = -1L;
        if (message.getMessageId() != null) {
            return message.getMessageId();
        }
        id = this.createSingleMessage(message);
        message.setMessageId(id);
        if (message.isSentToMany()) {
            String[] toList;
            for (String tofield : toList = message.getTo().trim().replace("undefined,", "").split(",")) {
                Message singleMessage = new Message(message);
                singleMessage.setKeyString(message.getKeyString());
                singleMessage.setTo(tofield);
                singleMessage.processContactIds(this.context);
                singleMessage.setMessageId(this.createSingleMessage(singleMessage));
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long createSingleMessage(Message message) {
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        long id = -1L;
        boolean duplicateCheck = true;
        SharedPreferences prefs = this.context.getSharedPreferences(MobiComKitClientService.getApplicationKey(this.context), 0);
        long minCreatedAt = prefs.getLong(MIN_CREATED_AT_KEY, 0L);
        long maxCreatedAt = prefs.getLong(MAX_CREATED_AT_KEY, Long.MAX_VALUE);
        if (message.getCreatedAtTime() < minCreatedAt) {
            duplicateCheck = false;
            prefs.edit().putLong(MIN_CREATED_AT_KEY, message.getCreatedAtTime().longValue()).commit();
        }
        if (message.getCreatedAtTime() > maxCreatedAt) {
            duplicateCheck = false;
            prefs.edit().putLong(MAX_CREATED_AT_KEY, message.getCreatedAtTime().longValue()).commit();
        }
        if (duplicateCheck) {
            Cursor cursor = null;
            try {
                String queryClause = "";
                queryClause = message.getGroupId() != null ? "channelKey ='" + String.valueOf(message.getGroupId()) + "'" : "contactNumbers ='" + message.getContactIds() + "'";
                cursor = message.isSentToServer() && !TextUtils.isEmpty((CharSequence)message.getKeyString()) ? database.rawQuery("SELECT COUNT(*) FROM sms WHERE keyString = ? and " + queryClause, new String[]{message.getKeyString()}) : database.rawQuery("SELECT COUNT(*) FROM sms WHERE sentToServer=0 and " + queryClause + " and message = ? and createdAt = " + message.getCreatedAtTime(), new String[]{message.getMessage()});
                cursor.moveToFirst();
                if (cursor.getInt(0) > 0) {
                    long l = -1L;
                    return l;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                this.dbHelper.close();
            }
        }
        try {
            FileMeta fileMeta;
            ContentValues values = new ContentValues();
            values.put("toNumbers", message.getTo());
            values.put("message", message.getMessage());
            values.put("createdAt", message.getCreatedAtTime());
            values.put("storeOnDevice", Boolean.valueOf(message.isStoreOnDevice()));
            values.put("delivered", message.getDelivered());
            values.put("scheduledAt", message.getScheduledAt());
            values.put("type", message.getType());
            values.put("contactNumbers", message.getContactIds());
            values.put("sentToServer", Boolean.valueOf(message.isSentToServer()));
            values.put("keyString", message.getKeyString());
            values.put("source", message.getSource());
            values.put("timeToLive", message.getTimeToLive());
            values.put("canceled", Boolean.valueOf(message.isCanceled()));
            values.put("read", Integer.valueOf(message.isRead() != false ? 1 : 0));
            values.put("applicationId", message.getApplicationId());
            values.put("messageContentType", Short.valueOf(message.getContentType()));
            values.put("status", Short.valueOf(message.getStatus()));
            values.put("conversationId", message.getConversationId());
            values.put("topicId", message.getTopicId());
            values.put("hidden", Boolean.valueOf(message.isHidden()));
            boolean hidden = this.hideActionMessages && message.isActionMessage() || message.isHidden();
            values.put("hidden", Boolean.valueOf(hidden));
            if (message.getGroupId() != null) {
                values.put("channelKey", message.getGroupId());
            }
            if (!TextUtils.isEmpty((CharSequence)message.getClientGroupId())) {
                values.put("clientGroupId", message.getClientGroupId());
            }
            if (message.getFileMetaKeyStrings() != null) {
                values.put("fileMetaKeyStrings", message.getFileMetaKeyStrings());
            }
            if (message.getFilePaths() != null && !message.getFilePaths().isEmpty()) {
                values.put("filePaths", TextUtils.join((CharSequence)",", message.getFilePaths()));
            }
            if (message.getMetadata() != null && !message.getMetadata().isEmpty()) {
                values.put("metadata", GsonUtils.getJsonFromObject(message.getMetadata(), Map.class));
            }
            values.put("replyMessage", Integer.valueOf(message.isReplyMessage()));
            if (message.getFileMetas() != null && (fileMeta = message.getFileMetas()) != null) {
                values.put("thumbnailUrl", fileMeta.getThumbnailUrl());
                values.put("size", Integer.valueOf(fileMeta.getSize()));
                values.put("name", fileMeta.getName());
                values.put("contentType", fileMeta.getContentType());
                values.put("metaFileKeyString", fileMeta.getKeyString());
                values.put("blobKeyString", fileMeta.getBlobKeyString());
                values.put("thumbnailBlobKey", fileMeta.getThumbnailBlobKey());
                values.put("url", fileMeta.getUrl());
            }
            id = database.insertOrThrow("sms", null, values);
        }
        catch (SQLException ex) {
            Utils.printLog((Context)this.context, (String)TAG, (String)(" Ignore Duplicate entry in sms table, sms: " + (Object)((Object)message)));
        }
        finally {
            this.dbHelper.close();
        }
        return id;
    }

    public void updateSmsType(String smsKeyString, Message.MessageType messageType) {
        ContentValues values = new ContentValues();
        values.put("type", messageType.getValue());
        this.dbHelper.getWritableDatabase().update("sms", values, "keyString='" + smsKeyString + "'", null);
        this.dbHelper.close();
    }

    public int updateMessageDeliveryReportForContact(String contactId, boolean markRead) {
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            String whereClause = "contactNumbers= '" + contactId + "' and ";
            values.put("delivered", "1");
            if (markRead) {
                whereClause = whereClause + "status not in (5)";
                values.put("status", String.valueOf(Message.Status.DELIVERED_AND_READ.getValue()));
            } else {
                whereClause = whereClause + "status not in (4,5)";
                values.put("status", String.valueOf(Message.Status.DELIVERED.getValue()));
            }
            whereClause = whereClause + " and type=5 ";
            int rows = database.update("sms", values, whereClause, null);
            this.dbHelper.close();
            return rows;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void updateMessageDeliveryReportForContact(String messageKeyString, String contactNumber, boolean markRead) {
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            if (markRead) {
                values.put("status", String.valueOf(Message.Status.DELIVERED_AND_READ.getValue()));
            } else {
                values.put("status", String.valueOf(Message.Status.DELIVERED.getValue()));
            }
            values.put("delivered", "1");
            if (TextUtils.isEmpty((CharSequence)contactNumber)) {
                database.update("sms", values, "keyString='" + messageKeyString + "' and type = 5", null);
            } else {
                database.update("sms", values, "keyString='" + messageKeyString + "' and contactNumbers='" + contactNumber + "' and type = 5", null);
            }
            this.dbHelper.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageSyncStatus(Message message, String keyString) {
        try {
            ContentValues values = new ContentValues();
            values.put("keyString", keyString);
            values.put("sentToServer", "1");
            values.put("createdAt", Long.valueOf(message.getSentMessageTimeAtServer()));
            this.dbHelper.getWritableDatabase().update("sms", values, "id=" + message.getMessageId(), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeleteSyncStatus(Message message, String deleteStatus) {
        try {
            ContentValues values = new ContentValues();
            values.put("deleted", deleteStatus);
            this.dbHelper.getWritableDatabase().update("sms", values, "id=" + message.getMessageId(), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public void updateInternalFilePath(String keyString, String filePath) {
        ContentValues values = new ContentValues();
        values.put("filePaths", filePath);
        this.dbHelper.getWritableDatabase().update("sms", values, "keyString='" + keyString + "'", null);
        this.dbHelper.close();
    }

    public void updateMessage(Long id, Long createdAt, String KeyString, boolean isSentToServer) {
        ContentValues values = new ContentValues();
        values.put("createdAt", createdAt);
        values.put("keyString", KeyString);
        values.put("sentToServer", Boolean.valueOf(isSentToServer));
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + id, null);
        this.dbHelper.close();
    }

    public void updateCanceledFlag(long smsId, int value) {
        ContentValues values = new ContentValues();
        values.put("canceled", Integer.valueOf(value));
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + smsId, null);
        this.dbHelper.close();
    }

    public void updateMessageReadFlag(long smsId, boolean read) {
        ContentValues values = new ContentValues();
        values.put("read", Integer.valueOf(read ? 1 : 0));
        values.put("status", Integer.valueOf(1));
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + smsId, null);
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMessageCountForContact(String userId) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT unreadCount FROM contact WHERE userId = '" + userId + "'", null);
            cursor.moveToFirst();
            int unreadMessageCount = 0;
            if (cursor.getCount() > 0) {
                unreadMessageCount = cursor.getInt(0);
            }
            int n = unreadMessageCount;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMessageCountForChannel(Integer channelKey) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT unreadCount FROM channel WHERE channelKey = '" + String.valueOf(channelKey) + "'", null);
            cursor.moveToFirst();
            int unreadMessage = 0;
            if (cursor.getCount() > 0) {
                unreadMessage = cursor.getInt(0);
            }
            int n = unreadMessage;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadConversationCount() {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT COUNT(DISTINCT (contactNumbers)) FROM sms WHERE read = 0 ", null);
            cursor.moveToFirst();
            int conversationCount = 0;
            if (cursor.getCount() > 0) {
                conversationCount = cursor.getInt(0);
            }
            int n = conversationCount;
            return n;
        }
        catch (Exception ex) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Exception while fetching unread conversation count");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMessageCount() {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            cursor = db.rawQuery("SELECT COUNT(1) FROM sms WHERE read = 0 ", null);
            cursor.moveToFirst();
            int unreadMessageCount = 0;
            if (cursor.getCount() > 0) {
                unreadMessageCount = cursor.getInt(0);
            }
            int n = unreadMessageCount;
            return n;
        }
        catch (Exception ex) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Exception while fetching unread message count");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return 0;
    }

    public List<Message> getLatestMessage(String contactNumbers) {
        ArrayList<Message> messages = new ArrayList();
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("select * from sms where contactNumbers = '" + contactNumbers + "' order by createdAt desc limit 1", null);
        if (cursor.moveToFirst()) {
            messages = MessageDatabaseService.getMessageList(cursor);
        }
        this.dbHelper.close();
        return messages;
    }

    public List<Message> getLatestMessageByClientGroupId(String clientGroupId) {
        return this.getLatestMessageForChannel(null, clientGroupId);
    }

    public List<Message> getLatestMessageByChannelKey(Integer channelKey) {
        return this.getLatestMessageForChannel(channelKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getLatestMessageForChannel(Integer channelKey, String clientGroupId) {
        String clauseString = null;
        if (channelKey != null && channelKey != 0) {
            clauseString = " channelKey = '" + channelKey + "'";
        } else if (!TextUtils.isEmpty((CharSequence)clientGroupId)) {
            clauseString = " clientGroupId = '" + clientGroupId + "'";
        }
        List<Message> messages = new ArrayList<Message>();
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery("select * from sms where " + clauseString + " order by createdAt desc limit 1", null);
        try {
            if (cursor.moveToFirst()) {
                messages = MessageDatabaseService.getMessageList(cursor);
            }
            ArrayList<Message> arrayList = messages;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessagePresent(String key, Integer replyMessageType) {
        Cursor cursor = null;
        boolean present = false;
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        try {
            cursor = database.rawQuery("SELECT COUNT(*) FROM sms WHERE keyString = ? AND replyMessage = ?", new String[]{key, String.valueOf(replyMessageType)});
            cursor.moveToFirst();
            present = cursor.getInt(0) > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.dbHelper.close();
        }
        return present;
    }

    public List<Message> getChannelCustomMessagesByClientGroupId(String clientGroupId) {
        return this.getChannelCustomMessageList(null, clientGroupId);
    }

    public List<Message> getChannelCustomMessagesByChannelKey(Integer channelKey) {
        return this.getChannelCustomMessageList(channelKey, null);
    }

    private List<Message> getChannelCustomMessageList(Integer channelKey, String clientGroupId) {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        if (channelKey != null && channelKey != 0) {
            structuredNameWhere = "channelKey = ? AND ";
            structuredNameParamsList.add(String.valueOf(channelKey));
        } else if (!TextUtils.isEmpty((CharSequence)clientGroupId)) {
            structuredNameWhere = "clientGroupId = ? AND ";
            structuredNameParamsList.add(clientGroupId);
        }
        structuredNameWhere = structuredNameWhere + "messageContentType in (10) ";
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt desc");
        return MessageDatabaseService.getMessageList(cursor);
    }

    public int updateReadStatus(String contactNumbers) {
        ContentValues values = new ContentValues();
        values.put("read", Integer.valueOf(1));
        int read = this.dbHelper.getWritableDatabase().update("sms", values, " contactNumbers = '" + contactNumbers + "' and read = 0", null);
        this.dbHelper.close();
        return read;
    }

    public int updateReadStatusForKeyString(String keyString) {
        ContentValues values = new ContentValues();
        values.put("read", Integer.valueOf(1));
        values.put("status", Integer.valueOf(1));
        int read = this.dbHelper.getWritableDatabase().update("sms", values, " keyString = '" + keyString + "'", null);
        this.dbHelper.close();
        return read;
    }

    public int updateReadStatusForContact(String userId) {
        ContentValues values = new ContentValues();
        values.put("unreadCount", Integer.valueOf(0));
        int read = this.dbHelper.getWritableDatabase().update("contact", values, "userId = '" + userId + "'", null);
        this.dbHelper.close();
        return read;
    }

    public int updateReadStatusForChannel(String channelKey) {
        ContentValues values = new ContentValues();
        values.put("unreadCount", Integer.valueOf(0));
        int read = this.dbHelper.getWritableDatabase().update("channel", values, "channelKey = '" + channelKey + "'", null);
        this.dbHelper.close();
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getLatestGroupMessages(Long createdAt, String searchText, Integer parentGroupKey) {
        if (parentGroupKey != null && parentGroupKey != 0) {
            List<String> channelKeysArray = ChannelService.getInstance(this.context).getChildGroupKeys(parentGroupKey);
            if (channelKeysArray == null || channelKeysArray.size() < 1) {
                return new ArrayList<Message>();
            }
            channelKeysArray.add(String.valueOf(parentGroupKey));
            String createdAtClause = "";
            String searchCaluse = "";
            if (createdAt != null && createdAt > 0L) {
                createdAtClause = " and  m.createdAt < " + createdAt;
            }
            if (!TextUtils.isEmpty((CharSequence)searchText)) {
                searchCaluse = searchCaluse + " and (m.message like '%" + searchText.replaceAll("'", "''") + "%'  or c.channelName like '%" + searchText.replaceAll("'", "''") + "%' )";
            }
            createdAtClause = createdAtClause + " and m.deleted = 0 ";
            String messageTypeClause = "";
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            if (!userPreferences.isDisplayCallRecordEnable()) {
                messageTypeClause = " and m.type != " + Message.MessageType.CALL_INCOMING.getValue() + " and m.type != " + Message.MessageType.CALL_OUTGOING.getValue();
            }
            String hiddenType = " and m.messageContentType != " + Message.ContentType.HIDDEN.getValue() + " and m.hidden = 0 and  m.replyMessage != " + Message.ReplyMessage.HIDE_MESSAGE.getValue();
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            String[] toStringArray = new String[channelKeysArray.size()];
            toStringArray = channelKeysArray.toArray(toStringArray);
            String placeHolderString = Utils.makePlaceHolders((int)channelKeysArray.size());
            String str = "select m1.* from sms m1, (SELECT          m.channelKey as channelKey1, MAX(createdAt) as createdAt1    FROM        sms m join channel c on m.channelKey IN (" + placeHolderString + ")    WHERE 1=1 " + searchCaluse + messageTypeClause + hiddenType + createdAtClause + " GROUP BY m.channelKey) m2 Where  m1.createdAt = m2.createdAt1         AND m1.channelKey = m2.channelKey1  order by m1.createdAt desc";
            Cursor cursor = db.rawQuery(str, channelKeysArray.toArray(toStringArray));
            try {
                List<Message> list = MessageDatabaseService.getMessageList(cursor);
                return list;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                this.dbHelper.close();
            }
        }
        return new ArrayList<Message>();
    }

    public List<Message> getMessages(Long createdAt) {
        return this.getMessages(createdAt, null, null);
    }

    List<Message> getMessages(Long createdAt, String searchText) {
        return this.getMessages(createdAt, searchText, null);
    }

    public List<Message> getMessages(Long createdAt, String searchText, Integer parentGroupKey) {
        if (parentGroupKey != null && parentGroupKey != 0) {
            return this.getLatestGroupMessages(createdAt, searchText, parentGroupKey);
        }
        Cursor cursor = null;
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        if (!TextUtils.isEmpty((CharSequence)searchText)) {
            String searchQuery = "select * from sms where deleted = 0 and messageContentType not in (10,11,102,103) and replyMessage not in (2) and type not in (6,7) and hidden = 0 and message like +'%" + searchText.replaceAll("'", "''") + "%' order by createdAt DESC";
            cursor = db.rawQuery(searchQuery, null);
        } else {
            String createdAtClause = "";
            if (createdAt != null && createdAt > 0L) {
                createdAtClause = " and m1.createdAt < " + createdAt;
            }
            createdAtClause = createdAtClause + " and m1.deleted = 0 ";
            String messageTypeClause = "";
            String messageTypeJoinClause = "";
            String searchCaluse = "";
            String categoryClause = " left join channel ch on ch.channelKey = m1.channelKey ";
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            String categoryName = userPreferences.getCategoryName();
            if (!userPreferences.isDisplayCallRecordEnable()) {
                messageTypeClause = " and m1.type != " + Message.MessageType.CALL_INCOMING.getValue() + " and m1.type != " + Message.MessageType.CALL_OUTGOING.getValue();
                messageTypeJoinClause = " and m1.type = m2.type";
            }
            if (!TextUtils.isEmpty((CharSequence)searchText)) {
                searchCaluse = searchCaluse + " and m1.message like '%" + searchText.replaceAll("'", "''") + "%' ";
            }
            String hiddenType = " and m1.messageContentType not in (" + Message.ContentType.HIDDEN.getValue() + "," + Message.ContentType.VIDEO_CALL_NOTIFICATION_MSG.getValue() + ") AND m1.hidden = 0 AND m1.replyMessage not in (" + Message.ReplyMessage.HIDE_MESSAGE.getValue() + ")";
            String rowQuery = "select m1.* from sms m1 left outer join sms m2 on (m1.createdAt < m2.createdAt and m1.channelKey = m2.channelKey and m1.contactNumbers = m2.contactNumbers and m1.deleted = m2.deleted and  m1.messageContentType = m2.messageContentType and m1.hidden = m2.hidden " + messageTypeJoinClause + " ) ";
            if (!TextUtils.isEmpty((CharSequence)categoryName) || this.skipDeletedGroups) {
                rowQuery = rowQuery + categoryClause;
            }
            rowQuery = rowQuery + "where m2.createdAt is null ";
            if (!TextUtils.isEmpty((CharSequence)categoryName)) {
                rowQuery = rowQuery + "and ch.AL_CATEGORY = '" + categoryName + "'";
            }
            if (this.skipDeletedGroups) {
                rowQuery = rowQuery + " and ch.deletedAtTime is null";
            }
            rowQuery = rowQuery + createdAtClause + searchCaluse + hiddenType + messageTypeClause + " order by m1.createdAt desc";
            cursor = db.rawQuery(rowQuery, null);
        }
        List<Message> messageList = MessageDatabaseService.getLatestMessageList(cursor, this.hideActionMessages);
        this.dbHelper.close();
        return messageList;
    }

    public List<Message> getKmConversationList(int status, Long lastFetchTime) {
        String rowQuery;
        String statusQuery;
        Cursor cursor = null;
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        String string = statusQuery = status == 2 ? "ch.kmStatus in (1, 2)" : "ch.kmStatus = " + status;
        if (status == 3) {
            rowQuery = "select max(createdAt) , m.* from sms m inner join channel ch on m.channelKey = ch.channelKey where m.hidden = 0 AND m.deleted = 0 AND m.messageContentType not in (11,102) AND m.type not in (6, 7) AND " + statusQuery + (lastFetchTime != null && lastFetchTime > 0L ? " AND m.createdAt < " + lastFetchTime : "") + " group by m.channelKey order by createdAt desc";
            cursor = db.rawQuery(rowQuery, null);
        } else {
            rowQuery = "SELECT * FROM (select max(createdAt) as maxCreatedAt , m.* from sms m inner join channel ch on m.channelKey = ch.channelKey where m.hidden = 0 AND m.deleted = 0 AND m.messageContentType not in (11,102) AND m.type not in (6, 7) AND " + statusQuery + " group by m.channelKey UNION ALL select max(createdAt) as maxCreatedAt , m.* from sms m where m.hidden = 0 AND m.deleted = 0 AND m.messageContentType not in (11,102) AND m.type not in (6, 7) AND m.channelKey = 0 group by m.contactNumbers ) temp  ORDER BY temp.maxCreatedAt DESC";
            cursor = db.rawQuery(rowQuery, null);
        }
        List<Message> messageList = MessageDatabaseService.getLatestMessageList(cursor, this.hideActionMessages);
        this.dbHelper.close();
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalUnreadCountForSupportGroup(int status) {
        Cursor cursor = null;
        Cursor contactCountCursor = null;
        int count = 0;
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        String statusQuery = status == 2 ? "kmStatus in (1, 2)" : "kmStatus = " + status;
        try {
            String rowQuery = "select sum(unreadCount) from channel where " + statusQuery;
            if (status != 3) {
                String contactCountQuery = "select sum(unreadCount) from contact";
                contactCountCursor = db.rawQuery(contactCountQuery, null);
                contactCountCursor.moveToFirst();
                if (contactCountCursor.getCount() > 0) {
                    count += contactCountCursor.getInt(0);
                }
            }
            cursor = db.rawQuery(rowQuery, null);
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                count += cursor.getInt(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.close();
            this.dbHelper.close();
            if (cursor != null) {
                cursor.close();
            }
            if (contactCountCursor != null) {
                contactCountCursor.close();
            }
        }
        return count;
    }

    public String deleteMessage(Message message, String contactNumber) {
        if (!message.isSentToServer()) {
            this.deleteMessageFromDb(message);
        } else if (this.isMessagePresent(message.getKeyString(), Message.ReplyMessage.REPLY_MESSAGE.getValue())) {
            this.updateReplyFlag(message.getKeyString(), Message.ReplyMessage.HIDE_MESSAGE.getValue());
        } else if (!this.isMessagePresent(message.getKeyString(), Message.ReplyMessage.HIDE_MESSAGE.getValue())) {
            this.deleteMessageFromDb(message);
        }
        return null;
    }

    public void deleteMessageFromDb(Message message) {
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            database.delete("sms", "keyString='" + message.getKeyString() + "'", null);
            this.dbHelper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteConversation(String contactNumber) {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Deleting conversation for contactNumber: " + contactNumber));
        int deletedRows = this.dbHelper.getWritableDatabase().delete("sms", "contactNumbers=? AND channelKey = 0", new String[]{contactNumber});
        this.updateContactUnreadCountToZero(contactNumber);
        this.dbHelper.close();
        Utils.printLog((Context)this.context, (String)TAG, (String)("Delete " + deletedRows + " messages."));
    }

    public void deleteChannelConversation(Integer channelKey) {
        Utils.printLog((Context)this.context, (String)TAG, (String)("Deleting  Conversation for channel: " + channelKey));
        int deletedRows = this.dbHelper.getWritableDatabase().delete("sms", "channelKey=?", new String[]{String.valueOf(channelKey)});
        this.updateChannelUnreadCountToZero(channelKey);
        this.dbHelper.close();
        Utils.printLog((Context)this.context, (String)TAG, (String)("Delete " + deletedRows + " messages."));
    }

    public synchronized void updateContactUnreadCount(String userId) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE contact SET unreadCount = unreadCount + 1 WHERE userId ='" + userId + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateChannelUnreadCount(Integer channelKey) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE channel SET unreadCount = unreadCount + 1 WHERE channelKey ='" + channelKey + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateChannelUnreadCountToZero(Integer channelKey) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE channel SET unreadCount = 0 WHERE channelKey ='" + channelKey + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateContactUnreadCountToZero(String userId) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE contact SET unreadCount = 0 WHERE userId ='" + userId + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateReplyFlag(String messageKey, int isReplyMessage) {
        ContentValues values = new ContentValues();
        values.put("replyMessage", Integer.valueOf(isReplyMessage));
        int updatedMessage = this.dbHelper.getWritableDatabase().update("sms", values, " keyString = '" + messageKey + "'", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageReplyType(String messageKey, Integer replyMessage) {
        try {
            ContentValues values = new ContentValues();
            values.put("replyMessage", replyMessage);
            this.dbHelper.getWritableDatabase().update("sms", values, "keyString = ?", new String[]{messageKey});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalUnreadCount() {
        Cursor channelCursor = null;
        Cursor contactCursor = null;
        int totalCount = 0;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            contactCursor = db.rawQuery("SELECT * FROM contact WHERE unreadCount > 0 ", null);
            channelCursor = db.rawQuery("SELECT * FROM channel WHERE unreadCount > 0 ", null);
            if (contactCursor.moveToFirst()) {
                do {
                    totalCount += contactCursor.getInt(contactCursor.getColumnIndex("unreadCount"));
                } while (contactCursor.moveToNext());
            }
            if (channelCursor.moveToFirst()) {
                do {
                    totalCount += channelCursor.getInt(channelCursor.getColumnIndex("unreadCount"));
                } while (channelCursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (channelCursor != null) {
                channelCursor.close();
            }
            if (contactCursor != null) {
                contactCursor.close();
            }
        }
        return totalCount;
    }

    public List<Message> getAttachmentMessages(String contactId, Integer groupId, boolean downloadedOnly) {
        if (contactId == null && (groupId == null || groupId == 0)) {
            return new ArrayList<Message>();
        }
        String query = "SELECT * FROM sms WHERE ";
        String params = "";
        if (groupId != null && groupId != 0) {
            params = "channelKey = " + groupId + " AND";
        } else if (contactId != null) {
            params = "contactNumbers = '" + contactId + "' AND";
        }
        String selectionArgs = (downloadedOnly ? " filePaths" : " blobKeyString") + " IS NOT NULL ORDER BY createdAt DESC";
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query + params + selectionArgs, null);
        return MessageDatabaseService.getMessageList(cursor);
    }

    public void updateMessageMetadata(String keyString, Map<String, String> metadata) {
        ContentValues values = new ContentValues();
        if (this.isMessagePresent(keyString)) {
            values.put("metadata", GsonUtils.getJsonFromObject(metadata, Map.class));
            this.dbHelper.getWritableDatabase().update("sms", values, "keyString='" + keyString + "'", null);
        }
        this.dbHelper.close();
    }
}

