/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.register;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.conversation.ApplozicMqttIntentService;
import com.applozic.mobicomkit.api.conversation.ConversationIntentService;
import com.applozic.mobicomkit.api.notification.NotificationChannels;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicommons.ALSpecificSettings;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.gson.Gson;
import java.net.ConnectException;
import java.util.TimeZone;

public class RegisterUserClientService
extends MobiComKitClientService {
    public static final String CREATE_ACCOUNT_URL = "/rest/ws/register/client?";
    public static final String UPDATE_ACCOUNT_URL = "/rest/ws/register/update?";
    public static final String CHECK_PRICING_PACKAGE = "/rest/ws/application/pricing/package";
    public static final Short MOBICOMKIT_VERSION_CODE = 111;
    private static final String TAG = "RegisterUserClient";
    private static final String INVALID_APP_ID = "INVALID_APPLICATIONID";
    private HttpRequestUtils httpRequestUtils;

    public RegisterUserClientService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        ApplozicService.initWithContext((Context)context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getCreateAccountUrl() {
        return this.getBaseUrl() + CREATE_ACCOUNT_URL;
    }

    public String getPricingPackageUrl() {
        return this.getBaseUrl() + CHECK_PRICING_PACKAGE;
    }

    public String getUpdateAccountUrl() {
        return this.getBaseUrl() + UPDATE_ACCOUNT_URL;
    }

    public RegistrationResponse createAccount(User user) throws Exception {
        user.setDeviceType(Short.valueOf("1"));
        user.setPrefContactAPI(Short.valueOf("2"));
        user.setTimezone(TimeZone.getDefault().getID());
        user.setEnableEncryption(user.isEnableEncryption());
        if (!TextUtils.isEmpty((CharSequence)user.getAlBaseUrl())) {
            ALSpecificSettings.getInstance((Context)this.context).setAlBaseUrl(user.getAlBaseUrl());
        }
        if (!TextUtils.isEmpty((CharSequence)user.getKmBaseUrl())) {
            ALSpecificSettings.getInstance((Context)this.context).setKmBaseUrl(user.getKmBaseUrl());
        }
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        Gson gson = new Gson();
        user.setAppVersionCode(MOBICOMKIT_VERSION_CODE);
        user.setApplicationId(RegisterUserClientService.getApplicationKey(this.context));
        user.setRegistrationId(mobiComUserPreference.getDeviceRegistrationId());
        if (RegisterUserClientService.getAppModuleName(this.context) != null) {
            user.setAppModuleName(RegisterUserClientService.getAppModuleName(this.context));
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("Net status" + Utils.isInternetAvailable((Context)this.context.getApplicationContext())));
        if (!Utils.isInternetAvailable((Context)this.context.getApplicationContext())) {
            throw new ConnectException("No Internet Connection");
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("Registration json " + gson.toJson((Object)user)));
        String response = this.httpRequestUtils.postJsonToServer(this.getCreateAccountUrl(), gson.toJson((Object)user));
        Utils.printLog((Context)this.context, (String)TAG, (String)("Registration response is: " + response));
        if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html")) {
            throw new Exception("503 Service Unavailable");
        }
        RegistrationResponse registrationResponse = (RegistrationResponse)((Object)gson.fromJson(response, RegistrationResponse.class));
        if (registrationResponse.isRegistrationSuccess()) {
            Utils.printLog((Context)this.context, (String)"Registration response ", (String)("is " + (Object)((Object)registrationResponse)));
            if (registrationResponse.getNotificationResponse() != null) {
                Utils.printLog((Context)this.context, (String)"Registration response ", (String)("" + registrationResponse.getNotificationResponse()));
            }
            mobiComUserPreference.setEncryptionKey(registrationResponse.getEncryptionKey());
            mobiComUserPreference.enableEncryption(user.isEnableEncryption());
            mobiComUserPreference.setCountryCode(user.getCountryCode());
            mobiComUserPreference.setUserId(user.getUserId());
            mobiComUserPreference.setContactNumber(user.getContactNumber());
            mobiComUserPreference.setEmailVerified(user.isEmailVerified());
            mobiComUserPreference.setDisplayName(user.getDisplayName());
            mobiComUserPreference.setMqttBrokerUrl(registrationResponse.getBrokerUrl());
            mobiComUserPreference.setDeviceKeyString(registrationResponse.getDeviceKey());
            mobiComUserPreference.setEmailIdValue(user.getEmail());
            mobiComUserPreference.setImageLink(user.getImageLink());
            mobiComUserPreference.setSuUserKeyString(registrationResponse.getUserKey());
            mobiComUserPreference.setLastSyncTimeForMetadataUpdate(String.valueOf(registrationResponse.getCurrentTimeStamp()));
            mobiComUserPreference.setLastSyncTime(String.valueOf(registrationResponse.getCurrentTimeStamp()));
            mobiComUserPreference.setLastSeenAtSyncTime(String.valueOf(registrationResponse.getCurrentTimeStamp()));
            mobiComUserPreference.setChannelSyncTime(String.valueOf(registrationResponse.getCurrentTimeStamp()));
            mobiComUserPreference.setUserBlockSyncTime("10000");
            ApplozicClient.getInstance(this.context).skipDeletedGroups(user.isSkipDeletedGroups());
            if (!TextUtils.isEmpty((CharSequence)registrationResponse.getUserEncryptionKey())) {
                mobiComUserPreference.setUserEncryptionKey(registrationResponse.getUserEncryptionKey());
            }
            mobiComUserPreference.setPassword(user.getPassword());
            mobiComUserPreference.setPricingPackage(registrationResponse.getPricingPackage().shortValue());
            mobiComUserPreference.setAuthenticationType(String.valueOf(user.getAuthenticationTypeId()));
            if (registrationResponse.getRoleType() != null) {
                mobiComUserPreference.setUserRoleType(registrationResponse.getRoleType());
            }
            if (user.getUserTypeId() != null) {
                mobiComUserPreference.setUserTypeId(String.valueOf(user.getUserTypeId()));
            }
            if (!TextUtils.isEmpty((CharSequence)user.getNotificationSoundFilePath())) {
                Applozic.getInstance(this.context).setCustomNotificationSound(user.getNotificationSoundFilePath());
            }
            Contact contact = new Contact();
            contact.setUserId(user.getUserId());
            contact.setFullName(registrationResponse.getDisplayName());
            contact.setImageURL(registrationResponse.getImageLink());
            contact.setContactNumber(registrationResponse.getContactNumber());
            if (user.getUserTypeId() != null) {
                contact.setUserTypeId(user.getUserTypeId());
            }
            contact.setRoleType(user.getRoleType());
            contact.setMetadata(user.getMetadata());
            contact.setStatus(registrationResponse.getStatusMessage());
            if (Build.VERSION.SDK_INT >= 26) {
                Applozic.getInstance(this.context).setNotificationChannelVersion(NotificationChannels.NOTIFICATION_CHANNEL_VERSION - 1);
                new NotificationChannels(this.context, Applozic.getInstance(this.context).getCustomNotificationSound()).prepareNotificationChannels();
            }
            contact.processContactNumbers(this.context);
            new AppContactService(this.context).upsert(contact);
            Intent conversationIntentService = new Intent(this.context, ConversationIntentService.class);
            conversationIntentService.putExtra("AL_SYNC", false);
            ConversationIntentService.enqueueWork(this.context, conversationIntentService);
            Intent mutedUserListService = new Intent(this.context, ConversationIntentService.class);
            mutedUserListService.putExtra("MutedUserListSync", true);
            ConversationIntentService.enqueueWork(this.context, mutedUserListService);
            Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
            intent.putExtra("connectedPublish", true);
            ApplozicMqttIntentService.enqueueWork(this.context, intent);
        }
        return registrationResponse;
    }

    public RegistrationResponse createAccount(String email, String userId, String phoneNumber, String displayName, String imageLink, String pushNotificationId) throws Exception {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        String url = mobiComUserPreference.getUrl();
        mobiComUserPreference.clearAll();
        mobiComUserPreference.setUrl(url);
        return this.updateAccount(email, userId, phoneNumber, displayName, imageLink, pushNotificationId);
    }

    private RegistrationResponse updateAccount(String email, String userId, String phoneNumber, String displayName, String imageLink, String pushNotificationId) throws Exception {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        User user = new User();
        user.setUserId(userId);
        user.setEmail(email);
        user.setImageLink(imageLink);
        user.setRegistrationId(pushNotificationId);
        user.setDisplayName(displayName);
        user.setContactNumber(phoneNumber);
        RegistrationResponse registrationResponse = this.createAccount(user);
        Intent intent = new Intent(this.context, ApplozicMqttIntentService.class);
        intent.putExtra("connectedPublish", true);
        ApplozicMqttIntentService.enqueueWork(this.context, intent);
        return registrationResponse;
    }

    public RegistrationResponse updatePushNotificationId(String pushNotificationId) throws Exception {
        MobiComUserPreference pref = MobiComUserPreference.getInstance(this.context);
        RegistrationResponse registrationResponse = null;
        User user = this.getUserDetail();
        if (!TextUtils.isEmpty((CharSequence)pushNotificationId)) {
            pref.setDeviceRegistrationId(pushNotificationId);
        }
        user.setRegistrationId(pushNotificationId);
        if (pref.isRegistered()) {
            registrationResponse = this.updateRegisteredAccount(user);
        }
        return registrationResponse;
    }

    public RegistrationResponse updateRegisteredAccount(User user) throws Exception {
        RegistrationResponse registrationResponse = null;
        user.setDeviceType(Short.valueOf("1"));
        user.setPrefContactAPI(Short.valueOf("2"));
        user.setTimezone(TimeZone.getDefault().getID());
        if (!TextUtils.isEmpty((CharSequence)user.getAlBaseUrl())) {
            ALSpecificSettings.getInstance((Context)this.context).setAlBaseUrl(user.getAlBaseUrl());
        }
        if (!TextUtils.isEmpty((CharSequence)user.getKmBaseUrl())) {
            ALSpecificSettings.getInstance((Context)this.context).setKmBaseUrl(user.getKmBaseUrl());
        }
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        Gson gson = new Gson();
        user.setEnableEncryption(mobiComUserPreference.isEncryptionEnabled());
        user.setAppVersionCode(MOBICOMKIT_VERSION_CODE);
        user.setApplicationId(RegisterUserClientService.getApplicationKey(this.context));
        user.setAuthenticationTypeId(Short.valueOf(mobiComUserPreference.getAuthenticationType()));
        if (!TextUtils.isEmpty((CharSequence)mobiComUserPreference.getUserTypeId())) {
            user.setUserTypeId(Short.valueOf(mobiComUserPreference.getUserTypeId()));
        }
        if (RegisterUserClientService.getAppModuleName(this.context) != null) {
            user.setAppModuleName(RegisterUserClientService.getAppModuleName(this.context));
        }
        if (!TextUtils.isEmpty((CharSequence)mobiComUserPreference.getDeviceRegistrationId())) {
            user.setRegistrationId(mobiComUserPreference.getDeviceRegistrationId());
        }
        Utils.printLog((Context)this.context, (String)TAG, (String)("Registration update json " + gson.toJson((Object)user)));
        String response = this.httpRequestUtils.postJsonToServer(this.getUpdateAccountUrl(), gson.toJson((Object)user));
        if (TextUtils.isEmpty((CharSequence)response) || response.contains("<html")) {
            throw null;
        }
        registrationResponse = (RegistrationResponse)((Object)gson.fromJson(response, RegistrationResponse.class));
        Utils.printLog((Context)this.context, (String)TAG, (String)("Registration update response: " + (Object)((Object)registrationResponse)));
        mobiComUserPreference.setPricingPackage(registrationResponse.getPricingPackage().shortValue());
        if (registrationResponse.getNotificationResponse() != null) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Notification response: " + registrationResponse.getNotificationResponse()));
        }
        return registrationResponse;
    }

    private User getUserDetail() {
        MobiComUserPreference pref = MobiComUserPreference.getInstance(this.context);
        User user = new User();
        user.setEmail(pref.getEmailIdValue());
        user.setUserId(pref.getUserId());
        user.setContactNumber(pref.getContactNumber());
        user.setDisplayName(pref.getDisplayName());
        user.setImageLink(pref.getImageLink());
        user.setRoleType(pref.getUserRoleType());
        return user;
    }

    public void syncAccountStatus() {
        try {
            String response = this.httpRequestUtils.getResponse(this.getPricingPackageUrl(), "application/json", "application/json");
            Utils.printLog((Context)this.context, (String)TAG, (String)("Pricing package response: " + response));
            ApiResponse apiResponse = (ApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, ApiResponse.class));
            if (apiResponse.getResponse() != null) {
                int pricingPackage = Integer.parseInt(apiResponse.getResponse().toString());
                MobiComUserPreference.getInstance(this.context).setPricingPackage(pricingPackage);
            }
        }
        catch (Exception e) {
            Utils.printLog((Context)this.context, (String)TAG, (String)"Account status sync call failed");
        }
    }
}

