/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.channel.service;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.api.notification.MuteNotificationRequest;
import com.applozic.mobicomkit.api.people.AlGetPeopleTask;
import com.applozic.mobicomkit.api.people.ChannelInfo;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.channel.database.ChannelDatabaseService;
import com.applozic.mobicomkit.channel.service.ChannelClientService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.AlResponse;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicomkit.feed.ChannelFeedApiResponse;
import com.applozic.mobicomkit.feed.ChannelFeedListResponse;
import com.applozic.mobicomkit.feed.ChannelUsersFeed;
import com.applozic.mobicomkit.feed.GroupInfoUpdate;
import com.applozic.mobicomkit.listners.AlChannelListener;
import com.applozic.mobicomkit.sync.SyncChannelFeed;
import com.applozic.mobicommons.ApplozicService;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.ChannelUserMapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChannelService {
    public static boolean isUpdateTitle = false;
    private static ChannelService channelService;
    public Context context;
    private ChannelDatabaseService channelDatabaseService;
    private ChannelClientService channelClientService;
    private BaseContactService baseContactService;
    private UserService userService;

    private ChannelService(Context context) {
        this.context = ApplozicService.getContext((Context)context);
        this.channelClientService = ChannelClientService.getInstance(ApplozicService.getContext((Context)context));
        this.channelDatabaseService = ChannelDatabaseService.getInstance(ApplozicService.getContext((Context)context));
        this.userService = UserService.getInstance(ApplozicService.getContext((Context)context));
        this.baseContactService = new AppContactService(ApplozicService.getContext((Context)context));
    }

    public static synchronized ChannelService getInstance(Context context) {
        if (channelService == null) {
            channelService = new ChannelService(ApplozicService.getContext((Context)context));
        }
        return channelService;
    }

    @VisibleForTesting
    public void setChannelClientService(ChannelClientService channelClientService) {
        this.channelClientService = channelClientService;
    }

    @VisibleForTesting
    public void setChannelDatabaseService(ChannelDatabaseService channelDatabaseService) {
        this.channelDatabaseService = channelDatabaseService;
    }

    @VisibleForTesting
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @VisibleForTesting
    public void setContactService(AppContactService appContactService) {
        this.baseContactService = appContactService;
    }

    public Channel getChannelInfoFromLocalDb(Integer key) {
        return this.channelDatabaseService.getChannelByChannelKey(key);
    }

    public Channel getChannelInfo(Integer key) {
        ChannelFeed channelFeed;
        if (key == null) {
            return null;
        }
        Channel channel = this.channelDatabaseService.getChannelByChannelKey(key);
        if (channel == null && (channelFeed = this.channelClientService.getChannelInfo(key)) != null) {
            channelFeed.setUnreadCount(0);
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds, false);
            channel = this.getChannel(channelFeed);
            return channel;
        }
        return channel;
    }

    public Channel getChannelInfo(String clientGroupId) {
        ChannelFeed channelFeed;
        if (TextUtils.isEmpty((CharSequence)clientGroupId)) {
            return null;
        }
        Channel channel = this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
        if (channel == null && (channelFeed = this.channelClientService.getChannelInfo(clientGroupId)) != null) {
            channelFeed.setUnreadCount(0);
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds, false);
            channel = this.getChannel(channelFeed);
            return channel;
        }
        return channel;
    }

    public void createMultipleChannels(List<ChannelInfo> channelInfo) {
        List<ChannelFeed> channelFeeds = this.channelClientService.createMultipleChannels(channelInfo);
        if (channelFeeds != null) {
            this.processChannelList(channelFeeds);
        }
    }

    public void processChannelFeedList(ChannelFeed[] channelFeeds, boolean isUserDetails) {
        if (channelFeeds != null && channelFeeds.length > 0) {
            for (ChannelFeed channelFeed : channelFeeds) {
                this.processChannelFeed(channelFeed, isUserDetails);
            }
        }
    }

    public void processChannelFeed(ChannelFeed channelFeed, boolean isUserDetails) {
        if (channelFeed != null) {
            Set<String> memberUserIds = null;
            memberUserIds = channelFeed.getMembersName() != null ? channelFeed.getMembersName() : channelFeed.getContactGroupMembersId();
            Channel channel = this.getChannel(channelFeed);
            if (this.channelDatabaseService.isChannelPresent(channel.getKey())) {
                this.channelDatabaseService.updateChannel(channel);
            } else {
                this.channelDatabaseService.addChannel(channel);
            }
            if (channelFeed.getConversationPxy() != null) {
                channelFeed.getConversationPxy().setGroupId(channelFeed.getId());
                ConversationService.getInstance(this.context).addConversation(channelFeed.getConversationPxy());
            }
            if (memberUserIds != null && memberUserIds.size() > 0) {
                for (String userId : memberUserIds) {
                    ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelFeed.getId(), userId);
                    channelUserMapper.setParentKey(channelFeed.getParentKey());
                    if (this.channelDatabaseService.isChannelUserPresent(channelFeed.getId(), userId)) {
                        this.channelDatabaseService.updateChannelUserMapper(channelUserMapper);
                        continue;
                    }
                    this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
                }
            }
            if (isUserDetails) {
                this.userService.processUserDetail(channelFeed.getUsers());
            }
            if (channelFeed.getGroupUsers() != null && channelFeed.getGroupUsers().size() > 0) {
                for (ChannelUsersFeed channelUsers : channelFeed.getGroupUsers()) {
                    if (channelUsers.getRole() == null) continue;
                    this.channelDatabaseService.updateRoleInChannelUserMapper(channelFeed.getId(), channelUsers.getUserId(), channelUsers.getRole());
                }
            }
            if (channelFeed.getChildKeys() != null && channelFeed.getChildKeys().size() > 0) {
                this.processChildGroupKeys(channelFeed.getChildKeys());
            }
        }
    }

    public synchronized Channel getChannelByChannelKey(Integer channelKey) {
        if (channelKey == null) {
            return null;
        }
        return this.channelDatabaseService.getChannelByChannelKey(channelKey);
    }

    public List<ChannelUserMapper> getListOfUsersFromChannelUserMapper(Integer channelKey) {
        return this.channelDatabaseService.getChannelUserList(channelKey);
    }

    public Channel getChannel(Integer channelKey) {
        Channel channel = this.channelDatabaseService.getChannelByChannelKey(channelKey);
        if (channel == null) {
            channel = new Channel(channelKey);
        }
        return channel;
    }

    public void updateChannel(Channel channel) {
        if (this.channelDatabaseService.getChannelByChannelKey(channel.getKey()) == null) {
            this.channelDatabaseService.addChannel(channel);
        } else {
            this.channelDatabaseService.updateChannel(channel);
        }
    }

    public List<Channel> getChannelList() {
        return this.channelDatabaseService.getAllChannels();
    }

    public synchronized void syncChannels(boolean isMetadataUpdate) {
        MobiComUserPreference userpref = MobiComUserPreference.getInstance(this.context);
        SyncChannelFeed syncChannelFeed = this.channelClientService.getChannelFeed(userpref.getChannelSyncTime());
        if (syncChannelFeed == null) {
            return;
        }
        if (syncChannelFeed.isSuccess()) {
            this.processChannelList(syncChannelFeed.getResponse());
            BroadcastService.sendUpdate(this.context, isMetadataUpdate, BroadcastService.INTENT_ACTIONS.CHANNEL_SYNC.toString());
        }
        userpref.setChannelSyncTime(syncChannelFeed.getGeneratedAt());
    }

    public synchronized void syncChannels() {
        this.syncChannels(false);
    }

    public synchronized AlResponse createChannel(ChannelInfo channelInfo) {
        if (channelInfo == null) {
            return null;
        }
        AlResponse alResponse = new AlResponse();
        ChannelFeedApiResponse channelFeedResponse = null;
        try {
            channelFeedResponse = this.channelClientService.createChannelWithResponse(channelInfo);
            if (channelFeedResponse == null) {
                return null;
            }
            if (channelFeedResponse.isSuccess()) {
                alResponse.setStatus("success");
                ChannelFeed channelFeed = channelFeedResponse.getResponse();
                if (channelFeed != null) {
                    ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                    this.processChannelFeedList(channelFeeds, true);
                    alResponse.setResponse(this.getChannel(channelFeed));
                }
            } else {
                alResponse.setStatus("error");
                alResponse.setResponse(channelFeedResponse.getErrorResponse());
            }
        }
        catch (Exception e) {
            alResponse.setStatus("error");
            alResponse.setException(e);
        }
        return alResponse;
    }

    public Channel getChannel(ChannelFeed channelFeed) {
        Channel channel = new Channel(channelFeed.getId(), channelFeed.getName(), channelFeed.getAdminName(), Short.valueOf(channelFeed.getType()), channelFeed.getUnreadCount(), channelFeed.getImageUrl());
        channel.setClientGroupId(channelFeed.getClientGroupId());
        channel.setNotificationAfterTime(channelFeed.getNotificationAfterTime());
        channel.setDeletedAtTime(channelFeed.getDeletedAtTime());
        channel.setMetadata(channelFeed.getMetadata());
        channel.setParentKey(channelFeed.getParentKey());
        channel.setParentClientGroupId(channelFeed.getParentClientGroupId());
        channel.setKmStatus(channel.generateKmStatus(MobiComUserPreference.getInstance(this.context).getUserId()));
        return channel;
    }

    public String removeMemberFromChannelProcess(Integer channelKey, String userId) {
        if (channelKey == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.removeMemberFromChannel(channelKey, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.removeMemberFromChannel(channelKey, userId);
        }
        return apiResponse.getStatus();
    }

    public String removeMemberFromChannelProcess(String clientGroupId, String userId) {
        if (clientGroupId == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.removeMemberFromChannel(clientGroupId, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.removeMemberFromChannel(clientGroupId, userId);
        }
        return apiResponse.getStatus();
    }

    @Deprecated
    public String addMemberToChannelProcess(Integer channelKey, String userId) {
        if (channelKey == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(channelKey, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelKey, userId);
            this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
        }
        return apiResponse.getStatus();
    }

    @Deprecated
    public String addMemberToChannelProcess(String clientGroupId, String userId) {
        if (TextUtils.isEmpty((CharSequence)clientGroupId) && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(clientGroupId, userId);
        if (apiResponse == null) {
            return null;
        }
        return apiResponse.getStatus();
    }

    public ApiResponse addMemberToChannelProcessWithResponse(String clientGroupId, String userId) {
        if (TextUtils.isEmpty((CharSequence)clientGroupId) && TextUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(clientGroupId, userId);
        if (apiResponse == null) {
            return null;
        }
        return apiResponse;
    }

    public ApiResponse addMemberToChannelProcessWithResponse(Integer channelKey, String userId) {
        if (channelKey == null && TextUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(channelKey, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelKey, userId);
            this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
        }
        return apiResponse;
    }

    public String addMemberToMultipleChannelsProcess(Set<String> clientGroupIds, String userId) {
        if (clientGroupIds == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToMultipleChannelsByClientGroupIds(clientGroupIds, userId);
        if (apiResponse == null) {
            return null;
        }
        return apiResponse.getStatus();
    }

    public String addMemberToMultipleChannelsProcessByChannelKeys(Set<Integer> channelKeys, String userId) {
        if (channelKeys == null && TextUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToMultipleChannelsByChannelKey(channelKeys, userId);
        if (apiResponse == null) {
            return null;
        }
        return apiResponse.getStatus();
    }

    public String leaveMemberFromChannelProcess(String clientGroupId, String userId) {
        if (TextUtils.isEmpty((CharSequence)clientGroupId)) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.leaveMemberFromChannel(clientGroupId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.leaveMemberFromChannel(clientGroupId, userId);
        }
        return apiResponse.getStatus();
    }

    public String leaveMemberFromChannelProcess(Integer channelKey, String userId) {
        if (channelKey == null) {
            return "";
        }
        ApiResponse apiResponse = this.channelClientService.leaveMemberFromChannel(channelKey);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.leaveMemberFromChannel(channelKey, userId);
        }
        return apiResponse.getStatus();
    }

    public String updateChannel(GroupInfoUpdate groupInfoUpdate) {
        if (groupInfoUpdate == null) {
            return null;
        }
        ApiResponse apiResponse = this.channelClientService.updateChannel(groupInfoUpdate);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.updateChannel(groupInfoUpdate);
        }
        return apiResponse.getStatus();
    }

    public synchronized String createConversation(Integer groupId, String userId, String agentId, String applicationId) {
        return this.channelClientService.createConversation(groupId, userId, agentId, applicationId);
    }

    public synchronized void processChannelList(List<ChannelFeed> channelFeedList) {
        if (channelFeedList != null && channelFeedList.size() > 0) {
            for (ChannelFeed channelFeed : channelFeedList) {
                this.processChannelFeedForSync(channelFeed);
            }
        }
    }

    public ChannelUserMapper getChannelUserMapper(Integer channelKey) {
        return this.channelDatabaseService.getChannelUserByChannelKey(channelKey);
    }

    public void updateRoleInChannelUserMapper(Integer channelKey, String userId, Integer role) {
        this.channelDatabaseService.updateRoleInChannelUserMapper(channelKey, userId, role);
    }

    public ChannelUserMapper getChannelUserMapperByUserId(Integer channelKey, String userId) {
        return this.channelDatabaseService.getChannelUserByChannelKeyAndUserId(channelKey, userId);
    }

    public synchronized boolean processIsUserPresentInChannel(Integer channelKey) {
        return this.channelDatabaseService.isChannelUserPresent(channelKey, MobiComUserPreference.getInstance(this.context).getUserId());
    }

    public synchronized boolean isUserAlreadyPresentInChannel(Integer channelKey, String userId) {
        return this.channelDatabaseService.isChannelUserPresent(channelKey, userId);
    }

    public synchronized boolean processIsUserPresentInChannel(String clientGroupId) {
        Channel channel = this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
        return this.channelDatabaseService.isChannelUserPresent(channel.getKey(), MobiComUserPreference.getInstance(this.context).getUserId());
    }

    public synchronized boolean isUserAlreadyPresentInChannel(String clientGroupId, String userId) {
        Channel channel = this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
        return this.channelDatabaseService.isChannelUserPresent(channel.getKey(), userId);
    }

    public synchronized String processChannelDeleteConversation(Channel channel, Context context) {
        String response = new MobiComConversationService(context).deleteSync(null, channel, null);
        if (!TextUtils.isEmpty((CharSequence)response) && "success".equals(response)) {
            this.channelDatabaseService.deleteChannelUserMappers(channel.getKey());
            this.channelDatabaseService.deleteChannel(channel.getKey());
        }
        return response;
    }

    public void updateChannelLocalImageURI(Integer channelKey, String localImageURI) {
        this.channelDatabaseService.updateChannelLocalImageURI(channelKey, localImageURI);
    }

    public ApiResponse muteNotifications(MuteNotificationRequest muteNotificationRequest) {
        ApiResponse apiResponse = this.channelClientService.muteNotification(muteNotificationRequest);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            this.channelDatabaseService.updateNotificationAfterTime(muteNotificationRequest.getId(), muteNotificationRequest.getNotificationAfterTime());
        }
        return apiResponse;
    }

    public Channel getChannelByClientGroupId(String clientGroupId) {
        if (TextUtils.isEmpty((CharSequence)clientGroupId)) {
            return null;
        }
        return this.channelDatabaseService.getChannelByClientGroupId(clientGroupId);
    }

    public ChannelFeedApiResponse createChannelWithResponse(ChannelInfo channelInfo) {
        ChannelFeed channelFeed;
        ChannelFeedApiResponse channelFeedApiResponse = this.channelClientService.createChannelWithResponse(channelInfo);
        if (channelFeedApiResponse == null) {
            return null;
        }
        if (channelFeedApiResponse.isSuccess() && (channelFeed = channelFeedApiResponse.getResponse()) != null) {
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds, true);
        }
        return channelFeedApiResponse;
    }

    public ApiResponse addMemberToChannelWithResponseProcess(Integer channelKey, String userId) {
        if (channelKey == null && TextUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        ApiResponse apiResponse = this.channelClientService.addMemberToChannel(channelKey, userId);
        if (apiResponse == null) {
            return null;
        }
        if (apiResponse.isSuccess()) {
            ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelKey, userId);
            this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
        }
        return apiResponse;
    }

    public String getGroupOfTwoReceiverUserId(Integer channelKey) {
        return this.channelDatabaseService.getGroupOfTwoReceiverId(channelKey);
    }

    @Deprecated
    public Channel createGroupOfTwo(ChannelInfo channelInfo) {
        if (channelInfo == null) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)channelInfo.getClientGroupId())) {
            Channel channel = this.channelDatabaseService.getChannelByClientGroupId(channelInfo.getClientGroupId());
            if (channel != null) {
                return channel;
            }
            ChannelFeedApiResponse channelFeedApiResponse = this.channelClientService.createChannelWithResponse(channelInfo);
            if (channelFeedApiResponse == null) {
                return null;
            }
            if (channelFeedApiResponse.isSuccess()) {
                ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
                if (channelFeed != null) {
                    ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                    this.processChannelFeedList(channelFeeds, true);
                    return this.getChannel(channelFeed);
                }
            } else {
                ChannelFeed channelFeed = this.channelClientService.getChannelInfo(channelInfo.getClientGroupId());
                if (channelFeed != null) {
                    ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                    this.processChannelFeedList(channelFeeds, false);
                    return this.getChannel(channelFeed);
                }
            }
        }
        return null;
    }

    public AlResponse createGroupOfTwoWithResponse(ChannelInfo channelInfo) {
        if (channelInfo == null) {
            return null;
        }
        AlResponse alResponse = new AlResponse();
        if (!TextUtils.isEmpty((CharSequence)channelInfo.getClientGroupId())) {
            Channel channel = this.channelDatabaseService.getChannelByClientGroupId(channelInfo.getClientGroupId());
            if (channel != null) {
                alResponse.setStatus("success");
                alResponse.setResponse(channel);
            } else {
                ChannelFeedApiResponse channelFeedApiResponse = this.channelClientService.createChannelWithResponse(channelInfo);
                if (channelFeedApiResponse == null) {
                    alResponse.setStatus("error");
                } else if (channelFeedApiResponse.isSuccess()) {
                    ChannelFeed channelFeed = channelFeedApiResponse.getResponse();
                    if (channelFeed != null) {
                        ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                        this.processChannelFeedList(channelFeeds, true);
                        alResponse.setStatus("success");
                        alResponse.setResponse(this.getChannel(channelFeed));
                    }
                } else {
                    ChannelFeed channelFeed = this.channelClientService.getChannelInfo(channelInfo.getClientGroupId());
                    if (channelFeed != null) {
                        ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                        this.processChannelFeedList(channelFeeds, false);
                        alResponse.setStatus("success");
                        alResponse.setResponse(this.getChannel(channelFeed));
                    }
                }
            }
        }
        return alResponse;
    }

    public List<ChannelFeed> getGroupInfoFromGroupIds(List<String> groupIds) {
        return this.getGroupInfoFromGroupIds(groupIds, null);
    }

    public List<ChannelFeed> getGroupInfoFromClientGroupIds(List<String> clientGroupIds) {
        return this.getGroupInfoFromGroupIds(null, clientGroupIds);
    }

    public List<String> getChildGroupKeys(Integer parentGroupKey) {
        return this.channelDatabaseService.getChildGroupIds(parentGroupKey);
    }

    public List<ChannelFeed> getGroupInfoFromGroupIds(List<String> groupIds, List<String> clientGroupIds) {
        ChannelFeedListResponse channelFeedList = this.channelClientService.getGroupInfoFromGroupIds(groupIds, clientGroupIds);
        if (channelFeedList == null) {
            return null;
        }
        if (channelFeedList != null && "success".equals(channelFeedList.getStatus())) {
            this.processChannelFeedList(channelFeedList.getResponse().toArray(new ChannelFeed[channelFeedList.getResponse().size()]), false);
        }
        return channelFeedList.getResponse();
    }

    public boolean addMemberToContactGroup(String contactGroupId, String groupType, List<String> contactGroupMemberList) {
        ApiResponse apiResponse = null;
        if (!TextUtils.isEmpty((CharSequence)contactGroupId) && contactGroupMemberList != null) {
            apiResponse = !TextUtils.isEmpty((CharSequence)groupType) ? this.channelClientService.addMemberToContactGroupOfType(contactGroupId, groupType, contactGroupMemberList) : this.channelClientService.addMemberToContactGroup(contactGroupId, contactGroupMemberList);
        }
        if (apiResponse == null) {
            return false;
        }
        return apiResponse.isSuccess();
    }

    public ChannelFeed getMembersFromContactGroup(String contactGroupId, String groupType) {
        ChannelFeed channelFeed = null;
        if (!TextUtils.isEmpty((CharSequence)contactGroupId)) {
            channelFeed = !TextUtils.isEmpty((CharSequence)groupType) ? this.channelClientService.getMembersFromContactGroupOfType(contactGroupId, groupType) : this.channelClientService.getMembersFromContactGroup(contactGroupId);
        }
        if (channelFeed != null) {
            ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
            this.processChannelFeedList(channelFeeds, false);
            UserService.getInstance(this.context).processUserDetails(channelFeed.getContactGroupMembersId());
            return channelFeed;
        }
        return null;
    }

    public ChannelFeed[] getMembersFromContactGroupList(List<String> groupIdList, List<String> groupNames, String groupType) {
        ChannelFeedListResponse channelFeedListResponse = this.channelClientService.getMemebersFromContactGroupIds(groupIdList, groupNames, groupType);
        if (channelFeedListResponse != null && channelFeedListResponse.getStatus().equals("success")) {
            List<ChannelFeed> channelFeedList = channelFeedListResponse.getResponse();
            this.processChannelFeedList(channelFeedList.toArray(new ChannelFeed[channelFeedList.size()]), false);
            return channelFeedList.toArray(new ChannelFeed[channelFeedList.size()]);
        }
        return null;
    }

    public ApiResponse removeMemberFromContactGroup(String contactGroupId, String groupType, String userId) {
        if (!TextUtils.isEmpty((CharSequence)contactGroupId) && !TextUtils.isEmpty((CharSequence)userId)) {
            ApiResponse apiResponse = this.channelClientService.removeMemberFromContactGroupOfType(contactGroupId, groupType, userId);
            return apiResponse;
        }
        return null;
    }

    public void processChannelFeedForSync(ChannelFeed channelFeed) {
        if (channelFeed != null) {
            Set<String> memberUserIds = channelFeed.getMembersName();
            HashSet<String> userIds = new HashSet<String>();
            Channel channel = this.getChannel(channelFeed);
            if (this.channelDatabaseService.isChannelPresent(channel.getKey())) {
                this.channelDatabaseService.updateChannel(channel);
                this.channelDatabaseService.deleteChannelUserMappers(channel.getKey());
            } else {
                this.channelDatabaseService.addChannel(channel);
            }
            if (memberUserIds != null && memberUserIds.size() > 0) {
                for (String userId : memberUserIds) {
                    ChannelUserMapper channelUserMapper = new ChannelUserMapper(channelFeed.getId(), userId);
                    channelUserMapper.setParentKey(channelFeed.getParentKey());
                    this.channelDatabaseService.addChannelUserMapper(channelUserMapper);
                    if (this.baseContactService.isContactExists(userId)) continue;
                    userIds.add(userId);
                }
                if (userIds != null && userIds.size() > 0) {
                    this.userService.processUserDetailsByUserIds(userIds);
                }
            }
            if (channelFeed.getGroupUsers() != null && channelFeed.getGroupUsers().size() > 0) {
                for (ChannelUsersFeed channelUsers : channelFeed.getGroupUsers()) {
                    if (channelUsers.getRole() == null) continue;
                    this.channelDatabaseService.updateRoleInChannelUserMapper(channelFeed.getId(), channelUsers.getUserId(), channelUsers.getRole());
                }
            }
            if (channelFeed.getChildKeys() != null && channelFeed.getChildKeys().size() > 0) {
                this.processChildGroupKeysForChannelSync(channelFeed.getChildKeys());
            }
            if (channel.isDeleted() && ApplozicClient.getInstance(this.context).isSkipDeletedGroups()) {
                BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), null, channel.getKey(), "success");
            }
        }
    }

    private void processChildGroupKeys(Set<Integer> childGroupKeys) {
        for (Integer channelKey : childGroupKeys) {
            ChannelFeed channelFeed;
            Channel channel = this.channelDatabaseService.getChannelByChannelKey(channelKey);
            if (channel != null || (channelFeed = this.channelClientService.getChannelInfo(channelKey)) == null) continue;
            this.processChannelFeed(channelFeed, false);
        }
    }

    private void processChildGroupKeysForChannelSync(Set<Integer> childGroupKeys) {
        for (Integer channelKey : childGroupKeys) {
            ChannelFeed channelFeed;
            Channel channel = this.channelDatabaseService.getChannelByChannelKey(channelKey);
            if (channel != null || (channelFeed = this.channelClientService.getChannelInfo(channelKey)) == null) continue;
            this.processChannelFeedForSync(channelFeed);
        }
    }

    public Integer getParentGroupKeyByClientGroupKey(String parentClientGroupKey) {
        return this.channelDatabaseService.getParentGroupKey(parentClientGroupKey);
    }

    public void getChannelByChannelKeyAsync(Integer groupId, AlChannelListener channelListener) {
        new AlGetPeopleTask(this.context, null, null, groupId, channelListener, null, null, this.channelDatabaseService).execute(new Void[0]);
    }

    public void getChannelByClientKeyAsync(String clientChannelKey, AlChannelListener channelListener) {
        new AlGetPeopleTask(this.context, null, clientChannelKey, null, channelListener, null, null, this.channelDatabaseService).execute(new Void[0]);
    }
}

