/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.schedule.ScheduleMessageService;
import com.applozic.mobicommons.json.GsonUtils;

public class MessageIntentService
extends JobIntentService {
    private static final String TAG = "MessageIntentService";
    private MessageClientService messageClientService;
    static final int JOB_ID = 1111;

    public static void enqueueWork(Context context, Intent work) {
        MessageIntentService.enqueueWork((Context)context, MessageIntentService.class, (int)1111, (Intent)work);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        this.messageClientService = new MessageClientService((Context)this);
        Message message = (Message)((Object)GsonUtils.getObjectFromJson((String)intent.getStringExtra("message_json"), Message.class));
        Thread thread = new Thread(new MessageSender(message));
        thread.start();
    }

    private class MessageSender
    implements Runnable {
        private Message message;

        public MessageSender(Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                MessageIntentService.this.messageClientService.sendMessageToServer(this.message, ScheduleMessageService.class);
                MessageIntentService.this.messageClientService.syncPendingMessages(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

