/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.RemoteInput;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;

public class NotificationBroadcastReceiver
extends BroadcastReceiver {
    public static String LAUNCH_APP = "applozic.LAUNCH_APP";
    public static String TAG = "NotificationBroadcastReceiver";

    public void onReceive(Context context, Intent intent) {
        String actionName = intent.getAction();
        String messageJson = intent.getStringExtra("message_json");
        String activityToOpen = Utils.getMetaDataValueForReceiver((Context)context, (String)NotificationBroadcastReceiver.class.getName(), (String)"activity.open.on.notification");
        if (actionName.equals(LAUNCH_APP)) {
            String messageText;
            String string = messageText = this.getMessageText(intent) == null ? null : this.getMessageText(intent).toString();
            if (!TextUtils.isEmpty((CharSequence)messageText)) {
                Message message = (Message)((Object)GsonUtils.getObjectFromJson((String)messageJson, Message.class));
                Message replyMessage = new Message();
                replyMessage.setTo(message.getTo());
                replyMessage.setStoreOnDevice(Boolean.TRUE);
                replyMessage.setSendToDevice(Boolean.FALSE);
                replyMessage.setType(Message.MessageType.MT_OUTBOX.getValue());
                replyMessage.setMessage(messageText);
                replyMessage.setDeviceKeyString(MobiComUserPreference.getInstance(context).getDeviceKeyString());
                replyMessage.setSource(Message.Source.MT_MOBILE_APP.getValue());
                Intent newIntent = new Intent(context, MessageIntentService.class);
                newIntent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)((Object)replyMessage), Message.class));
                MessageIntentService.enqueueWork(context, newIntent);
                return;
            }
            Class<?> activity = null;
            try {
                activity = Class.forName(activityToOpen);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (activity == null) {
                // empty if block
            }
            Intent newIntent = new Intent(context, activity);
            newIntent.putExtra("message_json", messageJson);
            newIntent.putExtra("sms_body", "text");
            newIntent.setType("vnd.android-dir/mms-sms");
            newIntent.setAction(LAUNCH_APP);
            newIntent.setFlags(0x14000000);
            context.startActivity(newIntent);
        }
    }

    private CharSequence getMessageText(Intent intent) {
        Bundle remoteInput = RemoteInput.getResultsFromIntent((Intent)intent);
        if (remoteInput != null) {
            return remoteInput.getCharSequence("extra_voice_reply");
        }
        return null;
    }
}

