/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.ApplozicMultipartUtility;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.attachment.MarkStream;
import com.applozic.mobicomkit.api.attachment.urlservice.URLServiceProvider;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.api.conversation.service.ConversationService;
import com.applozic.mobicomkit.feed.TopicDetail;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class FileClientService
extends MobiComKitClientService {
    public static final String MOBI_COM_IMAGES_FOLDER = "/image";
    public static final String MOBI_COM_VIDEOS_FOLDER = "/video";
    public static final String MOBI_COM_CONTACT_FOLDER = "/contact";
    public static final String MOBI_COM_OTHER_FILES_FOLDER = "/other";
    public static final String MOBI_COM_THUMBNAIL_SUFIX = "/.Thumbnail";
    public static final String FILE_UPLOAD_URL = "/rest/ws/aws/file/url";
    public static final String IMAGE_DIR = "image";
    public static final String AL_UPLOAD_FILE_URL = "/rest/ws/upload/file";
    public static final String CUSTOM_STORAGE_SERVICE_END_POINT = "/rest/ws/upload/image";
    public static final String S3_SIGNED_URL_END_POINT = "/rest/ws/upload/image";
    public static final String S3_SIGNED_URL_PARAM = "aclsPrivate";
    public static final String THUMBNAIL_URL = "/files/";
    private static final int MARK = 1024;
    private static final String TAG = "FileClientService";
    private static final String MAIN_FOLDER_META_DATA = "main_folder_name";
    private HttpRequestUtils httpRequestUtils;
    private MobiComKitClientService mobiComKitClientService;

    public FileClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
        this.mobiComKitClientService = new MobiComKitClientService(context);
    }

    public static File getFilePath(String fileName, Context context, String contentType, boolean isThumbnail) {
        File dir;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            String folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_OTHER_FILES_FOLDER;
            if (contentType.startsWith(IMAGE_DIR)) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_IMAGES_FOLDER;
            } else if (contentType.startsWith("video")) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_VIDEOS_FOLDER;
            } else if (contentType.equalsIgnoreCase("text/x-vCard")) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_CONTACT_FOLDER;
            }
            if (isThumbnail) {
                folder = folder + MOBI_COM_THUMBNAIL_SUFIX;
            }
            if (!(dir = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + folder)).exists()) {
                dir.mkdirs();
            }
        } else {
            ContextWrapper cw = new ContextWrapper(context);
            dir = cw.getDir(IMAGE_DIR, 0);
        }
        File filePath = new File(dir, fileName);
        return filePath;
    }

    public static File getFilePath(String fileName, Context context, String contentType) {
        return FileClientService.getFilePath(fileName, context, contentType, false);
    }

    public String profileImageUploadURL() {
        return this.getBaseUrl() + AL_UPLOAD_FILE_URL;
    }

    public Bitmap loadThumbnailImage(Context context, Message message, int reqWidth, int reqHeight) {
        try {
            Bitmap attachedImage = null;
            String thumbnailUrl = new URLServiceProvider(context).getThumbnailURL(message);
            if (TextUtils.isEmpty((CharSequence)thumbnailUrl)) {
                return null;
            }
            String contentType = message.getFileMetas().getContentType();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            String imageName = FileUtils.getName((String)message.getFileMetas().getName()) + message.getCreatedAtTime() + "." + FileUtils.getFileFormat((String)message.getFileMetas().getName());
            String imageLocalPath = FileClientService.getFilePath(imageName, context, message.getFileMetas().getContentType(), true).getAbsolutePath();
            if (imageLocalPath != null) {
                try {
                    attachedImage = BitmapFactory.decodeFile((String)imageLocalPath);
                }
                catch (Exception ex) {
                    Utils.printLog((Context)context, (String)TAG, (String)("File not found on local storage: " + ex.getMessage()));
                }
            }
            if (attachedImage == null) {
                HttpURLConnection connection = this.openHttpConnection(thumbnailUrl);
                if (connection.getResponseCode() == 200) {
                    attachedImage = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
                    File file = FileClientService.getFilePath(imageName, context, contentType, true);
                    imageLocalPath = ImageUtils.saveImageToInternalStorage((File)file, (Bitmap)attachedImage);
                } else {
                    Utils.printLog((Context)context, (String)TAG, (String)("Download is failed response code is ...." + connection.getResponseCode()));
                    return null;
                }
            }
            options.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)options, (int)200, (int)reqHeight);
            options.inJustDecodeBounds = false;
            attachedImage = BitmapFactory.decodeFile((String)imageLocalPath, (BitmapFactory.Options)options);
            return attachedImage;
        }
        catch (FileNotFoundException ex) {
            Utils.printLog((Context)context, (String)TAG, (String)("File not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            Utils.printLog((Context)context, (String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        return null;
    }

    public void loadContactsvCard(Message message) {
        File file = null;
        try {
            InputStream inputStream = null;
            FileMeta fileMeta = message.getFileMetas();
            String contentType = fileMeta.getContentType();
            String fileName = fileMeta.getName();
            file = FileClientService.getFilePath(fileName, this.context.getApplicationContext(), contentType);
            if (!file.exists()) {
                HttpURLConnection connection = new URLServiceProvider(this.context).getDownloadConnection(message);
                if (connection.getResponseCode() != 200) {
                    Utils.printLog((Context)this.context, (String)TAG, (String)("Got Error response while uploading file : " + connection.getResponseCode()));
                    return;
                }
                inputStream = connection.getInputStream();
                FileOutputStream output = new FileOutputStream(file);
                byte[] data = new byte[1024];
                int count = 0;
                while ((count = inputStream.read(data)) != -1) {
                    ((OutputStream)output).write(data, 0, count);
                }
                output.flush();
                ((OutputStream)output).close();
                inputStream.close();
            }
            new MessageDatabaseService(this.context).updateInternalFilePath(message.getKeyString(), file.getAbsolutePath());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            message.setFilePaths(arrayList);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Utils.printLog((Context)this.context, (String)TAG, (String)"File not found on server");
        }
        catch (Exception ex) {
            if (file != null && file.exists()) {
                Utils.printLog((Context)this.context, (String)TAG, (String)(" Exception occured while downloading :" + file.getAbsolutePath()));
                file.delete();
            }
            ex.printStackTrace();
            Utils.printLog((Context)this.context, (String)TAG, (String)"Exception fetching file from server");
        }
    }

    public Bitmap loadMessageImage(Context context, String url) {
        try {
            InputStream in;
            Bitmap attachedImage = null;
            if (attachedImage == null && (in = new URL(url).openStream()) != null) {
                attachedImage = BitmapFactory.decodeStream((InputStream)in);
            }
            return attachedImage;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Utils.printLog((Context)context, (String)TAG, (String)("File not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Utils.printLog((Context)context, (String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        return null;
    }

    public String uploadBlobImage(String path, Handler handler, String oldMessageKey) throws UnsupportedEncodingException {
        try {
            ApplozicMultipartUtility multipart = new ApplozicMultipartUtility(this.getUploadURL(), "UTF-8", this.context);
            if (ApplozicClient.getInstance(this.context).isS3StorageServiceEnabled()) {
                multipart.addFilePart("file", new File(path), handler, oldMessageKey);
            } else {
                multipart.addFilePart("files[]", new File(path), handler, oldMessageKey);
            }
            return multipart.getResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUploadURL() {
        String fileUrl = new URLServiceProvider(this.context).getFileUploadUrl();
        return fileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap downloadBitmap(Contact contact, Channel channel) {
        HttpURLConnection connection = null;
        MarkStream inputStream = null;
        try {
            connection = contact != null ? this.openHttpConnection(contact.getImageURL()) : this.openHttpConnection(channel.getImageUrl());
            if (connection != null) {
                if (connection.getResponseCode() == 200) {
                    inputStream = new MarkStream(connection.getInputStream());
                    BitmapFactory.Options optionsBitmap = new BitmapFactory.Options();
                    optionsBitmap.inJustDecodeBounds = true;
                    inputStream.allowMarksToExpire(false);
                    long mark = inputStream.setPos(1024);
                    BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)optionsBitmap);
                    inputStream.resetPos(mark);
                    optionsBitmap.inJustDecodeBounds = false;
                    optionsBitmap.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)optionsBitmap, (int)100, (int)50);
                    Bitmap attachedImage = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)optionsBitmap);
                    inputStream.allowMarksToExpire(true);
                    Bitmap bitmap = attachedImage;
                    return bitmap;
                }
                Utils.printLog((Context)this.context, (String)TAG, (String)("Download is failed response code is ...." + connection.getResponseCode()));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Utils.printLog((Context)this.context, (String)TAG, (String)("Image not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Utils.printLog((Context)this.context, (String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        catch (Throwable e) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Bitmap createAndSaveVideoThumbnail(String filePath) {
        String[] parts = filePath.split("/");
        String videoThumbnailPath = "";
        String thumbnailDir = "";
        String videoFileName = parts[parts.length - 1].split("[.]")[0];
        for (int i = 0; i < parts.length - 1; ++i) {
            thumbnailDir = thumbnailDir + parts[i] + "/";
        }
        File dir = new File(thumbnailDir = thumbnailDir + "Thumbnails/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        videoThumbnailPath = thumbnailDir + videoFileName + ".jpeg";
        Bitmap videoThumbnail = null;
        if (new File(videoThumbnailPath).exists()) {
            videoThumbnail = BitmapFactory.decodeFile((String)videoThumbnailPath);
        } else {
            FileOutputStream fOut = null;
            File file = new File(thumbnailDir, videoFileName + ".jpeg");
            try {
                file.createNewFile();
                fOut = new FileOutputStream(file);
                videoThumbnail = ThumbnailUtils.createVideoThumbnail((String)filePath, (int)2);
                videoThumbnail.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)fOut);
                fOut.flush();
                ((OutputStream)fOut).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return videoThumbnail;
    }

    public String uploadProfileImage(String path) throws UnsupportedEncodingException {
        try {
            ApplozicMultipartUtility multipart = new ApplozicMultipartUtility(this.profileImageUploadURL(), "UTF-8", this.context);
            multipart.addFilePart("file", new File(path), null, null);
            return multipart.getResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bitmap loadMessageImage(Context context, Conversation conversation) {
        try {
            if (conversation == null) {
                return null;
            }
            Bitmap attachedImage = ImageUtils.getBitMapFromLocalPath((String)conversation.getTopicLocalImageUri());
            if (attachedImage != null) {
                return attachedImage;
            }
            Bitmap bitmap = this.downloadProductImage(conversation);
            if (bitmap != null) {
                File file = FileClientService.getFilePath("topic_" + conversation.getId(), context.getApplicationContext(), IMAGE_DIR, true);
                String imageLocalPath = ImageUtils.saveImageToInternalStorage((File)file, (Bitmap)bitmap);
                conversation.setTopicLocalImageUri(imageLocalPath);
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getTopicLocalImageUri())) {
                ConversationService.getInstance(context).updateTopicLocalImageUri(conversation.getTopicLocalImageUri(), conversation.getId());
            }
            return bitmap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap downloadProductImage(Conversation conversation) {
        TopicDetail topicDetail = (TopicDetail)((Object)GsonUtils.getObjectFromJson((String)conversation.getTopicDetail(), TopicDetail.class));
        if (TextUtils.isEmpty((CharSequence)topicDetail.getLink())) {
            return null;
        }
        HttpURLConnection connection = null;
        MarkStream inputStream = null;
        try {
            if (conversation != null) {
                connection = this.openHttpConnection(topicDetail.getLink());
            }
            if (connection != null) {
                if (connection.getResponseCode() == 200) {
                    inputStream = new MarkStream(connection.getInputStream());
                    BitmapFactory.Options optionsBitmap = new BitmapFactory.Options();
                    optionsBitmap.inJustDecodeBounds = true;
                    inputStream.allowMarksToExpire(false);
                    long mark = inputStream.setPos(1024);
                    BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)optionsBitmap);
                    inputStream.resetPos(mark);
                    optionsBitmap.inJustDecodeBounds = false;
                    optionsBitmap.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)optionsBitmap, (int)100, (int)50);
                    Bitmap attachedImage = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)optionsBitmap);
                    inputStream.allowMarksToExpire(true);
                    Bitmap bitmap = attachedImage;
                    return bitmap;
                }
                Bitmap optionsBitmap = null;
                return optionsBitmap;
            }
        }
        catch (FileNotFoundException ex) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Image not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            Utils.printLog((Context)this.context, (String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        catch (Throwable e) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(Uri uri, File file) {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.context.getContentResolver().openInputStream(uri);
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            out = new FileOutputStream(file);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null && out != null) {
                try {
                    out.flush();
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

