/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.ApplozicClient;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicommons.commons.core.utils.DateUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.JsonMarker;
import com.applozic.mobicommons.people.channel.Channel;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Message
extends JsonMarker {
    private Long createdAtTime = new Date().getTime();
    private String to;
    private String message;
    private String key;
    private String deviceKey;
    private String userKey;
    private String emailIds;
    private boolean shared;
    private boolean sent;
    private Boolean delivered;
    private Short type = MessageType.MT_OUTBOX.getValue();
    private boolean storeOnDevice;
    private String contactIds = "";
    private Integer groupId;
    private boolean sendToDevice;
    private Long scheduledAt;
    private Short source = Source.MT_MOBILE_APP.getValue();
    private Integer timeToLive;
    private boolean sentToServer = true;
    private String fileMetaKey;
    private List<String> filePaths;
    private String pairedMessageKey;
    private long sentMessageTimeAtServer;
    private boolean canceled = false;
    private String clientGroupId;
    @SerializedName(value="fileMeta")
    private FileMeta fileMeta;
    @SerializedName(value="id")
    private Long messageId;
    private Boolean read = false;
    private boolean attDownloadInProgress;
    private String applicationId;
    private Integer conversationId;
    private String topicId;
    private boolean connected = false;
    private short contentType = ContentType.DEFAULT.getValue();
    private Map<String, String> metadata = new HashMap<String, String>();
    private short status = Status.READ.getValue();
    private boolean hidden;
    private int replyMessage;
    public static final String IMAGE = "image";
    public static final String VIDEO = "video";
    public static final String AUDIO = "audio";
    public static final String CONTACT = "contact";
    public static final String LOCATION = "location";
    public static final String OTHER = "other";
    public static final String KM_ASSIGN = "KM_ASSIGN";
    public static final String KM_STATUS = "KM_STATUS";

    public Message() {
    }

    public Message(String to, String body) {
        this.to = to;
        this.message = body;
    }

    public Message(Message message) {
        this.setMessage(message.getMessage());
        this.setContactIds(message.getContactIds());
        this.setCreatedAtTime(message.getCreatedAtTime());
        this.setDeviceKeyString(message.getDeviceKeyString());
        this.setSendToDevice(message.isSendToDevice());
        this.setTo(message.getTo());
        this.setType(message.getType());
        this.setSent(message.isSent());
        this.setDelivered(message.getDelivered());
        this.setStoreOnDevice(message.isStoreOnDevice());
        this.setScheduledAt(message.getScheduledAt());
        this.setSentToServer(message.isSentToServer());
        this.setSource(message.getSource());
        this.setTimeToLive(message.getTimeToLive());
        this.setFileMetas(message.getFileMetas());
        this.setFileMetaKeyStrings(message.getFileMetaKeyStrings());
        this.setFilePaths(message.getFilePaths());
        this.setGroupId(message.getGroupId());
        this.setRead(message.isRead());
        this.setApplicationId(message.getApplicationId());
        this.setContentType(message.getContentType());
        this.setStatus(message.getStatus());
        this.setConversationId(message.getConversationId());
        this.setTopicId(message.getTopicId());
        this.setMetadata(message.getMetadata());
        this.setHidden(message.isHidden());
    }

    public long getSentMessageTimeAtServer() {
        return this.sentMessageTimeAtServer;
    }

    public void setSentMessageTimeAtServer(long sentMessageTimeAtServer) {
        this.sentMessageTimeAtServer = sentMessageTimeAtServer;
    }

    public boolean isAttDownloadInProgress() {
        return this.attDownloadInProgress;
    }

    public void setAttDownloadInProgress(boolean attDownloadInProgress) {
        this.attDownloadInProgress = attDownloadInProgress;
    }

    public Boolean isRead() {
        return this.read != false || this.isTypeOutbox() || this.getScheduledAt() != null;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public boolean isSelfDestruct() {
        return this.getTimeToLive() != null;
    }

    public boolean isUploadRequired() {
        return this.hasAttachment() && this.fileMeta == null;
    }

    public boolean hasAttachment() {
        return this.filePaths != null && !this.filePaths.isEmpty() || this.fileMeta != null;
    }

    public boolean isAttachmentUploadInProgress() {
        return this.filePaths != null && !this.filePaths.isEmpty() && FileUtils.isFileExist((String)this.filePaths.get(0)) && !this.sentToServer;
    }

    public boolean isAttachmentDownloaded() {
        return this.filePaths != null && !this.filePaths.isEmpty() && FileUtils.isFileExist((String)this.filePaths.get(0));
    }

    public boolean isCall() {
        return MessageType.CALL_INCOMING.getValue().equals(this.type) || MessageType.CALL_OUTGOING.getValue().equals(this.type);
    }

    public boolean isOutgoingCall() {
        return MessageType.CALL_OUTGOING.getValue().equals(this.type);
    }

    public boolean isIncomingCall() {
        return MessageType.CALL_INCOMING.getValue().equals(this.type);
    }

    public Long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public boolean isDummyEmptyMessage() {
        return this.getCreatedAtTime() != null && this.getCreatedAtTime() == 0L && TextUtils.isEmpty((CharSequence)this.getMessage());
    }

    public boolean isLocalMessage() {
        return TextUtils.isEmpty((CharSequence)this.getKeyString()) && this.isSentToServer();
    }

    public String getKeyString() {
        return this.key;
    }

    public void setKeyString(String keyString) {
        this.key = keyString;
    }

    public Long getCreatedAtTime() {
        return this.createdAtTime;
    }

    public void setCreatedAtTime(Long createdAtTime) {
        this.createdAtTime = createdAtTime;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSent() {
        return this.sent;
    }

    public void setSent(boolean sent) {
        this.sent = sent;
    }

    public Boolean getDelivered() {
        return this.delivered != null ? this.delivered : false;
    }

    public void setDelivered(Boolean delivered) {
        this.delivered = delivered;
    }

    public boolean isStoreOnDevice() {
        return this.storeOnDevice;
    }

    public void setStoreOnDevice(boolean storeOnDevice) {
        this.storeOnDevice = storeOnDevice;
    }

    public String getDeviceKeyString() {
        return this.deviceKey;
    }

    public void setDeviceKeyString(String deviceKeyString) {
        this.deviceKey = deviceKeyString;
    }

    public String getSuUserKeyString() {
        return this.userKey;
    }

    public void setSuUserKeyString(String suUserKeyString) {
        this.userKey = suUserKeyString;
    }

    public Short getType() {
        return this.type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void processContactIds(Context context) {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(context);
        if (TextUtils.isEmpty((CharSequence)this.getContactIds())) {
            this.setContactIds(this.getTo());
        }
    }

    public String getContactIds() {
        return this.getTo();
    }

    public void setContactIds(String contactIds) {
        this.contactIds = contactIds;
    }

    public boolean isSendToDevice() {
        return this.sendToDevice;
    }

    public void setSendToDevice(boolean sendToDevice) {
        this.sendToDevice = sendToDevice;
    }

    public Long getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(Long scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public boolean isSentToMany() {
        return !TextUtils.isEmpty((CharSequence)this.getTo()) && this.getTo().split(",").length > 1;
    }

    public boolean isSentToServer() {
        return this.sentToServer;
    }

    public void setSentToServer(boolean sentToServer) {
        this.sentToServer = sentToServer;
    }

    public boolean isTypeOutbox() {
        return MessageType.OUTBOX.getValue().equals(this.type) || MessageType.MT_OUTBOX.getValue().equals(this.type) || MessageType.OUTBOX_SENT_FROM_DEVICE.getValue().equals(this.type) || MessageType.CALL_OUTGOING.getValue().equals(this.type);
    }

    public boolean isSentViaApp() {
        return MessageType.MT_OUTBOX.getValue().equals(this.type);
    }

    public boolean isSentViaCarrier() {
        return MessageType.OUTBOX.getValue().equals(this.type);
    }

    public Short getSource() {
        return this.source;
    }

    public void setSource(Short source) {
        this.source = source;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getFileMetaKeyStrings() {
        return this.fileMetaKey;
    }

    public void setFileMetaKeyStrings(String fileMetaKeyStrings) {
        this.fileMetaKey = fileMetaKeyStrings;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(List<String> filePaths) {
        this.filePaths = filePaths;
    }

    public String getPairedMessageKeyString() {
        return this.pairedMessageKey;
    }

    public void setPairedMessageKeyString(String pairedMessageKeyString) {
        this.pairedMessageKey = pairedMessageKeyString;
    }

    public FileMeta getFileMetas() {
        return this.fileMeta;
    }

    public void setFileMetas(FileMeta fileMetas) {
        this.fileMeta = fileMetas;
    }

    public String getEmailIds() {
        return this.emailIds;
    }

    public void setEmailIds(String emailIds) {
        this.emailIds = emailIds;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public short getContentType() {
        return this.contentType;
    }

    public void setContentType(short contentType) {
        this.contentType = contentType;
    }

    public Integer getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(Integer conversationId) {
        this.conversationId = conversationId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public String getCurrentId() {
        return this.getGroupId() != null ? String.valueOf(this.getGroupId()) : this.getContactIds();
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)((Object)o);
        if (message.isTempDateType() && this.isTempDateType()) {
            return DateUtils.getDate((Long)message.getCreatedAtTime()).equals(DateUtils.getDate((Long)this.getCreatedAtTime()));
        }
        if (this.getMessageId() != null && message.getMessageId() != null && this.getMessageId().equals(message.getMessageId())) {
            return true;
        }
        if (this.getKeyString() != null && message.getKeyString() != null) {
            return this.getKeyString().equals(message.getKeyString());
        }
        return false;
    }

    public String getAttachmentType() {
        String type = "no_attachment";
        if (this.getContentType() == ContentType.LOCATION.getValue().shortValue()) {
            type = LOCATION;
        } else if (this.getContentType() == ContentType.AUDIO_MSG.getValue().shortValue()) {
            type = AUDIO;
        } else if (this.getContentType() == ContentType.VIDEO_MSG.getValue().shortValue()) {
            type = VIDEO;
        } else if (this.getContentType() == ContentType.ATTACHMENT.getValue().shortValue()) {
            if (this.getFilePaths() != null) {
                String filePath = this.getFilePaths().get(this.getFilePaths().size() - 1);
                String mimeType = FileUtils.getMimeType((String)filePath);
                if (mimeType != null) {
                    type = mimeType.startsWith(IMAGE) ? IMAGE : (mimeType.startsWith(AUDIO) ? AUDIO : (mimeType.startsWith(VIDEO) ? VIDEO : "others"));
                }
            } else if (this.getFileMetas() != null) {
                type = this.getFileMetas().getContentType().contains(IMAGE) ? IMAGE : (this.getFileMetas().getContentType().contains(AUDIO) ? AUDIO : (this.getFileMetas().getContentType().contains(VIDEO) ? VIDEO : "others"));
            }
        } else if (this.getContentType() == ContentType.CONTACT_MSG.getValue().shortValue()) {
            type = CONTACT;
        } else if (this.hasAttachment()) {
            type = "others";
        }
        return type;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.messageId != null ? this.messageId.hashCode() : 0);
        if (this.isTempDateType()) {
            result = 31 * result + DateUtils.getDate((Long)this.getCreatedAtTime()).hashCode();
        }
        return result;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public short getStatus() {
        return this.status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    public boolean isTempDateType() {
        return this.type.equals(MessageType.DATE_TEMP.value);
    }

    public void setTempDateType(short tempDateType) {
        this.type = tempDateType;
    }

    public boolean isCustom() {
        return this.contentType == ContentType.CUSTOM.value;
    }

    public boolean isChannelCustomMessage() {
        return this.contentType == ContentType.CHANNEL_CUSTOM_MESSAGE.getValue();
    }

    public boolean isDeliveredAndRead() {
        return Status.DELIVERED_AND_READ.getValue().shortValue() == this.getStatus();
    }

    public boolean isReadStatus() {
        return Status.READ.getValue().shortValue() == this.getStatus();
    }

    public boolean isReadStatusForUpdate() {
        return Status.READ.getValue().shortValue() == this.getStatus() || this.isTypeOutbox();
    }

    public boolean isContactMessage() {
        return ContentType.CONTACT_MSG.getValue().equals(this.getContentType());
    }

    public boolean isLocationMessage() {
        return ContentType.LOCATION.getValue().equals(this.getContentType());
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean isGroupMessage() {
        return this.groupId != null;
    }

    public String getClientGroupId() {
        return this.clientGroupId;
    }

    public void setClientGroupId(String clientGroupId) {
        this.clientGroupId = clientGroupId;
    }

    public String getMetaDataValueForKey(String key) {
        return this.getMetadata() != null ? this.getMetadata().get(key) : null;
    }

    public boolean isUpdateMessage() {
        return !ContentType.HIDDEN.getValue().equals(this.contentType) && !MetaDataType.ARCHIVE.getValue().equals(this.getMetaDataValueForKey(MetaDataType.KEY.getValue())) && !this.isVideoNotificationMessage();
    }

    public boolean isVideoNotificationMessage() {
        return ContentType.VIDEO_CALL_NOTIFICATION_MSG.getValue().equals(this.getContentType());
    }

    public boolean isVideoCallMessage() {
        return ContentType.VIDEO_CALL_STATUS_MSG.getValue().equals(this.getContentType());
    }

    public boolean isVideoOrAudioCallMessage() {
        String msgType = this.getMetaDataValueForKey("MSG_TYPE");
        return "CALL_STARTED".equals(msgType) || "CALL_REJECTED".equals(msgType) || "CALL_CANCELED".equals(msgType) || "CALL_ANSWERED".equals(msgType) || "CALL_END".equals(msgType) || "CALL_DIALED".equals(msgType) || "CALL_ANSWERED".equals(msgType) || "CALL_MISSED".equals(msgType);
    }

    public boolean isConsideredForCount() {
        return !ContentType.HIDDEN.getValue().equals(this.getContentType()) && !ContentType.VIDEO_CALL_NOTIFICATION_MSG.getValue().equals(this.getContentType()) && !this.isReadStatus() && !this.isHidden();
    }

    public boolean isHidden() {
        return GroupMessageMetaData.TRUE.getValue().equals(this.getMetaDataValueForKey(GroupMessageMetaData.HIDE_KEY.getValue())) || ContentType.HIDDEN.getValue().equals(this.getContentType());
    }

    public boolean isGroupMetaDataUpdated() {
        return ContentType.CHANNEL_CUSTOM_MESSAGE.getValue().equals(this.getContentType()) && this.getMetadata() != null && this.getMetadata().containsKey("action") && GroupAction.GROUP_META_DATA_UPDATED.getValue().toString().equals(this.getMetadata().get("action"));
    }

    public void setHidden(boolean hidden) {
    }

    public int isReplyMessage() {
        return this.replyMessage;
    }

    public void setReplyMessage(int replyMessage) {
        this.replyMessage = replyMessage;
    }

    public boolean isActionMessage() {
        return this.getMetadata() != null && (this.getMetadata().containsKey(KM_ASSIGN) || this.getMetadata().containsKey(KM_STATUS));
    }

    public boolean isIgnoreMessageAdding(Context context) {
        if (ApplozicClient.getInstance(context).isSubGroupEnabled() && MobiComUserPreference.getInstance(context).getParentGroupKey() != null || !TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(context).getCategoryName())) {
            Channel channel = ChannelService.getInstance(context).getChannelByChannelKey(this.getGroupId());
            boolean subGroupFlag = channel != null && channel.getParentKey() != null && MobiComUserPreference.getInstance(context).getParentGroupKey().equals(channel.getParentKey());
            boolean categoryFlag = channel != null && channel.isPartOfCategory(MobiComUserPreference.getInstance(context).getCategoryName());
            return subGroupFlag || categoryFlag || ApplozicClient.getInstance(context).isSubGroupEnabled() || !TextUtils.isEmpty((CharSequence)MobiComUserPreference.getInstance(context).getCategoryName()) || this.hidden;
        }
        return ApplozicClient.getInstance(context).isActionMessagesHidden() && this.isActionMessage() || this.isHidden();
    }

    public String toString() {
        return "Message{createdAtTime=" + this.createdAtTime + ", to='" + this.to + '\'' + ", message='" + this.message + '\'' + ", key='" + this.key + '\'' + ", deviceKey='" + this.deviceKey + '\'' + ", userKey='" + this.userKey + '\'' + ", emailIds='" + this.emailIds + '\'' + ", shared=" + this.shared + ", sent=" + this.sent + ", delivered=" + this.delivered + ", type=" + this.type + ", storeOnDevice=" + this.storeOnDevice + ", contactIds='" + this.contactIds + '\'' + ", groupId=" + this.groupId + ", sendToDevice=" + this.sendToDevice + ", scheduledAt=" + this.scheduledAt + ", source=" + this.source + ", timeToLive=" + this.timeToLive + ", sentToServer=" + this.sentToServer + ", fileMetaKey='" + this.fileMetaKey + '\'' + ", filePaths=" + this.filePaths + ", pairedMessageKey='" + this.pairedMessageKey + '\'' + ", sentMessageTimeAtServer=" + this.sentMessageTimeAtServer + ", canceled=" + this.canceled + ", clientGroupId='" + this.clientGroupId + '\'' + ", fileMeta=" + (Object)((Object)this.fileMeta) + ", messageId=" + this.messageId + ", read=" + this.read + ", attDownloadInProgress=" + this.attDownloadInProgress + ", applicationId='" + this.applicationId + '\'' + ", conversationId=" + this.conversationId + ", topicId='" + this.topicId + '\'' + ", connected=" + this.connected + ", contentType=" + this.contentType + ", metadata=" + this.metadata + ", status=" + this.status + '}';
    }

    public static enum GroupAction {
        CREATE(0),
        ADD_MEMBER(1),
        REMOVE_MEMBER(2),
        LEFT(3),
        DELETE_GROUP(4),
        CHANGE_GROUP_NAME(5),
        CHANGE_IMAGE_URL(6),
        JOIN(7),
        GROUP_USER_ROLE_UPDATED(8),
        GROUP_META_DATA_UPDATED(9);

        private Integer value;

        private GroupAction(Integer value) {
            this.value = value;
        }

        public Short getValue() {
            return this.value.shortValue();
        }
    }

    public static enum ReplyMessage {
        NON_HIDDEN(0),
        REPLY_MESSAGE(1),
        HIDE_MESSAGE(2);

        private Integer value;

        private ReplyMessage(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }

    public static enum GroupMessageMetaData {
        KEY("show"),
        HIDE_KEY("hide"),
        FALSE("false"),
        TRUE("true");

        private String value;

        private GroupMessageMetaData(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum MetaDataType {
        KEY("category"),
        HIDDEN("HIDDEN"),
        PUSHNOTIFICATION("PUSHNOTIFICATION"),
        ARCHIVE("ARCHIVE"),
        AL_REPLY("AL_REPLY");

        private String value;

        private MetaDataType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        UNREAD(Short.valueOf("0")),
        READ(Short.valueOf("1")),
        PENDING(Short.valueOf("2")),
        SENT(Short.valueOf("3")),
        DELIVERED(Short.valueOf("4")),
        DELIVERED_AND_READ(Short.valueOf("5"));

        private Short value;

        private Status(Short value) {
            this.value = value;
        }

        public Short getValue() {
            return this.value;
        }
    }

    public static enum ContentType {
        DEFAULT(Short.valueOf("0")),
        ATTACHMENT(Short.valueOf("1")),
        LOCATION(Short.valueOf("2")),
        TEXT_HTML(Short.valueOf("3")),
        PRICE(Short.valueOf("4")),
        TEXT_URL(Short.valueOf("5")),
        CONTACT_MSG(Short.valueOf("7")),
        AUDIO_MSG(Short.valueOf("8")),
        VIDEO_MSG(Short.valueOf("9")),
        CHANNEL_CUSTOM_MESSAGE(Short.valueOf("10")),
        CUSTOM(Short.valueOf("101")),
        HIDDEN(Short.valueOf("11")),
        VIDEO_CALL_NOTIFICATION_MSG(Short.valueOf("102")),
        VIDEO_CALL_STATUS_MSG(Short.valueOf("103"));

        private Short value;

        private ContentType(Short value) {
            this.value = value;
        }

        public Short getValue() {
            return this.value;
        }
    }

    public static enum MessageType {
        INBOX(Short.valueOf("0")),
        OUTBOX(Short.valueOf("1")),
        DRAFT(Short.valueOf("2")),
        OUTBOX_SENT_FROM_DEVICE(Short.valueOf("3")),
        MT_INBOX(Short.valueOf("4")),
        MT_OUTBOX(Short.valueOf("5")),
        CALL_INCOMING(Short.valueOf("6")),
        CALL_OUTGOING(Short.valueOf("7")),
        DATE_TEMP(Short.valueOf("100"));

        private Short value;

        private MessageType(Short c) {
            this.value = c;
        }

        public Short getValue() {
            return this.value;
        }
    }

    public static enum Source {
        DEVICE_NATIVE_APP(Short.valueOf("0")),
        WEB(Short.valueOf("1")),
        MT_MOBILE_APP(Short.valueOf("2")),
        API(Short.valueOf("3"));

        private Short value;

        private Source(Short c) {
            this.value = c;
        }

        public Short getValue() {
            return this.value;
        }
    }
}

