/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.support.v4.content.LocalBroadcastManager;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.conversation.ApplozicIntentService;
import com.applozic.mobicommons.commons.core.utils.Utils;

public class ConnectivityReceiver
extends BroadcastReceiver {
    public static final String CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
    private static final String TAG = "ConnectivityReceiver";
    private static final String BOOT_COMPLETED = "android.intent.action.BOOT_COMPLETED";
    private static boolean firstConnect = true;
    Context context;

    public void onReceive(Context context, Intent intent) {
        this.context = context;
        String action = intent.getAction();
        Utils.printLog((Context)context, (String)TAG, (String)action);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent(action));
        if (action.equalsIgnoreCase(CONNECTIVITY_CHANGE) || action.equalsIgnoreCase(BOOT_COMPLETED)) {
            if (!Utils.isInternetAvailable((Context)context)) {
                firstConnect = true;
                return;
            }
            if (!MobiComUserPreference.getInstance(context).isLoggedIn()) {
                return;
            }
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().isConnected() && firstConnect) {
                firstConnect = false;
                Intent connectivityIntent = new Intent(context, ApplozicIntentService.class);
                connectivityIntent.putExtra("AL_SYNC_ON_CONNECTIVITY", true);
                context.startService(connectivityIntent);
            }
        }
    }
}

