/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.R;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.app.RemoteInput;
import com.applozic.mobicomkit.ApplozicClient;

public class WearableNotificationWithVoice {
    public static final String EXTRA_VOICE_REPLY = "extra_voice_reply";
    Class<?> notificationHandler;
    Context mContext;
    int actionIconResId;
    NotificationCompat.Builder notificationBuilder;
    int replyLabelResourceId;
    int actionTitleId;
    int notificationId;
    PendingIntent pendingIntent;

    public WearableNotificationWithVoice(NotificationCompat.Builder notificationBuilder, int actionTitleId, int replyLabelResourceId, int actionIcon, int notificationId) {
        this.notificationBuilder = notificationBuilder;
        this.replyLabelResourceId = replyLabelResourceId;
        this.actionIconResId = actionIcon;
        this.actionTitleId = actionTitleId;
        this.notificationId = notificationId;
    }

    public void setNotificationHandler(Class<?> replyActivityClass) {
        this.notificationHandler = replyActivityClass;
    }

    public void setCurrentContext(Context currentContext) {
        this.mContext = currentContext;
    }

    public void setPendingIntent(PendingIntent pendingIntent) {
        this.pendingIntent = pendingIntent;
    }

    public void sendNotification() throws Exception {
        int smallIconViewId;
        if (this.pendingIntent == null && this.notificationHandler == null) {
            throw new RuntimeException("Either pendingIntent or handler class requires.");
        }
        Notification notification = this.notificationBuilder.extend((NotificationCompat.Extender)new NotificationCompat.WearableExtender()).build();
        if (ApplozicClient.getInstance(this.mContext).isNotificationSmallIconHidden() && Build.VERSION.SDK_INT >= 16 && (smallIconViewId = this.mContext.getResources().getIdentifier("right_icon", "id", R.class.getPackage().getName())) != 0) {
            if (notification.contentIntent != null) {
                notification.contentView.setViewVisibility(smallIconViewId, 4);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (notification.headsUpContentView != null) {
                    notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                }
                if (notification.bigContentView != null) {
                    notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                }
            }
        }
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.mContext);
        notificationManager.notify(this.notificationId, notification);
    }

    private NotificationCompat.Action buildWearableAction() {
        String replyLabel = this.mContext.getString(this.replyLabelResourceId);
        RemoteInput remoteInput = new RemoteInput.Builder(EXTRA_VOICE_REPLY).setLabel((CharSequence)replyLabel).build();
        if (this.pendingIntent == null) {
            Intent replyIntent = new Intent(this.mContext, this.notificationHandler);
            this.pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)((int)(System.currentTimeMillis() & 0xFFFFFFFL)), (Intent)replyIntent, (int)0x8000000);
        }
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(this.actionIconResId, (CharSequence)this.mContext.getString(this.actionTitleId), this.pendingIntent).addRemoteInput(remoteInput).build();
        return action;
    }
}

