/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_LIMIT_INCREMENT = 1024;
    private final InputStream inputStream;
    private long offsetValue;
    private long resetValue;
    private long limit;
    private long defaultValue = -1L;
    private boolean allowExpire = true;
    private int limitIncrement = -1;

    public MarkStream(InputStream in) {
        this(in, 4096);
    }

    public MarkStream(InputStream in, int size) {
        this(in, size, 1024);
    }

    private MarkStream(InputStream inputStream, int size, int limitIncrement) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, size);
        }
        this.inputStream = inputStream;
        this.limitIncrement = limitIncrement;
    }

    @Override
    public void mark(int readLimit) {
        this.defaultValue = this.setPos(readLimit);
    }

    public long setPos(int readLimit) {
        long offsetLimit = this.offsetValue + (long)readLimit;
        if (this.limit < offsetLimit) {
            this.setLimit(offsetLimit);
        }
        return this.offsetValue;
    }

    public void allowMarksToExpire(boolean allowExpire) {
        this.allowExpire = allowExpire;
    }

    private void setLimit(long limit) {
        try {
            if (this.resetValue < this.offsetValue && this.offsetValue <= this.limit) {
                this.inputStream.reset();
                this.inputStream.mark((int)(limit - this.resetValue));
                this.skipBytes(this.resetValue, this.offsetValue);
            } else {
                this.resetValue = this.offsetValue;
                this.inputStream.mark((int)(limit - this.offsetValue));
            }
            this.limit = limit;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to mark: " + e);
        }
    }

    @Override
    public void reset() throws IOException {
        this.resetPos(this.defaultValue);
    }

    public void resetPos(long token) throws IOException {
        if (this.offsetValue > this.limit || token < this.resetValue) {
            throw new IOException("Cannot reset the pos ");
        }
        this.inputStream.reset();
        this.skipBytes(this.resetValue, token);
        this.offsetValue = token;
    }

    private void skipBytes(long current, long pos) throws IOException {
        while (current < pos) {
            long skipped = this.inputStream.skip(pos - current);
            if (skipped == 0L) {
                if (this.read() == -1) break;
                skipped = 1L;
            }
            current += skipped;
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        if (!this.allowExpire && this.offsetValue + 1L > this.limit) {
            this.setLimit(this.limit + (long)this.limitIncrement);
        }
        if ((result = this.inputStream.read()) != -1) {
            ++this.offsetValue;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int byteCount;
        if (!this.allowExpire && this.offsetValue + (long)buffer.length > this.limit) {
            this.setLimit(this.offsetValue + (long)buffer.length + (long)this.limitIncrement);
        }
        if ((byteCount = this.inputStream.read(buffer)) != -1) {
            this.offsetValue += (long)byteCount;
        }
        return byteCount;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int byteCount;
        if (!this.allowExpire && this.offsetValue + (long)length > this.limit) {
            this.setLimit(this.offsetValue + (long)length + (long)this.limitIncrement);
        }
        if ((byteCount = this.inputStream.read(buffer, offset, length)) != -1) {
            this.offsetValue += (long)byteCount;
        }
        return byteCount;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        if (!this.allowExpire && this.offsetValue + byteCount > this.limit) {
            this.setLimit(this.offsetValue + byteCount + (long)this.limitIncrement);
        }
        long skipped = this.inputStream.skip(byteCount);
        this.offsetValue += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

