/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.CustomerPackageDetail;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicomkit.contact.BaseContactService;
import com.applozic.mobicomkit.feed.ApiResponse;
import com.applozic.mobicomkit.feed.RegisteredUsersApiResponse;
import com.applozic.mobicomkit.feed.SyncBlockUserApiResponse;
import com.applozic.mobicomkit.sync.SyncUserBlockFeed;
import com.applozic.mobicomkit.sync.SyncUserBlockListFeed;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserService {
    private static UserService userService;
    Context context;
    UserClientService userClientService;
    BaseContactService baseContactService;
    private MobiComUserPreference userPreference;

    private UserService(Context context) {
        this.context = context;
        this.userClientService = new UserClientService(context);
        this.userPreference = MobiComUserPreference.getInstance(context);
        this.baseContactService = new AppContactService(context);
    }

    public static UserService getInstance(Context context) {
        if (userService == null) {
            userService = new UserService(context.getApplicationContext());
        }
        return userService;
    }

    public synchronized void processSyncUserBlock() {
        try {
            SyncBlockUserApiResponse apiResponse = this.userClientService.getSyncUserBlockList(this.userPreference.getUserBlockSyncTime());
            if (apiResponse != null && "success".equals(apiResponse.getStatus())) {
                SyncUserBlockListFeed syncUserBlockListFeed = apiResponse.getResponse();
                if (syncUserBlockListFeed != null) {
                    Contact contact;
                    List<SyncUserBlockFeed> blockedToUserList = syncUserBlockListFeed.getBlockedToUserList();
                    List<SyncUserBlockFeed> blockedByUserList = syncUserBlockListFeed.getBlockedByUserList();
                    if (blockedToUserList != null && blockedToUserList.size() > 0) {
                        for (SyncUserBlockFeed syncUserBlockedFeed : blockedToUserList) {
                            contact = new Contact();
                            if (syncUserBlockedFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockedFeed.getBlockedTo())) continue;
                            if (this.baseContactService.isContactExists(syncUserBlockedFeed.getBlockedTo())) {
                                this.baseContactService.updateUserBlocked(syncUserBlockedFeed.getBlockedTo(), syncUserBlockedFeed.getUserBlocked());
                                continue;
                            }
                            contact.setBlocked(syncUserBlockedFeed.getUserBlocked().booleanValue());
                            contact.setUserId(syncUserBlockedFeed.getBlockedTo());
                            this.baseContactService.upsert(contact);
                            this.baseContactService.updateUserBlocked(syncUserBlockedFeed.getBlockedTo(), syncUserBlockedFeed.getUserBlocked());
                        }
                    }
                    if (blockedByUserList != null && blockedByUserList.size() > 0) {
                        for (SyncUserBlockFeed syncUserBlockByFeed : blockedByUserList) {
                            contact = new Contact();
                            if (syncUserBlockByFeed.getUserBlocked() == null || TextUtils.isEmpty((CharSequence)syncUserBlockByFeed.getBlockedBy())) continue;
                            if (this.baseContactService.isContactExists(syncUserBlockByFeed.getBlockedBy())) {
                                this.baseContactService.updateUserBlockedBy(syncUserBlockByFeed.getBlockedBy(), syncUserBlockByFeed.getUserBlocked());
                                continue;
                            }
                            contact.setBlockedBy(syncUserBlockByFeed.getUserBlocked().booleanValue());
                            contact.setUserId(syncUserBlockByFeed.getBlockedBy());
                            this.baseContactService.upsert(contact);
                            this.baseContactService.updateUserBlockedBy(syncUserBlockByFeed.getBlockedBy(), syncUserBlockByFeed.getUserBlocked());
                        }
                    }
                }
                this.userPreference.setUserBlockSyncTime(apiResponse.getGeneratedAt());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApiResponse processUserBlock(String userId, boolean block) {
        ApiResponse apiResponse = this.userClientService.userBlock(userId, block);
        if (apiResponse != null && apiResponse.isSuccess()) {
            this.baseContactService.updateUserBlocked(userId, block);
            return apiResponse;
        }
        return null;
    }

    public synchronized void processUserDetail(Set<UserDetail> userDetails) {
        if (userDetails != null && userDetails.size() > 0) {
            for (UserDetail userDetail : userDetails) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUserDetails(String userId) {
        HashSet<String> userIds = new HashSet<String>();
        userIds.add(userId);
        this.processUserDetails(userIds);
    }

    public synchronized void processUserDetails(Set<String> userIds) {
        String response = this.userClientService.getUserDetails(userIds);
        if (!TextUtils.isEmpty((CharSequence)response)) {
            UserDetail[] userDetails;
            for (UserDetail userDetail : userDetails = (UserDetail[])GsonUtils.getObjectFromJson((String)response, UserDetail[].class)) {
                this.processUser(userDetail);
            }
        }
    }

    public synchronized void processUser(UserDetail userDetail) {
        Contact contact = new Contact();
        contact.setUserId(userDetail.getUserId());
        contact.setContactNumber(userDetail.getPhoneNumber());
        contact.setConnected(userDetail.isConnected());
        contact.setStatus(userDetail.getStatusMessage());
        contact.setFullName(userDetail.getDisplayName());
        contact.setLastSeenAt(userDetail.getLastSeenAtTime());
        contact.setUserTypeId(userDetail.getUserTypeId());
        contact.setUnreadCount(Integer.valueOf(0));
        if (!TextUtils.isEmpty((CharSequence)userDetail.getImageLink())) {
            contact.setImageURL(userDetail.getImageLink());
        }
        this.baseContactService.upsert(contact);
    }

    public synchronized String[] getOnlineUsers(int numberOfUser) {
        try {
            Map<String, String> userMapList = this.userClientService.getOnlineUserList(numberOfUser);
            if (userMapList != null && userMapList.size() > 0) {
                String[] userIdArray = new String[userMapList.size()];
                HashSet<String> userIds = new HashSet<String>();
                int i = 0;
                for (Map.Entry<String, String> keyValue : userMapList.entrySet()) {
                    Contact contact = new Contact();
                    contact.setUserId(keyValue.getKey());
                    contact.setConnected(keyValue.getValue().contains("true"));
                    userIdArray[i] = keyValue.getKey();
                    userIds.add(keyValue.getKey());
                    this.baseContactService.upsert(contact);
                    ++i;
                }
                this.processUserDetails(userIds);
                return userIdArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized RegisteredUsersApiResponse getRegisteredUsersList(Long startTime, int pageSize) {
        String response = this.userClientService.getRegisteredUsers(startTime, pageSize);
        RegisteredUsersApiResponse apiResponse = null;
        if (!TextUtils.isEmpty((CharSequence)response) && !"error".equals(response)) {
            apiResponse = (RegisteredUsersApiResponse)((Object)GsonUtils.getObjectFromJson((String)response, RegisteredUsersApiResponse.class));
            if (apiResponse != null) {
                this.processUserDetail(apiResponse.getUsers());
                this.userPreference.setRegisteredUsersLastFetchTime(apiResponse.getLastFetchTime());
            }
            return apiResponse;
        }
        return null;
    }

    public String updateDisplayNameORImageLink(String displayName, String profileImageLink, String localURL, String status) {
        return this.updateDisplayNameORImageLink(displayName, profileImageLink, status, null);
    }

    public String updateDisplayNameORImageLink(String displayName, String profileImageLink, String localURL, String status, String contactNumber) {
        ApiResponse response = this.userClientService.updateDisplayNameORImageLink(displayName, profileImageLink, status, contactNumber);
        if (response == null) {
            return null;
        }
        if (response != null && response.isSuccess()) {
            Contact contact = this.baseContactService.getContactById(MobiComUserPreference.getInstance(this.context).getUserId());
            if (!TextUtils.isEmpty((CharSequence)displayName)) {
                contact.setFullName(displayName);
            }
            if (!TextUtils.isEmpty((CharSequence)profileImageLink)) {
                contact.setImageURL(profileImageLink);
            }
            contact.setLocalImageUrl(localURL);
            if (!TextUtils.isEmpty((CharSequence)status)) {
                contact.setStatus(status);
            }
            if (!TextUtils.isEmpty((CharSequence)contactNumber)) {
                contact.setContactNumber(contactNumber);
            }
            this.baseContactService.upsert(contact);
            Contact contact1 = this.baseContactService.getContactById(MobiComUserPreference.getInstance(this.context).getUserId());
            Utils.printLog((Context)this.context, (String)"UserService", (String)(contact1.getImageURL() + ", " + contact1.getDisplayName() + "," + contact1.getStatus() + "," + contact1.getStatus()));
        }
        return response.getStatus();
    }

    public void processUserDetailsResponse(String response) {
        if (!TextUtils.isEmpty((CharSequence)response)) {
            List userDetails = (List)GsonUtils.getObjectFromJson((String)response, (Type)new TypeToken<List<UserDetail>>(){}.getType());
            for (UserDetail userDetail : userDetails) {
                this.processUser(userDetail);
            }
        }
    }

    public void processUserDetailsByUserIds(Set<String> userIds) {
        this.userClientService.postUserDetailsByUserIds(userIds);
    }

    public ApiResponse processUserReadConversation() {
        return this.userClientService.getUserReadServerCall();
    }

    public String processUpdateUserPassword(String oldPassword, String newPassword) {
        String response = this.userClientService.updateUserPassword(oldPassword, newPassword);
        if (!TextUtils.isEmpty((CharSequence)response) && "success".equals(response)) {
            this.userPreference.setPassword(newPassword);
        }
        return response;
    }

    public void processPackageDetail() {
        CustomerPackageDetail customerPackageDetail = new CustomerPackageDetail();
        customerPackageDetail.setApplicationKey(MobiComKitClientService.getApplicationKey(this.context));
        customerPackageDetail.setPackageName(this.context.getPackageName());
        String response = this.userClientService.packageDetail(customerPackageDetail);
        if (!TextUtils.isEmpty((CharSequence)response) && response.equals("\"success\"")) {
            this.userPreference.setApplicationInfoCallDone(true);
        } else {
            this.userPreference.setApplicationInfoCallDone(false);
        }
    }
}

