/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;

public class ApplozicIntentService
extends IntentService {
    public static final String CONTACT = "contact";
    public static final String CHANNEL = "channel";
    public static final String AL_SYNC_ON_CONNECTIVITY = "AL_SYNC_ON_CONNECTIVITY";
    private static final String TAG = "ApplozicIntentService";
    MobiComConversationService conversationService;
    private MessageClientService messageClientService;

    public ApplozicIntentService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.messageClientService = new MessageClientService((Context)this);
        this.conversationService = new MobiComConversationService((Context)this);
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        boolean connectivityChange = intent.getBooleanExtra(AL_SYNC_ON_CONNECTIVITY, false);
        if (connectivityChange) {
            SyncCallService.getInstance((Context)this).syncMessages(null);
            this.messageClientService.syncPendingMessages(true);
            this.messageClientService.syncDeleteMessages(true);
            this.conversationService.processLastSeenAtStatus();
            UserService.getInstance((Context)this).processSyncUserBlock();
        }
    }
}

