/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.user;

import android.content.Context;
import android.os.AsyncTask;
import com.applozic.mobicomkit.api.account.register.RegisterUserClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.api.account.user.UserClientService;
import com.applozic.mobicomkit.api.account.user.UserService;

public class UserLoginTask
extends AsyncTask<Void, Void, Boolean> {
    private final TaskListener taskListener;
    private final Context context;
    private User user;
    private Exception mException;
    private RegistrationResponse registrationResponse;
    private UserClientService userClientService;
    private RegisterUserClientService registerUserClientService;
    private UserService userService;

    public UserLoginTask(User user, TaskListener listener, Context context) {
        this.taskListener = listener;
        this.context = context;
        this.user = user;
        this.userClientService = new UserClientService(context);
        this.registerUserClientService = new RegisterUserClientService(context);
        this.userService = UserService.getInstance(context);
    }

    protected Boolean doInBackground(Void ... params) {
        try {
            this.userClientService.clearDataAndPreference();
            this.registrationResponse = this.registerUserClientService.createAccount(this.user);
            this.userService.processPackageDetail();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mException = e;
            return false;
        }
        return true;
    }

    protected void onPostExecute(Boolean result) {
        if (result.booleanValue() && this.taskListener != null) {
            this.taskListener.onSuccess(this.registrationResponse, this.context);
        } else if (this.mException != null && this.taskListener != null) {
            this.taskListener.onFailure(this.registrationResponse, this.mException);
        }
    }

    public static interface TaskListener {
        public void onSuccess(RegistrationResponse var1, Context var2);

        public void onFailure(RegistrationResponse var1, Exception var2);
    }
}

