/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.Applozic;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicommons.commons.core.utils.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;

public class MobiComKitClientService {
    public static final String BASE_URL_METADATA = "com.applozic.server.url";
    public static final String MQTT_BASE_URL_METADATA = "com.applozic.mqtt.server.url";
    public static final String FILE_URL = "/rest/ws/aws/file/";
    public static String APPLICATION_KEY_HEADER = "Application-Key";
    public static String APP_MOUDLE_NAME_KEY_HEADER = "App-Module-Name";
    public static String APPLICATION_KEY_HEADER_VALUE_METADATA = "com.applozic.application.key";
    public static String APP_MODULE_NAME_META_DATA_KEY = "com.applozic.module.key";
    protected Context context;
    protected String DEFAULT_URL = "https://apps.applozic.com";
    protected String FILE_BASE_URL = "https://applozic.appspot.com";
    protected String DEFAULT_MQTT_URL = "tcp://apps.applozic.com:1883";

    public MobiComKitClientService() {
    }

    public MobiComKitClientService(Context context) {
        this.context = context.getApplicationContext();
    }

    public static String getApplicationKey(Context context) {
        String applicationKey = Applozic.getInstance(context).getApplicationKey();
        if (!TextUtils.isEmpty((CharSequence)applicationKey)) {
            return applicationKey;
        }
        return Utils.getMetaDataValue((Context)context.getApplicationContext(), (String)APPLICATION_KEY_HEADER_VALUE_METADATA);
    }

    public static String getAppModuleName(Context context) {
        return Utils.getMetaDataValue((Context)context.getApplicationContext(), (String)APP_MODULE_NAME_META_DATA_KEY);
    }

    protected String getBaseUrl() {
        String SELECTED_BASE_URL = MobiComUserPreference.getInstance(this.context).getUrl();
        if (!TextUtils.isEmpty((CharSequence)SELECTED_BASE_URL)) {
            return SELECTED_BASE_URL;
        }
        String BASE_URL = Utils.getMetaDataValue((Context)this.context.getApplicationContext(), (String)BASE_URL_METADATA);
        if (!TextUtils.isEmpty((CharSequence)BASE_URL)) {
            return BASE_URL;
        }
        return this.DEFAULT_URL;
    }

    protected String getMqttBaseUrl() {
        String MQTT_BROKER_URL = MobiComUserPreference.getInstance(this.context).getMqttBrokerUrl();
        if (!TextUtils.isEmpty((CharSequence)MQTT_BROKER_URL)) {
            return MQTT_BROKER_URL;
        }
        String MQTT_BASE_URL = Utils.getMetaDataValue((Context)this.context.getApplicationContext(), (String)MQTT_BASE_URL_METADATA);
        if (!TextUtils.isEmpty((CharSequence)MQTT_BASE_URL)) {
            return MQTT_BASE_URL;
        }
        return this.DEFAULT_MQTT_URL;
    }

    public PasswordAuthentication getCredentials() {
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isRegistered()) {
            return null;
        }
        return new PasswordAuthentication(userPreferences.getUserId(), userPreferences.getDeviceKeyString().toCharArray());
    }

    public HttpURLConnection openHttpConnection(String urlString) throws IOException {
        HttpURLConnection httpConn;
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException("Not an HTTP connection");
        }
        try {
            httpConn = (HttpURLConnection)conn;
            httpConn.setAllowUserInteraction(false);
            httpConn.setInstanceFollowRedirects(true);
            httpConn.setRequestMethod("GET");
            httpConn.connect();
        }
        catch (Exception ex) {
            throw new IOException("Error connecting");
        }
        return httpConn;
    }

    public String getFileUrl() {
        return this.FILE_BASE_URL + FILE_URL;
    }
}

