/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.applozic.mobicomkit.api.account.user.UserService;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.List;

public class ConversationIntentService
extends IntentService {
    private static final String TAG = "ConversationIntent";
    public static final String SYNC = "AL_SYNC";
    private static final int PRE_FETCH_MESSAGES_FOR = 6;
    private MobiComMessageService mobiComMessageService;

    public ConversationIntentService() {
        super(TAG);
    }

    public void onCreate() {
        super.onCreate();
        this.mobiComMessageService = new MobiComMessageService((Context)this, MessageIntentService.class);
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        boolean sync = intent.getBooleanExtra(SYNC, false);
        Log.i((String)TAG, (String)("Syncing messages service started: " + sync));
        if (sync) {
            this.mobiComMessageService.syncMessages();
        } else {
            Thread thread = new Thread(new ConversationSync());
            thread.start();
        }
    }

    private class ConversationSync
    implements Runnable {
        @Override
        public void run() {
            try {
                UserService.getInstance((Context)ConversationIntentService.this).processSyncUserBlock();
                MobiComConversationService mobiComConversationService = new MobiComConversationService((Context)ConversationIntentService.this);
                List<Message> messages = mobiComConversationService.getLatestMessagesGroupByPeople();
                for (Message message : messages.subList(0, Math.min(6, messages.size()))) {
                    Contact contact = null;
                    Channel channel = null;
                    if (message.getGroupId() != null) {
                        channel = new Channel(message.getGroupId());
                    } else {
                        contact = new Contact(message.getContactIds());
                    }
                    mobiComConversationService.getMessages(1L, null, contact, channel, null, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

