/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.Toast;
import com.applozic.mobicomkit.api.attachment.AttachmentTask;
import com.applozic.mobicomkit.api.attachment.AttachmentView;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AttachmentManager {
    static final int DOWNLOAD_FAILED = -1;
    static final int DECODE_FAILED = -2;
    static final int DOWNLOAD_STARTED = 1;
    static final int DOWNLOAD_COMPLETE = 2;
    static final int DECODE_STARTED = 3;
    static final int TASK_COMPLETE = 4;
    private static final String TAG = "AttachmentManager";
    private static final int KEEP_ALIVE_TIME = 1;
    private static final int IMAGE_CACHE_SIZE = 0x400000;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private static final int CORE_POOL_SIZE = 8;
    private static final int MAXIMUM_POOL_SIZE = 8;
    private static int NUMBER_OF_CORES;
    private static AttachmentManager sInstance;
    public final List<String> attachmentInProgress = new ArrayList<String>();
    public final List<AttachmentTask> attachmentTaskList = new ArrayList<AttachmentTask>();
    private LruCache<String, Bitmap> mPhotoCache = null;
    private final BlockingQueue<Runnable> mDownloadWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final BlockingQueue<Runnable> mDecodeWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final Queue<AttachmentTask> mPhotoTaskWorkQueue = new LinkedBlockingQueue<AttachmentTask>();
    private final ThreadPoolExecutor mDownloadThreadPool = new ThreadPoolExecutor(8, 8, 1L, KEEP_ALIVE_TIME_UNIT, this.mDownloadWorkQueue);
    private final ThreadPoolExecutor mDecodeThreadPool = new ThreadPoolExecutor(NUMBER_OF_CORES, NUMBER_OF_CORES, 1L, KEEP_ALIVE_TIME_UNIT, this.mDecodeWorkQueue);
    private Handler mHandler;

    private AttachmentManager() {
        this.mPhotoCache = new LruCache<String, Bitmap>(0x400000){};
        this.mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message inputMessage) {
                AttachmentTask attachmentTask = (AttachmentTask)inputMessage.obj;
                AttachmentView localView = attachmentTask.getPhotoView();
                if (localView != null) {
                    switch (inputMessage.what) {
                        case 1: {
                            localView.getMessage().setAttDownloadInProgress(true);
                            localView.getProressBar().setVisibility(0);
                            break;
                        }
                        case 2: {
                            localView.getProressBar().setProgress(70);
                            localView.getMessage().setAttDownloadInProgress(false);
                            break;
                        }
                        case 3: {
                            localView.getProressBar().setVisibility(0);
                            localView.getProressBar().setProgress(90);
                            break;
                        }
                        case 4: {
                            if (localView.getDownloadProgressLayout() != null && !localView.getMessage().isAttachmentUploadInProgress()) {
                                localView.getDownloadProgressLayout().setVisibility(8);
                            } else if (localView.getProressBar() != null) {
                                localView.getProressBar().setVisibility(8);
                            }
                            BroadcastService.sendMessageUpdateBroadcast(localView.getContext(), BroadcastService.INTENT_ACTIONS.MESSAGE_ATTACHMENT_DOWNLOAD_DONE.toString(), localView.getMessage());
                            localView.setImageBitmap(attachmentTask.getImage());
                            AttachmentManager.this.recycleTask(attachmentTask);
                            break;
                        }
                        case -1: {
                            localView.getProressBar().setProgress(0);
                            localView.getMessage().setAttDownloadInProgress(false);
                            localView.getDownloadProgressLayout().setVisibility(8);
                            localView.setVisibility(4);
                            localView.cancelDownload();
                            BroadcastService.sendMessageUpdateBroadcast(localView.getContext(), BroadcastService.INTENT_ACTIONS.MESSAGE_ATTACHMENT_DOWNLOAD_FAILD.toString(), localView.getMessage());
                            Toast.makeText((Context)localView.getContext(), (CharSequence)"Download failed.", (int)0).show();
                            AttachmentManager.this.recycleTask(attachmentTask);
                            break;
                        }
                        default: {
                            super.handleMessage(inputMessage);
                        }
                    }
                }
            }
        };
    }

    public static AttachmentManager getInstance() {
        return sInstance;
    }

    public static boolean isAttachmentInProgress(String messageKeyString) {
        boolean result = false;
        if (sInstance != null) {
            result = AttachmentManager.sInstance.attachmentInProgress.contains(messageKeyString);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll() {
        AttachmentTask[] taskArray = new AttachmentTask[AttachmentManager.sInstance.mDownloadWorkQueue.size()];
        AttachmentManager.sInstance.mDownloadWorkQueue.toArray(taskArray);
        int taskArraylen = taskArray.length;
        AttachmentManager attachmentManager = sInstance;
        synchronized (attachmentManager) {
            for (AttachmentTask aTaskArray : taskArray) {
                Thread thread = aTaskArray.mThreadThis;
                if (null == thread) continue;
                thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDownload(AttachmentTask downloaderTask) {
        if (downloaderTask != null) {
            AttachmentManager attachmentManager = sInstance;
            synchronized (attachmentManager) {
                Thread thread = downloaderTask.getCurrentThread();
                if (null != thread) {
                    thread.interrupt();
                } else {
                    Log.i((String)TAG, (String)"Thread is coming null");
                }
            }
            AttachmentManager.sInstance.mDownloadThreadPool.remove(downloaderTask.getHTTPDownloadRunnable());
        }
    }

    public static AttachmentTask startDownload(AttachmentView imageView, boolean cacheFlag) {
        AttachmentTask downloadTask = AttachmentManager.sInstance.mPhotoTaskWorkQueue.poll();
        if (null == downloadTask) {
            downloadTask = new AttachmentTask();
        }
        downloadTask.initializeDownloaderTask(sInstance, imageView, cacheFlag);
        if (!downloadTask.getMessage().isAttachmentDownloaded()) {
            AttachmentManager.sInstance.mDownloadThreadPool.execute(downloadTask.getHTTPDownloadRunnable());
            AttachmentManager.sInstance.attachmentInProgress.add(downloadTask.getMessage().getKeyString());
            AttachmentManager.sInstance.attachmentTaskList.add(downloadTask);
            imageView.getProressBar().setVisibility(0);
        } else {
            sInstance.handleState(downloadTask, 2);
        }
        return downloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentTask getBGThreadForAttachment(String messageKeyString) {
        Log.d((String)TAG, (String)("Worker length... " + AttachmentManager.sInstance.attachmentTaskList.size()));
        AttachmentManager attachmentManager = sInstance;
        synchronized (attachmentManager) {
            for (AttachmentTask r : AttachmentManager.sInstance.attachmentTaskList) {
                if (r.getMessage() == null || !messageKeyString.equals(r.getMessage().getKeyString())) continue;
                Log.i((String)TAG, (String)("Found the thread for: " + messageKeyString));
                return r;
            }
        }
        Log.i((String)TAG, (String)("Not found the thread for: " + messageKeyString));
        return null;
    }

    @SuppressLint(value={"HandlerLeak"})
    public void handleState(AttachmentTask photoTask, int state) {
        switch (state) {
            case 4: {
                if (photoTask.isCacheEnabled() && photoTask != null && photoTask.getImage() != null) {
                    this.mPhotoCache.put((Object)photoTask.getMessage().getKeyString(), (Object)photoTask.getImage());
                }
                Message completeMessage = this.mHandler.obtainMessage(state, (Object)photoTask);
                completeMessage.sendToTarget();
                break;
            }
            case 2: {
                if (photoTask.getPhotoView() != null && photoTask.getContentType() != null && photoTask.getContentType().contains("image")) {
                    this.mDecodeThreadPool.execute(photoTask.getPhotoDecodeRunnable());
                } else {
                    this.mHandler.obtainMessage(4, (Object)photoTask).sendToTarget();
                }
            }
            default: {
                this.mHandler.obtainMessage(state, (Object)photoTask).sendToTarget();
            }
        }
    }

    void recycleTask(AttachmentTask downloadTask) {
        downloadTask.recycle();
        this.mPhotoTaskWorkQueue.offer(downloadTask);
    }

    public Bitmap getBitMapFromCache(String key) {
        if (this.mPhotoCache != null) {
            return (Bitmap)this.mPhotoCache.get((Object)key);
        }
        return null;
    }

    static {
        NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
        sInstance = null;
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        sInstance = new AttachmentManager();
    }
}

