/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicommons.commons.core.utils.DBUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MessageDatabaseService {
    private static final String TAG = "MessageDatabaseService";
    private static final String MIN_CREATED_AT_KEY = "mck.sms.createdAt.min";
    private static final String MAX_CREATED_AT_KEY = "mck.sms.createdAt.max";
    public static List<Message> recentlyAddedMessage = new ArrayList<Message>();
    Context context = null;
    private MobiComUserPreference userPreferences;
    private MobiComDatabaseHelper dbHelper;

    public MessageDatabaseService(Context context) {
        this.context = context.getApplicationContext();
        this.userPreferences = MobiComUserPreference.getInstance(context);
        this.dbHelper = MobiComDatabaseHelper.getInstance(context);
    }

    public static Message getMessage(Cursor cursor) {
        String metadata;
        String filePaths;
        Message message = new Message();
        message.setMessageId(cursor.getLong(cursor.getColumnIndex("id")));
        message.setKeyString(cursor.getString(cursor.getColumnIndex("keyString")));
        message.setType(cursor.getShort(cursor.getColumnIndex("type")));
        message.setSource(cursor.getShort(cursor.getColumnIndex("source")));
        Long storeOnDevice = cursor.getLong(cursor.getColumnIndex("storeOnDevice"));
        message.setStoreOnDevice(storeOnDevice != null && storeOnDevice.intValue() == 1);
        String contactNumbers = cursor.getString(cursor.getColumnIndex("contactNumbers"));
        message.setContactIds(contactNumbers);
        message.setCreatedAtTime(cursor.getLong(cursor.getColumnIndex("createdAt")));
        Long delivered = cursor.getLong(cursor.getColumnIndex("delivered"));
        message.setDelivered(delivered != null && delivered.intValue() == 1);
        Long canceled = cursor.getLong(cursor.getColumnIndex("canceled"));
        message.setCanceled(canceled != null && canceled.intValue() == 1);
        Long read = cursor.getLong(cursor.getColumnIndex("read"));
        message.setRead(read != null && read.intValue() == 1);
        message.setStatus(cursor.getShort(cursor.getColumnIndex("status")));
        message.setClientGroupId(cursor.getString(cursor.getColumnIndex("clientGroupId")));
        Long scheduledAt = cursor.getLong(cursor.getColumnIndex("scheduledAt"));
        message.setScheduledAt(scheduledAt == null || scheduledAt.intValue() == 0 ? null : scheduledAt);
        message.setMessage(cursor.getString(cursor.getColumnIndex("message")));
        Long sentToServer = cursor.getLong(cursor.getColumnIndex("sentToServer"));
        message.setSentToServer(sentToServer != null && sentToServer.intValue() == 1);
        message.setTo(cursor.getString(cursor.getColumnIndex("toNumbers")));
        int timeToLive = cursor.getInt(cursor.getColumnIndex("timeToLive"));
        message.setTimeToLive(timeToLive != 0 ? Integer.valueOf(timeToLive) : null);
        String fileMetaKeyStrings = cursor.getString(cursor.getColumnIndex("fileMetaKeyStrings"));
        if (!TextUtils.isEmpty((CharSequence)fileMetaKeyStrings)) {
            message.setFileMetaKeyStrings(fileMetaKeyStrings);
        }
        if (!TextUtils.isEmpty((CharSequence)(filePaths = cursor.getString(cursor.getColumnIndex("filePaths"))))) {
            message.setFilePaths(Arrays.asList(filePaths.split(",")));
        }
        if (!TextUtils.isEmpty((CharSequence)(metadata = cursor.getString(cursor.getColumnIndex("metadata"))))) {
            message.setMetadata((Map)GsonUtils.getObjectFromJson((String)metadata, Map.class));
        }
        message.setApplicationId(cursor.getString(cursor.getColumnIndex("applicationId")));
        message.setContentType(cursor.getShort(cursor.getColumnIndex("messageContentType")));
        int conversationId = cursor.getInt(cursor.getColumnIndex("conversationId"));
        if (conversationId == 0) {
            message.setConversationId(null);
        } else {
            message.setConversationId(conversationId);
        }
        message.setTopicId(cursor.getString(cursor.getColumnIndex("topicId")));
        int channelKey = cursor.getInt(cursor.getColumnIndex("channelKey"));
        if (channelKey == 0) {
            message.setGroupId(null);
        } else {
            message.setGroupId(channelKey);
        }
        if (cursor.getString(cursor.getColumnIndex("blobKeyString")) != null) {
            FileMeta fileMeta = new FileMeta();
            fileMeta.setKeyString(cursor.getString(cursor.getColumnIndex("metaFileKeyString")));
            fileMeta.setBlobKeyString(cursor.getString(cursor.getColumnIndex("blobKeyString")));
            fileMeta.setThumbnailUrl(cursor.getString(cursor.getColumnIndex("thumbnailUrl")));
            fileMeta.setSize(cursor.getInt(cursor.getColumnIndex("size")));
            fileMeta.setName(cursor.getString(cursor.getColumnIndex("name")));
            fileMeta.setContentType(cursor.getString(cursor.getColumnIndex("contentType")));
            message.setFileMetas(fileMeta);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> getMessageList(Cursor cursor) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    messageList.add(MessageDatabaseService.getMessage(cursor));
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> getLatestMessageList(Cursor cursor) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    Message message;
                    if ((message = MessageDatabaseService.getMessage(cursor)) == null || Message.MetaDataType.ARCHIVE.getValue().equals(message.getMetaDataValueForKey(Message.MetaDataType.KEY.getValue()))) continue;
                    messageList.add(message);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> getLatestMessageListForNotification(Cursor cursor) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            cursor.moveToFirst();
            if (cursor.getCount() > 0) {
                do {
                    Message message;
                    if ((message = MessageDatabaseService.getMessage(cursor)) == null || Message.GroupMessageMetaData.FALSE.getValue().equals(message.getMetaDataValueForKey(Message.GroupMessageMetaData.KEY.getValue()))) continue;
                    messageList.add(message);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return messageList;
    }

    public List<Message> getMessages(Long startTime, Long endTime, Contact contact, Channel channel, Integer conversationId) {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        if (channel != null && channel.getKey() != null) {
            structuredNameWhere = structuredNameWhere + "channelKey = ? AND ";
            structuredNameParamsList.add(String.valueOf(channel.getKey()));
        } else {
            structuredNameWhere = structuredNameWhere + "channelKey = ? AND ";
            structuredNameParamsList.add("0");
        }
        if (contact != null && !TextUtils.isEmpty((CharSequence)contact.getContactIds())) {
            structuredNameWhere = structuredNameWhere + "contactNumbers = ? AND ";
            structuredNameParamsList.add(contact.getContactIds());
        }
        if (startTime != null) {
            structuredNameWhere = structuredNameWhere + "createdAt >= ? AND ";
            structuredNameParamsList.add(String.valueOf(startTime));
        }
        if (endTime != null) {
            structuredNameWhere = structuredNameWhere + "createdAt < ? AND ";
            structuredNameParamsList.add(String.valueOf(endTime));
        }
        if (BroadcastService.isContextBasedChatEnabled() && conversationId != null && conversationId != 0) {
            structuredNameWhere = structuredNameWhere + "conversationId = ? AND ";
            structuredNameParamsList.add(String.valueOf(conversationId));
        }
        structuredNameWhere = structuredNameWhere + "messageContentType != ? AND ";
        structuredNameParamsList.add(String.valueOf(Message.ContentType.HIDDEN.getValue()));
        structuredNameWhere = structuredNameWhere + "deleted = ? AND ";
        structuredNameParamsList.add("0");
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isDisplayCallRecordEnable()) {
            structuredNameWhere = structuredNameWhere + "type != ? AND type != ? AND ";
            structuredNameParamsList.add(String.valueOf(Message.MessageType.CALL_INCOMING.getValue()));
            structuredNameParamsList.add(String.valueOf(Message.MessageType.CALL_OUTGOING.getValue()));
        }
        if (!TextUtils.isEmpty((CharSequence)structuredNameWhere)) {
            structuredNameWhere = structuredNameWhere.substring(0, structuredNameWhere.length() - 5);
        }
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt asc");
        List<Message> messageList = MessageDatabaseService.getMessageList(cursor);
        this.dbHelper.close();
        return messageList;
    }

    public List<Message> getUnreadMessages() {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "messageContentType not in (11) AND ";
        structuredNameWhere = structuredNameWhere + "status in (0,3) AND ";
        structuredNameWhere = structuredNameWhere + "type = ? ";
        structuredNameParamsList.add(String.valueOf(Message.MessageType.MT_INBOX.getValue()));
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt desc limit 10");
        return MessageDatabaseService.getLatestMessageListForNotification(cursor);
    }

    public List<Message> getPendingMessages() {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "sentToServer = ? and canceled = ? and deleted = ?";
        structuredNameParamsList.add("0");
        structuredNameParamsList.add("0");
        structuredNameParamsList.add("0");
        Cursor cursor = this.dbHelper.getWritableDatabase().query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt asc");
        List<Message> messageList = MessageDatabaseService.getMessageList(cursor);
        this.dbHelper.close();
        return messageList;
    }

    public List<Message> getPendingDeleteMessages() {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "sentToServer = ? and deleted = ?";
        structuredNameParamsList.add("1");
        structuredNameParamsList.add("1");
        Cursor cursor = this.dbHelper.getWritableDatabase().query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt asc");
        List<Message> messageList = MessageDatabaseService.getMessageList(cursor);
        return messageList;
    }

    public long getMinCreatedAtFromMessageTable() {
        SQLiteDatabase db = MobiComDatabaseHelper.getInstance(this.context).getWritableDatabase();
        Cursor cursor = db.rawQuery("select min(createdAt) as createdAt from sms", null);
        long createdAt = 0L;
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            createdAt = cursor.getLong(0);
        }
        cursor.close();
        this.dbHelper.close();
        return createdAt;
    }

    public Message getMessage(String contactNumber, String message) {
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "contactNumbers = ? AND message = ?";
        structuredNameParamsList.add(contactNumber);
        structuredNameParamsList.add(message);
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, null);
        Message message1 = null;
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            message1 = MessageDatabaseService.getMessage(cursor);
        }
        cursor.close();
        this.dbHelper.close();
        return message1;
    }

    public boolean isMessagePresent(String key) {
        boolean present;
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        Cursor cursor = database.rawQuery("SELECT COUNT(*) FROM sms WHERE keyString = ?", new String[]{key});
        cursor.moveToFirst();
        boolean bl = present = cursor.getInt(0) > 0;
        if (cursor != null) {
            cursor.close();
        }
        this.dbHelper.close();
        return present;
    }

    public Message getMessage(String keyString) {
        if (TextUtils.isEmpty((CharSequence)keyString)) {
            return null;
        }
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        structuredNameWhere = structuredNameWhere + "keyString = ?";
        structuredNameParamsList.add(keyString);
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, null);
        Message message = null;
        if (cursor.getCount() > 0) {
            cursor.moveToFirst();
            message = MessageDatabaseService.getMessage(cursor);
        }
        cursor.close();
        this.dbHelper.close();
        return message;
    }

    public List<Message> getScheduledMessages(Long time) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (!DBUtils.isTableExists((SQLiteDatabase)db, (String)"ScheduleSMS")) {
            this.dbHelper.close();
            return new ArrayList<Message>();
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        Cursor cursor = time != null ? db.query("ScheduleSMS", null, "timeStamp <= ?", new String[]{time + ""}, null, null, null) : db.query("ScheduleSMS", null, null, null, null, null, null);
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            do {
                String createdTime = cursor.getString(cursor.getColumnIndex("timeStamp"));
                Message message = new Message();
                message.setCreatedAtTime(Long.valueOf(createdTime));
                message.setScheduledAt(cursor.getLong(cursor.getColumnIndex("timeStamp")));
                message.setMessage(cursor.getString(cursor.getColumnIndex("sms")));
                message.setType(cursor.getShort(cursor.getColumnIndex("SMSType")));
                message.setSource(cursor.getShort(cursor.getColumnIndex("source")));
                message.setContactIds(cursor.getString(cursor.getColumnIndex("contactId")));
                message.setTo(cursor.getString(cursor.getColumnIndex("toField")));
                message.setKeyString(cursor.getString(cursor.getColumnIndex("smsKeyString")));
                message.setStoreOnDevice("1".equals(cursor.getString(cursor.getColumnIndex("storeOnDevice"))));
                if (cursor.getColumnIndex("timeToLive") != -1) {
                    int timeToLive = cursor.getInt(cursor.getColumnIndex("timeToLive"));
                    message.setTimeToLive(timeToLive == 0 ? null : Integer.valueOf(timeToLive));
                }
                messages.add(message);
            } while (cursor.moveToNext());
        }
        cursor.close();
        this.dbHelper.close();
        return messages;
    }

    public void deleteScheduledMessages(long time) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        db.delete("ScheduleSMS", "timeStamp <= ? ", new String[]{time + ""});
        this.dbHelper.close();
    }

    public boolean deleteScheduledMessage(String messageKeyString) {
        SQLiteDatabase db = MobiComDatabaseHelper.getInstance(this.context).getWritableDatabase();
        boolean deleted = db.delete("ScheduleSMS", "smsKeyString='" + messageKeyString + "'", null) > 0;
        this.dbHelper.close();
        return deleted;
    }

    public boolean isMessageTableEmpty() {
        this.dbHelper = MobiComDatabaseHelper.getInstance(this.context);
        boolean empty = DBUtils.isTableEmpty((SQLiteDatabase)this.dbHelper.getWritableDatabase(), (String)"sms");
        this.dbHelper.close();
        return empty;
    }

    public synchronized void updateMessageFileMetas(long messageId, Message message) {
        FileMeta fileMeta;
        ContentValues values = new ContentValues();
        values.put("keyString", message.getKeyString());
        if (message.getFileMetaKeyStrings() != null) {
            values.put("fileMetaKeyStrings", message.getFileMetaKeyStrings());
        }
        if (message.getFileMetas() != null && (fileMeta = message.getFileMetas()) != null) {
            values.put("thumbnailUrl", fileMeta.getThumbnailUrl());
            values.put("size", Integer.valueOf(fileMeta.getSize()));
            values.put("name", fileMeta.getName());
            values.put("contentType", fileMeta.getContentType());
            values.put("metaFileKeyString", fileMeta.getKeyString());
            values.put("blobKeyString", fileMeta.getBlobKeyString());
        }
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + messageId, null);
        this.dbHelper.close();
    }

    public synchronized long createMessage(Message message) {
        long id = -1L;
        if (message.getMessageId() != null) {
            return message.getMessageId();
        }
        id = this.createSingleMessage(message);
        message.setMessageId(id);
        if (message.isSentToMany()) {
            String[] toList;
            for (String tofield : toList = message.getTo().trim().replace("undefined,", "").split(",")) {
                Message singleMessage = new Message(message);
                singleMessage.setKeyString(message.getKeyString());
                singleMessage.setTo(tofield);
                singleMessage.processContactIds(this.context);
                singleMessage.setMessageId(this.createSingleMessage(singleMessage));
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long createSingleMessage(Message message) {
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        long id = -1L;
        boolean duplicateCheck = true;
        SharedPreferences prefs = this.context.getSharedPreferences(MobiComKitClientService.getApplicationKey(this.context), 0);
        long minCreatedAt = prefs.getLong(MIN_CREATED_AT_KEY, 0L);
        long maxCreatedAt = prefs.getLong(MAX_CREATED_AT_KEY, Long.MAX_VALUE);
        if (message.getCreatedAtTime() < minCreatedAt) {
            duplicateCheck = false;
            prefs.edit().putLong(MIN_CREATED_AT_KEY, message.getCreatedAtTime().longValue()).commit();
        }
        if (message.getCreatedAtTime() > maxCreatedAt) {
            duplicateCheck = false;
            prefs.edit().putLong(MAX_CREATED_AT_KEY, message.getCreatedAtTime().longValue()).commit();
        }
        if (duplicateCheck) {
            String queryClause = "";
            queryClause = message.getGroupId() != null ? "channelKey ='" + String.valueOf(message.getGroupId()) + "'" : "contactNumbers ='" + message.getContactIds() + "'";
            Cursor cursor = message.isSentToServer() && !TextUtils.isEmpty((CharSequence)message.getKeyString()) ? database.rawQuery("SELECT COUNT(*) FROM sms WHERE keyString = ? and " + queryClause, new String[]{message.getKeyString()}) : database.rawQuery("SELECT COUNT(*) FROM sms WHERE sentToServer=0 and " + queryClause + " and message = ? and createdAt = " + message.getCreatedAtTime(), new String[]{message.getMessage()});
            cursor.moveToFirst();
            if (cursor.getInt(0) > 0) {
                cursor.close();
                this.dbHelper.close();
                return -1L;
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        try {
            FileMeta fileMeta;
            ContentValues values = new ContentValues();
            values.put("toNumbers", message.getTo());
            values.put("message", message.getMessage());
            values.put("createdAt", message.getCreatedAtTime());
            values.put("storeOnDevice", Boolean.valueOf(message.isStoreOnDevice()));
            values.put("delivered", message.getDelivered());
            values.put("scheduledAt", message.getScheduledAt());
            values.put("type", message.getType());
            values.put("contactNumbers", message.getContactIds());
            values.put("sentToServer", Boolean.valueOf(message.isSentToServer()));
            values.put("keyString", message.getKeyString());
            values.put("source", message.getSource());
            values.put("timeToLive", message.getTimeToLive());
            values.put("canceled", Boolean.valueOf(message.isCanceled()));
            values.put("read", Integer.valueOf(message.isRead() != false ? 1 : 0));
            values.put("applicationId", message.getApplicationId());
            values.put("messageContentType", Short.valueOf(message.getContentType()));
            values.put("status", Short.valueOf(message.getStatus()));
            values.put("conversationId", message.getConversationId());
            values.put("topicId", message.getTopicId());
            if (message.getGroupId() != null) {
                values.put("channelKey", message.getGroupId());
            }
            if (!TextUtils.isEmpty((CharSequence)message.getClientGroupId())) {
                values.put("clientGroupId", message.getClientGroupId());
            }
            if (message.getFileMetaKeyStrings() != null) {
                values.put("fileMetaKeyStrings", message.getFileMetaKeyStrings());
            }
            if (message.getFilePaths() != null && !message.getFilePaths().isEmpty()) {
                values.put("filePaths", TextUtils.join((CharSequence)",", message.getFilePaths()));
            }
            if (message.getMetadata() != null && !message.getMetadata().isEmpty()) {
                values.put("metadata", GsonUtils.getJsonFromObject(message.getMetadata(), Map.class));
            }
            if (message.getFileMetas() != null && (fileMeta = message.getFileMetas()) != null) {
                values.put("thumbnailUrl", fileMeta.getThumbnailUrl());
                values.put("size", Integer.valueOf(fileMeta.getSize()));
                values.put("name", fileMeta.getName());
                values.put("contentType", fileMeta.getContentType());
                values.put("metaFileKeyString", fileMeta.getKeyString());
                values.put("blobKeyString", fileMeta.getBlobKeyString());
            }
            id = database.insert("sms", null, values);
        }
        catch (SQLiteConstraintException ex) {
            Log.e((String)TAG, (String)("Duplicate entry in sms table, sms: " + (Object)((Object)message)));
        }
        finally {
            this.dbHelper.close();
        }
        return id;
    }

    public void updateSmsType(String smsKeyString, Message.MessageType messageType) {
        ContentValues values = new ContentValues();
        values.put("type", messageType.getValue());
        this.dbHelper.getWritableDatabase().update("sms", values, "keyString='" + smsKeyString + "'", null);
        this.dbHelper.close();
    }

    public int updateMessageDeliveryReportForContact(String contactId, boolean markRead) {
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        String whereClause = "contactNumbers= '" + contactId + "' and ";
        values.put("delivered", "1");
        if (markRead) {
            whereClause = whereClause + "status not in (5)";
            values.put("status", String.valueOf(Message.Status.DELIVERED_AND_READ.getValue()));
        } else {
            whereClause = whereClause + "status not in (4,5)";
            values.put("status", String.valueOf(Message.Status.DELIVERED.getValue()));
        }
        whereClause = whereClause + " and type=5 ";
        int rows = database.update("sms", values, whereClause, null);
        this.dbHelper.close();
        return rows;
    }

    public void updateMessageDeliveryReportForContact(String messageKeyString, String contactNumber, boolean markRead) {
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        if (markRead) {
            values.put("status", String.valueOf(Message.Status.DELIVERED_AND_READ.getValue()));
        } else {
            values.put("status", String.valueOf(Message.Status.DELIVERED.getValue()));
        }
        values.put("delivered", "1");
        if (TextUtils.isEmpty((CharSequence)contactNumber)) {
            database.update("sms", values, "keyString='" + messageKeyString + "' and type = 5", null);
        } else {
            database.update("sms", values, "keyString='" + messageKeyString + "' and contactNumbers='" + contactNumber + "' and type = 5", null);
        }
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessageSyncStatus(Message message, String keyString) {
        try {
            ContentValues values = new ContentValues();
            values.put("keyString", keyString);
            values.put("sentToServer", "1");
            values.put("createdAt", Long.valueOf(message.getSentMessageTimeAtServer()));
            this.dbHelper.getWritableDatabase().update("sms", values, "id=" + message.getMessageId(), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeleteSyncStatus(Message message, String deleteStatus) {
        try {
            ContentValues values = new ContentValues();
            values.put("deleted", deleteStatus);
            this.dbHelper.getWritableDatabase().update("sms", values, "id=" + message.getMessageId(), null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public void updateInternalFilePath(String keyString, String filePath) {
        ContentValues values = new ContentValues();
        values.put("filePaths", filePath);
        this.dbHelper.getWritableDatabase().update("sms", values, "keyString='" + keyString + "'", null);
        this.dbHelper.close();
    }

    public void updateMessage(Long id, Long createdAt, String KeyString, boolean isSentToServer) {
        ContentValues values = new ContentValues();
        values.put("createdAt", createdAt);
        values.put("keyString", KeyString);
        values.put("sentToServer", Boolean.valueOf(isSentToServer));
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + id, null);
        this.dbHelper.close();
    }

    public void updateCanceledFlag(long smsId, int value) {
        ContentValues values = new ContentValues();
        values.put("canceled", Integer.valueOf(value));
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + smsId, null);
        this.dbHelper.close();
    }

    public void updateMessageReadFlag(long smsId, boolean read) {
        ContentValues values = new ContentValues();
        values.put("read", Integer.valueOf(read ? 1 : 0));
        values.put("status", Integer.valueOf(1));
        this.dbHelper.getWritableDatabase().update("sms", values, "id=" + smsId, null);
        this.dbHelper.close();
    }

    public int getUnreadMessageCountForContact(String userId) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.rawQuery("SELECT unreadCount FROM contact WHERE userId = '" + userId + "'", null);
            cursor.moveToFirst();
            int unreadMessageCount = 0;
            if (cursor.getCount() > 0) {
                unreadMessageCount = cursor.getInt(0);
            }
            cursor.close();
            this.dbHelper.close();
            return unreadMessageCount;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int getUnreadMessageCountForChannel(Integer channelKey) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.rawQuery("SELECT unreadCount FROM channel WHERE channelKey = '" + String.valueOf(channelKey) + "'", null);
            cursor.moveToFirst();
            int unreadMessage = 0;
            if (cursor.getCount() > 0) {
                unreadMessage = cursor.getInt(0);
            }
            cursor.close();
            this.dbHelper.close();
            return unreadMessage;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int getUnreadConversationCount() {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.rawQuery("SELECT COUNT(DISTINCT (contactNumbers)) FROM sms WHERE read = 0 ", null);
            cursor.moveToFirst();
            int conversationCount = 0;
            if (cursor.getCount() > 0) {
                conversationCount = cursor.getInt(0);
            }
            cursor.close();
            this.dbHelper.close();
            return conversationCount;
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)"Exception while fetching unread conversation count");
            return 0;
        }
    }

    public int getUnreadMessageCount() {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            Cursor cursor = db.rawQuery("SELECT COUNT(1) FROM sms WHERE read = 0 ", null);
            cursor.moveToFirst();
            int unreadMessageCount = 0;
            if (cursor.getCount() > 0) {
                unreadMessageCount = cursor.getInt(0);
            }
            cursor.close();
            this.dbHelper.close();
            return unreadMessageCount;
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)"Exception while fetching unread message count");
            return 0;
        }
    }

    public List<Message> getLatestMessage(String contactNumbers) {
        ArrayList<Message> messages = new ArrayList();
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select * from sms where contactNumbers = '" + contactNumbers + "'" + " order by createdAt desc limit 1", null);
        if (cursor.moveToFirst()) {
            messages = MessageDatabaseService.getMessageList(cursor);
        }
        this.dbHelper.close();
        return messages;
    }

    public List<Message> getLatestMessageByClientGroupId(String clientGroupId) {
        return this.getLatestMessageForChannel(null, clientGroupId);
    }

    public List<Message> getLatestMessageByChannelKey(Integer channelKey) {
        return this.getLatestMessageForChannel(channelKey, null);
    }

    private List<Message> getLatestMessageForChannel(Integer channelKey, String clientGroupId) {
        String clauseString = null;
        if (channelKey != null && channelKey != 0) {
            clauseString = " channelKey = '" + channelKey + "'";
        } else if (!TextUtils.isEmpty((CharSequence)clientGroupId)) {
            clauseString = " clientGroupId = '" + clientGroupId + "'";
        }
        ArrayList<Message> messages = new ArrayList();
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select * from sms where " + clauseString + " order by createdAt desc limit 1", null);
        if (cursor.moveToFirst()) {
            messages = MessageDatabaseService.getMessageList(cursor);
        }
        cursor.close();
        this.dbHelper.close();
        return messages;
    }

    public List<Message> getChannelCustomMessagesByClientGroupId(String clientGroupId) {
        return this.getChannelCustomMessageList(null, clientGroupId);
    }

    public List<Message> getChannelCustomMessagesByChannelKey(Integer channelKey) {
        return this.getChannelCustomMessageList(channelKey, null);
    }

    private List<Message> getChannelCustomMessageList(Integer channelKey, String clientGroupId) {
        String structuredNameWhere = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        if (channelKey != null && channelKey != 0) {
            structuredNameWhere = "channelKey = ? AND ";
            structuredNameParamsList.add(String.valueOf(channelKey));
        } else if (!TextUtils.isEmpty((CharSequence)clientGroupId)) {
            structuredNameWhere = "clientGroupId = ? AND ";
            structuredNameParamsList.add(clientGroupId);
        }
        structuredNameWhere = structuredNameWhere + "messageContentType in (10) ";
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.query("sms", null, structuredNameWhere, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "createdAt desc");
        return MessageDatabaseService.getMessageList(cursor);
    }

    public int updateReadStatus(String contactNumbers) {
        ContentValues values = new ContentValues();
        values.put("read", Integer.valueOf(1));
        int read = this.dbHelper.getWritableDatabase().update("sms", values, " contactNumbers = '" + contactNumbers + "'" + " and read = 0", null);
        this.dbHelper.close();
        return read;
    }

    public int updateReadStatusForKeyString(String keyString) {
        ContentValues values = new ContentValues();
        values.put("read", Integer.valueOf(1));
        values.put("status", Integer.valueOf(1));
        int read = this.dbHelper.getWritableDatabase().update("sms", values, " keyString = '" + keyString + "'", null);
        this.dbHelper.close();
        return read;
    }

    public int updateReadStatusForContact(String userId) {
        ContentValues values = new ContentValues();
        values.put("unreadCount", Integer.valueOf(0));
        int read = this.dbHelper.getWritableDatabase().update("contact", values, "userId = '" + userId + "'", null);
        this.dbHelper.close();
        return read;
    }

    public int updateReadStatusForChannel(String channelKey) {
        ContentValues values = new ContentValues();
        values.put("unreadCount", Integer.valueOf(0));
        int read = this.dbHelper.getWritableDatabase().update("channel", values, "channelKey = '" + channelKey + "'", null);
        this.dbHelper.close();
        return read;
    }

    public List<Message> getMessages(Long createdAt) {
        return this.getMessages(createdAt, null);
    }

    public List<Message> getMessages(Long createdAt, String searchText) {
        String createdAtClause = "";
        if (createdAt != null && createdAt > 0L) {
            createdAtClause = " and m1.createdAt < " + createdAt;
        }
        createdAtClause = createdAtClause + " and m1.deleted = 0 ";
        String messageTypeClause = "";
        String messageTypeJoinClause = "";
        String searchCaluse = "";
        MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
        if (!userPreferences.isDisplayCallRecordEnable()) {
            messageTypeClause = " and m1.type != " + Message.MessageType.CALL_INCOMING.getValue() + " and m1.type != " + Message.MessageType.CALL_OUTGOING.getValue();
            messageTypeJoinClause = " and m1.type = m2.type";
        }
        if (!TextUtils.isEmpty((CharSequence)searchText)) {
            searchCaluse = searchCaluse + " and m1.message like '%" + searchText.replaceAll("'", "''") + "%' ";
        }
        String hiddenType = " and m1.messageContentType != " + Message.ContentType.HIDDEN.getValue();
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select m1.* from sms m1 left outer join sms m2 on (m1.createdAt < m2.createdAt and m1.channelKey = m2.channelKey and m1.contactNumbers = m2.contactNumbers and m1.deleted = m2.deleted and  m1.messageContentType = m2.messageContentType" + messageTypeJoinClause + " ) where m2.createdAt is null " + createdAtClause + searchCaluse + hiddenType + messageTypeClause + " order by m1.createdAt desc", null);
        List<Message> messageList = MessageDatabaseService.getLatestMessageList(cursor);
        this.dbHelper.close();
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteMessage(Message message, String contactNumber) {
        String contactNumbers = contactNumber;
        String contactNumberClause = TextUtils.isEmpty((CharSequence)contactNumber) ? "" : " and contactNumbers='" + contactNumber + "'";
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        try (Cursor cursor = database.rawQuery("select contactNumbers from sms where keyString='" + message.getKeyString() + "'" + contactNumberClause, null);){
            if (cursor.moveToFirst()) {
                contactNumbers = cursor.getString(cursor.getColumnIndex("contactNumbers"));
            }
        }
        database.delete("sms", "keyString='" + message.getKeyString() + "'" + contactNumberClause, null);
        this.dbHelper.close();
        return contactNumbers;
    }

    public void deleteConversation(String contactNumber) {
        Log.i((String)TAG, (String)("Deleting conversation for contactNumber: " + contactNumber));
        int deletedRows = this.dbHelper.getWritableDatabase().delete("sms", "contactNumbers=? AND channelKey = 0", new String[]{contactNumber});
        this.updateContactUnreadCountToZero(contactNumber);
        this.dbHelper.close();
        Log.i((String)TAG, (String)("Delete " + deletedRows + " messages."));
    }

    public void deleteChannelConversation(Integer channelKey) {
        Log.i((String)TAG, (String)("Deleting  Conversation for channel: " + channelKey));
        int deletedRows = this.dbHelper.getWritableDatabase().delete("sms", "channelKey=?", new String[]{String.valueOf(channelKey)});
        this.updateChannelUnreadCountToZero(channelKey);
        this.dbHelper.close();
        Log.i((String)TAG, (String)("Delete " + deletedRows + " messages."));
    }

    public synchronized void updateContactUnreadCount(String userId) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE contact SET unreadCount = unreadCount + 1 WHERE userId ='" + userId + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateChannelUnreadCount(Integer channelKey) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE channel SET unreadCount = unreadCount + 1 WHERE channelKey ='" + channelKey + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateChannelUnreadCountToZero(Integer channelKey) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE channel SET unreadCount = 0 WHERE channelKey ='" + channelKey + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void updateContactUnreadCountToZero(String userId) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            db.execSQL("UPDATE contact SET unreadCount = 0 WHERE userId ='" + userId + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalUnreadCount() {
        Cursor channelCursor = null;
        Cursor contactCursor = null;
        int totalCount = 0;
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            contactCursor = db.rawQuery("SELECT * FROM contact WHERE unreadCount > 0 ", null);
            channelCursor = db.rawQuery("SELECT * FROM channel WHERE unreadCount > 0 ", null);
            if (contactCursor.moveToFirst()) {
                do {
                    totalCount += contactCursor.getInt(contactCursor.getColumnIndex("unreadCount"));
                } while (contactCursor.moveToNext());
            }
            if (channelCursor.moveToFirst()) {
                do {
                    totalCount += channelCursor.getInt(channelCursor.getColumnIndex("unreadCount"));
                } while (channelCursor.moveToNext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (channelCursor != null) {
                channelCursor.close();
            }
            if (contactCursor != null) {
                contactCursor.close();
            }
        }
        return totalCount;
    }
}

