/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ThumbnailUtils;
import android.os.Environment;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.ApplozicMultipartUtility;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.attachment.MarkStream;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;

public class FileClientService
extends MobiComKitClientService {
    public static final String MOBI_COM_IMAGES_FOLDER = "/image";
    public static final String MOBI_COM_VIDEOS_FOLDER = "/video";
    public static final String MOBI_COM_CONTACT_FOLDER = "/contact";
    public static final String MOBI_COM_OTHER_FILES_FOLDER = "/other";
    public static final String MOBI_COM_THUMBNAIL_SUFIX = "/.Thumbnail";
    public static final String FILE_UPLOAD_URL = "/rest/ws/aws/file/url";
    public static final String IMAGE_DIR = "image";
    private static final int MARK = 1024;
    private static final String TAG = "FileClientService";
    private HttpRequestUtils httpRequestUtils;
    public static final String AL_UPLOAD_FILE_URL = "/rest/ws/upload/file";
    private static final String MAIN_FOLDER_META_DATA = "main_folder_name";

    public FileClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String profileImageUploadURL() {
        return this.getBaseUrl() + AL_UPLOAD_FILE_URL;
    }

    public String getFileUploadUrl() {
        return this.FILE_BASE_URL + FILE_UPLOAD_URL;
    }

    public static File getFilePath(String fileName, Context context, String contentType, boolean isThumbnail) {
        File dir;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            String folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_OTHER_FILES_FOLDER;
            if (contentType.startsWith(IMAGE_DIR)) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_IMAGES_FOLDER;
            } else if (contentType.startsWith("video")) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_VIDEOS_FOLDER;
            } else if (contentType.equalsIgnoreCase("text/x-vCard")) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_COM_CONTACT_FOLDER;
            }
            if (isThumbnail) {
                folder = folder + MOBI_COM_THUMBNAIL_SUFIX;
            }
            if (!(dir = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + folder)).exists()) {
                dir.mkdirs();
            }
        } else {
            ContextWrapper cw = new ContextWrapper(context);
            dir = cw.getDir(IMAGE_DIR, 0);
        }
        File filePath = new File(dir, fileName);
        return filePath;
    }

    public static File getFilePath(String fileName, Context context, String contentType) {
        return FileClientService.getFilePath(fileName, context, contentType, false);
    }

    public Bitmap loadThumbnailImage(Context context, FileMeta fileMeta, int reqWidth, int reqHeight) {
        try {
            Bitmap attachedImage = null;
            String thumbnailUrl = fileMeta.getThumbnailUrl();
            String contentType = fileMeta.getContentType();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            String imageName = fileMeta.getBlobKeyString() + "." + FileUtils.getFileFormat((String)fileMeta.getName());
            String imageLocalPath = FileClientService.getFilePath(imageName, context, fileMeta.getContentType(), true).getAbsolutePath();
            if (imageLocalPath != null) {
                try {
                    attachedImage = BitmapFactory.decodeFile((String)imageLocalPath);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("File not found on local storage: " + ex.getMessage()));
                }
            }
            if (attachedImage == null) {
                HttpURLConnection connection = this.openHttpConnection(thumbnailUrl);
                if (connection.getResponseCode() == 200) {
                    attachedImage = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
                    File file = FileClientService.getFilePath(imageName, context, contentType, true);
                    imageLocalPath = ImageUtils.saveImageToInternalStorage((File)file, (Bitmap)attachedImage);
                } else {
                    Log.w((String)TAG, (String)("Download is failed response code is ...." + connection.getResponseCode()));
                    return null;
                }
            }
            options.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)options, (int)200, (int)reqHeight);
            options.inJustDecodeBounds = false;
            attachedImage = BitmapFactory.decodeFile((String)imageLocalPath, (BitmapFactory.Options)options);
            return attachedImage;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("File not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        return null;
    }

    public void loadContactsvCard(Message message) {
        File file = null;
        try {
            InputStream inputStream = null;
            FileMeta fileMeta = message.getFileMetas();
            String contentType = fileMeta.getContentType();
            String fileName = fileMeta.getName();
            file = FileClientService.getFilePath(fileName, this.context.getApplicationContext(), contentType);
            if (!file.exists()) {
                HttpURLConnection connection = this.openHttpConnection(new MobiComKitClientService(this.context).getFileUrl() + fileMeta.getBlobKeyString());
                if (connection.getResponseCode() != 200) {
                    Log.i((String)TAG, (String)("Got Error response while uploading file : " + connection.getResponseCode()));
                    return;
                }
                inputStream = connection.getInputStream();
                FileOutputStream output = new FileOutputStream(file);
                byte[] data = new byte[1024];
                int count = 0;
                while ((count = inputStream.read(data)) != -1) {
                    ((OutputStream)output).write(data, 0, count);
                }
                output.flush();
                ((OutputStream)output).close();
                inputStream.close();
            }
            new MessageDatabaseService(this.context).updateInternalFilePath(message.getKeyString(), file.getAbsolutePath());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            message.setFilePaths(arrayList);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)"File not found on server");
        }
        catch (Exception ex) {
            if (file != null && file.exists()) {
                Log.i((String)TAG, (String)(" Exception occured while downloading :" + file.getAbsolutePath()));
                file.delete();
            }
            ex.printStackTrace();
            Log.e((String)TAG, (String)"Exception fetching file from server");
        }
    }

    public Bitmap loadMessageImage(Context context, String url) {
        try {
            InputStream in;
            Bitmap attachedImage = null;
            if (attachedImage == null && (in = new URL(url).openStream()) != null) {
                attachedImage = BitmapFactory.decodeStream((InputStream)in);
            }
            return attachedImage;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("File not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        return null;
    }

    public String uploadBlobImage(String path) throws UnsupportedEncodingException {
        try {
            ApplozicMultipartUtility multipart = new ApplozicMultipartUtility(this.getUploadKey(), "UTF-8", this.context);
            multipart.addFilePart("files[]", new File(path));
            return multipart.getResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUploadKey() {
        return this.httpRequestUtils.getResponse(this.getFileUploadUrl() + "?" + new Date().getTime(), "text/plain", "text/plain", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap downloadBitmap(Contact contact, Channel channel) {
        HttpURLConnection connection = null;
        MarkStream inputStream = null;
        try {
            connection = contact != null ? this.openHttpConnection(contact.getImageURL()) : this.openHttpConnection(channel.getImageUrl());
            if (connection != null) {
                if (connection.getResponseCode() == 200) {
                    inputStream = new MarkStream(connection.getInputStream());
                    BitmapFactory.Options optionsBitmap = new BitmapFactory.Options();
                    optionsBitmap.inJustDecodeBounds = true;
                    inputStream.allowMarksToExpire(false);
                    long mark = inputStream.setPos(1024);
                    BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)optionsBitmap);
                    inputStream.resetPos(mark);
                    optionsBitmap.inJustDecodeBounds = false;
                    optionsBitmap.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)optionsBitmap, (int)100, (int)50);
                    Bitmap attachedImage = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)optionsBitmap);
                    inputStream.allowMarksToExpire(true);
                    Bitmap bitmap = attachedImage;
                    return bitmap;
                }
                Log.w((String)TAG, (String)("Download is failed response code is ...." + connection.getResponseCode()));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("Image not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        catch (Throwable e) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Bitmap createAndSaveVideoThumbnail(String filePath) {
        String[] parts = filePath.split("/");
        String videoThumbnailPath = "";
        String thumbnailDir = "";
        String videoFileName = parts[parts.length - 1].split("[.]")[0];
        for (int i = 0; i < parts.length - 1; ++i) {
            thumbnailDir = thumbnailDir + parts[i] + "/";
        }
        File dir = new File(thumbnailDir = thumbnailDir + "Thumbnails/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Log.i((String)"abc", (String)thumbnailDir);
        videoThumbnailPath = thumbnailDir + videoFileName + ".jpeg";
        Bitmap videoThumbnail = null;
        if (new File(videoThumbnailPath).exists()) {
            videoThumbnail = BitmapFactory.decodeFile((String)videoThumbnailPath);
        } else {
            FileOutputStream fOut = null;
            File file = new File(thumbnailDir, videoFileName + ".jpeg");
            try {
                file.createNewFile();
                fOut = new FileOutputStream(file);
                videoThumbnail = ThumbnailUtils.createVideoThumbnail((String)filePath, (int)2);
                videoThumbnail.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)fOut);
                fOut.flush();
                ((OutputStream)fOut).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return videoThumbnail;
    }

    public String uploadProfileImage(String path) throws UnsupportedEncodingException {
        try {
            ApplozicMultipartUtility multipart = new ApplozicMultipartUtility(this.profileImageUploadURL(), "UTF-8", this.context);
            multipart.addFilePart("file", new File(path));
            return multipart.getResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

