/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.database.MobiComDatabaseHelper;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.ArrayList;
import java.util.List;

public class ConversationDatabaseService {
    private static final String TAG = "ConversationDatabase";
    private static ConversationDatabaseService conversationDatabaseService;
    private MobiComDatabaseHelper dbHelper;
    private Context context;

    private ConversationDatabaseService(Context context) {
        this.context = context;
        this.dbHelper = MobiComDatabaseHelper.getInstance(context);
    }

    public static synchronized ConversationDatabaseService getInstance(Context context) {
        if (conversationDatabaseService == null) {
            conversationDatabaseService = new ConversationDatabaseService(context.getApplicationContext());
        }
        return conversationDatabaseService;
    }

    public static List<Conversation> getConversationList(Cursor cursor) {
        ArrayList<Conversation> conversationList = new ArrayList<Conversation>();
        cursor.moveToFirst();
        if (cursor.getCount() > 0) {
            do {
                conversationList.add(ConversationDatabaseService.getConversation(cursor));
            } while (cursor.moveToNext());
        }
        return conversationList;
    }

    public static Conversation getConversation(Cursor cursor) {
        String userId;
        String topicDetail;
        Conversation conversation = new Conversation();
        conversation.setId(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("key"))));
        conversation.setGroupId(Integer.valueOf(cursor.getInt(cursor.getColumnIndex("channelKey"))));
        String topicId = cursor.getString(cursor.getColumnIndex("topicId"));
        if (!TextUtils.isEmpty((CharSequence)topicId)) {
            conversation.setTopicId(topicId);
        }
        if (!TextUtils.isEmpty((CharSequence)(topicDetail = cursor.getString(cursor.getColumnIndex("topicDetail"))))) {
            conversation.setTopicDetail(topicDetail);
        }
        if (!TextUtils.isEmpty((CharSequence)(userId = cursor.getString(cursor.getColumnIndex("userId"))))) {
            conversation.setUserId(userId);
        }
        return conversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConversation(Conversation conversation) {
        try {
            ContentValues contentValues = this.prepareConversationValue(conversation);
            long l = this.dbHelper.getWritableDatabase().insert("conversation", null, contentValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.dbHelper.close();
        }
    }

    public ContentValues prepareConversationValue(Conversation conversation) {
        ContentValues contentValues = new ContentValues();
        if (conversation != null) {
            if (conversation.getId() != null) {
                contentValues.put("key", conversation.getId());
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getTopicId())) {
                contentValues.put("topicId", conversation.getTopicId());
            }
            if (conversation.getGroupId() != null) {
                contentValues.put("channelKey", conversation.getGroupId());
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getUserId())) {
                contentValues.put("userId", conversation.getUserId());
            }
            if (!TextUtils.isEmpty((CharSequence)conversation.getTopicDetail())) {
                contentValues.put("topicDetail", conversation.getTopicDetail());
            }
        }
        return contentValues;
    }

    public Conversation getConversationByConversationId(Integer conversationId) {
        Conversation conversation = null;
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        String conversationParameters = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        conversationParameters = conversationParameters + "key = ? ";
        structuredNameParamsList.add(String.valueOf(conversationId));
        Cursor cursor = database.query("conversation", null, conversationParameters, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, null);
        if (cursor.moveToFirst()) {
            conversation = ConversationDatabaseService.getConversation(cursor);
            cursor.close();
        }
        this.dbHelper.close();
        return conversation;
    }

    public List<Conversation> getConversationList(Channel channel, Contact contact) {
        List<Conversation> conversation = null;
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        String conversationParameters = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        if (channel != null) {
            conversationParameters = conversationParameters + "channelKey = ? ";
            structuredNameParamsList.add(String.valueOf(channel.getKey()));
        } else {
            conversationParameters = conversationParameters + "userId = ? ";
            structuredNameParamsList.add(contact.getContactIds());
        }
        Cursor cursor = database.query("conversation", null, conversationParameters, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, "key desc");
        if (cursor.moveToFirst()) {
            conversation = ConversationDatabaseService.getConversationList(cursor);
            cursor.close();
        }
        return conversation;
    }

    public boolean isConversationPresent(Integer conversationId) {
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        Cursor cursor = database.rawQuery("SELECT COUNT(*) FROM conversation WHERE key=?", new String[]{String.valueOf(conversationId)});
        boolean present = false;
        if (cursor.moveToFirst()) {
            present = cursor.getInt(0) > 0;
            cursor.close();
        }
        this.dbHelper.close();
        return present;
    }

    public void updateConversation(Conversation conversation) {
        try {
            ContentValues contentValues = this.prepareConversationValue(conversation);
            this.dbHelper.getWritableDatabase().update("conversation", contentValues, "key=?", new String[]{String.valueOf(conversation.getId())});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteConversation(String userId) {
        int deletedRows = this.dbHelper.getWritableDatabase().delete("conversation", "userId=?", new String[]{userId});
        Log.i((String)TAG, (String)("Delete no of conversation:" + deletedRows));
    }

    public Integer isConversationExit(String userId, String topicId) {
        Conversation conversation = null;
        SQLiteDatabase database = this.dbHelper.getReadableDatabase();
        String conversationParameters = "";
        ArrayList<String> structuredNameParamsList = new ArrayList<String>();
        conversationParameters = conversationParameters + "userId = ? ";
        structuredNameParamsList.add(userId);
        conversationParameters = conversationParameters + " and topicId = ? ";
        structuredNameParamsList.add(topicId);
        Cursor cursor = database.query("conversation", null, conversationParameters, structuredNameParamsList.toArray(new String[structuredNameParamsList.size()]), null, null, null);
        if (cursor.moveToFirst()) {
            conversation = ConversationDatabaseService.getConversation(cursor);
            cursor.close();
            return conversation.getId();
        }
        return null;
    }
}

