/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation.service;

import android.content.Context;
import android.text.TextUtils;
import com.applozic.mobicomkit.api.conversation.database.ConversationDatabaseService;
import com.applozic.mobicomkit.api.conversation.service.ConversationClientService;
import com.applozic.mobicomkit.channel.service.ChannelService;
import com.applozic.mobicomkit.feed.ChannelFeed;
import com.applozic.mobicommons.people.channel.Channel;
import com.applozic.mobicommons.people.channel.Conversation;
import com.applozic.mobicommons.people.contact.Contact;
import java.util.List;

public class ConversationService {
    private static ConversationService conversationService;
    private Context context;
    private ConversationDatabaseService conversationDatabaseService;
    private ConversationClientService conversationClientService;

    private ConversationService(Context context) {
        this.context = context;
        this.conversationDatabaseService = ConversationDatabaseService.getInstance(context);
        this.conversationClientService = ConversationClientService.getInstance(context);
    }

    public static synchronized ConversationService getInstance(Context context) {
        if (conversationService == null) {
            conversationService = new ConversationService(context);
        }
        return conversationService;
    }

    public synchronized void processConversationArray(Conversation[] conversations, Channel channel, Contact contact) {
        if (conversations != null && conversations.length > 0) {
            for (Conversation conversation : conversations) {
                if (channel != null) {
                    conversation.setGroupId(channel.getKey());
                } else if (contact != null) {
                    conversation.setUserId(contact.getUserId());
                    conversation.setGroupId(Integer.valueOf(0));
                }
                if (this.conversationDatabaseService.isConversationPresent(conversation.getId())) {
                    this.conversationDatabaseService.updateConversation(conversation);
                    continue;
                }
                this.conversationDatabaseService.addConversation(conversation);
            }
        }
    }

    public synchronized Conversation getConversationByConversationId(Integer conversationId) {
        return this.conversationDatabaseService.getConversationByConversationId(conversationId);
    }

    public synchronized List<Conversation> getConversationList(Channel channel, Contact contact) {
        return this.conversationDatabaseService.getConversationList(channel, contact);
    }

    public synchronized void addConversation(Conversation conversation) {
        if (conversation != null) {
            if (this.conversationDatabaseService.isConversationPresent(conversation.getId())) {
                this.conversationDatabaseService.updateConversation(conversation);
            } else {
                this.conversationDatabaseService.addConversation(conversation);
            }
        }
    }

    public synchronized Integer createConversation(Conversation conversation) {
        ChannelFeed channelFeed = this.conversationClientService.createConversation(conversation);
        if (channelFeed != null) {
            if (conversation.getSupportIds() != null) {
                ChannelFeed[] channelFeeds = new ChannelFeed[]{channelFeed};
                ChannelService.getInstance(this.context).processChannelFeedList(channelFeeds, false);
            }
            if (channelFeed.getConversationPxy() != null) {
                this.addConversation(channelFeed.getConversationPxy());
                return channelFeed.getConversationPxy().getId();
            }
        }
        return null;
    }

    public synchronized void getConversation(Integer conversationId) {
        Conversation conversation;
        if (!this.conversationDatabaseService.isConversationPresent(conversationId) && (conversation = this.conversationClientService.getConversation(conversationId)) != null) {
            this.conversationDatabaseService.addConversation(conversation);
        }
    }

    public synchronized void deleteConversation(String userId) {
        this.conversationDatabaseService.deleteConversation(userId);
    }

    public synchronized Integer isConversationExist(String userId, String topicId) {
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)topicId)) {
            return null;
        }
        return this.conversationDatabaseService.isConversationExit(userId, topicId);
    }
}

